/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.DateTime;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.db.types.DataType;
import inform.agent.mtd.ServerVariableList;
import java.io.IOException;

public class GlobalServerVariableOperation
extends Request {
    int operation = 0;
    private ServerVariableList.Variable var = null;
    private static final int GSVAR_OP_GET = 0;
    private static final int GSVAR_OP_SET = 1;
    private static final int GSVAR_OP_SET_MAX = 2;
    private static final int GSVAR_OP_INC = 3;
    private static final int GSVAR_OP_NEXT = 4;
    private static final int TAG_GSVAR_OPERATION = 1;
    private static final int TAG_GSVAR_NAME = 2;
    private static final int TAG_GSVAR_NULL_VALUE = 3;
    private static final int TAG_GSVAR_INT_VALUE = 4;
    private static final int TAG_GSVAR_DOUBLE_VALUE = 5;
    private static final int TAG_GSVAR_DATE_VALUE = 6;
    private static final int TAG_GSVAR_STRING_VALUE = 7;
    private static final int TAG_GSVAR_UNDEF_VALUE = 8;

    public GlobalServerVariableOperation(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        RequestResult result = new RequestResult(this);
        TaggedWriter out = result.getWriter();
        boolean changed = false;
        block10: while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.operation = in.getInt();
                    continue block10;
                }
                case 2: {
                    this.var = new ServerVariableList.Variable(in.getString());
                    if (!ServerVariableList.get(this.var)) continue block10;
                    changed = true;
                    continue block10;
                }
            }
            if (!this.loadVariable(in)) continue;
            changed = true;
        }
        if (this.var == null) {
            this.sendError("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0441\u0435\u0440\u0435\u0432\u0435\u0440\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", null);
        } else {
            switch (this.var.dataType) {
                case INTEGER: {
                    out.putInt32(4, (int)this.var.numberValue);
                    break;
                }
                case FLOAT: {
                    out.putDouble(5, this.var.numberValue);
                    break;
                }
                case DATE_TIME: {
                    out.putDouble(6, DateTime.fromServerTime(this.var.numberValue, this));
                    break;
                }
                case STRING: {
                    out.putString(7, this.var.stringValue);
                    break;
                }
                default: {
                    out.putEmpty(8);
                }
            }
        }
        if (changed && this.var != null) {
            ServerVariableList.put(this.var);
        }
        result.sendResult();
    }

    private boolean loadVariable(TaggedReader in) throws IOException, TaggedReaderException {
        if (this.var == null) {
            return false;
        }
        if (this.operation == 0) {
            return false;
        }
        DataType dataType = DataType.NONE;
        double numberValue = 0.0;
        String stringValue = "";
        switch (in.getCurrentTag()) {
            case 4: {
                numberValue = in.getInt();
                dataType = DataType.INTEGER;
                break;
            }
            case 5: {
                numberValue = in.getDouble();
                dataType = DataType.FLOAT;
                break;
            }
            case 6: {
                numberValue = DateTime.toServerTime(in.getDouble(), this);
                dataType = DataType.DATE_TIME;
                break;
            }
            case 7: {
                stringValue = in.getString();
                dataType = DataType.STRING;
            }
        }
        block6 : switch (this.operation) {
            case 1: {
                this.var.dataType = dataType;
                this.var.numberValue = numberValue;
                this.var.stringValue = stringValue;
                break;
            }
            case 2: {
                if (dataType == this.var.dataType && dataType != DataType.NONE) {
                    if (dataType == DataType.STRING) {
                        if (this.var.stringValue.compareTo(stringValue) < 0) {
                            this.var.stringValue = stringValue;
                            break;
                        }
                        return false;
                    }
                    if (this.var.numberValue < numberValue) {
                        this.var.numberValue = numberValue;
                        break;
                    }
                    return false;
                }
                if (dataType != DataType.NONE && this.var.dataType == DataType.NONE) {
                    this.var.dataType = dataType;
                    this.var.numberValue = numberValue;
                    this.var.stringValue = stringValue;
                    break;
                }
                return false;
            }
            case 3: {
                switch (this.var.dataType) {
                    case STRING: 
                    case NONE: {
                        return false;
                    }
                }
                switch (dataType) {
                    case STRING: 
                    case NONE: {
                        this.var.numberValue += 1.0;
                        break block6;
                    }
                }
                this.var.numberValue += numberValue;
                break;
            }
            case 4: {
                if (dataType == this.var.dataType && dataType != DataType.NONE) {
                    if (dataType == DataType.STRING) {
                        if (this.var.stringValue.compareTo(stringValue) < 0) {
                            this.var.stringValue = stringValue;
                            break;
                        }
                        return false;
                    }
                    if (this.var.numberValue < numberValue) {
                        this.var.numberValue = numberValue;
                        break;
                    }
                    this.var.numberValue += 1.0;
                    break;
                }
                if (dataType == DataType.NONE || this.var.dataType != DataType.NONE) break;
                this.var.dataType = dataType;
                this.var.numberValue = numberValue;
                this.var.stringValue = stringValue;
            }
        }
        return true;
    }
}

