/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedReaderSizeOverflowException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.mtd.Acl;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.NoContentRecordException;
import inform.agent.mtd.nodes.Node;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;

public class NodeDependeceEngine {
    public static void parseContentForDependencies(TaggedReader in, DoubleSet set) throws IOException, TaggedReaderException {
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 202: {
                    NodeDependeceEngine.parseContentForDependencies(in.getStreamReader(), set);
                    break;
                }
                case 151: {
                    double nodeId;
                    if (in.getCurrentTagSize() != 8 || (double)((long)(nodeId = in.getDouble())) != nodeId) break;
                    set.add(nodeId);
                    break;
                }
                case 154: {
                    Acl.tryLoadRoles(in.getRaw(), set);
                }
            }
        }
    }

    public static void parseAttributeForDependencies(TaggedReader in, DoubleSet set) throws IOException, TaggedReaderException, SQLException, InterruptedException {
        byte[] aclContent = null;
        boolean isAclInherited = false;
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 2: {
                    aclContent = in.getRaw();
                    break;
                }
                case 18: {
                    isAclInherited = in.getBoolean();
                    break;
                }
                case 105: {
                    double[] groups;
                    for (double g : groups = LittleEndian.toDoubleArray(in.getRaw())) {
                        set.add(g);
                    }
                    break;
                }
            }
        }
        if (!isAclInherited) {
            Acl.tryLoadRoles(aclContent, set);
        }
    }

    public static void parseNodeDependencies(Node node, DoubleSet set) throws InformException, IOException, SQLException, InterruptedException {
        if (node.getType() == 2) {
            NodeDependeceEngine.getNodeDependencies(node.getRefNodeId(), set);
        } else {
            if (node instanceof BasicNode) {
                byte[] content;
                BasicNode basicNode = (BasicNode)node;
                try {
                    content = basicNode.getContent();
                }
                catch (NoContentRecordException ex) {
                    Core.logger.error(null, ex);
                    content = null;
                }
                if (content != null && TaggedReader.containsTag(150, content)) {
                    TaggedReader in = new TaggedReader(content);
                    try {
                        NodeDependeceEngine.parseContentForDependencies(in, set);
                    }
                    catch (TaggedReaderSizeOverflowException ex) {
                        String msg = ex.getMessage() + " \u0443\u0437\u0435\u043b \u0441 \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u043c \u0442\u0435\u0433\u043e\u0432\u044b\u043c \u043f\u043e\u0442\u043e\u043a\u043e\u043c " + node.getId();
                        Core.logger.error(msg);
                    }
                }
            }
            TaggedReader in = new TaggedReader(node.getRawAttributes());
            NodeDependeceEngine.parseAttributeForDependencies(in, set);
        }
    }

    public static void getNodeDependencies(double nodeId, DoubleSet set) throws InformException, IOException, SQLException, InterruptedException {
        Node node = MtdEngine.getNode(nodeId);
        if (node == null) {
            return;
        }
        try {
            NodeDependeceEngine.parseNodeDependencies(node, set);
        }
        catch (TaggedReaderSizeOverflowException ex) {
            String msg = ex.getMessage() + "\u0443\u0437\u0435\u043b \u0441 \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u043c \u0442\u0435\u0433\u043e\u0432\u044b\u043c \u043f\u043e\u0442\u043e\u043a\u043e\u043c " + nodeId;
            Core.logger.error(msg);
        }
        catch (Throwable ex) {
            throw InformException.detail(InformException.wrap(ex, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u0432\u0437\u0430\u0438\u043c\u043e\u0441\u0432\u044f\u0437\u0435\u0439 \u0443\u0437\u043b\u043e\u0432"), node.toLogString());
        }
    }

    public static boolean isNodeContentDependedOn(TaggedReader in, double dependedId) throws IOException, TaggedReaderException, SQLException, InterruptedException {
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 202: {
                    if (!NodeDependeceEngine.isNodeContentDependedOn(in.getStreamReader(), dependedId)) break;
                    return true;
                }
                case 151: {
                    double nodeId;
                    if (in.getCurrentTagSize() != 8 || (nodeId = in.getDouble()) != dependedId) break;
                    return true;
                }
                case 154: {
                    if (!Acl.containRole(in.getRaw(), dependedId)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isNodeAttributeDependedOn(TaggedReader in, double dependedId) throws IOException, TaggedReaderException, SQLException, InterruptedException {
        byte[] aclContent = null;
        boolean isAclInherited = false;
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 2: {
                    aclContent = in.getRaw();
                    break;
                }
                case 18: {
                    isAclInherited = in.getBoolean();
                    break;
                }
                case 105: {
                    double[] groups;
                    for (double g : groups = LittleEndian.toDoubleArray(in.getRaw())) {
                        if (g != dependedId) continue;
                        return true;
                    }
                    break;
                }
            }
        }
        return !isAclInherited && Acl.containRole(aclContent, dependedId);
    }

    public static boolean isNodeDependedOn(Node node, double dependedId) throws IOException, SQLException, InterruptedException {
        TaggedReader in;
        if (node.getType() == 2) {
            return NodeDependeceEngine.isNodeDependedOn(node.getRefNodeId(), dependedId);
        }
        if (node instanceof BasicNode) {
            TaggedReader in2;
            byte[] content;
            BasicNode basicNode = (BasicNode)node;
            try {
                content = basicNode.getContent();
            }
            catch (NoContentRecordException ex) {
                Core.logger.error(null, ex);
                content = null;
            }
            if (content != null && TaggedReader.containsTag(150, content) && NodeDependeceEngine.isNodeContentDependedOn(in2 = new TaggedReader(content), dependedId)) {
                return true;
            }
        }
        return NodeDependeceEngine.isNodeAttributeDependedOn(in = new TaggedReader(node.getRawAttributes()), dependedId);
    }

    public static boolean isNodeDependedOn(double nodeId, double dependedId) throws IOException, SQLException, InterruptedException {
        Node node = MtdEngine.getNode(nodeId);
        return node != null && NodeDependeceEngine.isNodeDependedOn(node, dependedId);
    }

    public static void replaceNodeIdInContent(TaggedReader in, double sourceId, double replaceId, TaggedWriter out) throws IOException {
        java.io.ByteArrayOutputStream data = null;
        TaggedWriter stream = null;
        block5: while (in.getNextTag() != 0) {
            int tag = in.getCurrentTag();
            switch (tag) {
                case 202: {
                    if (data == null) {
                        data = new ByteArrayOutputStream();
                        stream = new TaggedWriter(data);
                    } else {
                        data.reset();
                        stream.reset(data);
                    }
                    NodeDependeceEngine.replaceNodeIdInContent(in.getStreamReader(), sourceId, replaceId, stream);
                    stream.flush();
                    out.putRaw(tag, ((ByteArrayOutputStream)data).internalBuffer(), data.size());
                    continue block5;
                }
                case 151: {
                    double nodeId = in.getDouble();
                    if (nodeId == sourceId) {
                        out.putDouble(tag, replaceId);
                        continue block5;
                    }
                    out.putDouble(tag, nodeId);
                    continue block5;
                }
                case 154: {
                    out.putRaw(tag, Acl.replaceRole(in.getRaw(), sourceId, replaceId));
                    continue block5;
                }
            }
            in.transferTag(out);
        }
    }

    public static void replaceNodeIdInAttributes(TaggedReader in, double sourceId, double replaceId, TaggedWriter out) throws IOException {
        block4: while (in.getNextTag() != 0) {
            int tag = in.getCurrentTag();
            switch (tag) {
                case 154: {
                    out.putRaw(tag, Acl.replaceRole(in.getRaw(), sourceId, replaceId));
                    continue block4;
                }
                case 105: {
                    double[] groups = LittleEndian.toDoubleArray(in.getRaw());
                    for (int i = 0; i < groups.length; ++i) {
                        if (groups[i] != sourceId) continue;
                        groups[i] = replaceId;
                    }
                    out.putRaw(tag, LittleEndian.doubleArrayToBinary(groups));
                    continue block4;
                }
            }
            in.transferTag(out);
        }
    }

    public static ReplacedNode replaceNodeId(Node node, double sourceId, double replaceId) throws IOException {
        if (node.getType() == 2) {
            return NodeDependeceEngine.replaceNodeId(node.getRefNodeId(), sourceId, replaceId);
        }
        if (node.getType() == 1) {
            return null;
        }
        byte[] newContent = null;
        if (node instanceof BasicNode) {
            BasicNode.NodeContent nodeContent;
            BasicNode basicNode = (BasicNode)node;
            try {
                nodeContent = basicNode.getNodeContent(0.0, true);
            }
            catch (NoContentRecordException ex) {
                Core.logger.error(null, ex);
                nodeContent = null;
            }
            if (nodeContent != null && nodeContent.dslContent == null && TaggedReader.containsTag(150, nodeContent.content)) {
                TaggedReader in = new TaggedReader(nodeContent.content);
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                TaggedWriter out = new TaggedWriter(bytes);
                NodeDependeceEngine.replaceNodeIdInContent(in, sourceId, replaceId, out);
                out.flush();
                newContent = bytes.toByteArray();
                if (Arrays.equals(nodeContent.content, newContent)) {
                    newContent = null;
                }
            }
        }
        byte[] newAttributes = null;
        byte[] attributes = node.getRawAttributes();
        if (attributes != null && attributes.length != 0) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(bytes);
            TaggedReader in = new TaggedReader(attributes);
            NodeDependeceEngine.replaceNodeIdInAttributes(in, sourceId, replaceId, out);
            out.flush();
            newAttributes = bytes.toByteArray();
            if (Arrays.equals(attributes, newAttributes)) {
                newAttributes = null;
            }
        }
        if (newAttributes == null && newContent == null) {
            return null;
        }
        return new ReplacedNode(node, newAttributes, newContent, null);
    }

    public static ReplacedNode replaceNodeId(double nodeId, double sourceId, double replaceId) throws IOException {
        Node node = MtdEngine.getNode(nodeId);
        if (node == null) {
            return null;
        }
        return NodeDependeceEngine.replaceNodeId(node, sourceId, replaceId);
    }

    public static class ReplacedNode {
        public final Node node;
        public final byte[] attributes;
        public final byte[] content;
        public final String dslContent;

        public ReplacedNode(Node node, byte[] attributes, byte[] content, String dslContent) {
            this.node = node;
            this.attributes = attributes;
            this.content = content;
            this.dslContent = dslContent;
        }
    }
}

