/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.request.NodeDependeceEngine;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.net.AlertingEngine;
import java.util.ArrayList;

public class ReplaceNodeDependencies
extends Request {
    private static final int TAG_NODE_ID = 1;

    public ReplaceNodeDependencies(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        double sourceId = in.getDouble(1);
        double replaceId = in.getDouble(1);
        DoubleSet nodes = new DoubleSet();
        while (in.next()) {
            nodes.add(in.getDouble(1));
        }
        ByteArrayOutputStream notification = new ByteArrayOutputStream();
        TaggedWriter notificationOut = new TaggedWriter(notification);
        ArrayList<NodeDependeceEngine.ReplacedNode> replacedNodes = new ArrayList<NodeDependeceEngine.ReplacedNode>();
        for (Cursor.Double nodeId : nodes) {
            NodeDependeceEngine.ReplacedNode node = NodeDependeceEngine.replaceNodeId(nodeId.value, sourceId, replaceId);
            if (node == null) continue;
            replacedNodes.add(node);
            notificationOut.putDouble(3, node.node.getId());
        }
        if (replacedNodes.isEmpty()) {
            this.sendResult();
            return;
        }
        MetadataNodeReader.NodeChanges changes = new MetadataNodeReader.NodeChanges();
        try (Connector.Metabase connector = new Connector.Metabase();){
            Node.ModifyNodeArg arg = new Node.ModifyNodeArg(this, connector, NodeStatus.MODIFIED, this.security());
            arg.userId = this.getUserID();
            arg.sessionId = this.getSessionID();
            for (NodeDependeceEngine.ReplacedNode rNode : replacedNodes) {
                if (rNode.node instanceof BasicNode) {
                    BasicNode node = arg.modifyNode((BasicNode)rNode.node);
                    if (node.getPinId() != 0.0) {
                        node.Unpin();
                    }
                    long seconds = System.currentTimeMillis() / 1000L;
                    arg.contentModificationTime = seconds * 1000L;
                    if (rNode.attributes != null) {
                        node.changeNodeAttributes(arg.sessionId, rNode.attributes, arg.contentModificationTime);
                    }
                    if (rNode.content == null) continue;
                    node.setContent(rNode.content, rNode.dslContent, arg);
                    continue;
                }
                changes.clear();
                if (rNode.attributes != null) {
                    changes.setRawAttributes(rNode.attributes);
                    changes.setModificationAttributeTime(System.currentTimeMillis());
                }
                if (rNode.content != null) {
                    changes.setContent(rNode.content);
                    changes.setModificationContentTime(System.currentTimeMillis());
                    changes.setModificationUserId(rNode.node.getModificationUserId());
                }
                if (rNode.attributes == null && rNode.content == null) continue;
                changes.setApplicationId(Core.getApplicationId());
                changes.setApplicationTime(System.currentTimeMillis());
                changes.setReplId(0.0);
                changes.setReplNodeId(0.0);
                MetadataNodeReader.updateNodeTransact(this.ssContext, changes, rNode.node.getId(), this.getUserID(), this.getSessionID(), null, rNode.node.getType(), connector.connection());
            }
            MtdEngine.updateNodes(this.ssContext, arg);
        }
        MtdEngine.invalidate();
        AlertingEngine.sendChangeNotification(null, notification.internalBuffer(), notification.size(), 0L);
    }
}

