/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.Memory;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleDoubleMap;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.ClosableResult;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.SearchMetatreeNodeData;
import inform.agent.mtd.nodes.SymLinkNodeCache;
import inform.common.Base64BinString;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchMetatreeNode
extends Request {
    private static final int COMPARE_TYPE_LESS = -1;
    private static final int COMPARE_TYPE_EQUAL = 0;
    private static final int COMPARE_TYPE_GREATER = 1;
    private static final int COMPARE_TYPE_NONE = -99999;
    private static final int MAX_MATCHED_GROUPS = 512;
    private int compareContentType = -99999;
    private long nodeSize = Long.MAX_VALUE;
    private byte[] contentText = null;
    private boolean strict = false;
    private boolean inTrash;
    private boolean regexp;
    private Memory.Matcher searchInt;
    private Memory.Matcher searchNumber;
    private Pattern searchRegExp;
    SearchMetatreeNodeData data = new SearchMetatreeNodeData();
    private final DoubleHash<MetadataNodeReader.Children> childrenCache = new DoubleHash();
    private final DoubleSet nodeCache = new DoubleSet();
    private final DoubleDoubleMap nodePathCache = new DoubleDoubleMap();
    private SymLinkNodeCache symlinkCache;
    private DoubleDoubleMap symlinkRefCache;
    private final DoubleList foundNode = new DoubleList(1);
    private final List<Collection<String>> foundHints = new ArrayList<Collection<String>>();
    private double[] nodesToLoad = new double[32];
    private final double[] reversePath = new double[128];
    private double startNodeId;
    private Collection<String> matchedGroups = new ArrayList<String>();
    private double[] nodeListIds = null;

    public SearchMetatreeNode(RequestHeader rq) {
        super(rq, RequestDuration.MIDDLE);
    }

    private boolean isMatch(NodeStruct node) {
        int contentLength = node.content == null ? 0 : node.content.length;
        switch (this.compareContentType) {
            case -1: {
                if ((long)contentLength <= this.nodeSize) break;
                return false;
            }
            case 0: {
                if ((long)contentLength == this.nodeSize) break;
                return false;
            }
            case 1: {
                if ((long)contentLength >= this.nodeSize) break;
                return false;
            }
        }
        if (!this.inTrash) {
            if (node.parentId == 1.0) {
                return false;
            }
            if (MtdEngine.isNodeInTrash(node.id)) {
                return false;
            }
        }
        if (this.searchNumber != null) {
            if (this.searchNumber.findIndex(node.content) >= 0) {
                return true;
            }
            if (this.searchNumber.findIndex(node.attributesContent) >= 0) {
                return true;
            }
            if (this.searchInt != null) {
                if (this.searchInt.findIndex(node.content) >= 0) {
                    return true;
                }
                if (this.searchInt.findIndex(node.attributesContent) >= 0) {
                    return true;
                }
            }
        }
        if (this.searchRegExp != null && node.content != null) {
            Matcher m = this.searchRegExp.matcher(new Win1251CharSequence(node.content, 0, node.content.length));
            while (this.matchedGroups.size() < 512 && m.find()) {
                this.matchedGroups.add(m.group());
            }
            if (!this.matchedGroups.isEmpty()) {
                return true;
            }
        }
        if (this.contentText != null) {
            int index = this.strict ? Memory.indexOf(this.contentText, node.content) : Memory.indexOfIgnoreCase(this.contentText, node.content);
            return index >= 0;
        }
        return true;
    }

    private boolean needContent() {
        switch (this.compareContentType) {
            case -1: 
            case 0: 
            case 1: {
                return true;
            }
        }
        if (this.contentText != null) {
            return true;
        }
        if (this.searchNumber != null) {
            return true;
        }
        return this.searchRegExp != null;
    }

    private void processNode(NodeStruct node) throws TaggedReaderException {
        if (!this.nodeCache.add(node.id)) {
            return;
        }
        if (this.isMatch(node)) {
            this.foundNode.add(node.id);
            if (this.matchedGroups.isEmpty()) {
                this.foundHints.add(null);
            } else {
                this.foundHints.add(this.matchedGroups);
                this.matchedGroups = new ArrayList<String>();
            }
        }
    }

    private void addSliceNode(DoubleList slice, double id, DoubleSet processed) {
        if (!processed.add(id)) {
            return;
        }
        slice.add(id);
        if (this.symlinkRefCache.contains(id)) {
            this.addSliceNode(slice, this.symlinkRefCache.lget(), processed);
        } else {
            MetadataNodeReader.Children children = this.childrenCache.get(id);
            if (children == null) {
                return;
            }
            for (Cursor.Double c : children) {
                this.addSliceNode(slice, c.value, processed);
            }
        }
    }

    private DoubleList getNodeSlice() {
        if (this.nodeListIds != null) {
            DoubleList slice = new DoubleList(this.nodeListIds.length);
            for (double id : this.nodeListIds) {
                slice.add(id);
            }
            return slice;
        }
        if (this.childrenCache.empty() || this.nodePathCache.empty() || this.symlinkCache.empty()) {
            return null;
        }
        DoubleList slice = new DoubleList(1);
        DoubleSet processed = new DoubleSet();
        this.addSliceNode(slice, this.startNodeId, processed);
        return slice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNodes(DatabaseConnection connection) throws SQLException, IOException, TaggedReaderException, InformException {
        this.symlinkCache = MtdEngine.getMtdCache().getSymlinkCache();
        this.symlinkRefCache = this.symlinkCache.createRefCache();
        this.data.setNodeSlice(this.getNodeSlice());
        this.data.needContent = this.needContent();
        int count = 0;
        do {
            try (ClosableResult closableResult = MetadataNodeReader.getResultSetForSearch(null, this.data, connection);){
                int fidxRawContent;
                ResultSet nodes = closableResult.getResultSet();
                int fidxId = nodes.findColumn("ID");
                int fidxParentId = nodes.findColumn("PARENT_ID");
                int fidxNodeName = nodes.findColumn("NODE_NAME");
                int fidxAttrsB64 = this.data.needContent ? nodes.findColumn("ATTRS_B64") : 0;
                int n = fidxRawContent = this.data.needContent ? nodes.findColumn("RAW_CONTENT") : 0;
                while (nodes.next()) {
                    this.idle();
                    NodeStruct node = new NodeStruct(nodes.getDouble(fidxId), nodes.getDouble(fidxParentId), nodes.getString(fidxNodeName), this.data.needContent ? nodes.getBlobBytes(fidxRawContent) : null, this.data.needContent ? Base64BinString.Decode(nodes.getString(fidxAttrsB64)) : null);
                    this.processNode(node);
                    if (count >= this.nodesToLoad.length) {
                        this.nodesToLoad = Arrays.copyOf(this.nodesToLoad, this.nodesToLoad.length + 32);
                    }
                    this.nodesToLoad[count++] = node.id;
                    this.putRequestStateText(count + "(" + this.foundNode.size() + "): " + node.name);
                }
            }
        } while (this.data.sliceCount > 0);
    }

    private int getNodePath(double nodeId, double rootId, double startNodeId, double[] path) {
        boolean hasStart;
        int count = 0;
        boolean hasRoot = false;
        boolean bl = hasStart = startNodeId == nodeId;
        while (count < this.reversePath.length && this.nodePathCache.contains(nodeId)) {
            nodeId = this.nodePathCache.lget();
            if (nodeId == rootId) {
                hasRoot = true;
            }
            if (nodeId == startNodeId) {
                hasStart = true;
            }
            this.reversePath[count++] = nodeId;
            if (nodeId != 0.0) continue;
        }
        if (!hasRoot || !hasStart) {
            return -1;
        }
        int c = count;
        for (int i = 0; i < count; ++i) {
            path[--c] = this.reversePath[i];
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 13: {
                    this.data.setName(in.getAnsi());
                    break;
                }
                case 4: {
                    this.data.setName(in.getAnsi());
                    break;
                }
                case 2: {
                    this.data.setNodeTypes(LittleEndian.toIntArray(in.getRaw()));
                    break;
                }
                case 55: {
                    this.compareContentType = in.getInt();
                    break;
                }
                case 6: {
                    this.nodeSize = in.getUnsignedInt();
                    break;
                }
                case 60: {
                    this.data.setDateMask(in.getInt());
                    break;
                }
                case 53: {
                    this.data.setBeginDate(DateTime.toServerTime(in.getDouble(), this));
                    break;
                }
                case 54: {
                    this.data.setEndDate(DateTime.toServerTime(in.getDouble(), this));
                    break;
                }
                case 56: {
                    this.contentText = in.getRaw();
                    break;
                }
                case 67: {
                    this.data.strict = true;
                    this.strict = true;
                    break;
                }
                case 66: {
                    this.inTrash = true;
                    break;
                }
                case 68: {
                    this.regexp = true;
                    break;
                }
                case 69: {
                    this.nodeListIds = LittleEndian.toDoubleArray(in.getRaw());
                }
            }
        }
        if (Memory.isNumber(this.contentText)) {
            long number = Memory.toLong(this.contentText);
            if (number >= Integer.MIN_VALUE && number <= Integer.MAX_VALUE) {
                byte[] intBytes = LittleEndian.intToBinary((int)number);
                this.searchInt = Memory.matcher(intBytes);
            }
            byte[] dblBytes = LittleEndian.doubleToBinary(number);
            this.searchNumber = Memory.matcher(dblBytes);
        }
        if (this.contentText != null && this.regexp) {
            int flags = 32;
            if (!this.strict) {
                flags |= 2;
            }
            this.searchRegExp = Pattern.compile(new String(this.contentText, TaggedWriter.ANSI), flags);
        }
        this.idle();
        double rootNodeId = this.getRootNodeID();
        this.startNodeId = this.getNodeID();
        if (this.startNodeId == 0.0 || this.nodeListIds != null) {
            this.startNodeId = rootNodeId;
        }
        try (DatabaseConnection connection = DatabaseDescriptor.getMetabase().connectPrivileged("rq:SearchMetatreeNode");){
            if (this.startNodeId != rootNodeId) {
                MetadataNodeReader.fillNodePathInfo(null, this.nodePathCache, this.childrenCache, connection);
            }
            this.loadNodes(connection);
            if (!this.foundNode.empty() && this.nodePathCache.empty()) {
                MetadataNodeReader.fillNodePathInfo(null, this.nodePathCache, null, connection);
            }
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        double[] path = new double[this.reversePath.length];
        double[] symPath = new double[this.reversePath.length];
        for (DoubleList.Cursor fn : this.foundNode) {
            Collection<String> hints;
            double nodeId = fn.value;
            int count = this.getNodePath(nodeId, rootNodeId, this.startNodeId, path);
            if (count < 0) {
                count = this.getNodePath(nodeId, 0.0, 0.0, path);
                if (count < 0) continue;
                boolean found = false;
                for (int index = 0; index < count; ++index) {
                    double refId = path[index];
                    DoubleList symlinks = this.symlinkCache.get(refId);
                    if (symlinks == null) continue;
                    for (Cursor.Double sl : symlinks) {
                        int symCount;
                        double symId = sl.value;
                        if (symId == nodeId || (symCount = this.getNodePath(symId, rootNodeId, this.startNodeId, symPath)) < 0) continue;
                        symPath[symCount++] = symId;
                        for (int i = index + 1; i < count && symCount < symPath.length; ++i) {
                            symPath[symCount++] = path[i];
                        }
                        out.putDouble(1, nodeId);
                        out.putRaw(15, LittleEndian.doubleArrayToBinary(symPath, symCount));
                        found = true;
                    }
                    if (!found) {
                        continue;
                    }
                    break;
                }
            } else {
                out.putDouble(1, nodeId);
                out.putRaw(15, LittleEndian.doubleArrayToBinary(path, count));
            }
            if ((hints = this.foundHints.get(fn.index)) == null) continue;
            for (String h : hints) {
                out.putString(68, h);
            }
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }

    private static class NodeStruct {
        final double id;
        final double parentId;
        final String name;
        final byte[] content;
        final byte[] attributesContent;

        NodeStruct(double id, double parentId, String name, byte[] content, byte[] attributesContent) {
            this.id = id;
            this.parentId = parentId;
            this.name = name;
            this.content = content;
            this.attributesContent = attributesContent;
        }
    }

    private static class Win1251CharSequence
    implements CharSequence {
        private static final char[] MAP = new char[]{'\u0402', '\u0403', '\u201a', '\u0453', '\u201e', '\u2026', '\u2020', '\u2021', '\u20ac', '\u2030', '\u0409', '\u2039', '\u040a', '\u040c', '\u040b', '\u040f', '\u0452', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\ufffd', '\u2122', '\u0459', '\u203a', '\u045a', '\u045c', '\u045b', '\u045f', '\u00a0', '\u040e', '\u045e', '\u0408', '\u00a4', '\u0490', '\u00a6', '\u00a7', '\u0401', '\u00a9', '\u0404', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u0407', '\u00b0', '\u00b1', '\u0406', '\u0456', '\u0491', '\u00b5', '\u00b6', '\u00b7', '\u0451', '\u2116', '\u0454', '\u00bb', '\u0458', '\u0405', '\u0455', '\u0457'};
        private final byte[] bytes;
        private final int offset;
        private final int length;
        private String toStringCache;

        public Win1251CharSequence(byte[] bytes, int offset, int length) {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            int ansi = this.bytes[this.offset + index] & 0xFF;
            if (ansi < 128) {
                return (char)ansi;
            }
            if (ansi < 192) {
                return MAP[ansi - 128];
            }
            return (char)(ansi - 192 + 1040);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new Win1251CharSequence(this.bytes, this.offset + start, end - start);
        }

        @Override
        public String toString() {
            if (this.toStringCache == null) {
                this.toStringCache = new String(this.bytes, this.offset, this.length, TaggedWriter.ANSI);
            }
            return this.toStringCache;
        }
    }
}

