/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.LogContext;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.VirtualUser;
import inform.agent.net.LoginController;
import inform.agent.net.Security;

public class TemporaryLockUserStatus
extends Request {
    private static final int TAG_TLUS_GET_IS_LOCKED = 1;
    private static final int TAG_TLUS_IS_LOCKED = 2;
    private static final int TAG_TLUS_ULOCK = 3;

    public TemporaryLockUserStatus(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    @Override
    public void execute() throws Throwable {
        int accessMask;
        double userId = this.getUserID();
        Security security = this.security();
        double nodeId = this.getTranslatedNodeID();
        AccountNode accountNode = null;
        if (MtdEngine.serverNode().descriptor().useUsersTable) {
            accountNode = VirtualUser.getUser(nodeId);
        }
        if (accountNode == null) {
            accountNode = MtdEngine.getValidAccountNode(this.getTranslatedNodeID());
        }
        if (AccessMask.accessDenied(0x40000000, accessMask = security.accessMask(accountNode))) {
            throw new InformException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432 \u0443\u0437\u043b\u0430");
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        if (accountNode.getType() != 3) {
            out.putBool(2, false);
            out.flush();
            this.sendResult(result.internalBuffer(), result.size());
            return;
        }
        LogContext.Builder blockCause = new LogContext.Builder();
        boolean hasTemporaryLock = LoginController.isBlocked(nodeId) != null || MtdEngine.isFailedLoginCountExceed(nodeId, blockCause);
        TaggedReader in = this.createRequestContentReader();
        if (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    out.putBool(2, hasTemporaryLock);
                    out.flush();
                    this.sendResult(result.internalBuffer(), result.size());
                    return;
                }
                case 3: {
                    if (hasTemporaryLock) {
                        LoginController.successLogin(nodeId);
                        MtdEngine.registerFailedLoginCount(nodeId, true);
                        AccountNode.invalidateSecurity();
                        MtdEngine.invalidate();
                        accountNode.trySetLock(MtdEngine.getMtdCache(), false);
                        hasTemporaryLock = LoginController.isBlocked(nodeId) != null || MtdEngine.isFailedLoginCountExceed(nodeId, blockCause);
                    }
                    out.putBool(2, hasTemporaryLock);
                    out.flush();
                    this.sendResult(result.internalBuffer(), result.size());
                    return;
                }
            }
        }
        this.sendResult();
    }
}

