/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TagReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.AgentJARVersion;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.VersionInfo;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.net.ClientProtocol;
import inform.agent.net.ClientSession;
import inform.agent.net.IoMemory;
import inform.common.Empty;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AgentConnection {
    public final ClientProtocol.ClientType clientType;
    public final Context context;
    private final TaggedSocket socket;
    private final LoginInfo login;
    private final ServerSideHost ssHost;
    private GenericRequest current;
    private static final String NO_CURRENT_REQUEST = "\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f";
    private static final String ANOTHER_REQUEST_RUNNING = "\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0434\u0440\u0443\u0433\u043e\u0439 \u0437\u0430\u043f\u0440\u043e\u0441";
    private static final String INVALID_REQUEST_ID = "\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0437\u0430\u043f\u0440\u043e\u0441";
    private final ByteBuffer rqHeader = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
    private final ByteBuffer resHeader = ByteBuffer.allocate(44).order(ByteOrder.LITTLE_ENDIAN);
    private static final int LOOPS = 3;
    private static final int DEFAULT_CLIENT_PORT = 5001;
    public static final int CLIENT_AGENT_PROTOCOL_VERSION = 10;
    private static final int CHECK_RESULT_TIME = 100;
    private static final int PING_SERVER_PULSE = 150;
    private static final String WIN_NAME = "agent_service";
    private static final byte[] COLON = ":".getBytes(TaggedWriter.ANSI);
    private double sessionId = 0.0;
    private String serverId = "";
    private String agentId = "";
    private final VersionInfo versionInfo = new VersionInfo();

    public AgentConnection(ClientProtocol.ClientType clientType, ServerSideHost ssHost, String server, int port, String agent, String userName, String password, double channelId) throws InformException {
        this(clientType, ssHost, AgentConnection.s2a(server, port), agent, 0.0, userName, password, channelId);
    }

    public AgentConnection(ClientProtocol.ClientType clientType, ServerSideHost ssHost, String server, String agent, double userId, String userName, String password, double channelId) throws InformException {
        this(clientType, ssHost, AgentConnection.s2a(server), agent, userId, userName, password, channelId);
    }

    private AgentConnection(ClientProtocol.ClientType clientType, ServerSideHost ssHost, InetSocketAddress address, String agent, double userId, String userName, String password, double channelId) throws InformException {
        this(clientType, ssHost, address, agent, userId, userName, password, channelId, new Context(address, agent, userName, channelId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentConnection(ClientProtocol.ClientType clientType, ServerSideHost ssHost, InetSocketAddress address, String agent, double userId, String userName, String password, double channelId, Context context) throws InformException {
        this.clientType = clientType;
        this.ssHost = ssHost;
        this.context = context;
        try {
            UserNode userNode = null;
            if (agent == null) {
                throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0430\u0433\u0435\u043d\u0442\u0430");
            }
            if (userId != 0.0) {
                Node node = MtdEngine.getValidNode(userId);
                if (node == null || !(node instanceof UserNode)) {
                    MtdEngine.throwDetailError("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", userId);
                }
                userNode = (UserNode)node;
                userName = userNode.getName();
            }
            if (userName == null) {
                throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
            }
            if (address.isUnresolved()) {
                throw new IllegalArgumentException("\u0421\u0435\u0440\u0432\u0435\u0440 \"" + address.getHostName() + "\" \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
            }
            String comp = InetAddress.getLocalHost().getHostName();
            Core.logger.info("connecting to {} ...", (Object)address);
            TaggedSocket sock = new TaggedSocket(ssHost, address);
            LoginInfo lgn = null;
            try {
                int loopsLeft = 3;
                while (lgn == null && loopsLeft-- >= 0) {
                    sock.out.putSignature();
                    sock.out.putInt32(7, 10);
                    sock.out.putInt32(30, -1);
                    sock.out.putAnsi(20, userName);
                    sock.out.putAnsi(26, WIN_NAME);
                    sock.out.putAnsi(27, comp);
                    sock.out.putEmpty(17);
                    if (this.clientType != ClientProtocol.ClientType.Default) {
                        sock.out.putInt32(137, clientType.id);
                    }
                    sock.out.putRaw(71, VersionInfo.getBinary(AgentJARVersion.MAJOR, AgentJARVersion.MINOR, AgentJARVersion.RELEASE));
                    sock.out.putInt32(78, 2);
                    sock.out.putInt32(138, Core.serverTimeZoneHost.getTimeZoneOffset() / 1000);
                    sock.out.flush();
                    sock.out.putAnsi(14, agent);
                    sock.out.putEmpty(9);
                    sock.out.flush();
                    sock.waitTag().getSignature();
                    int version = sock.waitTag(7).getInt();
                    if (version != 10) {
                        throw new InformException(String.format("\u041d\u0435\u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0439 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e(%d) \u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0430\u0433\u0435\u043d\u0442\u0430(%d)", 10, version));
                    }
                    boolean brk = false;
                    while (!brk) {
                        TagReader tag = sock.waitTag();
                        switch (tag.getCurrentTag()) {
                            case 9: {
                                break;
                            }
                            case 50: {
                                this.serverId = tag.getAnsi();
                                break;
                            }
                            case 51: {
                                this.agentId = tag.getAnsi();
                                break;
                            }
                            case 71: {
                                this.versionInfo.setBinary(tag.getRaw());
                                break;
                            }
                            case 13: {
                                throw new InformException(tag.getAnsi());
                            }
                            case 14: {
                                int p = tag.getInt();
                                sock.close();
                                address = new InetSocketAddress(address.getAddress(), p);
                                sock = new TaggedSocket(ssHost, address);
                                brk = true;
                                break;
                            }
                            case 10: {
                                int clientId = sock.waitTag(30).getInt();
                                String remoteUserName = sock.waitTag(20).getAnsi();
                                double remoteUseId = sock.waitTag(29).getDouble();
                                lgn = new LoginInfo(clientId, remoteUserName, remoteUseId);
                                brk = true;
                                break;
                            }
                            case 11: {
                                throw new InformException(tag.getAnsi());
                            }
                            case 22: {
                                MessageDigest md;
                                byte[] disp;
                                byte[] salt;
                                tag.checkCurrentTag(22);
                                if (tag.getCurrentTagSize() == 16) {
                                    salt = new byte[16];
                                    disp = new byte[16];
                                } else {
                                    salt = new byte[8];
                                    disp = new byte[8];
                                }
                                tag.getRaw(salt, salt.length);
                                sock.waitTag(24).getRaw(disp, disp.length);
                                try {
                                    md = MessageDigest.getInstance(salt.length == 16 ? "SHA-256" : "MD5");
                                }
                                catch (NoSuchAlgorithmException e) {
                                    throw InformException.wrap(e);
                                }
                                if (userNode != null) {
                                    md.update(userNode.isSha256() ? userNode.getSha256Hash() : userNode.getSecurityHash());
                                } else {
                                    md.update(userName.getBytes(TaggedWriter.ANSI));
                                    md.update(COLON);
                                    md.update(salt);
                                    md.update(COLON);
                                    if (password != null) {
                                        md.update(password.getBytes(TaggedWriter.ANSI));
                                    }
                                    md.update(md.digest());
                                }
                                md.update(COLON);
                                md.update(disp);
                                sock.out.putRaw(21, md.digest());
                                sock.out.putEmpty(9);
                                sock.out.flush();
                                break;
                            }
                            case 97: {
                                this.sessionId = tag.getDouble();
                            }
                        }
                    }
                }
                if (lgn == null) {
                    throw new InformException(String.format("\u041f\u043e\u0441\u043b\u0435 %d \u0431\u0435\u0437\u0443\u0441\u043f\u0435\u0448\u043d\u044b\u0445 \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u044c\u0441\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c \"%s\"", 3, address));
                }
            }
            finally {
                if (lgn == null) {
                    sock.close();
                    sock = null;
                }
            }
            this.socket = sock;
            this.login = lgn;
            if (ClientSession.hasSession(this.sessionId)) {
                throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0430\u0433\u0435\u043d\u0442\u0430 \u043a \u0441\u0430\u043c\u043e\u043c\u0443 \u0441\u0435\u0431\u0435");
            }
        }
        catch (Throwable e) {
            throw context.remakeException("\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u044e\u0449\u0435\u0439 \u0441\u0442\u043e\u0440\u043e\u043d\u043e\u0439", e);
        }
    }

    public void request(GenericRequest request) throws InformException {
        try {
            this.waitForResult();
            this.current = request;
            this.rqHeader.putInt(0, request.id);
            this.rqHeader.putInt(4, request.type);
            this.rqHeader.putDouble(8, request.getNode());
            this.rqHeader.putInt(16, 0);
            this.socket.out.putRaw(1, this.rqHeader.array(), this.rqHeader.limit());
            boolean ok = false;
            try {
                this.socket.out.putRaw(3, request.getParams());
                this.socket.out.flush();
                ok = true;
            }
            finally {
                if (!ok) {
                    this.cancelCurrentRequest();
                }
            }
        }
        catch (Throwable e) {
            throw this.context.remakeException("\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0430 \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435", e);
        }
    }

    public boolean hasRequest() {
        return this.current != null;
    }

    public void waitForResult() throws InformException {
        try {
            int count = 0;
            while (this.current != null) {
                TimeUnit.MILLISECONDS.sleep(100L);
                this.checkResponse();
                if (++count <= 150 || this.current == null || !this.socket.socket.isConnected()) continue;
                this.socket.out.putEmpty(6);
                this.socket.out.flush();
                count = 0;
            }
        }
        catch (Throwable e) {
            Object reason = null;
            try {
                String hostReason;
                String coreReason = Core.getAgentStopReason();
                String string = hostReason = this.ssHost == null ? null : this.ssHost.getCancelReason();
                if (coreReason != null) {
                    reason = coreReason;
                }
                if (hostReason != null) {
                    reason = reason == null ? hostReason : (String)reason + "\n" + hostReason;
                }
            }
            catch (Throwable ee) {
                Core.logger.error(null, ee);
            }
            throw this.context.remakeException("\u043e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430 \u0441 \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430", (String)reason, e);
        }
    }

    public void cancelCurrentRequest() throws InformException {
        try {
            if (this.current == null) {
                throw new IllegalStateException(NO_CURRENT_REQUEST);
            }
            try {
                this.socket.out.putInt32(15, this.current.id);
                this.socket.out.flush();
            }
            finally {
                this.current = null;
            }
        }
        catch (Throwable e) {
            throw this.context.remakeException("\u043e\u0442\u043c\u0435\u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0430 \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435", e);
        }
    }

    public void sendChunk(byte[] data) throws InformException {
        try {
            if (this.current == null) {
                throw new IllegalStateException(NO_CURRENT_REQUEST);
            }
            this.socket.out.putInt32(88, this.current.id);
            this.socket.out.putRaw(3, data);
            this.socket.out.flush();
            this.checkResponse();
        }
        catch (Throwable e) {
            throw this.context.remakeException("\u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043f\u043e\u0440\u0446\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u0443", e);
        }
    }

    public void sendChunk(byte[] data, int size) throws InformException {
        try {
            if (this.current == null) {
                throw new IllegalStateException(NO_CURRENT_REQUEST);
            }
            this.socket.out.putInt32(88, this.current.id);
            this.socket.out.putRaw(3, data, size);
            this.socket.out.flush();
            this.checkResponse();
        }
        catch (Throwable e) {
            throw this.context.remakeException("\u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043f\u043e\u0440\u0446\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u0443", e);
        }
    }

    public void sendEndOfChunks() throws InformException {
        try {
            if (this.current == null) {
                throw new IllegalStateException(NO_CURRENT_REQUEST);
            }
            this.socket.out.putInt32(88, this.current.id);
            this.socket.out.putEmpty(89);
            this.socket.out.flush();
            this.checkResponse();
        }
        catch (Throwable e) {
            throw this.context.remakeException("\u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u043f\u043e\u0440\u0446\u0438\u0439 \u0434\u0430\u043d\u043d\u044b\u0445 \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u0443", e);
        }
    }

    private void process(TagReader tag) throws Exception, IOException, TaggedReaderException {
        if (this.current == null) {
            throw new IllegalStateException(NO_CURRENT_REQUEST);
        }
        switch (tag.getCurrentTag()) {
            case 2: {
                tag.getRaw(this.resHeader.array(), this.resHeader.limit());
                if (this.current.id != this.resHeader.getInt(0)) {
                    throw new InformException(INVALID_REQUEST_ID);
                }
                TagReader contentTag = this.socket.nextTag();
                if (contentTag != null && contentTag.getTag() == 3) {
                    this.current.processChunk(contentTag.getRaw());
                    break;
                }
                this.socket.tagBack(tag);
                break;
            }
            case 4: {
                tag.getRaw(this.resHeader.array(), this.resHeader.limit());
                if (this.current.id != this.resHeader.getInt(0)) {
                    throw new InformException(INVALID_REQUEST_ID);
                }
                this.current.processEndOfResult();
                this.current = null;
                break;
            }
            case 16: {
                this.current.processError("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e", "");
                this.current = null;
                this.close();
                break;
            }
            case 5: {
                tag.getRaw(this.resHeader.array(), this.resHeader.limit());
                if (this.current.id != this.resHeader.getInt(0)) {
                    throw new InformException(INVALID_REQUEST_ID);
                }
                boolean readError = true;
                String message = "";
                Object detailing = "";
                block15: while (readError) {
                    tag = this.socket.waitTag();
                    switch (tag.getTag()) {
                        case 3: {
                            readError = false;
                            message = tag.getAnsi();
                            continue block15;
                        }
                        case 19: {
                            switch (tag.getInt()) {
                                case 0: {
                                    message = this.socket.waitTag().getAnsi();
                                    continue block15;
                                }
                                case 1: {
                                    detailing = this.socket.waitTag().getAnsi();
                                    continue block15;
                                }
                                case 2: {
                                    readError = false;
                                    String extra = this.socket.waitTag().getAnsi();
                                    if (extra.isEmpty()) continue block15;
                                    if (!((String)detailing).isEmpty()) {
                                        detailing = (String)detailing + "\n" + extra;
                                        continue block15;
                                    }
                                    detailing = extra;
                                    continue block15;
                                }
                            }
                            readError = false;
                            continue block15;
                        }
                    }
                    readError = false;
                }
                this.current.processError(message, (String)detailing);
                this.current = null;
            }
        }
    }

    public String getAgentId() {
        return this.agentId;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public String getServerId() {
        return this.serverId;
    }

    private void checkResponse() throws InformException {
        try {
            TagReader tag;
            this.socket.idle();
            while (this.current != null && (tag = this.socket.nextTag()) != null) {
                this.process(tag);
            }
        }
        catch (Throwable e) {
            throw this.context.remakeException("\u043e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430 \u0441 \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430", e);
        }
    }

    public void close() throws InformException {
        try {
            TagReader tag;
            if (this.current != null) {
                try {
                    this.cancelCurrentRequest();
                }
                catch (Throwable ex) {
                    Core.logger.error(null, ex);
                }
            }
            this.socket.out.putEmpty(12);
            this.socket.out.flush();
            while ((tag = this.socket.waitTag()).getCurrentTag() != 16) {
            }
            this.socket.close();
        }
        catch (Throwable e) {
            throw this.context.remakeException("\u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u044b\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", e);
        }
    }

    public static InetSocketAddress s2a(String s) {
        if (Strings.isVoid(s)) {
            throw new RemoteAgentError("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u0434\u0440\u0435\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f", null);
        }
        String[] sp = s.split(":");
        int port = 5001;
        if (sp.length > 1) {
            port = Integer.parseInt(sp[1]);
        }
        return new InetSocketAddress(sp[0], port);
    }

    public static InetSocketAddress s2a(String s, int port) {
        if (Strings.isVoid(s)) {
            throw new RemoteAgentError("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u0434\u0440\u0435\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f", null);
        }
        String[] sp = s.split(":");
        if (sp.length > 1) {
            port = 5001;
            if (sp.length > 1) {
                port = Integer.parseInt(sp[1]);
            }
        }
        return new InetSocketAddress(sp[0], port);
    }

    public static class ChannelException
    extends InformException {
        public ChannelException(Context cx, String where, Throwable cause) {
            super(ChannelException.mkMsg(cx, where, null, cause), cause);
            this.detailsFrom(cause);
        }

        public ChannelException(Context cx, String where, String detail, Throwable cause) {
            super(ChannelException.mkMsg(cx, where, detail, cause), cause);
            this.detailsFrom(cause);
        }

        private static String mkMsg(Context cx, String where, String detail, Throwable cause) {
            StringBuilder result = new StringBuilder();
            result.append("\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f, ").append(where);
            String msg = cause.getMessage();
            if (msg != null) {
                result.append('\n').append(cause.getMessage());
            }
            if (detail != null) {
                result.append('\n').append(detail);
            }
            result.append("\n\u043a\u0430\u043d\u0430\u043b [").append((long)cx.channelId).append("]: \"").append(cx).append('\"');
            return result.toString();
        }
    }

    public static class Context {
        private final String host;
        private final String agent;
        private final String user;
        private final int port;
        private final double channelId;

        public Context(InetSocketAddress addr, String agent, String user, double channelId) {
            this.host = addr.getHostName();
            this.port = addr.getPort();
            this.agent = agent;
            this.user = user;
            this.channelId = channelId;
        }

        public InformException remakeException(String where, Throwable cause) {
            if (this.channelId == 0.0) {
                if (cause instanceof InformException) {
                    return (InformException)cause;
                }
                return (InformException)InformException.detail(cause, where);
            }
            if (cause instanceof ChannelException) {
                return (ChannelException)cause;
            }
            return new ChannelException(this, where, cause);
        }

        public InformException remakeException(String where, String detail, Throwable cause) {
            if (this.channelId == 0.0) {
                if (cause instanceof InformException) {
                    return (InformException)cause;
                }
                return ((InformException)InformException.detail(cause, where)).detail(detail);
            }
            if (cause instanceof ChannelException) {
                return (ChannelException)cause;
            }
            return new ChannelException(this, where, detail, cause);
        }

        public String toString() {
            return String.format("%s@%s:%d/%s", this.user, this.host, this.port, this.agent);
        }
    }

    public static class RemoteAgentError
    extends InformException {
        public RemoteAgentError(String message, String detailing) {
            super(message);
            this.detail(detailing);
        }
    }

    public static class PlainRequest
    extends GenericRequest {
        private ByteArrayOutputStream result = null;

        public PlainRequest(int type) {
            super(type);
        }

        public PlainRequest(int type, double nodeId) {
            super(type, nodeId);
        }

        public byte[] getResult() {
            if (this.result == null) {
                return Empty.byteArray;
            }
            return this.result.toByteArray();
        }

        @Override
        protected void processChunk(byte[] chunkData) throws InformException {
            if (this.result == null) {
                this.result = new ByteArrayOutputStream();
            }
            try {
                this.result.write(chunkData);
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
        }
    }

    public static class Request
    extends GenericRequest {
        private byte[][] result = null;

        public Request(int type) {
            super(type);
        }

        public Request(int type, double nodeId) {
            super(type, nodeId);
        }

        public byte[][] getResult() {
            return this.result;
        }

        @Override
        protected void processChunk(byte[] chunkData) throws InformException {
            this.result = this.result == null ? (Object)new byte[1][] : (byte[][])Arrays.copyOf(this.result, this.result.length + 1);
            this.result[this.result.length - 1] = chunkData;
        }
    }

    public static abstract class GenericRequest {
        private static final AtomicInteger ID_GEN = new AtomicInteger();
        public final int id = ID_GEN.incrementAndGet();
        public final int type;
        private double nodeId;
        private byte[] params = Empty.byteArray;

        public GenericRequest(int type) {
            this.type = type;
            this.nodeId = 0.0;
        }

        public GenericRequest(int type, double nodeId) {
            this.type = type;
            this.nodeId = nodeId;
        }

        public double getNode() {
            return this.nodeId;
        }

        public void setNodeId(double nodeId) {
            this.nodeId = nodeId;
        }

        public void setParams(byte[] params) {
            this.params = params == null ? Empty.byteArray : params;
        }

        protected byte[] getParams() {
            return this.params;
        }

        protected abstract void processChunk(byte[] var1) throws InformException;

        protected void processError(String message, String detaling) throws InformException {
            throw new RemoteAgentError(message, detaling);
        }

        protected void processEndOfResult() throws InformException {
        }
    }

    private static class LoginInfo {
        private final int clientId;
        private final String userName;
        private final double userNodeId;

        public LoginInfo(int clientId, String userName, double userNodeId) {
            this.clientId = clientId;
            this.userName = userName;
            this.userNodeId = userNodeId;
        }
    }

    public static class TaggedSocket
    implements Closeable {
        private final ServerSideHost ssHost;
        private final Socket socket;
        private final InputStream sockIn;
        public final TaggedWriter out;
        private final IoMemory receivingBuffer = new IoMemory();
        private final byte[] bytes = new byte[1024];
        private TagReader currentTag = null;

        public TaggedSocket(ServerSideHost ssHost, InetSocketAddress address) throws IOException {
            this.ssHost = ssHost;
            this.socket = new Socket(address.getAddress(), address.getPort());
            this.out = new TaggedWriter(new BufferedOutputStream(this.socket.getOutputStream()));
            this.sockIn = this.socket.getInputStream();
        }

        void idle() {
            if (this.ssHost != null) {
                try {
                    this.ssHost.idle();
                }
                catch (Throwable e) {
                    Object reason = null;
                    try {
                        String coreReason = Core.getAgentStopReason();
                        String hostReason = this.ssHost.getCancelReason();
                        if (coreReason != null) {
                            reason = coreReason;
                        }
                        if (hostReason != null) {
                            reason = reason == null ? hostReason : (String)reason + "\n" + hostReason;
                        }
                    }
                    catch (Throwable ee) {
                        Core.logger.error(null, ee);
                    }
                    if (reason == null) {
                        throw InformException.wrap(e);
                    }
                    throw InformException.detail(e, (String)reason);
                }
            }
        }

        public void processInput() throws IOException {
            while (this.sockIn.available() != 0) {
                int size = this.sockIn.read(this.bytes);
                this.receivingBuffer.add(Arrays.copyOf(this.bytes, size));
            }
            this.idle();
        }

        @Override
        public void close() throws IOException {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        }

        public TagReader waitTag() throws IOException, InformException, InterruptedException {
            TagReader tag = null;
            while (tag == null && (tag = this.nextTag()) == null) {
                Thread.sleep(0L);
            }
            return tag;
        }

        public TagReader waitTag(int tag) throws Exception {
            TagReader t = this.waitTag();
            t.checkCurrentTag(tag);
            return t;
        }

        public TagReader waitTag(int tag, int size) throws Exception {
            TagReader t = this.waitTag();
            t.checkCurrentTag(tag, size);
            return t;
        }

        public TagReader nextTag() throws IOException, InformException {
            TagReader tag;
            this.processInput();
            if (this.currentTag != null) {
                tag = this.currentTag;
                this.currentTag = null;
            } else {
                tag = this.receivingBuffer.poolTagReader();
            }
            return tag;
        }

        public void tagBack(TagReader tag) {
            this.currentTag = new TagReader(tag);
        }
    }
}

