/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net;

import inform.adt.InformException;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.net.Client;
import inform.agent.net.ClientSession;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;

public class AlertingEngine {
    private static final int TAG_IM_CLIENT_BEGIN = 1;
    private static final int TAG_IM_CLIENT_END = 2;
    public static final int TAG_IM_USER_ID = 3;
    public static final int TAG_IM_CLIENT_ID = 4;
    private static final int TAG_IM_CLIENT_NAME = 5;
    private static final int TAG_IM_CLIENT_STATUS = 6;
    private static final int TAG_IM_SENDER_CLIENT_ID = 7;
    private static final int TAG_IM_SENDER_USER_ID = 8;
    private static final int TAG_IM_SENDER_NAME = 9;
    public static final int TAG_IM_MESSAGE_BODY = 10;
    private static final int TAG_IM_EXCHANGE_MESSAGE = 11;
    private static final int TAG_IM_ALERTING_MESSAGES_obsolete = 12;
    private static final int TAG_IM_NOTIFICATION_MESSAGES = 13;
    public static final int TAG_IM_SESSION_ID = 14;
    private static final int TAG_IM_SENDER_SESSION_ID = 15;

    public static void enumerateImClients(TaggedWriter writer) throws IOException, InformException {
        for (Client c : ClientSession.getClients()) {
            writer.putEmpty(1);
            writer.putDouble(3, c.getUserId());
            writer.putInt32(4, c.getClientId());
            writer.putDouble(14, c.getSessionId());
            UserNode user = MtdEngine.getUserNode(c.getUserId());
            if (user != null) {
                writer.putAnsi(5, user.getName());
            }
            writer.putEmpty(2);
        }
    }

    public static void sendExchangeMessage(Client sender, byte[] message, int length) throws IOException {
        ByteArrayOutputStream msg_pkg = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(msg_pkg);
        writer.putRaw(11, message, length);
        writer.flush();
        for (Client c : ClientSession.getClients()) {
            if (c == sender) continue;
            c.sendMessage(msg_pkg.internalBuffer(), msg_pkg.size());
        }
    }

    public static void sendBroadcastMessage(Client sender, byte[] message) throws IOException, InformException {
        ByteArrayOutputStream msg_pkg = AlertingEngine.prepareMessagePacket(sender, message, message.length);
        for (Client c : ClientSession.getClients()) {
            if (c == sender) continue;
            c.sendMessage(msg_pkg.internalBuffer(), msg_pkg.size());
        }
    }

    public static void sendSelectiveMessage(Client sender, byte[] message, int length, IntegerSet recipients) throws IOException, InformException {
        ByteArrayOutputStream msg_pkg = AlertingEngine.prepareMessagePacket(sender, message, length);
        for (Client c : ClientSession.getClients()) {
            if (c == sender || !recipients.contains(c.getClientId())) continue;
            c.sendMessage(msg_pkg.internalBuffer(), msg_pkg.size());
        }
    }

    public static void sendSelectiveMessage(Client sender, byte[] message, int length, DoubleSet recipients) throws IOException, InformException {
        ByteArrayOutputStream msg_pkg = AlertingEngine.prepareMessagePacket(sender, message, length);
        for (Client c : ClientSession.getClients()) {
            if (c == sender || !recipients.contains(c.getSessionId())) continue;
            c.sendMessage(msg_pkg.internalBuffer(), msg_pkg.size());
        }
    }

    public static void sendUserNotification(double userId, byte[] message, int length) throws IOException, InformException {
        ByteArrayOutputStream msg_pkg = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(msg_pkg);
        writer.putRaw(13, message, length);
        writer.flush();
        HashSet<InetAddress> sended = new HashSet<InetAddress>();
        for (Client c : ClientSession.getClients()) {
            InetAddress a;
            if (c.getUserId() != userId || !sended.add(a = c.getSession().socketAddress().getAddress())) continue;
            c.sendMessage(msg_pkg.internalBuffer(), msg_pkg.size());
        }
    }

    public static void sendNotificationToClient(Client recipient, byte[] message, int length) throws IOException {
        if (recipient.isLive()) {
            ByteArrayOutputStream msg_pkg = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(msg_pkg);
            writer.putRaw(13, message, length);
            writer.flush();
            recipient.sendMessage(msg_pkg.internalBuffer(), msg_pkg.size());
        }
    }

    public static void sendChangeNotification(Client sender, byte[] message, int length, long timeout) throws IOException {
        for (Client c : ClientSession.getClients()) {
            if (c == sender) continue;
            c.sendChangeNotification(message, length, timeout);
        }
    }

    private static ByteArrayOutputStream prepareMessagePacket(Client sender, byte[] message, int length) throws IOException, InformException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(result);
        if (sender != null) {
            writer.putInt32(7, sender.getClientId());
            writer.putDouble(15, sender.getSessionId());
            writer.putDouble(8, sender.getUserId());
            UserNode user = MtdEngine.getUserNode(sender.getUserId());
            if (user != null) {
                writer.putAnsi(9, user.getName());
            }
        } else {
            writer.putAnsi(9, "\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440");
        }
        writer.putRaw(10, message, length);
        writer.flush();
        return result;
    }
}

