/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net;

import inform.adt.InformException;
import inform.adt.TimeZoneHost;
import inform.adt.collections.IntegerHash;
import inform.adt.taggedio.AbstractTaggedReader;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.CoreConsts;
import inform.agent.Ini;
import inform.agent.LogContext;
import inform.agent.ProductInfo;
import inform.agent.Request;
import inform.agent.RequestFactory;
import inform.agent.RequestHeader;
import inform.agent.RequestProfile;
import inform.agent.RequestStatistics;
import inform.agent.Statistics;
import inform.agent.VersionInfo;
import inform.agent.am.Telemeter;
import inform.agent.db.DBLogin;
import inform.agent.db.PersonalSessionHelper;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.mtd.LockEngine;
import inform.agent.mtd.MtdEngine;
import inform.agent.net.ClientLoginInfo;
import inform.agent.net.ClientProtocol;
import inform.agent.net.ClientSession;
import inform.agent.net.RequestExecutor;
import inform.agent.net.Security;
import inform.agent.scripts.SSContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class Client
extends ClientProtocol
implements LogContext,
TimeZoneHost {
    public static final int RUNNING_REQUEST_LIMIT = 8;
    public static final int CLIENT_LEVEL_0 = 0;
    public static final int CLIENT_LEVEL_1 = 1;
    public static final int CLIENT_LEVEL_2 = 2;
    public static final int CLIENT_LEVEL_3 = 3;
    public static final int CLIENT_LEVEL_4 = 4;
    public static final int CLIENT_LEVEL_6 = 6;
    private static final AtomicInteger idGen = new AtomicInteger();
    private final int id = idGen.incrementAndGet();
    private final ClientSession session;
    private State state;
    private final ArrayDeque<Request> requestDeque = new ArrayDeque();
    private final IntegerHash<Request> runningRequests = new IntegerHash();
    private Request requestToRun = null;
    private final RequestHeader.Extra requestExtraHeader = new RequestHeader.Extra();
    private byte[] requestExtraParams = null;
    private boolean waitingInputChunkContent = false;
    private int inputChunkRequestId = 0;
    private final long loginTime;
    private long lastRequestActivityTime;
    private boolean wasRequestActivity = false;
    private final ArrayList<DBLogin> dbLogins;
    private ConnectionManager[] personalSessions = PersonalSessionHelper.init();
    private SSContext.ClientContext ssContext;
    ClientLoginInfo loginInfo = null;
    public final Statistics.WithHistory statistics = new Statistics.WithHistory(65536, 5000L);

    public Client(ClientSession session, ArrayList<DBLogin> dbLogins) {
        this.session = session;
        this.state = State.DISCONNECTED;
        this.loginTime = this.lastRequestActivityTime = System.currentTimeMillis();
        if (dbLogins == null || dbLogins.isEmpty()) {
            this.dbLogins = null;
        } else {
            this.dbLogins = new ArrayList(dbLogins.size());
            for (DBLogin dbl : dbLogins) {
                this.dbLogins.add(new DBLogin(dbl));
            }
        }
    }

    public int getClientId() {
        return this.id;
    }

    public double getSessionId() {
        return this.loginInfo.sessionId;
    }

    public double getUserId() {
        return this.loginInfo.userId;
    }

    public double getEffectiveUserId() {
        return this.loginInfo.effectiveUserId == 0.0 ? this.loginInfo.userId : this.loginInfo.effectiveUserId;
    }

    public void setEffectiveUserId(double nodeID) {
        this.loginInfo.effectiveUserId = nodeID;
    }

    public String getUserName() {
        return this.loginInfo.userName;
    }

    public String getHostUserName() {
        return this.loginInfo.hostUserName;
    }

    public String getHostComputerName() {
        return this.loginInfo.hostComputerName;
    }

    public String getHostIP() {
        return this.loginInfo.peerIp;
    }

    public Security security() {
        return this.loginInfo.secutity;
    }

    public double getRootNodeId() {
        return this.loginInfo.rootNodeId;
    }

    public VersionInfo getVersion() {
        return this.loginInfo.clientVersion;
    }

    public ProductInfo getProduct() {
        return this.loginInfo.productInfo;
    }

    public double getLoginId() {
        return this.loginInfo.auditId;
    }

    public boolean isServerToServerLogin() {
        return this.loginInfo.serverToServerLogin;
    }

    @Override
    public int getTimeZoneOffset() {
        return this.loginInfo.getTimeZoneOffset();
    }

    public ClientProtocol.ClientType clientType() {
        return this.loginInfo.clientType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoginInfo(ClientLoginInfo info) {
        this.loginInfo = info;
        this.ssContext = new SSContext.ClientContext(this.loginInfo);
        Client client = this;
        synchronized (client) {
            this.state = State.CONNECTED;
        }
    }

    public boolean isClientLevel(int level) {
        return level <= this.loginInfo.clientLevel;
    }

    public boolean isCurrentUserAnonymous() {
        return this.loginInfo.isAnonUser;
    }

    public void writeLogInfo(String msg) {
        Core.logger.security("{} {} session: {} ip: {} user node: {} win: {} {} {} {} client version: {} auth type: {}", msg, this.loginInfo.userName, (long)this.loginInfo.sessionId, this.loginInfo.peerIp, this.loginInfo.getLogUserId(), this.loginInfo.hostComputerName, this.loginInfo.hostUserName, this.loginInfo.secutity.id == this.loginInfo.userId ? "" : "master user:", this.loginInfo.secutity.id == this.loginInfo.userId ? "" : this.loginInfo.getLogSecurityId(), this.loginInfo.clientVersion, this.loginInfo.isDomainAuthentication ? CoreConsts.authorizationTypeToString(this.loginInfo.authorizationType) : "built-in");
    }

    public ClientSession getSession() {
        return this.session;
    }

    @Override
    public synchronized boolean isLive() {
        if (Core.isAgentStopped()) {
            return false;
        }
        switch (this.state) {
            case DISCONNECTED: 
            case REMOVED: {
                return true;
            }
        }
        return !this.session.isClosing();
    }

    private ByteArrayOutputStream getResultHeader(RequestHeader rq, RequestProfile profile, int options) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream(44);
        LittleEndianDataOutputStream data = new LittleEndianDataOutputStream(result);
        data.writeUnsignedInt(rq.id);
        data.writeInt(rq.request);
        data.writeInt(options);
        long received = profile == null ? 0L : profile.tp_receivedNano;
        data.writeUnsignedInt(received / 1000000L);
        data.writeInt(0);
        long start_executing = profile == null ? 0L : profile.tp_start_processingNano;
        data.writeUnsignedInt(start_executing / 1000000L);
        data.writeUnsignedInt(profile == null ? 0L : profile.tp_end_processingNano / 1000000L);
        long clock = Core.nanoClock();
        data.writeUnsignedInt(clock / 1000000L);
        data.writeUnsignedInt((start_executing - received) / 1000000L);
        data.writeUnsignedInt((clock - start_executing) / 1000000L);
        data.writeUnsignedInt(profile == null ? 0L : profile.standingNano / 1000000L);
        data.flush();
        return result;
    }

    private void putContent(TaggedWriter out, boolean packed, byte[] data, int dataSize) throws IOException {
        if (packed || !this.loginInfo.packTraffic || dataSize <= 255) {
            out.putRaw(3, data, dataSize);
        } else {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            DeflaterOutputStream compression = new DeflaterOutputStream(result);
            compression.write(data, 0, dataSize);
            compression.close();
            if (dataSize - result.size() > 255 || (double)result.size() / (double)dataSize > 0.05) {
                out.putRaw(86, result);
            } else {
                out.putRaw(3, data, dataSize);
            }
        }
    }

    public void sendChunk(RequestHeader rq, byte[] chunk, int chunkSize) throws Exception {
        TaggedWriter out = this.session.createMemoryAwareWriter();
        ByteArrayOutputStream header = this.getResultHeader(rq, null, 2);
        out.putRaw(2, header);
        this.putContent(out, rq.contentPacked, chunk, chunkSize);
        out.flush();
    }

    public void sendResult(RequestHeader rq, RequestProfile profile, byte[] result, int resultLength, byte[] resultInfo, int resultInfoLength) throws Exception {
        if (!this.isLive()) {
            return;
        }
        TaggedWriter out = this.session.createWriter();
        ByteArrayOutputStream header = this.getResultHeader(rq, profile, resultInfoLength == 0 ? 0 : 4);
        if (resultLength > 0 || resultInfoLength > 0) {
            out.putRaw(2, header);
            this.putContent(out, rq.contentPacked, result, resultLength);
            if (resultInfoLength > 0) {
                out.putRaw(79, resultInfo, resultInfoLength);
            }
        }
        out.putRaw(4, header);
        out.flush();
    }

    public void sendError(RequestHeader rq, RequestProfile profile, String text, String extraText, String detailing) throws Exception {
        if (!this.isLive()) {
            return;
        }
        TaggedWriter out = this.session.createWriter();
        ByteArrayOutputStream header = this.getResultHeader(rq, profile, 0);
        out.putRaw(5, header);
        if (this.loginInfo.clientLevel <= 1) {
            StringBuilder msg = new StringBuilder();
            msg.append(text);
            if (extraText != null && extraText.length() != 0) {
                msg.append("\r\n").append(extraText);
            }
            if (detailing != null && detailing.length() != 0) {
                msg.append("\r\n").append(detailing);
            }
            out.putAnsi(3, msg.toString());
        } else {
            if (text != null && !text.isEmpty()) {
                out.putInt32(19, 0);
                out.putAnsi(3, text);
            }
            if (extraText != null && extraText.length() != 0) {
                out.putInt32(19, 1);
                out.putAnsi(3, extraText);
            }
            if (detailing != null && detailing.length() != 0) {
                out.putInt32(19, 2);
                out.putAnsi(3, detailing);
            }
            out.putInt32(19, -1);
        }
        out.flush();
    }

    public void sendError(RequestHeader rq, RequestProfile profile, String text) throws Exception {
        this.sendError(rq, profile, text, null, null);
    }

    public void sendError(RequestHeader rq, RequestProfile profile, String text, String extraText) throws Exception {
        this.sendError(rq, profile, text, extraText, null);
    }

    public void sendRequestState(RequestHeader rq, RequestProfile profile, byte[] data, int size) throws IOException {
        if (!this.isLive()) {
            return;
        }
        TaggedWriter out = this.session.createWriter();
        ByteArrayOutputStream header = this.getResultHeader(rq, profile, 0);
        out.putRaw(18, header);
        this.putContent(out, rq.contentPacked, data, size);
        out.flush();
    }

    public void sendMessage(byte[] message, int length) throws IOException {
        if (!this.isLive()) {
            return;
        }
        TaggedWriter out = this.session.createWriter();
        out.putRaw(63, message, length);
        out.flush();
    }

    public void sendChangeNotification(byte[] notification, int length, long timeout) throws IOException {
        if (!this.isLive()) {
            return;
        }
        TaggedWriter out = this.session.createWriter();
        out.putRaw(58, notification, length);
        out.flush();
    }

    public void shutdown() {
        if (this.session.isConnected()) {
            try {
                TaggedWriter out = this.session.createWriter();
                out.putEmpty(16);
                out.flush();
                this.session.close(false);
            }
            catch (IOException ex) {
                Core.logger.error("Client.shutdown", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(String reason) {
        try {
            LogContext.CURRENT.set(this);
            this.writeLogInfo("logout");
            this.loginInfo.registrateLogin(2, this.id, reason);
            ArrayDeque<Request> arrayDeque = this.requestDeque;
            synchronized (arrayDeque) {
                this.requestDeque.clear();
            }
            Request[] requestsToCancel = new Request[8];
            Request[] requestArray = this.runningRequests;
            synchronized (this.runningRequests) {
                requestsToCancel = this.runningRequests.toArray((Request[])requestsToCancel);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                for (Request request : requestsToCancel) {
                    if (request == null) break;
                    try {
                        request.cancelRun("\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c");
                    }
                    catch (Throwable ex) {
                        Core.logger.error(null, ex);
                    }
                }
                PersonalSessionHelper.closeAll(null, this.personalSessions);
                if (this.dbLogins != null) {
                    for (DBLogin dbl : this.dbLogins) {
                        try {
                            dbl.close();
                        }
                        catch (SQLException ex) {
                            Core.logger.error(null, ex);
                        }
                    }
                }
            }
        }
        finally {
            LogContext.CURRENT.set(null);
            LockEngine.unlockAll(this);
            MtdEngine.unlockClientSchemeLocks(this);
        }
        {
            return;
        }
    }

    private void disconnect() {
        try {
            this.session.close();
        }
        catch (IOException ex) {
            Core.logger.error("Client.disconnect", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequestDeque() {
        while (true) {
            Iterable<Request> iterable;
            Request request;
            IntegerHash<Request> integerHash = this.runningRequests;
            synchronized (integerHash) {
                if (this.runningRequests.size() >= 8) {
                    return;
                }
            }
            do {
                iterable = this.requestDeque;
                synchronized (iterable) {
                    request = this.requestDeque.poll();
                }
                if (request != null) continue;
                return;
            } while (request.isCancelled());
            request.setState(2);
            iterable = this.runningRequests;
            synchronized (iterable) {
                Request old = this.runningRequests.add(request);
                if (old != null) {
                    throw new IllegalStateException(String.format("Queuing for request [%s] failed. Slot with id:%d already used", old, request.getID()));
                }
            }
            RequestExecutor.runRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeRequest(AbstractTaggedReader in) throws Exception {
        if (this.requestToRun == null) {
            return false;
        }
        Request request = this.requestToRun;
        request.setState(1);
        this.requestToRun = null;
        byte[] requestContent = null;
        switch (in.getCurrentTag()) {
            case 3: {
                requestContent = in.getRaw();
                break;
            }
            case 86: {
                ByteArrayOutputStream content = new ByteArrayOutputStream();
                ByteArrayInputStream input = new ByteArrayInputStream(in.getRaw());
                try (InflaterInputStream compression = new InflaterInputStream(input);){
                    int size;
                    byte[] buf = new byte[1024];
                    while ((size = compression.read(buf)) >= 0) {
                        if (size == 0) continue;
                        content.write(buf, 0, size);
                    }
                }
                content.flush();
                requestContent = content.toByteArray();
                break;
            }
            default: {
                return false;
            }
        }
        request.setRequestContent(requestContent);
        ArrayDeque<Request> arrayDeque = this.requestDeque;
        synchronized (arrayDeque) {
            this.requestDeque.add(request);
        }
        this.executeRequestDeque();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeRequest(Request request) {
        IntegerHash<Request> integerHash = this.runningRequests;
        synchronized (integerHash) {
            if (this.runningRequests.remove(request.getID()) == null) {
                throw new IllegalStateException(String.format("Disposing failed. Request [%s] not running", request));
            }
        }
        this.executeRequestDeque();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRunningRequest() {
        this.loginInfo.logInfo();
        Iterable<Request> iterable = this.requestDeque;
        synchronized (iterable) {
            Core.logger.info("[requestDeque] {}", (Object)this.requestDeque.size());
        }
        iterable = this.runningRequests;
        synchronized (iterable) {
            Core.logger.info("[runningRequests] {}", (Object)this.runningRequests.size());
            for (Request request : this.runningRequests) {
                request.traceLog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request getExistingRequest(int id) {
        Iterable<Request> iterable = this.requestDeque;
        synchronized (iterable) {
            for (Request request : this.requestDeque) {
                if (request.getID() != id) continue;
                return request;
            }
        }
        iterable = this.runningRequests;
        synchronized (iterable) {
            return this.runningRequests.get(id);
        }
    }

    private boolean processInputChunk(AbstractTaggedReader in) throws Exception {
        switch (in.getCurrentTag()) {
            case 3: 
            case 89: {
                break;
            }
            default: {
                return false;
            }
        }
        Request request = this.getExistingRequest(this.inputChunkRequestId);
        this.waitingInputChunkContent = false;
        if (request == null) {
            return false;
        }
        switch (in.getCurrentTag()) {
            case 3: {
                request.addInputChunk(in.getRaw());
                return true;
            }
            case 89: {
                request.endInputChunk();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleTag(AbstractTaggedReader in) throws Exception {
        LogContext.CURRENT.set(this);
        try {
            if (this.requestToRun != null && this.executeRequest(in)) {
                return;
            }
            if (this.waitingInputChunkContent && this.processInputChunk(in)) {
                return;
            }
            switch (in.getCurrentTag()) {
                case 0: {
                    Core.logger.info("? RequestExecutorThread: SilentShutdown");
                    this.disconnect();
                    return;
                }
                case 12: {
                    this.disconnect();
                    return;
                }
                case 6: {
                    Core.logger.info("PING");
                    TaggedWriter out = this.session.createWriter();
                    out.putEmpty(103);
                    out.flush();
                    return;
                }
                case 1: {
                    this.requestToRun = this.readRequest(in.getRaw());
                    if (this.requestToRun != null && this.requestExtraParams != null && this.requestExtraHeader.isExtraOf(this.requestToRun.getRequestHeader())) {
                        this.requestToRun.setRequestExtraParams(this.requestExtraParams, this.requestExtraHeader.getNanoClock());
                    }
                    this.requestExtraHeader.clear();
                    this.requestExtraParams = null;
                    return;
                }
                case 15: {
                    Request requesToCancel;
                    int requestId = in.getInt();
                    IntegerHash<Request> integerHash = this.runningRequests;
                    synchronized (integerHash) {
                        requesToCancel = this.runningRequests.get(requestId);
                    }
                    Core.logger.info("\u041e\u0442\u043c\u0435\u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: Client.handleTag tagCancelRequest");
                    if (requesToCancel == null) return;
                    Core.logger.info("\u041e\u0442\u043c\u0435\u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: Client.handleTag cancelRun {}", (Object)requesToCancel);
                    requesToCancel.cancelRun("\u041e\u0442\u043c\u0435\u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043f\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0443 \u043a\u043b\u0438\u0435\u043d\u0442\u0430");
                    return;
                }
                case 88: {
                    this.inputChunkRequestId = in.getInt();
                    this.waitingInputChunkContent = true;
                    return;
                }
                case 122: {
                    this.requestExtraParams = in.getRaw();
                    return;
                }
                case 123: {
                    this.requestExtraHeader.read(in.getRaw());
                    return;
                }
            }
            return;
        }
        catch (Throwable ex) {
            this.disconnect();
            throw InformException.wrap(ex);
        }
        finally {
            LogContext.CURRENT.set(null);
        }
    }

    private RequestHeader readRequestHeader(byte[] args) throws Exception {
        LittleEndianDataInputStream header = new LittleEndianDataInputStream(new ByteArrayInputStream(args));
        int requestId = header.readInt();
        int requestNo = header.readInt();
        double nodeId = header.readDouble();
        int sessionId = header.readInt();
        return new RequestHeader(requestId, requestNo, nodeId, sessionId, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request readRequest(byte[] args) throws Exception {
        RequestHeader rq = this.readRequestHeader(args);
        if (rq.request != 1024) {
            Client client = this;
            synchronized (client) {
                this.wasRequestActivity = true;
            }
        }
        if (this.loginInfo.discardedVersion && rq.request != 69 && rq.request != 115) {
            StringBuilder msg = new StringBuilder();
            msg.append("\u041d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0439 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.\n\u0412\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 ").append(this.loginInfo.clientVersion.toString());
            VersionInfo minVersion = Core.getMinClientVersion(this.loginInfo.clientVersion.getMajor());
            VersionInfo maxVersion = Core.getMaxClientVersion();
            if (this.loginInfo.clientVersion.lessThen(minVersion)) {
                msg.append(", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u0432\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 ").append(minVersion.toString()).append(".\n");
            } else if (maxVersion.lessThen(this.loginInfo.clientVersion)) {
                msg.append(", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u0432\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u043d\u0435 \u0431\u043e\u043b\u0435\u0435 ").append(maxVersion.toString()).append(".\n");
            } else {
                msg.append(".\n");
            }
            msg.append("\u0414\u0430\u043b\u044c\u043d\u0435\u0439\u0448\u0430\u044f \u0440\u0430\u0431\u043e\u0442\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.");
            this.sendError(rq, null, msg.toString());
            return null;
        }
        Request request = null;
        try {
            if (this.loginInfo.clientType != ClientProtocol.ClientType.Default) {
                RequestFactory.check(this.loginInfo.clientType, rq.request);
            }
            request = RequestFactory.create(rq);
        }
        catch (InformException ex) {
            Core.logger.error(null, ex);
            this.sendError(rq, null, ex.toString());
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gatherTelemetry(Telemeter.Gatherer gatherer) throws IOException {
        long time;
        TimeZoneHost r3;
        if (Ini.autoDisconnectTime == 0) {
            Iterable<Request> iterable = this.requestDeque;
            synchronized (iterable) {
                for (Request r2 : this.requestDeque) {
                    r2.gatherTelemetry(gatherer);
                }
            }
            iterable = this.runningRequests;
            synchronized (iterable) {
                for (Request r2 : this.runningRequests) {
                    r2.gatherTelemetry(gatherer);
                }
            }
        }
        boolean hasExecutableRequest = false;
        Object object = this.requestDeque;
        synchronized (object) {
            for (TimeZoneHost r3 : this.requestDeque) {
                r3.gatherTelemetry(gatherer);
                if (r3.getID() == 1024) continue;
                hasExecutableRequest = true;
            }
        }
        object = this.runningRequests;
        synchronized (object) {
            for (TimeZoneHost r3 : this.runningRequests) {
                r3.gatherTelemetry(gatherer);
                if (r3.getID() == 1024) continue;
                hasExecutableRequest = true;
            }
        }
        if (!hasExecutableRequest) {
            object = this;
            synchronized (object) {
                hasExecutableRequest = this.wasRequestActivity;
            }
        }
        if (hasExecutableRequest) {
            object = this;
            synchronized (object) {
                this.wasRequestActivity = false;
                this.lastRequestActivityTime = System.currentTimeMillis();
            }
        }
        r3 = this;
        synchronized (r3) {
            time = System.currentTimeMillis() - this.lastRequestActivityTime;
        }
        if (time > (long)(Ini.autoDisconnectTime * 60000)) {
            String ends;
            if (1L <= (time /= 60000L) && time <= 20L) {
                ends = "";
            } else {
                switch ((byte)(time % 10L)) {
                    case 1: {
                        ends = "y";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        ends = "\u044b";
                        break;
                    }
                    default: {
                        ends = "";
                    }
                }
            }
            this.session.kill("\u0410\u0432\u0442\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 " + time + " \u043c\u0438\u043d\u0443\u0442" + ends + " \u043f\u0440\u043e\u0441\u0442\u043e\u044f");
        }
    }

    @Override
    public void contextMessage(LogContext.Builder out) {
        if (this.loginInfo != null) {
            out.append("s", (long)this.loginInfo.sessionId);
            out.append("u", (long)this.loginInfo.userId);
        }
    }

    @Override
    public Client client() {
        return this;
    }

    @Override
    public RequestStatistics.Value rqstat() {
        return null;
    }

    @Override
    public SSContext getSSContext() {
        return this.ssContext;
    }

    public long loginTime() {
        return this.loginTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRunningRequests() {
        IntegerHash<Request> integerHash = this.runningRequests;
        synchronized (integerHash) {
            return !this.runningRequests.empty();
        }
    }

    public DatabaseDescriptor getDBLogin(DatabaseDescriptor db) throws SQLException {
        if (this.dbLogins == null) {
            return null;
        }
        for (DBLogin dbl : this.dbLogins) {
            if (dbl.getDatabaseId() != db.getNodeId()) continue;
            return dbl.adjust(db);
        }
        return null;
    }

    public void personalSessionCreated(ConnectionManager ps) {
        this.personalSessions = PersonalSessionHelper.add(this.personalSessions, ps);
    }

    public void personalSessionClosed(ConnectionManager ps) {
        PersonalSessionHelper.remove(this.personalSessions, ps);
    }

    public static enum State {
        CONNECTED,
        DISCONNECTING,
        DISCONNECTED,
        REMOVED;

    }
}

