/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.TimeZoneHost;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.ProductInfo;
import inform.agent.VersionInfo;
import inform.agent.mtd.AuditJournal;
import inform.agent.net.ClientProtocol;
import inform.agent.net.Security;
import java.io.IOException;

public class ClientLoginInfo
implements TimeZoneHost {
    public String userName = null;
    public String certName = null;
    public String hostUserName = null;
    public String hostComputerName = null;
    public String ip = null;
    public double userId = 0.0;
    public double effectiveUserId = 0.0;
    public Security secutity = Security.ZERO;
    public double auditId = 0.0;
    public double rootNodeId = 0.0;
    public String peerIp = null;
    public String peerPort = null;
    public String agentIP = null;
    public boolean packTraffic = false;
    public int authorizationType = 0;
    public boolean isDomainAuthentication = false;
    boolean discardedVersion = false;
    final VersionInfo clientVersion = new VersionInfo();
    final ProductInfo productInfo = new ProductInfo();
    int clientLevel = 0;
    String serverHostName = null;
    public double sessionId = 0.0;
    public boolean serverToServerLogin = false;
    public boolean isAnonUser = false;
    public ClientProtocol.ClientType clientType = ClientProtocol.ClientType.Default;
    public boolean timeZoneAssigned = false;
    public int timeZoneOffset = Integer.MAX_VALUE;
    public double persistentSessionId = 0.0;
    public byte[] persistentSessionH1 = null;
    private String logUserId = null;
    private String logSecurityId = null;
    private String logAuditRecordId = null;
    private String logRootNodeId = null;

    @Override
    public int getTimeZoneOffset() {
        return this.timeZoneAssigned ? this.timeZoneOffset : DateTime.serverZoneOffset();
    }

    public String getLogAuditRecordId() {
        if (this.logAuditRecordId == null) {
            this.logAuditRecordId = NumberConverter.doubleToString(this.auditId);
        }
        return this.logAuditRecordId;
    }

    public String getLogSecurityId() {
        if (this.logSecurityId == null) {
            this.logSecurityId = NumberConverter.doubleToString(this.secutity.id);
        }
        return this.logSecurityId;
    }

    public String getLogUserId() {
        if (this.logUserId == null) {
            this.logUserId = NumberConverter.doubleToString(this.userId);
        }
        return this.logUserId;
    }

    public void registrateLogin(int code, int clientId, String info) {
        AuditJournal journal = new AuditJournal(AuditJournal.Journal.LOGIN);
        if (!journal.isEnabled()) {
            return;
        }
        AuditJournal.LoginParams params = new AuditJournal.LoginParams();
        params.code = code;
        params.userId = this.userId;
        params.time = System.currentTimeMillis();
        params.computer = this.hostComputerName;
        params.computerLogin = this.hostUserName;
        params.ip = this.peerIp;
        params.clientId = clientId;
        params.auditId = this.auditId;
        params.sessionId = this.sessionId;
        params.clientVersion = this.clientVersion;
        params.agentIP = this.agentIP;
        params.info = info;
        journal.registrateLogin(params);
        this.auditId = params.auditId;
    }

    public void registrateLogin(int code, int clientId) {
        this.registrateLogin(code, clientId, null);
    }

    public void registrateFailedLogin(String failedMessage, String place) throws InformException, IOException, TaggedReaderException {
        Core.logger.security("Failed Login - user id: {} user name: {} windows user: {} computer name: {} computer ip: {} error: {} place: {}", this.userId, this.userName, this.hostUserName, this.hostComputerName, this.peerIp, failedMessage, place);
        this.registrateLogin(10, 0);
    }

    public void logInfo() {
        Core.logger.info("Client session id: {}, user id: {}, user name: {}, windows user: {}, computer name: {}, computer ip: {}, client version: {}", (long)this.sessionId, this.userId, this.userName, this.hostUserName, this.hostComputerName, this.peerIp, this.clientVersion);
    }
}

