/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net;

import inform.adt.collections.DoubleHash;

public class LoginController {
    public static final long MAX_PAUSE_TIME = 10000L;
    public static final long INC_PAUSE_TIME = 1000L;
    private static final DoubleHash<Info> logins = new DoubleHash();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void successLogin(double userId) {
        Info info;
        DoubleHash<Info> doubleHash = logins;
        synchronized (doubleHash) {
            info = logins.get(userId);
        }
        if (info != null) {
            info.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failedLogin(double userId, Result result) {
        Info info;
        DoubleHash<Info> doubleHash = logins;
        synchronized (doubleHash) {
            info = logins.get(userId);
            if (info == null) {
                info = new Info(userId);
                DoubleHash<Info> doubleHash2 = logins;
                synchronized (doubleHash2) {
                    logins.add(info);
                }
                return;
            }
        }
        info.newTry(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String isBlocked(double userId) {
        Info info;
        DoubleHash<Info> doubleHash = logins;
        synchronized (doubleHash) {
            info = logins.get(userId);
        }
        if (info == null) {
            return null;
        }
        return info.isBlocked();
    }

    private static class Info
    implements DoubleHash.Entry {
        final double userId;
        int tryCount;
        int denyCount;
        int totalDenyCount;
        long lastTime;
        Result result;

        Info(double userId) {
            this.userId = userId;
            this.tryCount = 1;
            this.denyCount = 0;
            this.result = Result.Success;
            this.lastTime = System.currentTimeMillis();
        }

        synchronized void newTry(Result result) {
            if (this.result != result) {
                this.clear();
                this.result = result;
            }
            if (this.tryCount > 0) {
                long nextTime;
                long time = System.currentTimeMillis();
                long pause = (long)this.tryCount * 1000L;
                if (pause > 10000L) {
                    pause = 10000L;
                }
                if (time > (nextTime = this.lastTime + pause)) {
                    this.denyCount = 0;
                } else {
                    ++this.denyCount;
                    ++this.totalDenyCount;
                }
            }
            ++this.tryCount;
            this.lastTime = System.currentTimeMillis();
        }

        synchronized String isBlocked() {
            long nextTime;
            if (this.denyCount <= 0) {
                return null;
            }
            long time = System.currentTimeMillis();
            long pause = (long)this.tryCount * 1000L;
            if (pause > 10000L) {
                pause = 10000L;
            }
            if (time > (nextTime = this.lastTime + pause)) {
                return null;
            }
            return String.format("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u043e\u0434\u0431\u043e\u0440\u0430 \u043f\u0430\u0440\u043e\u043b\u044f(%d \u0440\u0430\u0437, \u0432\u0441\u0435\u0433\u043e \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u043f\u043e\u0434\u0431\u043e\u0440\u0430: %d, \u0432\u0441\u0435\u0433\u043e \u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u043d\u044b\u0445 \u0432\u0445\u043e\u0434\u043e\u0432: %d)", this.denyCount, this.totalDenyCount, this.tryCount);
        }

        synchronized void clear() {
            this.result = Result.Success;
            this.tryCount = 0;
            this.denyCount = 0;
            this.totalDenyCount = 0;
        }

        @Override
        public double key() {
            return this.userId;
        }
    }

    static enum Result {
        Success,
        Failed,
        Obsolete;

    }
}

