/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net;

import inform.agent.AtomicUtils;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.PhaThread;
import inform.agent.Request;
import inform.agent.RequestDuration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RequestExecutor {
    private static final ExecutorService shortExecutorService;
    private static final ExecutorService longExecutorService;
    private static final AtomicInteger pooledTaskCounter;
    private static final AtomicInteger maxRequestCountSTS;
    private static final AtomicInteger maxRequestCountTLM;
    private static final AtomicLong totalRequestWaitForExecuteTime;

    public static void runRequest(Request request) {
        int taskCount = pooledTaskCounter.incrementAndGet();
        ExecutorService executorService = shortExecutorService;
        if (longExecutorService != null && request.duration.duration() > RequestDuration.MIDDLE.duration()) {
            executorService = longExecutorService;
        }
        request.setFuture(executorService.submit(request));
        AtomicUtils.updateMaximum(maxRequestCountSTS, taskCount, pooledTaskCounter);
        AtomicUtils.updateMaximum(maxRequestCountTLM, taskCount, pooledTaskCounter);
    }

    public static void requestStarted(Request request, long waitForExecuteTime) {
        totalRequestWaitForExecuteTime.addAndGet(waitForExecuteTime);
    }

    public static void requestCompleted() {
        pooledTaskCounter.decrementAndGet();
    }

    public static void shutdown() {
        shortExecutorService.shutdownNow();
        if (longExecutorService != null) {
            longExecutorService.shutdownNow();
        }
    }

    public static void awaitTermination() throws InterruptedException {
        if (!shortExecutorService.awaitTermination(2L, TimeUnit.SECONDS)) {
            Core.logger.warn("long(>2s) termination of shortExecutorService");
            if (!shortExecutorService.awaitTermination(1L, TimeUnit.HOURS)) {
                Core.logger.warn("long(>1 hour) termination of shortExecutorService");
            }
        }
        if (longExecutorService != null && !longExecutorService.awaitTermination(2L, TimeUnit.SECONDS)) {
            Core.logger.warn("long(>2s) termination of longExecutorService");
            if (!longExecutorService.awaitTermination(1L, TimeUnit.HOURS)) {
                Core.logger.warn("long(>1 hour) termination of longExecutorService");
            }
        }
    }

    public static boolean canStartSoftTerminate() {
        int shortActiveCount = ((ThreadPoolExecutor)shortExecutorService).getActiveCount();
        int longActiveCount = 0;
        if (longExecutorService != null) {
            longActiveCount = ((ThreadPoolExecutor)longExecutorService).getActiveCount();
        }
        return shortActiveCount == 0 && longActiveCount == 0;
    }

    public static int pollMaximumRequestCountSTS() {
        return maxRequestCountSTS.getAndSet(pooledTaskCounter.get());
    }

    public static int pollMaximumRequestCountTLM() {
        return maxRequestCountTLM.getAndSet(pooledTaskCounter.get());
    }

    public static long getCurrentTotalRequestWaitForExecuteTime() {
        return totalRequestWaitForExecuteTime.get();
    }

    static {
        longExecutorService = null;
        pooledTaskCounter = new AtomicInteger();
        maxRequestCountSTS = new AtomicInteger();
        maxRequestCountTLM = new AtomicInteger();
        totalRequestWaitForExecuteTime = new AtomicLong();
        int maxSize = Ini.MaxThreads;
        int minSize = maxSize / 3;
        if (minSize <= 0) {
            minSize = 1;
        }
        Core.logger.info("Starting executor pool. min:{} max:{} .", (Object)minSize, (Object)maxSize);
        shortExecutorService = PhaThread.newFixedThreadPool(minSize, maxSize, "w");
    }
}

