/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net.request;

import inform.adt.IO;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class GetHelpContent
extends Request {
    private static final int TAG_HELP_FOLDER = 1;
    private static final int TAG_TOPIC_IDENTIFICATOR = 2;
    private static final int TAG_TOPIC_CONTENT = 3;

    public GetHelpContent(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader reader = this.createRequestContentReader();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        String helpFolder = null;
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    helpFolder = reader.getAnsi();
                    break;
                }
                case 2: {
                    String topicIdentificator = reader.getAnsi();
                    this.putTopicContent(helpFolder, topicIdentificator, out);
                }
            }
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putTopicContent(String helpFolder, String topicIdentificator, TaggedWriter out) throws IOException {
        if (Strings.isVoid(helpFolder) || Strings.isVoid(topicIdentificator)) {
            return;
        }
        String root = new File(Ini.PatchPath).getAbsolutePath().replace("\\", "/");
        StringBuilder clientZipFileName = new StringBuilder();
        clientZipFileName.append(root);
        if (!root.endsWith("/")) {
            clientZipFileName.append("/");
        }
        clientZipFileName.append(this.client().getProduct().folder()).append("/").append(this.client().getProduct().prefix()).append(this.client().getVersion().toString()).append(this.client().getProduct().suffix());
        File clientZipFile = new File(clientZipFileName.toString());
        if (!clientZipFile.exists()) {
            return;
        }
        try (ZipFile clientZip = new ZipFile(clientZipFile);){
            StringBuilder helpEntryName = new StringBuilder();
            helpEntryName.append("help/").append(helpFolder).append(".ahelp");
            ZipEntry helpEntry = clientZip.getEntry(helpEntryName.toString());
            if (helpEntry == null) {
                return;
            }
            InputStream cis = clientZip.getInputStream(helpEntry);
            if (cis == null) {
                return;
            }
            try (ZipInputStream zipHelpStream = new ZipInputStream(cis);){
                ZipEntry topicEntry = zipHelpStream.getNextEntry();
                while (topicEntry != null) {
                    if (!topicEntry.getName().equalsIgnoreCase(topicIdentificator.concat(".asmodoc"))) {
                        topicEntry = zipHelpStream.getNextEntry();
                        continue;
                    }
                    try {
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        IO.transfer(zipHelpStream, buffer);
                        out.putAnsi(2, topicIdentificator);
                        out.putRaw(3, buffer.toByteArray());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    break;
                }
            }
            finally {
                cis.close();
            }
        }
    }
}

