/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.SystemTable;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.BitSet;

public class ChannelTable
extends SystemTable {
    private final FieldDescriptor[] fields = new FieldDescriptor[8];
    private SqlParameter[] values = null;
    public static final int ctfChannelId = 0;
    public static final int ctfTitleId = 1;
    public static final int ctfReceivingId = 2;
    public static final int ctfBackReceivingId = 3;
    public static final int ctfRemoteServerId = 4;
    public static final int ctfRemoteAgentId = 5;
    public static final int ctfRemoteLoginId = 6;
    public static final int ctfRemotePasswordId = 7;
    public static final int ctfCount = 8;
    private static final SystemTable.SystemFieldDesc[] RTF_DESC = new SystemTable.SystemFieldDesc[]{new SystemTable.SystemFieldDesc("ID \u041a\u0430\u043d\u0430\u043b\u0430", keyTypes), new SystemTable.SystemFieldDesc("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a", strTypes), new SystemTable.SystemFieldDesc("\u0423\u0437\u0435\u043b \u041f\u0440\u0438\u0451\u043c\u0430", keyTypes), new SystemTable.SystemFieldDesc("\u041e\u0431\u0440\u0430\u0442\u043d\u044b\u0439 \u0443\u0437\u0435\u043b \u041f\u0440\u0438\u0451\u043c\u0430", keyTypes), new SystemTable.SystemFieldDesc("\u0423\u0434\u0430\u043b\u0451\u043d\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0435\u0440", strTypes), new SystemTable.SystemFieldDesc("\u0423\u0434\u0430\u043b\u0451\u043d\u043d\u044b\u0439 \u0430\u0433\u0435\u043d\u0442", strTypes), new SystemTable.SystemFieldDesc("\u0423\u0434\u0430\u043b\u0451\u043d\u043d\u044b\u0439 \u043b\u043e\u0433\u0438\u043d", strTypes), new SystemTable.SystemFieldDesc("\u0423\u0434\u0430\u043b\u0451\u043d\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c", strTypes)};

    public ChannelTable() throws IOException {
        this(((ServerNode)MtdEngine.getValidNode(2.0)).descriptor(), true);
    }

    public ChannelTable(boolean throwExceptions) throws IOException {
        this(((ServerNode)MtdEngine.getValidNode(2.0)).descriptor(), throwExceptions);
    }

    public ChannelTable(ServerNode.Descriptor descriptor) throws IOException {
        this(descriptor, true);
    }

    public ChannelTable(ServerNode.Descriptor descriptor, boolean throwExceptions) throws IOException {
        int ctf;
        assert (RTF_DESC.length == 8);
        byte[] content = descriptor.channelTable;
        if (content == null || content.length == 0) {
            return;
        }
        TaggedReader in = new TaggedReader(content);
        BitSet loadedRtf = new BitSet();
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    double tableId = in.getNodeID();
                    if (tableId == 0.0) {
                        return;
                    }
                    this.table = TableDescriptor.getIfExists(tableId);
                    if (this.table == null) {
                        if (throwExceptions) {
                            throw new InformException("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u043a\u0430\u043d\u0430\u043b\u043e\u0432 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 [" + (long)tableId + "]");
                        }
                        return;
                    }
                    this.enabled = true;
                    break;
                }
                case 2: {
                    if (this.table == null) {
                        return;
                    }
                    ctf = in.getInt();
                    loadedRtf.set(ctf);
                    if (ctf < 0 || this.fields.length <= ctf) break;
                    int fieldId = in.getInt(3);
                    this.fields[ctf] = this.table.getFieldDescriptor(fieldId);
                    break;
                }
                case 4: {
                    this.enabled = in.getBoolean();
                }
            }
        }
        for (ctf = 0; ctf < this.fields.length; ++ctf) {
            FieldDescriptor field = this.fields[ctf];
            SystemTable.SystemFieldDesc d = RTF_DESC[ctf];
            if (field == null) {
                if (!ChannelTable.isImportantField(ctf)) continue;
                TableDescriptor t = this.table;
                this.table = null;
                if (throwExceptions) {
                    if (loadedRtf.get(ctf)) {
                        throw new InformException("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u043a\u0430\u043d\u0430\u043b\u043e\u0432 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 " + d.name + " (\u0442\u0430\u0431\u043b\u0438\u0446\u0430 " + t.toString() + ")");
                    }
                    throw new InformException("\u0412 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043a\u0430\u043d\u0430\u043b\u043e\u0432 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u043b\u0435 " + d.name + " (\u0442\u0430\u0431\u043b\u0438\u0446\u0430 " + t.toString() + ")");
                }
                return;
            }
            if (d.isValid(field.getType().toInt())) continue;
            TableDescriptor t = this.table;
            this.table = null;
            if (throwExceptions) {
                throw new InformException("\u041f\u043e\u043b\u0435 " + field.getCaption() + "(" + d.name + ") \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043a\u0430\u043d\u0430\u043b\u043e\u0432 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f (\u0442\u0430\u0431\u043b\u0438\u0446\u0430: " + t.toString() + ")");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlParameter[] select(SSContext ssContext, double channelId) throws SQLException {
        if (!this.enabled() || channelId == 0.0) {
            return null;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        this.selectSql(sql);
        sql.append(" where ").append(this.fields[0]).append("=?");
        try (DatabaseConnection connection = this.table.getDatabaseDescriptor().connect(null, "ChannelTable.select by channelId");){
            try (PreparedStatement statement = connection.prepareStatement("ChannelTable.select by channelId", sql.toString());){
                statement.setDouble(1, channelId);
                try (ResultSet fetch = statement.executeQuery(ssContext);){
                    if (!fetch.next()) {
                        SqlParameter[] sqlParameterArray = null;
                        return sqlParameterArray;
                    }
                    this.readSelect(fetch);
                    if (fetch.next()) {
                        throw new InformException("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u043a\u0430\u043d\u0430\u043b\u043e\u0432 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0441 ID \u043a\u0430\u043d\u0430\u043b\u0430 " + (long)channelId);
                    }
                }
            }
            connection.commit();
        }
        return this.values;
    }

    public static SqlParameter[] findChannel(SSContext ssContext, double channelId) throws IOException, SQLException {
        ChannelTable channelTable = new ChannelTable();
        return channelTable.select(ssContext, channelId);
    }

    private void selectSql(SqlStringBuilder sql) {
        String comma = "";
        sql.append("select ");
        for (int ctf = 0; ctf < this.fields.length; ++ctf) {
            FieldDescriptor f = this.fields[ctf];
            if (f == null) {
                if (this.values == null) continue;
                this.values[ctf] = null;
                continue;
            }
            sql.append(comma).append(f);
            comma = ", ";
        }
        sql.append(" from ").appendFull(this.table);
    }

    private void readSelect(ResultSet fetch) throws SQLException {
        this.values = this.readSelect(fetch, this.fields);
    }

    public static boolean isImportantField(int ctf) {
        switch (ctf) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public FieldDescriptor field(int rtf) {
        return this.fields[rtf];
    }
}

