/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import java.io.IOException;

public class DownloadParams {
    public static final int TAG_DNL_ALL_DATA = 1;
    public static final int TAG_DNL_ETALON_DB = 2;
    public static final int TAG_DNL_DATA_ONLY = 3;
    public static final int TAG_DNL_FIND_PARAMS = 4;
    public static final int TAG_DNL_INCLUDE_FIND_ID = 5;
    public static final int TAG_DNL_EXCLUDE_FIND_ID = 6;
    public static final int TAG_DNL_SOURCE_DB_NAME = 7;
    public static final int TAG_DNL_DATA_OPERATION = 8;
    public static final int TAG_DNL_CHUNKED_DATA = 9;
    public static final int TAG_DNL_FIELD_FILTER = 10;
    public static final int ddNone = 0;
    public static final int ddAll = 1;
    public static final int ddByEtalonDB = 2;
    public static final int ddFiltered = 3;
    public static final int DO_DEFAULT = 0;
    public static final int DO_REFRESH = 1;
    public static final int DO_REPLACE = 2;
    private boolean processAttributes = true;
    private int processData = 0;
    private String etalonDB = null;
    private double includeSearchId = 0.0;
    private byte[] includeSearchParams = null;
    private double excludeSearchId = 0.0;
    private byte[] excludeSearchParams = null;
    private int[] fieldFilter = null;
    private String sourceDB = null;
    private int dataOperation = 0;
    private boolean chunkedData = false;

    public void parse(TaggedReader in) throws IOException, TaggedReaderException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.processData = 1;
                    break;
                }
                case 2: {
                    this.processData = 2;
                    this.etalonDB = in.getString();
                    break;
                }
                case 3: {
                    this.processAttributes = false;
                    break;
                }
                case 5: {
                    this.processData = 3;
                    this.includeSearchId = in.getDouble();
                    this.includeSearchParams = in.getRaw(4);
                    break;
                }
                case 6: {
                    this.processData = 3;
                    this.excludeSearchId = in.getDouble();
                    this.excludeSearchParams = in.getRaw(4);
                    break;
                }
                case 7: {
                    this.sourceDB = in.getString();
                    break;
                }
                case 8: {
                    this.dataOperation = in.getInt();
                    break;
                }
                case 9: {
                    this.chunkedData = true;
                    break;
                }
                case 10: {
                    this.fieldFilter = LittleEndian.toIntArray(in.getRaw());
                }
            }
        }
    }

    public int getDataOperation() {
        return this.dataOperation;
    }

    public String getEtalonDB() {
        return this.etalonDB;
    }

    public boolean hasExcludeFilter() {
        return this.excludeSearchId != 0.0;
    }

    public double getExcludeSearchId() {
        return this.excludeSearchId;
    }

    public byte[] getExcludeSearchParams() {
        return this.excludeSearchParams;
    }

    public boolean hasIncludeFilter() {
        return this.includeSearchId != 0.0;
    }

    public double getIncludeSearchId() {
        return this.includeSearchId;
    }

    public byte[] getIncludeSearchParams() {
        return this.includeSearchParams;
    }

    public boolean isProcessAttributes() {
        return this.processAttributes;
    }

    public int getProcessData() {
        return this.processData;
    }

    public String getSourceDB() {
        return this.sourceDB;
    }

    public boolean isChunkedData() {
        return this.chunkedData;
    }

    public int[] getFieldFilter() {
        return this.fieldFilter;
    }
}

