/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.SendReadyResponse;
import inform.adt.taggedio.SendReadyTaggedWriter;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.replication.ReplicationChannel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileChannel
extends ReplicationChannel
implements SendReadyResponse {
    private File file = null;
    private final String fileName;
    private FileOutputStream zipFile = null;
    private ZipOutputStream zip = null;
    private DeflaterOutputStream compression = null;
    private SendReadyTaggedWriter out = null;
    private int chunkCount = 0;
    private long dataSize = 0L;
    private long sendedSize = 0L;
    private long replicaSize = 0L;
    private final ByteArrayOutputStream result = new ByteArrayOutputStream();

    public FileChannel(double id, String fileName, ServerSideHost ssHost) {
        super(id, ssHost);
        this.fileName = fileName;
    }

    @Override
    public String getName() {
        return "\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u0432 \u0444\u0430\u0439\u043b";
    }

    @Override
    public long getReplicaSize() {
        return this.replicaSize;
    }

    @Override
    public boolean setMaxChunkSize(int value) {
        return false;
    }

    @Override
    public SendReadyTaggedWriter connect(double replicaId) throws InformException, IOException {
        Core.logger.info("\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u0447\u0435\u0440\u0435\u0437 \u0444\u0430\u0439\u043b '{}'", (Object)this.fileName);
        this.file = new File(this.fileName);
        if (this.file.exists() && !this.file.delete()) {
            throw new InformException("\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b '" + this.fileName + "'");
        }
        if (!this.file.createNewFile()) {
            throw new InformException("\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b '" + this.fileName + "'");
        }
        this.chunkCount = 0;
        this.zipFile = new FileOutputStream(this.file);
        this.zip = new ZipOutputStream(this.zipFile);
        this.compression = new DeflaterOutputStream(this.result);
        this.out = new SendReadyTaggedWriter(this.compression, this);
        return this.out;
    }

    @Override
    public boolean isValid() {
        return this.fileName != null && !this.fileName.isEmpty();
    }

    private void createChunk() throws IOException {
        this.out.flush();
        this.compression.close();
        ++this.chunkCount;
        this.dataSize += this.out.getInputSize();
        this.sendedSize += (long)this.result.size();
        Core.logger.info("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0447\u0430\u0441\u0442\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0438(\u043d\u043e\u043c\u0435\u0440 {}, \u0440\u0430\u0437\u043c\u0435\u0440 {}, \u0432\u0441\u0435\u0433\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e {})", this.chunkCount, this.result.size(), this.sendedSize);
        ZipEntry entry = new ZipEntry("replica." + this.chunkCount);
        entry.setMethod(0);
        entry.setSize(this.result.size());
        entry.setCompressedSize(this.result.size());
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(this.result.internalBuffer(), 0, this.result.size());
        entry.setCrc(crc.getValue());
        this.zip.putNextEntry(entry);
        this.zip.write(this.result.internalBuffer(), 0, this.result.size());
        this.zip.closeEntry();
        this.result.reset();
        this.compression = new DeflaterOutputStream(this.result);
        this.out.reset(this.compression);
        this.idle();
    }

    @Override
    protected void commit() throws InformException, IOException, SQLException {
    }

    @Override
    protected void ready(ReplicationChannel.Readme readme, byte[] info, int infoSize) throws InformException, IOException {
        ZipEntry entry = new ZipEntry(".info");
        this.zip.putNextEntry(entry);
        this.zip.write(info, 0, infoSize);
        this.zip.closeEntry();
        entry = new ZipEntry("readme.txt");
        this.zip.putNextEntry(entry);
        String readmeStr = readme.getReadme();
        byte[] readmeContent = readmeStr.getBytes(TaggedWriter.ANSI);
        this.zip.write(readmeContent, 0, readmeContent.length);
        this.zip.closeEntry();
        this.close();
    }

    @Override
    public void close() {
        this.idle();
        if (this.zip == null) {
            return;
        }
        try {
            ZipOutputStream file = this.zip;
            this.zip = null;
            file.close();
            this.idle();
            this.zipFile.close();
            if (this.file != null) {
                this.replicaSize = this.file.length();
            }
            this.idle();
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
        }
    }

    @Override
    public int getOperationCode() {
        return 4;
    }

    @Override
    public void notifyReadyToSend() throws Exception {
        this.idle();
        if (this.out == null) {
            return;
        }
        if (this.out.getInputSize() == 0L) {
            return;
        }
        this.createChunk();
    }

    @Override
    protected void flush() throws Exception {
        this.notifyReadyToSend();
    }

    @Override
    public boolean getWriteInfo(ReplicationChannel.WriteInfo info) {
        if (info.chunkCount == this.chunkCount) {
            return false;
        }
        info.chunkCount = this.chunkCount;
        info.dataSize = this.dataSize;
        info.sendedSize = this.sendedSize;
        return true;
    }

    @Override
    public long getTransferSize() {
        if (this.out != null) {
            return this.dataSize + this.out.getInputSize();
        }
        return this.dataSize;
    }

    @Override
    protected int getChunkCount() {
        return this.chunkCount;
    }
}

