/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.TimeZoneHost;
import inform.adt.taggedio.SendReadyTaggedWriter;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.utils.SqlParameter;
import inform.agent.mtd.MtdEngine;
import inform.agent.replication.ChannelTable;
import inform.agent.scripts.Constant;
import inform.agent.scripts.Constants;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.sql.SQLException;

public abstract class ReplicationChannel {
    protected SSContext ssContext;
    protected final ServerSideHost ssHost;
    protected final double id;
    protected double receivingId = 0.0;
    protected double backReceivingId = 0.0;
    protected Constants constants = new Constants(0.0);
    private boolean constantsLoaded = false;
    protected double outputTableId = 0.0;
    protected int replicaIdFieldId = 0;
    protected int chunkNoFieldId = 0;
    protected int chunkCountFieldId = 0;
    protected int chunkContentFieldId = 0;
    protected int chunkFlagFieldId = 0;
    private String title = null;
    protected boolean channelTableUsed = false;

    public ReplicationChannel(double id, ServerSideHost ssHost) {
        this.ssHost = ssHost;
        this.id = id;
    }

    public void setContext(SSContext ssContext) {
        this.ssContext = ssContext;
    }

    protected void rollback(Readme readme, byte[] info, int infoSize) throws InformException, IOException, SQLException {
        this.ready(readme, info, infoSize);
    }

    public abstract SendReadyTaggedWriter connect(double var1) throws InformException, IOException, SQLException;

    protected abstract void commit() throws InformException, IOException, SQLException;

    protected abstract void ready(Readme var1, byte[] var2, int var3) throws InformException, IOException, SQLException;

    protected abstract void flush() throws Exception;

    protected void finish() throws Exception {
        this.idle();
        this.flush();
        this.idle();
    }

    public abstract void close();

    public abstract int getOperationCode();

    protected abstract int getChunkCount();

    public abstract boolean getWriteInfo(WriteInfo var1);

    public abstract long getTransferSize();

    public abstract boolean isValid();

    public abstract boolean setMaxChunkSize(int var1);

    public abstract String getName();

    public abstract long getReplicaSize();

    public void cancel() {
    }

    public Constants getConstants() {
        return this.constants;
    }

    public void setExplicitConstants(Constants constants) {
        if (constants == null) {
            return;
        }
        this.constants = constants;
        this.constantsLoaded = true;
    }

    public void setModifiedConstants(Constants modifiedConstants) {
        if (this.constants == null) {
            return;
        }
        for (Constant constant : modifiedConstants.getAllConstants()) {
            Constant c;
            if (!constant.isModified() || (c = this.constants.findConstant(constant.getId())) == null) continue;
            c.setRawValue(constant.getValue());
            c.setActual();
        }
    }

    public void setConstantsContent(byte[] content) throws IOException, InformException {
        this.loadConstants();
        this.constants.load(content, (TimeZoneHost)this.ssHost);
    }

    public double getId() {
        return this.id;
    }

    public double getReceivingId() {
        return this.receivingId;
    }

    public void setReceivingId(double receivingId) {
        this.receivingId = receivingId;
    }

    public double getBackReceivingId() {
        return this.backReceivingId;
    }

    public void setBackReceivingId(double backReceivingId) {
        this.backReceivingId = backReceivingId;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = this.channelTableUsed ? "" : MtdEngine.tryGetNodeName(this.id);
        }
        return this.title;
    }

    public void load() throws InformException, IOException, SQLException {
        this.loadConstants();
        SqlParameter[] fields = ChannelTable.findChannel(this.ssContext, this.id);
        if (fields != null) {
            this.channelTableUsed = true;
            this.loadFields(fields);
        } else {
            this.channelTableUsed = false;
            byte[] content = MtdEngine.getNodeContent(this.id);
            this.load(new TaggedReader(content));
        }
    }

    protected void loadFields(SqlParameter[] fields) {
        SqlParameter field = fields[1];
        if (field != null) {
            this.title = field.getString();
            if (Strings.isVoid(this.title)) {
                this.title = "";
            }
        }
        if ((field = fields[2]) != null) {
            this.receivingId = field.getDouble();
        }
        if ((field = fields[3]) != null) {
            this.backReceivingId = field.getDouble();
        }
    }

    public void load(TaggedReader in) throws IOException, TaggedReaderException {
        while (in.next()) {
            this.loadTag(in);
        }
    }

    public void appendNodeNameForLog(StringBuilder msg) {
        msg.append('[').append(NumberConverter.doubleToString(this.id)).append(']');
        if (this.channelTableUsed || MtdEngine.getNode(this.id) != null) {
            msg.append(this.getTitle());
        } else {
            msg.append("???");
        }
    }

    private void loadConstants() throws InformException, IOException {
        if (this.constantsLoaded) {
            return;
        }
        this.constantsLoaded = true;
        this.constants.load(MtdEngine.getNodeContent(3.0), Core.serverTimeZoneHost);
    }

    protected void loadOutputTable(TaggedReader in) throws IOException, TaggedReaderException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.outputTableId = in.getNodeID();
                    break;
                }
                case 2: {
                    this.replicaIdFieldId = in.getFieldID();
                    break;
                }
                case 3: {
                    this.chunkNoFieldId = in.getFieldID();
                    break;
                }
                case 4: {
                    this.chunkCountFieldId = in.getFieldID();
                    break;
                }
                case 5: {
                    this.chunkContentFieldId = in.getFieldID();
                    break;
                }
                case 6: {
                    this.chunkFlagFieldId = in.getFieldID();
                }
            }
        }
    }

    protected void loadTag(TaggedReader in) throws IOException, TaggedReaderException {
        this.idle();
        switch (in.getCurrentTag()) {
            case 25: {
                this.receivingId = in.getDouble();
                break;
            }
            case 26: {
                this.constants.load(in.getRaw(), Core.serverTimeZoneHost);
                break;
            }
            case 28: {
                this.backReceivingId = in.getNodeID();
                break;
            }
            case 29: {
                this.receivingId = in.getNodeID();
                break;
            }
            case 31: {
                this.loadOutputTable(in.getSubStreamReader());
            }
        }
    }

    protected final void idle() {
        if (this.ssHost != null) {
            this.ssHost.idle();
        }
    }

    public static class WriteInfo {
        public long dataSize = 0L;
        public long sendedSize = 0L;
        public int chunkCount = 0;
    }

    public static interface Readme {
        public String getReadme() throws InformException;
    }
}

