/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.replication.Replication;
import inform.agent.replication.ReplicationException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;

public class ReplicationConf {
    private final double id;
    private final Replication replication;
    private BitSet nodeTypeFilter = null;
    private final ArrayList<Conf> nodeConf = new ArrayList();
    private final DoubleSet excludeNodes = new DoubleSet();
    private DoubleSet processedNodes = null;

    public ReplicationConf(double id, Replication replication) throws InformException, IOException, SQLException {
        this.id = id;
        this.replication = replication;
        this.load();
    }

    public int getNodes() throws InformException, SQLException {
        this.processedNodes = new DoubleSet();
        this.processRootNodes();
        return this.processedNodes.size();
    }

    private void load() throws InformException, IOException, SQLException {
        byte[] constent = MtdEngine.getNodeContent(this.id);
        this.load(new TaggedReader(constent));
    }

    private void load(TaggedReader in) throws IOException, InformException, SQLException {
        block6: while (in.next()) {
            switch (in.getCurrentTag()) {
                case 3: {
                    int[] types = LittleEndian.toIntArray(in.getRaw());
                    if (types.length == 0) break;
                    if (this.nodeTypeFilter == null) {
                        this.nodeTypeFilter = new BitSet();
                    }
                    for (int type : types) {
                        this.nodeTypeFilter.set(type);
                    }
                    continue block6;
                }
                case 4: {
                    this.loadExcludeConf(in);
                    break;
                }
                case 1: {
                    this.loadNodeConf(in);
                    break;
                }
                case 22: {
                    this.loadSharedConf(in);
                }
            }
        }
    }

    private void loadSharedConf(TaggedReader in) throws IOException, InformException, SQLException {
        block3: while (in.next()) {
            switch (in.getCurrentTag()) {
                case 151: {
                    this.replication.addSharedConf(in.getDouble());
                    continue block3;
                }
            }
            return;
        }
    }

    private void loadExcludeConf(TaggedReader in) throws IOException, InformException, SQLException {
        double nodeId = -1.0;
        DoubleSet excludeParents = new DoubleSet();
        while (in.next() && in.getCurrentTag() != 15) {
            switch (in.getCurrentTag()) {
                case 151: {
                    nodeId = in.getDouble();
                    this.excludeNodes.add(nodeId);
                    break;
                }
                case 24: {
                    excludeParents.add(nodeId);
                }
            }
        }
        for (Cursor.Double c : excludeParents) {
            this.enumChildren(c.value, this.excludeNodes, null, null);
        }
    }

    private void loadNodeConf(TaggedReader in) throws IOException, TaggedReaderException {
        double nodeId = in.getNodeID();
        if (nodeId == 0.0) {
            throw new ReplicationException("\u0423\u0437\u0435\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0443\u0437\u043b\u044b \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c 0. \u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.");
        }
        Conf conf = new Conf(nodeId);
        this.nodeConf.add(conf);
        while (in.next() && in.getCurrentTag() != 2) {
            switch (in.getCurrentTag()) {
                case 7: {
                    conf.option = in.getInt();
                    break;
                }
                case 5: {
                    in.skip();
                    conf.includeDataFilter = in.getDouble(151);
                    break;
                }
                case 6: {
                    in.skip();
                    conf.excludeDataFilter = in.getDouble(151);
                    break;
                }
                case 18: {
                    in.skip();
                    TaggedReader stream = in.getStreamReader();
                    if (conf.fieldFilter == null) {
                        conf.fieldFilter = new IntegerSet();
                    }
                    while (stream.next()) {
                        if (stream.getCurrentTag() != 163) continue;
                        conf.fieldFilter.add(stream.getInt());
                    }
                    break;
                }
            }
        }
    }

    protected void processRootNode(Conf conf) throws InformException, SQLException {
        DoubleSet nodeIds = new DoubleSet();
        DoubleList nodes = new DoubleList(8);
        nodes.add(conf.nodeId);
        if ((conf.option & 1) != 0) {
            this.enumChildren(conf.nodeId, nodeIds, nodes, null);
        }
        for (Cursor.Double c : nodes) {
            double time;
            boolean excludeByTime;
            Node node;
            double nodeId = c.value;
            if (this.excludeNodes.contains(nodeId) || this.processedNodes.contains(nodeId) || (node = MtdEngine.getNode(nodeId)) == null || this.nodeTypeFilter != null && !this.nodeTypeFilter.get(node.getType())) continue;
            this.processedNodes.add(nodeId);
            int option = 0;
            if ((conf.option & 0x40) != 0) {
                option |= 4;
            }
            boolean bl = excludeByTime = !this.replication.isProcessNodeByTime(time = DateTime.fromUnixTime(node.lastModificationTime()));
            if (!this.replication.isSyncMetadata() && node.getType() == 12 && (conf.option & 0x14) != 0) {
                boolean canDataScope = true;
                if (node instanceof TableNode) {
                    DatabaseDescriptor databaseDescriptor = ((TableNode)node).getDescriptor().getDbDescIfExists();
                    boolean bl2 = canDataScope = databaseDescriptor == null || !databaseDescriptor.isReplicationDisabled();
                }
                if (excludeByTime || (conf.option & 0x10) != 0) {
                    if (canDataScope) {
                        option |= 2;
                    }
                } else {
                    option |= 1;
                    if ((conf.option & 4) != 0 && canDataScope) {
                        option |= 2;
                    }
                }
            } else {
                if (excludeByTime) continue;
                option |= 1;
                if ((conf.option & 0x80) != 0 && node.getType() == 3) {
                    option |= 8;
                }
            }
            this.replication.addItem(node, option, conf);
        }
    }

    protected void processRootNodes() throws InformException, SQLException {
        for (Conf conf : this.nodeConf) {
            if (this.excludeNodes.contains(conf.nodeId)) continue;
            this.processRootNode(conf);
            this.idle();
        }
    }

    private void idle() {
        this.replication.idle();
    }

    private void enumChildren(double nodeId, DoubleSet children, DoubleList orderedChildrent, DoubleSet excludeNodes) throws InformException, SQLException {
        Node node = MtdEngine.getNode(nodeId);
        if (node != null) {
            node.enumerateChildren(this.replication.metabaseConnector(), this.nodeTypeFilter, children, excludeNodes, orderedChildrent);
        }
    }

    public static class Conf {
        public final double nodeId;
        public int option = 0;
        public double includeDataFilter = 0.0;
        public double excludeDataFilter = 0.0;
        public IntegerSet fieldFilter = null;

        public Conf(double nodeId) {
            this.nodeId = nodeId;
        }
    }
}

