/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.InformException;
import inform.adt.taggedio.SendReadyTaggedWriter;
import inform.agent.Core;
import inform.agent.replication.ReplicationChannel;
import inform.agent.replication.request.ExecuteReplication;
import java.io.IOException;

public class RequestResultChannel
extends ReplicationChannel {
    private final SendReadyTaggedWriter out;
    private final ExecuteReplication request;

    public RequestResultChannel(double id, ExecuteReplication request, SendReadyTaggedWriter out) {
        super(id, request);
        this.request = request;
        this.out = out;
    }

    @Override
    public String getName() {
        return "\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u043f\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0443 \u0444\u0430\u0439\u043b\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0438";
    }

    @Override
    public long getReplicaSize() {
        return this.request.getSendedSize();
    }

    @Override
    public boolean setMaxChunkSize(int value) {
        return false;
    }

    @Override
    protected void commit() throws InformException {
    }

    @Override
    protected void ready(ReplicationChannel.Readme readme, byte[] info, int infoSize) throws InformException, IOException {
        try {
            this.request.finalizeSend(info, infoSize);
        }
        catch (Throwable ex) {
            throw InformException.wrap(ex);
        }
    }

    @Override
    protected void flush() throws Exception {
        this.request.notifyReadyToSend();
    }

    @Override
    public SendReadyTaggedWriter connect(double replicaId) throws InformException, IOException {
        Core.logger.info("\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u0447\u0435\u0440\u0435\u0437 \u0444\u0430\u0439\u043b(\u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u0437\u0430\u043f\u0440\u043e\u0441)");
        return this.out;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public int getOperationCode() {
        return 4;
    }

    @Override
    protected int getChunkCount() {
        return this.request.getChunkCount();
    }

    @Override
    public boolean getWriteInfo(ReplicationChannel.WriteInfo info) {
        if (info.chunkCount == this.request.getChunkCount()) {
            return false;
        }
        info.chunkCount = this.request.getChunkCount();
        info.dataSize = this.request.getDataSize();
        info.sendedSize = this.request.getSendedSize();
        return true;
    }

    @Override
    public long getTransferSize() {
        return this.request.getTransferSize();
    }
}

