/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.InformException;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.PhenixLinks;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.types.DataType;
import inform.agent.replication.TableMetadata;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.util.ArrayList;

public class TableDifferentDataFinder {
    private final ServerSideHost ssHost;
    private final DatabaseConnection connection;
    private DoubleSet processedRows = null;
    private PhenixLinks linked = null;
    private PhenixLinks elements = null;
    private boolean metadata_writed = false;
    private boolean links_loaded = false;

    public TableDifferentDataFinder(ServerSideHost ssHost, DatabaseConnection connection) {
        this.ssHost = ssHost;
        this.connection = connection;
    }

    public void idle() {
        if (this.ssHost != null) {
            this.ssHost.idle();
        }
    }

    public Difference findDifference(SSContext ssContext, TaggedWriter writer, TableDescriptor tableInfo, String etaloneSchemaArg) throws InformException, SQLException {
        Difference result = Difference.ETALONE_TABLE_NOT_FOUND;
        StringBuilder etaloneTableName = new StringBuilder();
        StringBuilder etaloneSchema = new StringBuilder();
        etaloneSchema.append(etaloneSchemaArg);
        if (etaloneSchema.length() != 0 && etaloneSchema.charAt(etaloneSchema.length() - 1) != '.') {
            etaloneSchema.append('.');
        }
        etaloneTableName.append((CharSequence)etaloneSchema).append(tableInfo.getRawName());
        ArrayList<TableMetadata.Column> etalonMetadata = TableMetadata.getMetadata(ssContext, etaloneTableName.toString(), this.connection);
        if (etalonMetadata == null) {
            return result;
        }
        this.metadata_writed = false;
        this.links_loaded = false;
        this.processedRows = new DoubleSet();
        this.idle();
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> newFields = new ArrayList<String>();
        block0: for (FieldDescriptor field : tableInfo.getFields()) {
            for (int index = 0; index < etalonMetadata.size(); ++index) {
                TableMetadata.Column etaloneField = etalonMetadata.get(index);
                if (field.getRawName().equalsIgnoreCase(etaloneField.name)) {
                    if (etaloneField.phenixType != field.getType()) {
                        result = Difference.INTRICATE_TABLE_RESTRUCTURE;
                        continue block0;
                    }
                    if (etaloneField.phenixType != DataType.BLOB) {
                        fields.add(etaloneField.name);
                    }
                }
                if (index < etalonMetadata.size()) continue;
                newFields.add(field.getRawName());
            }
        }
        FieldDescriptor pkField = tableInfo.getValidRecordIdField();
        if (result == Difference.INTRICATE_TABLE_RESTRUCTURE) {
            return result;
        }
        return result;
    }

    public static enum Difference {
        DIFFERENCE_LOADED,
        ETALONE_TABLE_NOT_FOUND,
        INTRICATE_TABLE_RESTRUCTURE;

    }
}

