/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication.request;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.replication.BlobChannel;
import inform.agent.replication.FileChannel;
import inform.agent.replication.NetChannel;
import inform.agent.replication.ReplicationChannel;

public class GetLastReplicationSlice
extends Request {
    public static final int TAG_GLRS_CODE = 1;
    public static final int TAG_GLRS_EMPTY = 2;
    public static final int TAG_GLRS_DATE = 3;
    public static final int TAG_GLRS_INVALID = 4;

    public GetLastReplicationSlice(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        double chanelId = 0.0;
        double replId = 0.0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    chanelId = in.getDouble();
                    break;
                }
                case 2: {
                    replId = in.getDouble();
                }
            }
        }
        BasicNode chanelNode = MtdEngine.getTranslatedNode(chanelId);
        if (chanelNode == null || chanelNode.getType() != 53) {
            if (chanelId == 0.0) {
                throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u0430\u043d\u0430\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439");
            }
            MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043a\u0430\u043d\u0430\u043b\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439", chanelId);
        }
        byte[] chanelContent = chanelNode.getContent();
        ReplicationChannel[] channels = new ReplicationChannel[]{new FileChannel(chanelId, "file", this), new BlobChannel(chanelId, this), new NetChannel(chanelId, this)};
        AuditJournal journal = new AuditJournal(AuditJournal.Journal.REPLICATION);
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        TaggedWriter out = new TaggedWriter(result);
        for (ReplicationChannel chanel : channels) {
            chanel.load(new TaggedReader(chanelContent));
            out.putInt32(1, chanel.getOperationCode());
            if (!chanel.isValid()) {
                out.putEmpty(4);
                continue;
            }
            DateTime dateTime = journal.getLastSuccessfulReplication(this.ssContext, replId, chanelId);
            if (dateTime == null) {
                out.putEmpty(2);
                continue;
            }
            out.putDouble(3, dateTime.value());
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

