/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication.request;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.TimeZoneOffsetHost;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.Restructure;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.replication.DataReplicationApplyEngine;
import inform.agent.replication.TableDataIO;
import inform.agent.replication.UploadParams;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;

public class UploadNodeSet {
    private SSContext _ssContext;
    private ServerSideHost _host;
    private UsersTable usersTable = null;
    public Node node;
    public TableDataIO tableData;
    public TableDataIO.Upload upload = null;
    public Node.ModifyNodeArg arg;
    public UploadParams params;
    public double replicaId = 0.0;
    public byte[] attributes = null;
    public boolean moveNodes;
    public final IntegerSet fields = new IntegerSet();
    public boolean securityChanged;

    public UploadNodeSet(SSContext c, ServerSideHost h, boolean securityChanged) {
        this._ssContext = c;
        this._host = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncateData(Node.ModifyNodeArg arg) throws SQLException {
        if (!this.params.replaceData) {
            return;
        }
        this.params.replaceData = false;
        this.params.insertData = true;
        if (this.node == null || this.node.getType() != 12) {
            return;
        }
        TableDescriptor tableDescriptor = ((TableNode)this.node).getDescriptor();
        if (!tableDescriptor.isRealTable()) {
            return;
        }
        this.params.recreateIndexes = true;
        boolean mtdConnection = tableDescriptor.getDbId() == 2.0;
        DatabaseConnection connection = mtdConnection ? arg.connector.connection() : tableDescriptor.getDatabaseDescriptor().connect(this._host, "UploadNode");
        try {
            try (Statement statement = connection.createStatement();){
                Restructure.tryDropAllIndices(this._ssContext, connection.openScheme(), statement, tableDescriptor, Restructure.DDL_LOGGER);
            }
            if (Restructure.isTableExists(this._ssContext, connection.openScheme(), tableDescriptor)) {
                DataReplicationApplyEngine.truncateTableRecords(this._ssContext, connection, (TableNode)this.node, arg.userId, this.params.receivingId, this.params.replicaId, arg.sessionId, this._host.security());
            }
        }
        finally {
            if (!mtdConnection) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(Node.ModifyNodeArg arg, Node node, TaggedReader in, int mask) throws IOException, InformException, SQLException {
        arg.in = in;
        node = arg.modifyNode(node);
        byte[] content = null;
        String dslContent = null;
        double contentUserId = arg.userId;
        block11: while (in.next()) {
            int tag = in.getCurrentTag();
            switch (tag) {
                case 123: {
                    int offset = in.getInt();
                    if (!Core.isTimeZoneConversionUsed || arg.timeZoneHost != null && arg.timeZoneHost.getTimeZoneOffset() == offset) continue block11;
                    arg.timeZoneHost = new TimeZoneOffsetHost(offset);
                    continue block11;
                }
                case 14: {
                    if ((mask & 8) == 0) continue block11;
                    content = in.getRaw();
                    continue block11;
                }
                case 124: {
                    if ((mask & 8) == 0) continue block11;
                    dslContent = new String(in.getRaw(), TaggedWriter.UTF8);
                    continue block11;
                }
                case 32: {
                    contentUserId = in.getDouble();
                    continue block11;
                }
                case 22: {
                    if (!this.moveNodes) continue block11;
                    node.loadReplicationTag(tag, arg, 13);
                    arg.modifiedParents.add(node.getParentId());
                    continue block11;
                }
                case 20: {
                    continue block11;
                }
            }
            node.loadReplicationTag(tag, arg, 13);
        }
        node.setModificationAttributeTime(System.currentTimeMillis());
        arg.contentModificationTime = node.getModificationContentTime();
        if ((content != null || dslContent != null) && node.isContentApplicable()) {
            node.lockBarrier(0.0);
            this.truncateData(arg);
            double userId = arg.userId;
            arg.userId = contentUserId;
            try {
                if (node instanceof TableNode) {
                    ((TableNode)node).setContentEx(content, dslContent, arg, this.params.recreateIndexes);
                } else {
                    ((BasicNode)node).setContent(content, dslContent, arg);
                }
            }
            finally {
                arg.userId = userId;
            }
        }
        arg.replId = this.replicaId;
        for (Node n : arg.modifiedNodes) {
            n.setNodeChangingProps(arg);
        }
        MtdEngine.updateNodes(this._ssContext, arg);
    }

    public void applyAttribute(Node.ModifyNodeArg arg) throws IOException, SQLException {
        if (this.attributes == null) {
            return;
        }
        this.apply(arg, this.node, new TaggedReader(this.attributes), 8);
        this.attributes = null;
        this.node = MtdEngine.getValidNode(this.node.getId());
    }

    void upload(TaggedReader in) throws InformException, SQLException, IOException, NoSuchAlgorithmException {
        if (!this.securityChanged && this.node != null) {
            if (this.usersTable == null) {
                this.usersTable = new UsersTable();
            }
            if (this.usersTable.enabled() && this.usersTable.getTableID() == this.node.getId()) {
                this.securityChanged = true;
            }
        }
        if (this.upload == null) {
            this.truncateData(this.arg);
            this.upload = this.tableData.beginUpload((BasicNode)this.node, this.params, this.fields);
            if (!this.upload.isRealCurrentTable()) {
                this.tableData.closeUpload(this.upload);
                this.upload = null;
                return;
            }
            this.upload.detailing = "[" + NumberConverter.doubleToString(this.node.getId()) + "] " + this.node.getName();
        }
        this.tableData.processUpload(this.upload, in);
    }
}

