/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.sched;

import inform.adt.InformException;
import inform.agent.CancelRequestException;
import inform.agent.ClientUpdateInfo;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ProductInfo;
import inform.agent.VersionInfo;
import inform.agent.net.AlertingEngine;
import inform.agent.net.Client;
import inform.agent.net.ClientSession;
import inform.agent.scripts.notify.Notification;
import inform.agent.scripts.notify.Topic;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;

public class CheckVersionJob
implements Runnable {
    public final int CHECK_INTERVAL = Ini.NewVersionNotifyPeriod * 60 * 1000;
    public Future<?> future = null;
    public long lastRun = System.currentTimeMillis();

    public boolean needRun(long period) {
        return !Ini.NoUpdateClientInfo && period > (long)this.CHECK_INTERVAL;
    }

    @Override
    public void run() {
        HashMap<CallSite, VersionTopic> versionInfo = new HashMap<CallSite, VersionTopic>();
        Collection<Client> clients = ClientSession.getClients();
        VersionInfo version = new VersionInfo();
        for (Client client : clients) {
            if (!client.isLive()) continue;
            VersionInfo clientVersionInfo = client.getVersion();
            ProductInfo clientProductInfo = client.getProduct();
            String versionKey = clientProductInfo.folder() + ":" + clientVersionInfo.toString();
            VersionTopic r = (VersionTopic)versionInfo.get(versionKey);
            try {
                if (r == null) {
                    version.clear();
                    File update = ClientUpdateInfo.getRecommendedVersion(clientVersionInfo, version, client.getProduct());
                    if (update != null) {
                        r = new VersionTopic(version.toNumber(), clientVersionInfo, update, clientProductInfo);
                        versionInfo.put((CallSite)((Object)versionKey), r);
                    }
                }
                if (r == null) continue;
                version.setNumber(r.version);
                if (!clientVersionInfo.lessThen(version)) continue;
                r.send(client);
            }
            catch (CancelRequestException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
        }
    }

    private static class VersionTopic
    extends Topic {
        final long version;
        final VersionInfo currentVersion;
        final File update;
        final Set<InetAddress> sended;

        VersionTopic(long version, VersionInfo currentVersion, File update, ProductInfo productInfo) {
            super(2.0, true);
            this.version = version;
            this.currentVersion = currentVersion;
            this.update = update;
            this.sended = "phx".equals(productInfo.name()) ? new HashSet() : null;
            this.isSystem = true;
            this.setText(null);
        }

        void send(Client client) throws IOException, InformException {
            InetAddress a;
            if (this.sended != null && !this.sended.add(a = client.getSession().socketAddress().getAddress())) {
                return;
            }
            if (this.getText() == null) {
                this.setText("\u041d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 " + VersionInfo.toString(this.version));
                this.setIcon(9061.0);
                this.setAlertIcon(9060.0);
                Notification n = this.createNotification(VersionInfo.toString(this.version));
                n.setText("\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0440\u0430\u0431\u043e\u0442\u0443 \u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c \u0438 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u041f\u041e");
                try {
                    String changes = ClientUpdateInfo.getChanges(this.update, this.currentVersion);
                    if (changes != null) {
                        n.setText(n.getText() + "\n\n\u0421\u043f\u0438\u0441\u043e\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439:\n" + changes);
                    }
                }
                catch (Throwable e) {
                    Core.logger.warn("cannot fetch update changes", e);
                }
                n.setIcon(9061.0);
            }
            byte[] content = this.getContent();
            AlertingEngine.sendNotificationToClient(client, content, content.length);
        }
    }
}

