/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.sched;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.LogContext;
import inform.agent.RequestStatistics;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.net.Security;
import inform.agent.replication.NetChannel;
import inform.agent.replication.Replication;
import inform.agent.sched.JobLauncher;
import inform.agent.sched.JobSSSHost;
import inform.agent.sched.Sched;
import inform.agent.scripts.ServerScriptExecutor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.mozilla.javascript.Undefined;

public class Job {
    private static final int TAG_EXEC_NODE_ID = 1;
    private static final int TAG_EXEC_DATE_START = 2;
    private static final int TAG_EXEC_INTERVAL = 3;
    private static final int TAG_EXEC_ONCE = 4;
    private static final int TAG_EXEC_SEL_ALL_DAYS = 5;
    private static final int TAG_EXEC_ALLOW_TIME = 6;
    private static final int TAG_EXEC_SEL_DAYS = 7;
    private static final int TAG_EXEC_NOTE = 9;
    private static final int TAG_EXEC_USER_ID = 10;
    private static final int TAG_REPLICA_NODE_ID = 11;
    private static final int TAG_CHANNEL_OF_REPLICA_NODE_ID = 12;
    private static final int TAG_IMPORTANT_TASK = 13;
    private static final int TAG_PARAMETERS = 14;
    private static final int TAG_EXEC_TIMEOUT = 15;
    private static final int TAG_EXEC_LAST_MONTH_DAY = 16;
    private static final int TAG_EXEC_NEXT_TRIGGER = 17;
    private static final int TAG_EXEC_ALL_MONTHS = 18;
    private static final int TAG_EXEC_SEL_MONTHS = 19;
    private static final int TAG_EXEC_ALL_DAYS_OF_MONTH = 20;
    private static final int TAG_EXEC_SEL_DAYS_OF_MONTH = 21;
    private static final int TAG_EXEC_SEL_DAY_NO = 1;
    private static final int TAG_EXEC_MONTH_NO = 1;
    private static final int TAG_EXEC_DAY_NO = 1;
    private static final int TAG_EXEC_START_TIME = 1;
    private static final int TAG_EXEC_END_TIME = 2;
    public final double nodeId;
    public final double parentNodeId;
    private final String logInfo;
    private final double contentTime;
    private final double attributeTime;
    private volatile boolean enabled;
    private long runOnce;
    private long startTime;
    private long timeout;
    private double runNodeId;
    public double userNodeId;
    private double replNodeId;
    private double chanelId;
    private JobType type = JobType.SCRIPT;
    private JobSSSHost jobHost;
    private StringBuilder createLog = new StringBuilder();
    private StringBuilder loadLog = null;
    private boolean importantTask = false;
    private byte[] parameters;
    private long beginTimeout;
    private static final int ANY_WEEK_DAY = 1;
    private static final int[] weekMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private static final int ANY_MONTH = 1;
    private static final int[] monthMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096};
    private static final int ANY_MONTH_DAY = 1;
    private static final int[] monthDayMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE};
    private final ArrayList<Trigger> triggers = new ArrayList(1);
    private RunInfo lastRun = new RunInfo();
    Object lastResult = Undefined.instance;
    String lastError = null;
    Object lastScriptRequestState = null;
    final boolean isWorker;

    public Job(MetadataNodeReader nodeReader) {
        this.nodeId = nodeReader.id;
        this.parentNodeId = nodeReader.parentId;
        this.logInfo = NumberConverter.doubleToString(this.nodeId) + " " + nodeReader.name;
        this.contentTime = nodeReader.modificationContentTime;
        this.attributeTime = nodeReader.modificationAttributeTime;
        this.enabled = true;
        this.beginTimeout = 0L;
        this.isWorker = false;
        if (nodeReader.attributesContent != null) {
            try {
                TaggedReader reader = nodeReader.newAttributeReader();
                while (reader.getNextTag() != 0) {
                    if (reader.getCurrentTag() != 34) continue;
                    this.enabled = (reader.getByte() & 1) == 0;
                    break;
                }
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
                this.enabled = false;
                this.createLog.append("\r\nerror read attribute: ").append(ex.toString());
            }
        }
        if (this.enabled && nodeReader.content != null) {
            try {
                this.load(nodeReader.newContentReader());
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
                this.enabled = false;
                this.createLog.append("\r\nerror read content: ").append(ex.toString());
            }
        }
    }

    public Job(long id, double userId, double ownerId, String logInfo, double runNodeId, byte[] parameters) {
        this.nodeId = id;
        this.parentNodeId = ownerId;
        this.logInfo = logInfo;
        this.contentTime = 0.0;
        this.attributeTime = 0.0;
        this.importantTask = true;
        this.enabled = true;
        this.userNodeId = userId;
        this.runNodeId = runNodeId;
        this.parameters = parameters;
        this.isWorker = true;
        Trigger trigger = new Trigger();
        this.triggers.add(trigger);
        trigger.monthFilter = (short)(trigger.monthFilter | 1);
        trigger.monthDayFilter |= 1;
        trigger.init();
    }

    private void clear() {
        this.startTime = 0L;
        this.runOnce = 0L;
        this.runNodeId = 0.0;
        this.replNodeId = 0.0;
        this.chanelId = 0.0;
        this.type = JobType.SCRIPT;
        this.userNodeId = 0.0;
        this.loadLog = null;
        this.importantTask = false;
        this.parameters = null;
        this.timeout = 0L;
        this.triggers.clear();
    }

    private void load(TaggedReader in) throws IOException, TaggedReaderException {
        this.clear();
        this.loadLog = new StringBuilder();
        Trigger trigger = new Trigger();
        this.triggers.add(trigger);
        boolean needInit = true;
        block25: while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.runNodeId = in.getNodeID();
                    this.type = JobType.SCRIPT;
                    this.loadLog.append("\r\nrunNodeId: ").append(NumberConverter.doubleToString(this.runNodeId));
                    break;
                }
                case 10: {
                    this.userNodeId = in.getNodeID();
                    this.loadLog.append("\r\nuserNodeId: ").append(NumberConverter.doubleToString(this.userNodeId));
                    break;
                }
                case 2: {
                    double dateTime = in.getDouble();
                    this.startTime = DateTime.toUnixTime(dateTime);
                    break;
                }
                case 15: {
                    double dateTime = in.getDouble();
                    this.timeout = DateTime.toMillis(dateTime);
                    break;
                }
                case 4: {
                    double dateTime = in.getDouble();
                    this.runOnce = DateTime.toUnixTime(dateTime);
                    break;
                }
                case 11: {
                    in.skip();
                    this.replNodeId = in.getDouble(151);
                    this.type = JobType.REPLICATION;
                    break;
                }
                case 12: {
                    in.skip();
                    this.chanelId = in.getDouble(151);
                    this.type = JobType.REPLICATION;
                    break;
                }
                case 13: {
                    this.importantTask = true;
                    break;
                }
                case 14: {
                    in.skip();
                    this.parameters = in.getRaw(202);
                    break;
                }
                case 17: {
                    if (needInit) {
                        trigger.monthFilter = (short)(trigger.monthFilter | 1);
                        trigger.monthDayFilter |= 1;
                    }
                    trigger.init();
                    trigger = new Trigger();
                    this.triggers.add(trigger);
                    break;
                }
                case 3: {
                    double dateTime = in.getDouble();
                    trigger.period = DateTime.toMillis(dateTime);
                    break;
                }
                case 5: {
                    trigger.weekFilter = (byte)(trigger.weekFilter | 1);
                    break;
                }
                case 16: {
                    trigger.lastMonthDay = true;
                    break;
                }
                case 7: {
                    TaggedReader stream = in.getStreamReader();
                    while (stream.getNextTag() != 0) {
                        int weekDay = stream.getInt() + 1;
                        if (weekDay < 1 || weekDay > 7) continue;
                        trigger.weekFilter = (byte)(trigger.weekFilter | weekMask[weekDay]);
                    }
                    continue block25;
                }
                case 18: {
                    needInit = false;
                    trigger.monthFilter = (short)(trigger.monthFilter | 1);
                    break;
                }
                case 19: {
                    needInit = false;
                    TaggedReader stream = in.getStreamReader();
                    while (stream.getNextTag() != 0) {
                        int month = stream.getInt() + 1;
                        if (month < 1 || month > 12) continue;
                        trigger.monthFilter = (short)(trigger.monthFilter | monthMask[month]);
                    }
                    continue block25;
                }
                case 20: {
                    needInit = false;
                    trigger.monthDayFilter |= 1;
                    break;
                }
                case 21: {
                    needInit = false;
                    TaggedReader stream = in.getStreamReader();
                    while (stream.getNextTag() != 0) {
                        int day = stream.getInt() + 1;
                        if (day < 1 || day > 31) continue;
                        trigger.monthDayFilter |= monthDayMask[day];
                    }
                    continue block25;
                }
                case 6: {
                    double dateTime;
                    TaggedReader stream = in.getStreamReader();
                    TimePeriod timePeriod = null;
                    while (stream.getNextTag() != 0) {
                        switch (stream.getCurrentTag()) {
                            case 1: {
                                timePeriod = new TimePeriod();
                                dateTime = stream.getDouble();
                                if (dateTime >= 1.0) {
                                    dateTime -= (double)((int)dateTime);
                                }
                                timePeriod.begin = DateTime.toMillis(dateTime);
                                break;
                            }
                            case 2: {
                                dateTime = stream.getDouble();
                                if (dateTime >= 1.0) {
                                    dateTime -= (double)((int)dateTime);
                                }
                                timePeriod.end = DateTime.toMillis(dateTime);
                                if (trigger.timeFilter == null) {
                                    trigger.timeFilter = new ArrayList();
                                }
                                trigger.timeFilter.add(timePeriod);
                            }
                        }
                    }
                    break;
                }
            }
        }
        if (needInit) {
            trigger.monthFilter = (short)(trigger.monthFilter | 1);
            trigger.monthDayFilter |= 1;
        }
        trigger.init();
    }

    public boolean isObsolete(double contentTime, double attributeTime) {
        return this.contentTime != contentTime || this.attributeTime != attributeTime;
    }

    public boolean isImportantTask() {
        return this.importantTask;
    }

    private synchronized JobSSSHost getJobHost() {
        return this.jobHost;
    }

    void getCannotRunLog(StringBuilder log) {
        if (!this.enabled) {
            log.append("disabled");
        } else if (this.userNodeId == 0.0) {
            log.append(" userId = 0");
        }
        switch (this.type) {
            case REPLICATION: {
                if (this.replNodeId == 0.0) {
                    log.append(" replNodeId = 0");
                }
                if (this.chanelId != 0.0) break;
                log.append(" chanelId = 0");
                break;
            }
            default: {
                if (this.runNodeId != 0.0) break;
                log.append(" runNodeId = 0");
            }
        }
        boolean canRun = false;
        for (Trigger t : this.triggers) {
            if (!t.canRun()) continue;
            canRun = true;
            break;
        }
        if (!canRun) {
            log.append(" disabled at any week day");
        }
        if (this.createLog != null && this.createLog.length() != 0) {
            log.append("\r\ncreate log: ").append((CharSequence)this.createLog);
        }
        if (this.loadLog != null && this.loadLog.length() != 0) {
            log.append("\r\nload log: ").append((CharSequence)this.loadLog);
        }
    }

    public boolean canExplicitRun() {
        if (!this.enabled) {
            return false;
        }
        switch (this.type) {
            case REPLICATION: {
                if (this.replNodeId == 0.0) {
                    return false;
                }
                if (this.chanelId != 0.0) break;
                return false;
            }
            default: {
                if (this.runNodeId != 0.0) break;
                return false;
            }
        }
        return this.userNodeId != 0.0;
    }

    public boolean canRun(long currentTime, long runtime) {
        if (this.canExplicitRun()) {
            if (currentTime - 30000L < this.runOnce && runtime + 30000L < this.runOnce) {
                return true;
            }
            for (Trigger t : this.triggers) {
                if (!t.canRun()) continue;
                return true;
            }
        }
        return false;
    }

    double getNextRunPlan(long runtime) {
        return this.getNextRunPlan(runtime, System.currentTimeMillis());
    }

    double getNextRunPlan(long runtime, long currentPlanTime) {
        if (!this.canRun(currentPlanTime, runtime)) {
            return 0.0;
        }
        int count = 1000;
        long ro = 0L;
        if (currentPlanTime < this.runOnce && this.needRun(runtime, this.runOnce)) {
            ro = this.runOnce;
        }
        long nextRunTime = 0L;
        if (this.startTime <= currentPlanTime) {
            block0: for (Trigger t : this.triggers) {
                long currentTime;
                if (t.period <= 0L) continue;
                long longTime = currentTime + t.period * (long)count * 10L;
                int i = 0;
                for (currentTime = currentPlanTime + t.period - (currentPlanTime - this.startTime) % t.period; i < count && currentTime < longTime; currentTime += t.period) {
                    if (!t.needRun(runtime, currentTime, false, this.runOnce, this.startTime, null)) continue;
                    ++i;
                    if (currentTime <= ro) {
                        ro = 0L;
                    }
                    long pt = currentPlanTime < ro ? ro : currentTime;
                    if (nextRunTime != 0L && pt >= nextRunTime) continue block0;
                    nextRunTime = pt;
                    continue block0;
                }
            }
        }
        if (nextRunTime != 0L) {
            return DateTime.fromUnixTime(nextRunTime);
        }
        if (ro != 0L) {
            return DateTime.fromUnixTime(ro);
        }
        if (currentPlanTime < this.runOnce) {
            return DateTime.fromUnixTime(this.runOnce);
        }
        return 0.0;
    }

    private boolean isValidParent() {
        Node parentNode = MtdEngine.getNode(this.parentNodeId);
        if (parentNode == null) {
            return false;
        }
        if (Sched.jobFolderIdSet != null && Sched.jobFolderIdSet.contains(this.parentNodeId)) {
            return true;
        }
        if (Sched.jobFolderIdentSet != null && Sched.jobFolderIdentSet.contains(parentNode.getIdentName())) {
            return true;
        }
        return Sched.jobFolderIdSet == null && Sched.jobFolderIdentSet == null;
    }

    public void getSchedPlan(long runtime, int count, int tag, TaggedWriter out, boolean force) throws IOException {
        if (!force && !this.canRun(System.currentTimeMillis(), runtime)) {
            return;
        }
        double nextRunPlan = this.getNextRunPlan(runtime);
        if (nextRunPlan != 0.0) {
            out.putDouble(tag, nextRunPlan);
            if (count > 1) {
                long rt;
                for (int i = 1; i < count && (nextRunPlan = this.getNextRunPlan(rt = DateTime.toUnixTime(nextRunPlan), rt)) != 0.0; ++i) {
                    out.putDouble(tag, nextRunPlan);
                }
            }
        }
        long currentTime = System.currentTimeMillis();
        if (!this.enabled) {
            out.putString(7, "\u0417\u0430\u0434\u0430\u043d\u0438\u0435 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043e");
        } else {
            switch (this.type) {
                case REPLICATION: {
                    if (this.replNodeId == 0.0) {
                        out.putString(7, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u0443\u0437\u0435\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438");
                    }
                    if (this.chanelId != 0.0) break;
                    out.putString(7, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043a\u0430\u043d\u0430\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438");
                    break;
                }
                default: {
                    if (this.runNodeId != 0.0) break;
                    out.putString(7, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043c\u043e\u0434\u0443\u043b\u044c");
                }
            }
            if (this.userNodeId == 0.0) {
                out.putString(7, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c");
            }
            boolean hasWeekDay = false;
            boolean hasOnce = currentTime < this.runOnce;
            boolean hasPeriod = false;
            for (Trigger t : this.triggers) {
                if (t.lastMonthDay || t.weekFilter != 0) {
                    hasWeekDay = true;
                }
                if (t.period <= 0L) continue;
                hasPeriod = true;
            }
            if (!hasWeekDay) {
                out.putString(7, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u044b \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0435 \u0434\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438");
            } else if (Ini.DisableJavaSchedJobs) {
                out.putString(7, "\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u0434\u043b\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0437\u0430\u0434\u0430\u043d\u0438\u0439");
            } else if (!this.isValidParent()) {
                out.putString(7, "\u041f\u0430\u043f\u043a\u0430 \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u0434\u043b\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0437\u0430\u0434\u0430\u043d\u0438\u0439");
            } else if (!hasOnce && !hasPeriod) {
                out.putString(7, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b");
            }
        }
    }

    public boolean needRun(long runtime) {
        long currentTime = System.currentTimeMillis();
        return this.needRun(runtime, currentTime);
    }

    public boolean needRun(long runtime, long currentTime) {
        return this.needRun(runtime, currentTime, false);
    }

    public boolean needRun(long runtime, long currentTime, boolean force) {
        if (!force && !this.canRun(currentTime, runtime)) {
            return false;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(currentTime);
        for (Trigger t : this.triggers) {
            if (!t.needRun(runtime, currentTime, force, this.runOnce, this.startTime, calendar)) continue;
            return true;
        }
        return false;
    }

    private synchronized void setJobHost(JobSSSHost jobHost) {
        this.jobHost = jobHost;
    }

    void appendIntervalToString(long t, StringBuilder s) {
        long n = t / 86400000L;
        s.append(n);
        t -= n * 86400000L;
        n = (t /= 1000L) / 86400L;
        s.append(':').append(n);
        t -= n;
        n = t / 60L;
        s.append(':').append(n);
    }

    public boolean isTimeoutExceed() {
        if (this.beginTimeout == 0L || this.timeout <= 0L) {
            return false;
        }
        long time = System.currentTimeMillis() - this.beginTimeout;
        if (time > this.timeout) {
            StringBuilder msg = new StringBuilder();
            msg.append("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f: ");
            this.appendIntervalToString(time, msg);
            msg.append(" \u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f: ");
            this.appendIntervalToString(this.timeout, msg);
            msg.append("(\u0414\u0414.\u0427\u0427.\u041c\u041c)");
            this.beginTimeout = 0L;
            Core.logger.error("job failed: " + this.logInfo + " \nerror: \u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u0434\u0430\u043d\u0438\u044f\n", msg);
            return true;
        }
        return false;
    }

    public void checkTimeout() {
        if (this.beginTimeout == 0L || this.timeout <= 0L) {
            return;
        }
        long time = System.currentTimeMillis() - this.beginTimeout;
        if (time > this.timeout) {
            StringBuilder msg = new StringBuilder();
            msg.append("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f: ");
            this.appendIntervalToString(time, msg);
            msg.append(" \u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f: ");
            this.appendIntervalToString(this.timeout, msg);
            msg.append("(\u0414\u0414.\u0427\u0427.\u041c\u041c)");
            this.beginTimeout = 0L;
            throw new InformException("\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u0434\u0430\u043d\u0438\u044f").detail(msg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run(JobLauncher launcher) {
        switch (1.$SwitchMap$inform$agent$sched$Job$JobType[this.type.ordinal()]) {
            case 1: {
                if (this.replNodeId != 0.0 && this.chanelId != 0.0) break;
                return;
            }
            default: {
                if (this.runNodeId != 0.0) break;
                return;
            }
        }
        jobSSSHost = null;
        journal = new AuditJournal(AuditJournal.Journal.JOB_JOURNAL);
        journalParams = null;
        this.lastError = null;
        this.lastResult = Undefined.instance;
        this.lastScriptRequestState = null;
        try {
            node = null;
            if (!this.isWorker && (node = MtdEngine.getNode(this.nodeId)) == null) {
                return;
            }
            runNode = MtdEngine.getNode(this.runNodeId);
            if (runNode == null) {
                return;
            }
            security = new Security(this.userNodeId);
            v0 = mask = this.isWorker != false ? 0x8000000 : security.accessMask(node);
            if ((mask & 0x8000000) == 0) {
                return;
            }
            mask = security.accessMask(runNode);
            if ((mask & 0x8000000) == 0) {
                return;
            }
            Core.logger.info("job start: {}", (Object)this.logInfo);
            jobSSSHost = new JobSSSHost(security, launcher, this);
            rqstat = jobSSSHost.rqstat = RequestStatistics.THREAD_VALUE();
            rqstat.reset(-3, this.userNodeId, this.runNodeId);
            rqstat.ownerId = this.nodeId;
            this.setJobHost(jobSSSHost);
            LogContext.CURRENT.set(jobSSSHost);
            sTime = this.beginTimeout = System.currentTimeMillis();
            try {
                if (journal.isEnabled()) {
                    jobParams = new AuditJournal.JobParams();
                    jobParams.jobId = this.nodeId;
                    jobParams.startTime = sTime;
                    jobParams.userId = this.userNodeId;
                    journal.registerJob(jobSSSHost.getRootContext(), jobParams);
                    if (journal.isEnabled() && jobParams.auditId != 0.0) {
                        journalParams = new AuditJournal.UpdateJobParams();
                        journalParams.auditId = jobParams.auditId;
                    }
                }
                switch (1.$SwitchMap$inform$agent$sched$Job$JobType[this.type.ordinal()]) {
                    case 1: {
                        chanel = new NetChannel(this.chanelId, jobSSSHost);
                        chanel.load();
                        replication = new Replication(jobSSSHost.getRootContext(), jobSSSHost, this.replNodeId, chanel);
                        try {
                            try {
                                replication.execute(0.0, 0.0);
                                break;
                            }
                            catch (Throwable ex) {
                                jobSSSHost.writeLog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438:");
                                jobSSSHost.writeLogLine(ex.toString());
                                throw InformException.wrap(ex);
                            }
                        }
                        finally {
                            replication.close();
                        }
                    }
                    default: {
                        if (!this.isWorker) {
                            this.lastResult = ServerScriptExecutor.execute(jobSSSHost.getRootContext(), -1, this.runNodeId, this.parameters, jobSSSHost);
                            ** break;
lbl66:
                            // 1 sources

                            break;
                        }
                        worker = new ServerScriptExecutor.Worker(jobSSSHost.getRootContext(), -1, this.runNodeId, this.parameters, jobSSSHost);
                        if (!worker.init()) break;
                        try {
                            scope = jobSSSHost.getTopLevelScope();
                            this.lastScriptRequestState = scope.get("requestState", scope);
                            this.lastResult = worker.execute();
                            break;
                        }
                        finally {
                            worker.close();
                        }
                    }
                }
            }
            finally {
                endTime = System.currentTimeMillis();
                if (journalParams != null) {
                    journalParams.stopTime = endTime;
                }
                this.beginTimeout = 0L;
                LogContext.CURRENT.set(null);
                rqstat.apply(endTime - sTime);
                this.lastRun.runtime = jobSSSHost.getRuntime();
                this.lastRun.duration = endTime - this.lastRun.runtime;
                this.lastRun.requestState = jobSSSHost.getRequestStateContent();
                jobSSSHost.close();
            }
            this.setJobHost(null);
            if (journalParams != null) {
                journalParams.successful = true;
            }
        }
        catch (Throwable ex) {
            this.lastError = AuditJournal.getJournalErrorText(ex);
            if (journalParams != null) {
                journalParams.successful = false;
                journalParams.message = this.lastError;
            }
            Core.logger.error("job failed: " + this.logInfo + " \nerror:\n", ex);
        }
        if (journalParams != null) {
            if (journalParams.stopTime == 0L) {
                journalParams.stopTime = System.currentTimeMillis();
            }
            journal.updateJob(jobSSSHost.getRootContext(), journalParams);
        }
        Core.logger.info("job stop: {}", (Object)this.logInfo);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    double getRunNodeId() {
        return this.runNodeId;
    }

    RunInfo getLastRunInfo() {
        return this.lastRun;
    }

    RunInfo getRunInfo() throws IOException {
        RunInfo r = new RunInfo();
        JobSSSHost host = this.getJobHost();
        if (host != null) {
            r.runtime = host.getRuntime();
            r.duration = System.currentTimeMillis() - r.runtime;
            r.requestState = host.getRequestStateContent();
        }
        return r;
    }

    public String getLogInfo() {
        return this.logInfo;
    }

    void contextMessage(LogContext.Builder out) {
        out.append("n", (long)this.nodeId);
        out.append("u", (long)this.userNodeId);
        if (this.runNodeId != 0.0) {
            out.append("run", (long)this.runNodeId);
        }
        if (this.replNodeId != 0.0) {
            out.append("repl", (long)this.replNodeId);
        }
        if (this.chanelId != 0.0) {
            out.append("channel", (long)this.chanelId);
        }
    }

    static class RunInfo {
        long runtime = 0L;
        long duration = 0L;
        long lastHangCallstackTime;
        byte[] requestState = null;

        RunInfo() {
        }
    }

    private static class Trigger {
        long period;
        byte weekFilter;
        boolean lastMonthDay;
        short monthFilter;
        int monthDayFilter;
        ArrayList<TimePeriod> timeFilter;

        private Trigger() {
        }

        void init() {
            if (this.period <= 0L && (this.lastMonthDay || this.weekFilter != 0)) {
                this.period = 86400000L;
            }
        }

        boolean canRun() {
            return (this.lastMonthDay || this.weekFilter != 0) && this.period > 0L;
        }

        public boolean needRun(long runtime, long currentTime, boolean force, long runOnce, long startTime, Calendar calendar) {
            int day;
            int month;
            if (runtime <= runOnce && Math.abs(runOnce - currentTime) < 30990L) {
                return true;
            }
            if (!force && !this.canRun()) {
                return false;
            }
            if (calendar == null) {
                calendar = new GregorianCalendar();
                calendar.setTimeInMillis(currentTime);
            }
            if (!(this.lastMonthDay && calendar.get(5) == calendar.getActualMaximum(5) || (this.weekFilter & 1) != 0)) {
                int dayOfWeek = calendar.get(7) - 1;
                if (dayOfWeek == 0) {
                    dayOfWeek = 7;
                }
                if ((this.weekFilter & weekMask[dayOfWeek]) == 0) {
                    return false;
                }
            }
            if (this.timeFilter != null && !this.timeFilter.isEmpty()) {
                long time = (calendar.get(11) * 60 * 60 + calendar.get(12) * 60 + calendar.get(13)) * 1000 + calendar.get(14);
                boolean invalidTime = true;
                for (TimePeriod p : this.timeFilter) {
                    if (p.begin > time || time > p.end) continue;
                    invalidTime = false;
                    break;
                }
                if (invalidTime) {
                    return false;
                }
            }
            if ((this.monthFilter & 1) == 0 && (this.monthFilter & monthMask[month = calendar.get(2) + 1]) == 0) {
                return false;
            }
            if ((this.monthDayFilter & 1) == 0 && (this.monthDayFilter & monthDayMask[day = calendar.get(5)]) == 0) {
                return false;
            }
            if (startTime > currentTime) {
                return false;
            }
            if (this.period <= 0L) {
                return false;
            }
            long schedTime = startTime + (currentTime - startTime) / this.period * this.period;
            return runtime <= schedTime && schedTime <= currentTime;
        }
    }

    private static class TimePeriod {
        long begin;
        long end;

        private TimePeriod() {
        }
    }

    private static enum JobType {
        SCRIPT,
        REPLICATION;

    }
}

