/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.sched;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.PhaThread;
import inform.agent.am.Telemeter;
import inform.agent.db.ClosableResult;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.sql.ParserStringReader;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.sched.CheckVersionJob;
import inform.agent.sched.Job;
import inform.agent.sched.JobLauncher;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class Sched {
    private static final long JOB_LIST_INTERVAL_MILLIS = 50000L;
    private static DoubleHash<JobLauncher> schedJobs = null;
    private static ExecutorService executor = Executors.newCachedThreadPool(PhaThread.createFactory("she"));
    private static long updateTime = 0L;
    private static long runtime = System.currentTimeMillis();
    private static volatile boolean running = false;
    private static double[] jobFolderIds = null;
    private static String[] jobFolderIdents = null;
    static DoubleSet jobFolderIdSet = null;
    static HashSet<String> jobFolderIdentSet = null;
    private static final CheckVersionJob checkVersionJob = new CheckVersionJob();
    private static SchedLauncher launcher = new SchedLauncher();

    private static synchronized DoubleHash<JobLauncher> getSchedJobs() {
        return schedJobs;
    }

    private static synchronized void setSchedJobs(DoubleHash<JobLauncher> jobs) {
        schedJobs = jobs;
    }

    public static void setJobFolder(String folders) {
        ParserStringReader reader = new ParserStringReader(folders.replace(',', ' ').replace(';', ' '));
        StreamTokenizer parser = new StreamTokenizer(reader);
        parser.parseNumbers();
        double[] ids = new double[]{0.0, 0.0, 0.0, 0.0};
        int idCount = 0;
        String[] idents = new String[]{null, null, null, null};
        int identCount = 0;
        int tokenType = 0;
        while (tokenType != -1) {
            try {
                tokenType = parser.nextToken();
            }
            catch (IOException ex) {
                Core.logger.error(null, ex);
                continue;
            }
            if (tokenType == -2) {
                if (idCount >= ids.length) {
                    ids = Arrays.copyOf(ids, ids.length + 4);
                }
                ids[idCount++] = parser.nval;
                continue;
            }
            if (tokenType != -3) continue;
            if (identCount >= ids.length) {
                idents = Arrays.copyOf(idents, idents.length + 4);
            }
            idents[identCount++] = parser.sval;
        }
        if (idCount == 0) {
            jobFolderIds = null;
            jobFolderIdSet = null;
        } else {
            jobFolderIds = idCount == ids.length ? ids : Arrays.copyOf(ids, idCount);
            jobFolderIdSet = new DoubleSet();
            double[] dArray = jobFolderIds;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double id = dArray[i];
                jobFolderIdSet.add(id);
            }
        }
        if (identCount == 0) {
            jobFolderIdents = null;
            jobFolderIdentSet = null;
        } else {
            jobFolderIdents = identCount == idents.length ? idents : Arrays.copyOf(idents, identCount);
            jobFolderIdentSet = new HashSet();
            for (String s : jobFolderIdents) {
                jobFolderIdentSet.add(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static JobLauncher createAnyJob(SSContext ssContext, double nodeId) {
        try (DatabaseConnection connection = DatabaseDescriptor.getMetabase().connectPrivileged("Sched::createAnyJob");){
            JobLauncher jobLauncher;
            ClosableResult closableResult = MetadataNodeReader.getResultSetForNode(ssContext, nodeId, connection);
            if (closableResult == null) {
                JobLauncher jobLauncher2 = null;
                return jobLauncher2;
            }
            try {
                ResultSet jobs = closableResult.getResultSet();
                JobLauncher job = new JobLauncher(nodeId, runtime, new Job(MetadataNodeReader.createNode(nodeId, jobs)));
                connection.commit();
                jobLauncher = job;
            }
            catch (Throwable throwable) {
                closableResult.close();
                throw throwable;
            }
            closableResult.close();
            return jobLauncher;
        }
        catch (IOException | SQLException ex) {
            throw InformException.wrap(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateJobList() {
        try {
            DoubleHash<JobLauncher> loadedJobs = Sched.getSchedJobs();
            DoubleHash<JobLauncher> jobList = null;
            boolean jobChanged = false;
            try (DatabaseConnection connection = DatabaseDescriptor.getMetabase().connectPrivileged("Sched::updateJobList");){
                try (ClosableResult closableResult = MetadataNodeReader.getResultSetForJobs(null, connection, jobFolderIds, jobFolderIdents);){
                    ResultSet jobs = closableResult.getResultSet();
                    if (loadedJobs == null) {
                        while (jobs.next()) {
                            double nodeId = jobs.getDouble(jobs.findColumn("ID"));
                            JobLauncher job = new JobLauncher(nodeId, runtime, new Job(MetadataNodeReader.createNode(nodeId, jobs)));
                            if (jobList == null) {
                                jobList = new DoubleHash();
                            }
                            jobList.add(job);
                            jobChanged = true;
                        }
                    } else {
                        while (jobs.next()) {
                            double nodeId = jobs.getDouble(jobs.findColumn("ID"));
                            double dateTime = jobs.getDateTime(jobs.findColumn("MOD_CONTENT_TIME"));
                            double contentTime = jobs.wasNull() ? 0.0 : dateTime;
                            dateTime = jobs.getDateTime(jobs.findColumn("MOD_ATTRS_TIME"));
                            double attributeTime = jobs.wasNull() ? 0.0 : dateTime;
                            JobLauncher job = loadedJobs.get(nodeId);
                            if (job == null) {
                                job = new JobLauncher(nodeId, runtime, new Job(MetadataNodeReader.createNode(nodeId, jobs)));
                                jobChanged = true;
                            } else if (job.isObsolete(contentTime, attributeTime)) {
                                job.setJob(new Job(MetadataNodeReader.createNode(nodeId, jobs)));
                                jobChanged = true;
                            }
                            if (jobList == null) {
                                jobList = new DoubleHash();
                            }
                            jobList.add(job);
                        }
                        for (JobLauncher job : loadedJobs) {
                            if (jobList != null && jobList.get(job.key()) != null || !job.isRunning()) continue;
                            if (jobList == null) {
                                jobList = new DoubleHash<JobLauncher>();
                            }
                            jobList.add(job);
                        }
                    }
                    connection.commit();
                }
                if (jobChanged && jobList != null) {
                    StringBuilder jobLog = new StringBuilder();
                    jobLog.append("jobs: updateJobList\r\n").append("loaded ").append(jobList.size()).append(" jobs");
                    jobLog.append("\r\njobs states:\r\n");
                    for (JobLauncher job : jobList) {
                        job.getStateLog(jobLog);
                    }
                    Core.logger.info(jobLog.toString());
                }
                Sched.setSchedJobs(jobList);
                updateTime = System.currentTimeMillis();
            }
        }
        catch (InformException | IOException | SQLException ex) {
            Core.logger.error(null, ex);
        }
    }

    private static void update(boolean force) {
        if (force || Sched.getSchedJobs() == null) {
            Sched.updateJobList();
        } else {
            long now = System.currentTimeMillis();
            if (now - updateTime >= 50000L) {
                Sched.updateJobList();
            }
        }
    }

    private static void execute() {
        long time;
        if (!Ini.DisableJavaSchedJobs) {
            Sched.update(false);
            DoubleHash<JobLauncher> jobs = Sched.getSchedJobs();
            if (jobs != null) {
                for (JobLauncher job : jobs) {
                    if (!job.needRun()) continue;
                    job.setFuture(executor.submit(job));
                }
            }
        }
        if ((Sched.checkVersionJob.future == null || Sched.checkVersionJob.future.isDone()) && checkVersionJob.needRun(time = System.currentTimeMillis() - Sched.checkVersionJob.lastRun)) {
            Sched.checkVersionJob.lastRun = System.currentTimeMillis();
            executor.submit(checkVersionJob);
        }
    }

    public static void shutdown() {
        if (executor != null) {
            executor.shutdownNow();
        }
    }

    public static void awaitTermination() throws InterruptedException {
        if (executor != null && !executor.awaitTermination(2L, TimeUnit.SECONDS)) {
            Core.logger.warn("long(>2s) termination of Sched");
            executor.awaitTermination(1L, TimeUnit.DAYS);
        }
    }

    public static void run() {
        if (running) {
            return;
        }
        if (Ini.DisableJavaSchedJobs) {
            Core.logger.info("job scheduler disabled");
        } else {
            Core.logger.info("job scheduler enabled");
            if (Ini.JavaSchedJobFolders != null && !Ini.JavaSchedJobFolders.isEmpty()) {
                Sched.setJobFolder(Ini.JavaSchedJobFolders);
            }
        }
        running = true;
        executor.execute(launcher);
    }

    static void enumJobs(DoubleList jobIds) {
        if (jobIds == null) {
            return;
        }
        Sched.update(true);
        DoubleHash<JobLauncher> jobs = Sched.getSchedJobs();
        if (jobs == null) {
            return;
        }
        for (JobLauncher job : jobs) {
            jobIds.add(job.key());
        }
    }

    public static boolean isPlanned(double nodeId) {
        Sched.update(false);
        DoubleHash<JobLauncher> jobs = Sched.getSchedJobs();
        if (jobs == null) {
            return false;
        }
        JobLauncher job = jobs.get(nodeId);
        return job != null && job.isPlanned();
    }

    static void getPlan(double nodeId, int count, int tag, TaggedWriter out) throws IOException {
        boolean force = nodeId != 0.0;
        Sched.update(force);
        DoubleHash<JobLauncher> jobs = Sched.getSchedJobs();
        if (jobs == null) {
            return;
        }
        JobLauncher job = jobs.get(nodeId);
        if (job == null) {
            return;
        }
        job.getSchedPlan(runtime, count, tag, out, force);
    }

    static void getInfo(SSContext ssContext, double nodeId, TaggedWriter out, boolean force) throws IOException {
        int tag;
        Job.RunInfo runInfo;
        Sched.update(force);
        JobLauncher job = null;
        DoubleHash<JobLauncher> jobs = Sched.getSchedJobs();
        if (jobs != null) {
            job = jobs.get(nodeId);
        }
        if (job == null) {
            if (force) {
                job = Sched.createAnyJob(ssContext, nodeId);
                if (job == null) {
                    return;
                }
            } else {
                return;
            }
        }
        if (!job.isEnabled()) {
            out.putInt32(1, 1);
        }
        if ((runInfo = job.getJobRunInfo()) == null) {
            runInfo = job.getJobLastRunInfo();
            tag = 5;
        } else {
            tag = 2;
        }
        if (runInfo != null) {
            if (runInfo.requestState == null) {
                out.putEmpty(tag);
            } else {
                out.putRaw(tag, runInfo.requestState);
            }
            if (runInfo.runtime != 0L) {
                out.putDouble(3, DateTime.fromUnixTime(runInfo.runtime));
            }
            out.putDouble(4, DateTime.fromMillis(runInfo.duration));
        }
        out.putDouble(8, job.getRunNodeId());
        if (runInfo != null) {
            job.getSchedPlan(runInfo.runtime, 1, 6, out, force);
        }
    }

    public static synchronized JobLauncher runWorker(Job worker) throws InterruptedException {
        JobLauncher launcher;
        if (schedJobs == null) {
            schedJobs = new DoubleHash();
        }
        if ((launcher = schedJobs.get(worker.nodeId)) != null) {
            throw new InformException("Worker is already run");
        }
        launcher = new JobLauncher(worker.nodeId, 0L, worker);
        schedJobs.add(launcher);
        launcher.setExplicit();
        launcher.setFuture(executor.submit(launcher));
        launcher.waitStart();
        return launcher;
    }

    static void explicitRun(double nodeId) {
        Sched.update(true);
        DoubleHash<JobLauncher> jobs = Sched.getSchedJobs();
        if (jobs == null) {
            return;
        }
        JobLauncher job = jobs.get(nodeId);
        if (job == null) {
            return;
        }
        if (job.isRunning()) {
            return;
        }
        job.setExplicit();
        job.setFuture(executor.submit(job));
    }

    public static void explicitStop(double nodeId) {
        Sched.update(false);
        DoubleHash<JobLauncher> jobs = Sched.getSchedJobs();
        if (jobs == null) {
            return;
        }
        JobLauncher job = jobs.get(nodeId);
        if (job == null) {
            return;
        }
        if (!job.isRunning()) {
            return;
        }
        Future<?> future = job.getFuture();
        if (future != null && !future.isDone() && !future.isCancelled()) {
            future.cancel(true);
        }
    }

    public static void gatherTelemetry(Telemeter.Gatherer gatherer) throws IOException {
        DoubleHash<JobLauncher> jobs = Sched.getSchedJobs();
        if (jobs != null) {
            for (JobLauncher j : jobs) {
                j.gatherTelemetry(gatherer);
            }
        }
    }

    private static class SchedLauncher
    implements Runnable {
        private SchedLauncher() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    TimeUnit.MINUTES.sleep(1L);
                }
                catch (InterruptedException ex) {
                    return;
                }
                Sched.execute();
            }
        }
    }
}

