/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.agent.schemes.Attribute;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.PhxGraphicInsert;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.VsdxReader;
import java.util.ArrayList;

public class AttributeRef
extends Attribute {
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    public int shapeType() {
        return 226;
    }

    @Override
    public int shapeVersion() {
        return version;
    }

    @Override
    public void setValueExt(GraphicBlock parent, String text, boolean ignoreLines, ArrayList<String> strings, boolean recalcOrg) {
        boolean isConstant;
        boolean bl = isConstant = (this.Flags & 0x10000) == 65536;
        if (isConstant) {
            return;
        }
        if (this.Inscribe && parent.Objects != null && parent.Objects.get(0) != null) {
            int lInt;
            switch (this.Align) {
                case 0: {
                    lInt = 1;
                    break;
                }
                case 1: {
                    lInt = 3;
                    break;
                }
                default: {
                    lInt = 2;
                }
            }
            this.correctAttribute(parent.Objects.get(0), parent, this.StringProps == null ? "" : this.StringProps.Caption, text, true, lInt, 2, ignoreLines, strings, recalcOrg);
        } else if (strings == null) {
            this.updateLines(text);
        }
    }

    @Override
    public void correctAttribute(BaseGraphic bg, BaseGraphic parent, String name, String value, boolean divide, int hAlign, int vAlign, boolean ignoreLines, ArrayList<String> strings, boolean recalcOrg) {
        PhxGraphicInsert insert;
        boolean lByLines;
        GraphicBlock block;
        if (name == null || name.isEmpty()) {
            return;
        }
        GraphicBlock graphicBlock = block = bg instanceof GraphicBlock ? (GraphicBlock)bg : (GraphicBlock)parent;
        if (this.Lines == null || this.Lines.isEmpty()) {
            return;
        }
        RectTextLine lRectTextLine = (RectTextLine)this.Lines.get(0);
        if (lRectTextLine == null) {
            return;
        }
        BaseGraphic.RealPoint lBlockSize = new BaseGraphic.RealPoint(Math.abs(block.MaxPtX - block.MinPtX), Math.abs(block.MaxPtY - block.MinPtY));
        if (this.Inscribe && parent != null) {
            lBlockSize.X = lBlockSize.X * Math.abs(parent.TransProps == null ? 1.0 : parent.TransProps.ScaleX);
        }
        BaseGraphic.RealPoint lSize = VsdxReader.calcTextSize(this.getFont(), value);
        if (lBlockSize.X <= FloatTolerance || lSize.X <= FloatTolerance) {
            return;
        }
        StringBuilder lText = new StringBuilder();
        boolean lModified = false;
        boolean bl = lByLines = strings != null;
        if (lByLines) {
            int lStrIdx = 0;
            BaseGraphic.RealPoint lMaxLineSize = new BaseGraphic.RealPoint();
            int cnt = strings.size();
            for (int i = 0; i < cnt; ++i) {
                if (lStrIdx > this.Lines.size() - 1) {
                    this.Lines.addLine(strings.get(i));
                } else {
                    ((RectTextLine)this.Lines.get((int)lStrIdx)).Text = strings.get(i);
                }
                ++lStrIdx;
                BaseGraphic.RealPoint lLineSize = new BaseGraphic.RealPoint();
                ArrayList<String> lStrings = new ArrayList<String>();
                AttributeRef.divideText(strings.get(i), this.getFont(), lBlockSize.X, true, false, true, lStrings, lLineSize);
                if (lStrings.size() > 1) {
                    --lStrIdx;
                    int cntj = lStrings.size();
                    for (int j = 0; j < cntj; ++j) {
                        if (lStrIdx > this.Lines.size() - 1) {
                            this.Lines.addLine(lStrings.get(j).trim());
                            lModified = true;
                        } else if (!lStrings.get(j).trim().equals(((RectTextLine)this.Lines.get((int)lStrIdx)).Text)) {
                            ((RectTextLine)this.Lines.get((int)lStrIdx)).Text = lStrings.get(j).trim();
                            lModified = true;
                        }
                        ++lStrIdx;
                    }
                }
                if (lMaxLineSize.X < lLineSize.X) {
                    lMaxLineSize.X = lLineSize.X;
                }
                if (!(lLineSize.Y > 0.0)) continue;
                lMaxLineSize.Y = (double)this.Lines.size() * lLineSize.Y;
            }
            if (lMaxLineSize.X > 0.0) {
                lSize.X = lMaxLineSize.X;
            }
            if (lMaxLineSize.Y > 0.0) {
                lSize.Y = lMaxLineSize.Y;
            }
            if (this.Inscribe) {
                if (this.SideX < lSize.X) {
                    this.SideX = lSize.X;
                }
                if (this.SideX < lBlockSize.X) {
                    this.SideX = lBlockSize.X;
                }
                if (this.SideY < lSize.Y) {
                    this.SideY = lSize.Y;
                }
            }
        } else {
            AttributeRef.divideText(value, this.getFont(), lBlockSize.X, divide, ignoreLines, false, strings, lSize);
            if (strings != null) {
                int cnt = strings.size();
                for (int i = 0; i < cnt; ++i) {
                    lText.append(strings.get(i));
                    if (i >= cnt - 1) continue;
                    lText.append(";");
                }
            }
            lModified = !lText.toString().equals(this.getText());
        }
        PhxGraphicInsert phxGraphicInsert = insert = parent instanceof PhxGraphicInsert ? (PhxGraphicInsert)parent : null;
        if (insert == null) {
            if (!lByLines) {
                boolean bl2 = lModified = !lText.toString().equals(this.getText());
            }
            if (lModified) {
                if (lByLines) {
                    this.freshSides();
                } else {
                    this.updateLines(lText.toString());
                }
            }
            if ((hAlign > 0 && hAlign <= 3 || vAlign > 0 && vAlign <= 3) && recalcOrg) {
                BaseGraphic.RealPoint org = AttributeRef.calcAttributeOrg(this, this.OrgX, this.OrgY, lBlockSize.X, lBlockSize.Y, lSize.X, lSize.Y, hAlign, vAlign);
                this.OrgX = org.X;
                this.OrgY = org.Y;
            }
        }
    }
}

