/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.Scheme;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DiagramTable {
    private static final int TAG_DIAG_TABLE = 1;
    private static final int TAG_DIAGRAM_TABLE_META = 2;
    private static final int TAG_DIAGRAM_TABLE_COLUMN = 3;
    private static final int TAG_TABLE_ID = 1;
    private static final int TAG_TABLE_NAME = 2;
    private static final int TAG_COLUMN_NAME = 1;
    private static final int TAG_COLUMN_TYPE = 2;
    private static final int TAG_COLUMN_VALUES = 3;
    public static final int COLUMN_TYPE_UNKNOWN = 0;
    public static final int COLUMN_TYPE_BOOLEAN = 1;
    public static final int COLUMN_TYPE_INTEGER = 2;
    public static final int COLUMN_TYPE_DOUBLE = 3;
    public static final int COLUMN_TYPE_DATETIME = 4;
    public static final int COLUMN_TYPE_STRING = 5;
    public static final int COLUMN_TYPE_BINARY = 6;
    public double ID = 0.0;
    String Name;
    List<DiagramColumn> Columns = new ArrayList<DiagramColumn>();

    public static byte[] diagramTableToBlob(DiagramTable table) throws IOException {
        assert (table != null);
        assert (table.ID != 0.0);
        ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(outBuf);
        ByteArrayOutputStream tableWriterBuf = new ByteArrayOutputStream();
        TaggedWriter tableWriter = new TaggedWriter(tableWriterBuf);
        ByteArrayOutputStream metaWriterBuf = new ByteArrayOutputStream();
        TaggedWriter metaWriter = new TaggedWriter(metaWriterBuf);
        metaWriter.putDouble(1, table.ID);
        metaWriter.putString(2, table.Name);
        metaWriter.flush();
        if (metaWriterBuf.size() > 0) {
            tableWriter.putRaw(2, metaWriterBuf);
        }
        for (DiagramColumn col : table.Columns) {
            if (col == null) continue;
            ByteArrayOutputStream colWriterBuf = new ByteArrayOutputStream();
            TaggedWriter colWriter = new TaggedWriter(colWriterBuf);
            colWriter.putString(1, col.Name);
            colWriter.putInt32(2, col.ValueType);
            for (DiagramValue v : col.Values) {
                switch (v.ValueType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        colWriter.putDouble(3, v.NumValue);
                        break;
                    }
                    case 5: {
                        colWriter.putString(3, v.StrValue);
                        break;
                    }
                }
            }
            colWriter.flush();
            if (colWriterBuf.size() <= 0) continue;
            tableWriter.putRaw(3, colWriterBuf);
        }
        tableWriter.flush();
        if (tableWriterBuf.size() > 0) {
            out.putRaw(1, tableWriterBuf);
        }
        out.flush();
        return outBuf.toByteArray();
    }

    public static void blobToDiagramTable(DiagramTable table, byte[] blob) throws IOException {
        if (blob == null || blob.length == 0) {
            return;
        }
        assert (table != null);
        TaggedReader reader = new TaggedReader(blob);
        while (reader.next()) {
            if (reader.getCurrentTag() != 1) continue;
            TaggedReader tableReader = new TaggedReader(reader.getRaw());
            block18: while (tableReader.next()) {
                switch (tableReader.getCurrentTag()) {
                    case 2: {
                        TaggedReader metaReader = new TaggedReader(tableReader.getRaw());
                        block19: while (metaReader.next()) {
                            switch (metaReader.getCurrentTag()) {
                                case 1: {
                                    table.ID = metaReader.getDouble();
                                    continue block19;
                                }
                                case 2: {
                                    table.Name = metaReader.getString();
                                    continue block19;
                                }
                            }
                        }
                        continue block18;
                    }
                    case 3: {
                        TaggedReader colReader = new TaggedReader(tableReader.getRaw());
                        DiagramColumn col = new DiagramColumn();
                        int colType = 0;
                        block20: while (colReader.next()) {
                            switch (colReader.getCurrentTag()) {
                                case 1: {
                                    col.Name = colReader.getString();
                                    continue block20;
                                }
                                case 2: {
                                    col.ValueType = colType = colReader.getInt();
                                    continue block20;
                                }
                                case 3: {
                                    DiagramValue v = new DiagramValue();
                                    v.ValueType = colType;
                                    switch (colType) {
                                        case 2: 
                                        case 3: {
                                            v.NumValue = colReader.getDouble();
                                            break;
                                        }
                                        case 5: {
                                            v.StrValue = colReader.getString();
                                            break;
                                        }
                                    }
                                    col.Values.add(v);
                                    continue block20;
                                }
                            }
                        }
                        table.Columns.add(col);
                        continue block18;
                    }
                }
            }
        }
    }

    static void loadDiagramTable(Scheme s, byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return;
        }
        assert (s != null);
        if (s.diagTables == null) {
            s.diagTables = new ArrayList<DiagramTable>();
        }
        DiagramTable table = new DiagramTable();
        DiagramTable.blobToDiagramTable(table, data);
        s.diagTables.add(table);
    }

    public static class DiagramColumn {
        String Name;
        int ValueType = 0;
        List<DiagramValue> Values = new ArrayList<DiagramValue>();
    }

    public static class DiagramValue {
        int ValueType = 0;
        double NumValue = 0.0;
        String StrValue;

        public static DiagramValue createNumValue(double v) {
            DiagramValue result = new DiagramValue();
            result.ValueType = 3;
            result.NumValue = v;
            return result;
        }

        public static DiagramValue createStrValue(String v) {
            DiagramValue result = new DiagramValue();
            result.ValueType = 5;
            result.StrValue = v;
            return result;
        }
    }
}

