/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.schemes.Attribute;
import inform.agent.schemes.AttributeDef;
import inform.agent.schemes.AttributeRef;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BaseShape;
import inform.agent.schemes.Ellipse;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.Image;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PhxGraphicInsert;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.Pie;
import inform.agent.schemes.Polygon;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.Primitive;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.Region;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemeObjectsTypes;
import inform.agent.schemes.SchemePage;
import inform.agent.schemes.Spline;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MifWriter {
    private static final int TAG_MIF_LAYER_NAME = 1;
    private static final int TAG_MIF_FILE = 2;
    private static final int TAG_MID_FILE = 3;
    private static final int[] BRUSH_STYLES = new int[]{2, 1, 8, 7, 5, 6, 4, 3, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private static final String COL_ID_SHAPE = "ID_SHAPE";
    private static final String COL_ID_OBJ = "ID_OBJ";
    private final Scheme s;
    private final SchemeEngine engine;
    private StringBuilder[] sbMifs = null;
    private StringBuilder[] sbMids = null;
    private final StringBuilder sbCols = new StringBuilder();
    private final HashMap<String, Integer> columnsHash = new HashMap();
    private String[] layerNames;
    private int currentLayerIdx = -1;
    private boolean insertMode = false;
    private double currentObjId = 0.0;
    private String currentAttValues = "";
    private String emptyAttValues = "";
    private ServerSideHost stateHost;

    public MifWriter(Scheme scheme) {
        this.s = scheme;
        this.engine = new SchemeEngine(this.s);
        this.engine.InitTmpProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToStream(ConnectionManager dbMgr, OutputStream out) throws Exception {
        this.putStateCaption("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442 \u0441\u0445\u0435\u043c\u044b");
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043a \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0443");
        this.s.parse(dbMgr, true);
        this.s.sortObjects();
        if (this.s.SortLayers.isEmpty()) {
            return;
        }
        int count = this.s.SortLayers.size();
        this.s.calcSchemeBounds();
        this.layerNames = new String[count];
        this.sbMifs = new StringBuilder[count];
        this.sbMids = new StringBuilder[count];
        this.collectColumns(null);
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u0441\u043b\u043e\u0438");
        this.writeLayers();
        this.putStateProgressMax(this.s.SortShapes.size());
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u0444\u0438\u0433\u0443\u0440\u044b");
        this.writeShapes();
        TaggedWriter tw = new TaggedWriter(out);
        for (int i = 0; i < count; ++i) {
            if (this.layerNames[i] == null || this.layerNames[i].isEmpty()) continue;
            tw.putString(1, this.layerNames[i]);
            ByteArrayOutputStream mifStream = new ByteArrayOutputStream();
            ByteArrayOutputStream midStream = new ByteArrayOutputStream();
            PrintWriter pwMif = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)mifStream, "Cp1251"), true);
            PrintWriter pwMid = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)midStream, "Cp1251"), true);
            try {
                pwMif.append(this.sbMifs[i]);
                pwMid.append(this.sbMids[i]);
            }
            finally {
                pwMif.close();
                pwMid.close();
            }
            mifStream.flush();
            tw.putRaw(2, mifStream.internalBuffer(), mifStream.size());
            midStream.flush();
            tw.putRaw(3, midStream.internalBuffer(), midStream.size());
        }
        tw.flush();
        this.putStateProgressPosition(this.s.SortShapes.size());
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d");
    }

    private void writeLine(String value) {
        if (this.currentLayerIdx < 0) {
            return;
        }
        StringBuilder sb = this.sbMifs[this.currentLayerIdx];
        sb.append(value).append("\r\n");
    }

    private void writeMidLine(double shapeId) {
        if (this.currentLayerIdx < 0) {
            return;
        }
        StringBuilder sb = this.sbMids[this.currentLayerIdx];
        sb.append('\"').append(String.format("%.0f", shapeId)).append('\"');
        sb.append(",\"");
        if (this.currentObjId != 0.0) {
            sb.append(String.format("%.0f", this.currentObjId));
        }
        sb.append('\"');
        if (!this.currentAttValues.isEmpty()) {
            sb.append(',').append(this.currentAttValues);
        }
        sb.append("\r\n");
    }

    private static int getPenStyle(int pPattern) {
        switch (pPattern) {
            case 0: {
                return 2;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 23;
            }
            case 4: {
                return 24;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    private static long getPenWidth(double lWidth) {
        if (lWidth < 1.0E-12) {
            return 1L;
        }
        if (lWidth > 7.0) {
            return 7L;
        }
        return Math.round(lWidth);
    }

    private static int getBrushStyle(int bPattern) {
        if (bPattern < 0 || bPattern >= BRUSH_STYLES.length) {
            return 2;
        }
        return BRUSH_STYLES[bPattern];
    }

    private int getColor(Color c) {
        return c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
    }

    private void writePoints(double[] pts, int index, int count) {
        for (int i = 0; i < count; ++i) {
            int idx = 2 * (index + i);
            this.writePoint(pts[idx], -pts[idx + 1]);
        }
    }

    private void writePoint(double x, double y) {
        this.writeLine(String.valueOf(x) + " " + y);
    }

    private void writePen(double lWidth, int pPattern, Color color) {
        String str = "PEN(" + MifWriter.getPenWidth(lWidth) + "," + MifWriter.getPenStyle(pPattern) + "," + this.getColor(color) + ")";
        this.writeLine(str);
    }

    private void writeBrush(int bPattern, Color color, Color bkColor) {
        String str = "BRUSH(" + MifWriter.getBrushStyle(bPattern) + "," + this.getColor(color) + "," + this.getColor(bkColor) + ")";
        this.writeLine(str);
    }

    private void writeStyle(BaseShape bg) {
        this.writePenStyle(bg);
        this.writeBrushStyle(bg);
    }

    private void writePenStyle(BaseShape bg) {
        int pPattern = this.engine.getActualPenPattern(bg.PenPattern);
        Color pColor = this.engine.getActualPColor(bg.pColor);
        double lWidth = this.engine.getActualLWidth(bg.lWidth);
        this.writePen(lWidth, pPattern, pColor);
    }

    private void writeBrushStyle(BaseShape bg) {
        int bPattern = this.engine.getActualBrushPattern(bg.BrushPattern);
        Color bColor = this.engine.getActualBColor(bg.bColor);
        Color bkColor = this.engine.getActualBkColor(bg.BkColor);
        this.writeBrush(bPattern, bColor, bkColor);
    }

    private String getLayerName(PhxLayer layer) {
        if (layer == null) {
            return "";
        }
        Object layerName = "";
        if (layer.StringProps != null && layer.StringProps.Caption != null) {
            layerName = layer.StringProps.Caption.trim();
        }
        if (((String)layerName).isEmpty() || MifWriter.checkSpecSymb((String)layerName)) {
            layerName = "Phx_Layer_" + layer.ID;
        }
        return layerName;
    }

    private static boolean checkSpecSymb(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch != '<' && ch != '>' && ch != '/' && ch != '\\' && ch != '\"' && ch != ':' && ch != ';' && ch != '?' && ch != '*' && ch != '|' && ch != ',' && ch != '=' && ch != '`') continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectColumns(GraphicBlock block) {
        if (block == null) {
            List<SchemeObject> sShapes = this.s.SortShapes;
            int count = sShapes.size();
            for (int i = 0; i < count; ++i) {
                SchemeObject o = sShapes.get(i);
                if (o == null) continue;
                SchemeObject schemeObject = o;
                synchronized (schemeObject) {
                    this.collectAttributes(o.BG);
                    continue;
                }
            }
            this.sbCols.append("Columns ").append(2 + this.columnsHash.size());
            this.sbCols.append("\r\n").append(COL_ID_SHAPE).append(" Char(").append(10).append(')');
            this.sbCols.append("\r\n").append(COL_ID_OBJ).append(" Char(").append(10).append(')');
            for (Map.Entry<String, Integer> entry : this.columnsHash.entrySet()) {
                this.sbCols.append("\r\n").append(entry.getKey()).append(" Char(").append(entry.getValue()).append(')');
            }
        } else {
            if (block.Objects == null || block.Objects.isEmpty()) {
                return;
            }
            int count = block.Objects.size();
            for (int i = 0; i < count; ++i) {
                this.collectAttributes(block.Objects.get(i));
            }
        }
    }

    private void collectAttributes(BaseGraphic bg) {
        if (!(bg instanceof GraphicBlock)) {
            return;
        }
        if (bg instanceof PhxGraphicInsert) {
            PhxGraphicInsert insert = (PhxGraphicInsert)bg;
            int attCount = insert.Attributes != null ? insert.Attributes.size() : 0;
            for (int i = 0; i < attCount; ++i) {
                String attValue;
                String attCap;
                AttributeRef att = (AttributeRef)insert.Attributes.get(i);
                if (att == null || !att.invisible() || att.StringProps == null || att.StringProps.Caption == null || (attCap = att.StringProps.Caption.trim().toUpperCase()).isEmpty() || attCap.equals(COL_ID_SHAPE) || attCap.equals(COL_ID_OBJ) || (attValue = this.getText(att).trim()).isEmpty()) continue;
                int attSize = attValue.length();
                if (this.columnsHash.containsKey(attCap) && this.columnsHash.get(attCap) >= attSize) continue;
                this.columnsHash.put(attCap, attSize);
            }
        } else {
            this.collectColumns((GraphicBlock)bg);
        }
    }

    private String getAttValues(BaseGraphic bg) {
        if (this.columnsHash.isEmpty()) {
            return "";
        }
        if (this.emptyAttValues.isEmpty()) {
            StringBuilder emptyAttStr = new StringBuilder();
            int count = this.columnsHash.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    emptyAttStr.append(',');
                }
                emptyAttStr.append("\"\"");
            }
            this.emptyAttValues = emptyAttStr.toString();
        }
        if (!(bg instanceof PhxGraphicInsert)) {
            return this.emptyAttValues;
        }
        StringBuilder attStr = new StringBuilder();
        PhxGraphicInsert insert = (PhxGraphicInsert)bg;
        int idx = 0;
        for (Map.Entry<String, Integer> entry : this.columnsHash.entrySet()) {
            int attCount = insert.Attributes != null ? insert.Attributes.size() : 0;
            String attValue = "";
            for (int i = 0; i < attCount; ++i) {
                String attCap;
                AttributeRef att = (AttributeRef)insert.Attributes.get(i);
                if (att == null || !att.invisible() || att.StringProps == null || att.StringProps.Caption == null || (attCap = att.StringProps.Caption.trim().toUpperCase()).isEmpty() || !attCap.equals(entry.getKey())) continue;
                attValue = this.getText(att).trim();
                break;
            }
            if (idx > 0) {
                attStr.append(',');
            }
            attStr.append('\"').append(attValue).append('\"');
            ++idx;
        }
        return attStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLayers() {
        if (this.s.exportPageId == Scheme.INVISIBLE_PAGE_ID) {
            return;
        }
        List<SchemeObject> sLayers = this.s.SortLayers;
        int count = sLayers.size();
        SchemePage currentPage = null;
        if (!this.s.Pages.empty()) {
            currentPage = this.s.getPageById(this.s.exportPageId, true);
        }
        for (int i = 0; i < count; ++i) {
            SchemeObject o = sLayers.get(i);
            if (o == null) {
                Core.logger.info("MifWriter.writeLayers: not found object by index {}. saveToStream(scheme:{}).", (Object)i, (Object)this.s.getSchemeId());
                continue;
            }
            SchemeObject schemeObject = o;
            synchronized (schemeObject) {
                if (o.BG == null) {
                    Core.logger.info("MifWriter.writeLayers: object {} not parsed. saveToStream(scheme:{}).", (Object)o.getID(), (Object)this.s.getSchemeId());
                    continue;
                }
                assert (o.BG instanceof PhxLayer);
                PhxLayer layer = (PhxLayer)o.BG;
                if (!layer.Exportable || !layer.Visible) {
                    continue;
                }
                if (currentPage == null || currentPage.getNormalizeId() == layer.PageId) {
                    this.layerNames[i] = this.getLayerName(layer);
                    this.sbMifs[i] = new StringBuilder();
                    this.sbMids[i] = new StringBuilder();
                    this.currentLayerIdx = i;
                    this.writeLine("Version 650");
                    this.writeLine("Charset \"WindowsCyrillic\"");
                    this.writeLine("Delimiter \",\"");
                    String boundsStr = "CoordSys NonEarth Units \"m\" Bounds (" + this.s.getSchemeLeft() + ", " + -this.s.getSchemeBottom() + ") (" + this.s.getSchemeRight() + ", " + -this.s.getSchemeTop() + ")";
                    this.writeLine(boundsStr);
                    this.writeLine(this.sbCols.toString());
                    this.writeLine("Data");
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShapes() throws Exception {
        if (this.s.exportPageId == Scheme.INVISIBLE_PAGE_ID) {
            return;
        }
        List<SchemeObject> sShapes = this.s.SortShapes;
        int shapesCount = sShapes.size();
        this.currentLayerIdx = -1;
        SchemePage currentPage = null;
        if (!this.s.Pages.empty()) {
            currentPage = this.s.getPageById(this.s.exportPageId, true);
        }
        for (int i = 0; i < shapesCount; ++i) {
            SchemeObject o = sShapes.get(i);
            if (o == null) {
                Core.logger.info("MifWriter.writeShapes: not found object by index {}. saveToStream(scheme:{}).", (Object)i, (Object)this.s.getSchemeId());
                continue;
            }
            SchemeObject schemeObject = o;
            synchronized (schemeObject) {
                BaseGraphic bg = o.BG;
                if (bg == null) {
                    Core.logger.info("MifWriter.writeShapes: object {} not parsed. saveToStream(scheme:{}).", (Object)o.getID(), (Object)this.s.getSchemeId());
                    continue;
                }
                if (this.engine.tmpLayer == null || this.engine.tmpLayer.ID != bg.LayerID) {
                    this.engine.setTmpLayer(bg.LayerID);
                    this.currentLayerIdx = this.engine.tmpLayer.SortIndex;
                }
                if (this.engine.tmpLayer == null || !this.engine.tmpLayer.Exportable || this.currentLayerIdx < 0 || !this.engine.tmpLayer.Visible) {
                    continue;
                }
                if (currentPage == null || currentPage.getNormalizeId() == this.engine.tmpLayer.PageId) {
                    this.writeShape(bg, true);
                    this.putStateProgressPosition(i);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeShape(BaseGraphic bg, boolean root) {
        if (bg.Hidden) {
            return false;
        }
        if (bg.ParentGB != null && bg.TransProps != null && !SchemeObjectsTypes.ObjTypeIsText(bg.shapeType())) {
            boolean inInsert;
            boolean bl = inInsert = bg.ParentGB.ParentGB != null && bg.ParentGB.ParentGB.shapeType() == 207;
            if (inInsert || bg.ParentGB.ParentGB == null) {
                double parentScaleX = 1.0;
                double parentScaleY = 1.0;
                double a = bg.TransProps.Angle;
                if (Math.abs(a - 90.0 * (double)((int)(a / 90.0))) <= 0.5) {
                    boolean vert;
                    BaseGraphic parent = inInsert ? bg.ParentGB.ParentGB : bg.ParentGB;
                    boolean bl2 = vert = Math.abs(a - 180.0 * (double)((int)(a / 180.0))) > 0.5;
                    if (!vert) {
                        if (bg.FixScaleX && parent.TransProps != null) {
                            parentScaleX = parent.TransProps.ScaleX;
                        }
                        if (bg.FixScaleY && parent.TransProps != null) {
                            parentScaleY = parent.TransProps.ScaleY;
                        }
                    } else {
                        if (bg.FixScaleX && parent.TransProps != null) {
                            parentScaleY = parent.TransProps.ScaleX;
                        }
                        if (bg.FixScaleY && parent.TransProps != null) {
                            parentScaleX = parent.TransProps.ScaleY;
                        }
                    }
                    bg.TransProps.ScaleX /= parentScaleX;
                    bg.TransProps.ScaleY /= parentScaleY;
                }
            }
        }
        boolean res = false;
        AffineTransform OldGTM = new AffineTransform();
        OldGTM.setTransform(this.engine.GTM);
        double oldAngle = this.engine.tmpAngle;
        if (bg.TransProps != null && bg.TransProps.Angle != 0.0) {
            this.engine.tmpAngle += bg.TransProps.Angle;
        }
        try {
            this.engine.GTM.concatenate(SchemeEngine.GenTransform(bg));
            if (root) {
                this.currentObjId = this.s.objIDByShapeID(bg.ID);
            }
            if (!this.insertMode) {
                this.currentAttValues = this.getAttValues(bg);
            }
            if (bg instanceof PhxGraphicInsert) {
                res = this.writeInsert((PhxGraphicInsert)bg);
            } else if (bg instanceof GraphicBlock) {
                res = this.writeBlock((GraphicBlock)bg);
            } else if (bg instanceof Polygon) {
                res = this.writePolygon((Polygon)bg);
            } else if (bg instanceof Region) {
                res = this.writeRegion((Region)bg);
            } else if (bg instanceof Spline) {
                res = this.writeSpline((Spline)bg);
            } else if (bg instanceof Polyline) {
                res = this.writePolyline((Polyline)bg);
            } else if (bg instanceof Pie) {
                res = this.writePie((Pie)bg);
            } else if (bg instanceof Ellipse) {
                res = this.writeEllipse((Ellipse)bg);
            } else if (bg instanceof AttributeDef) {
                res = this.writeAttributeDef((AttributeDef)bg);
            } else if (bg instanceof AttributeRef) {
                res = this.writeAttributeRef((AttributeRef)bg);
            } else if (bg instanceof Paragraph) {
                res = this.writeParagraph((Paragraph)bg);
            } else if (bg instanceof Image) {
                res = this.writeImage((Image)bg);
            } else if (bg instanceof Rectangle) {
                res = this.writeRectangle((Rectangle)bg);
            }
            if (res && !(bg instanceof GraphicBlock)) {
                this.writeMidLine(bg.ID);
            }
            if (bg.emText()) {
                this.writeShape(bg.EmbeddedText, root);
            }
        }
        finally {
            this.engine.GTM.setTransform(OldGTM);
            this.engine.tmpAngle = oldAngle;
        }
        return res;
    }

    private boolean writePolyline(Polyline bg) {
        int pCount;
        int n = pCount = bg.Points != null ? bg.Points.length / 2 : 0;
        if (pCount < 2) {
            return false;
        }
        double[] pts = this.engine.MulPoints(bg.Points);
        int pPattern = !this.insertMode || bg.PenPattern != -1 ? bg.PenPattern : 0;
        boolean isSpec = !this.insertMode && this.engine.getActualPrimID(pPattern, bg.PrimID) > 0.0;
        pPattern = isSpec ? 0 : this.engine.getActualPenPattern(pPattern);
        int[] pointsCounts = bg.PointsCounts;
        if (pointsCounts != null && pointsCounts.length > 0) {
            double[] arr = bg.PointsWithJump;
            int bias = 0;
            for (int pointsCount : pointsCounts) {
                if (pointsCount == 0) continue;
                pCount = pointsCount;
                pts = new double[pCount * 2];
                System.arraycopy(arr, bias, pts, 0, pCount * 2);
                this.writePoly(bg, pts, 0, pCount, pPattern);
                bias += pCount * 2;
            }
        } else {
            if (bg.PointsWithJump != null) {
                pCount = bg.PointsWithJump.length / 2;
                pts = bg.PointsWithJump;
            }
            this.writePoly(bg, pts, 0, pCount, pPattern);
        }
        return true;
    }

    private boolean writePoly(BaseShape bg, double[] pts, int index, int count, int pPattern) {
        Color pColor = this.engine.getActualPColor(bg.pColor);
        double lWidth = this.engine.getActualLWidth(bg.lWidth);
        this.writeLine("PLINE " + count);
        this.writePoints(pts, index, count);
        this.writePen(lWidth, pPattern, pColor);
        return true;
    }

    private boolean writePoly(BaseShape bg, double[] pts, int index, int count) {
        int pPattern = this.engine.getActualPenPattern(bg.PenPattern);
        return this.writePoly(bg, pts, index, count, pPattern);
    }

    private boolean writeSpline(Spline bg) {
        int pCount;
        double[] points = bg.calcPoints();
        int n = pCount = points != null ? points.length / 2 : 0;
        if (pCount < 2) {
            return false;
        }
        double[] pts = this.engine.MulPoints(points);
        this.writePoly(bg, pts, 0, pCount);
        return true;
    }

    private boolean writePolygon(Polygon bg) {
        return this.writeAsPolygon(bg, this.engine.MulPoints(bg.Points), bg.Counts);
    }

    private boolean writeAsPolygon(BaseShape bg, double[] pts, int[] counts) {
        int pCount;
        int n = pCount = pts != null ? pts.length / 2 : 0;
        if (pCount < 2) {
            return false;
        }
        int sectCount = counts != null ? counts.length : 1;
        int vCount = pCount;
        int counter = 0;
        this.writeLine("REGION " + sectCount);
        for (int i = 0; i < sectCount; ++i) {
            if (sectCount > 1) {
                vCount = counter + counts[i] <= pCount ? counts[i] : pCount - counter;
            }
            this.writeLine(Integer.toString(vCount));
            this.writePoints(pts, counter, vCount);
            counter += vCount;
        }
        this.writeStyle(bg);
        return true;
    }

    private boolean writeRegion(Region bg) {
        int sectCount = bg.Counts != null ? bg.Counts.length : 1;
        this.writeLine("REGION " + sectCount);
        for (int i = 0; i < sectCount; ++i) {
            int pCount;
            double[] points = bg.calcPoints(i);
            int n = pCount = points != null ? points.length / 2 : 0;
            if (pCount < 2) continue;
            double[] pts = this.engine.MulPoints(points);
            this.writeLine(Integer.toString(pCount));
            this.writePoints(pts, 0, pCount);
        }
        this.writeStyle(bg);
        return true;
    }

    private boolean writeRectangle(Rectangle bg) {
        double[] points = bg.getRectPoints();
        double[] pts = this.engine.MulPoints(points);
        if (SchemeEngine.checkRect(pts[0], pts[1], pts[2], pts[3], pts[4], pts[5], pts[6], pts[7])) {
            String str = "RECT " + pts[0] + " " + -pts[1] + " " + pts[2] + " " + -pts[5];
            this.writeLine(str);
            this.writeStyle(bg);
            return true;
        }
        return this.writeAsPolygon(bg, pts, null);
    }

    private boolean writeImage(Image bg) {
        return this.writeRectangle(bg);
    }

    private boolean writeEllipse(Ellipse bg) {
        double[] points = bg.getRectPoints();
        double[] pts = this.engine.MulPoints(points);
        if (SchemeEngine.checkRect(pts[0], pts[1], pts[2], pts[3], pts[4], pts[5], pts[6], pts[7])) {
            String str = "ELLIPSE " + pts[0] + " " + -pts[1] + " " + pts[2] + " " + -pts[5];
            this.writeLine(str);
            this.writeStyle(bg);
            return true;
        }
        points = SchemeEngine.SidesToEllipse(bg.SideX, bg.SideY, bg.Slices);
        pts = this.engine.MulPoints(points);
        return this.writeAsPolygon(bg, pts, null);
    }

    private boolean writePie(Pie bg) {
        byte pieType = bg.PieType;
        double startAngle = 360.0 - 180.0 * bg.StartAngle / Math.PI;
        double endAngle = 360.0 - 180.0 * bg.EndAngle / Math.PI;
        double[] points = bg.getRectPoints();
        double[] pts = this.engine.MulPoints(points);
        if (pieType == 0 && SchemeEngine.checkRect(pts[0], pts[1], pts[2], pts[3], pts[4], pts[5], pts[6], pts[7])) {
            String str = "ARC " + pts[0] + " " + -pts[1] + " " + pts[2] + " " + -pts[5];
            this.writeLine(str);
            this.writeLine(String.valueOf(startAngle) + " " + endAngle);
            this.writePenStyle(bg);
            return true;
        }
        double sideX = Math.abs(bg.SideX);
        double sideY = Math.abs(bg.SideY);
        points = SchemeEngine.SidesToPie(sideX, sideY, bg.Slices + 1, pieType, bg.StartAngle, bg.EndAngle);
        int pCount = points.length / 2;
        for (int i = 0; i < pCount; ++i) {
            int idx = 2 * i + 1;
            points[idx] = -points[idx];
        }
        pts = this.engine.MulPoints(points);
        if (pieType == 0) {
            return this.writePoly(bg, pts, 0, pCount);
        }
        return this.writeAsPolygon(bg, pts, null);
    }

    private boolean writeParagraph(Paragraph bg) {
        if (bg.Lines == null || bg.Lines.isEmpty()) {
            return false;
        }
        String text = this.getText(bg);
        if (text.isEmpty()) {
            return false;
        }
        this.writeLine("TEXT \"" + text + "\"");
        double w = Math.abs(bg.SideX);
        double h = Math.abs(bg.SideY);
        double xl = -0.5 * w;
        double yt = -0.5 * h;
        double xPropCenterX = bg.TransProps == null ? 0.0 : bg.TransProps.CenterX;
        double xPropCenterY = bg.TransProps == null ? 0.0 : bg.TransProps.CenterY;
        double xPropScaleX = bg.TransProps == null ? 1.0 : bg.TransProps.ScaleX;
        double xPropScaleY = bg.TransProps == null ? 1.0 : bg.TransProps.ScaleY;
        double[] points = new double[]{xl -= xPropCenterX * Math.abs(xPropScaleX), yt += xPropCenterY * Math.abs(xPropScaleY)};
        double[] pts = this.engine.MulPoints(points);
        String boundsStr = String.valueOf(pts[0]) + " " + -pts[1] + " " + (pts[0] + w) + " " + (-pts[1] - h);
        this.writeLine(boundsStr);
        RectTextLine line = (RectTextLine)bg.Lines.get(0);
        String fontName = line.FontName != null && !line.FontName.isEmpty() ? line.FontName.trim() : "Arial";
        Color fontColor = this.engine.getActualFontColor(line.FontColor);
        String fontStr = "FONT (\"" + fontName + "\"," + line.FontStyle + "," + Math.max(line.FontSize, 0) + "," + this.getColor(fontColor) + ")";
        this.writeLine(fontStr);
        if (bg.Align == 1) {
            this.writeLine(" Justify Right");
        } else if (bg.Align == 2) {
            this.writeLine(" Justify Center");
        }
        if (this.engine.tmpAngle != 0.0) {
            this.writeLine("Angle " + (360.0 - this.engine.tmpAngle));
        }
        return true;
    }

    private String getText(Paragraph bg) {
        if (bg.Lines == null || bg.Lines.isEmpty()) {
            return "";
        }
        int count = bg.Lines.size();
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                text.append("\\n");
            }
            RectTextLine line = (RectTextLine)bg.Lines.get(i);
            text.append(line.Text != null ? line.Text : "");
        }
        return text.toString().replace("\"", "\"\"");
    }

    private boolean writeAttributeDef(AttributeDef bg) {
        if (bg.invisible()) {
            return false;
        }
        return this.writeParagraph(bg);
    }

    private boolean writeAttributeRef(AttributeRef bg) {
        if (bg.invisible()) {
            return false;
        }
        return this.writeParagraph(bg);
    }

    private boolean writeBlock(GraphicBlock block) {
        if (block.Objects == null || block.Objects.isEmpty()) {
            return false;
        }
        boolean res = false;
        int count = block.Objects.size();
        for (int i = 0; i < count; ++i) {
            BaseGraphic bg = block.Objects.get(i);
            if (bg == null || this.insertMode && (block.Objects.get(i) instanceof AttributeRef || block.Objects.get(i) instanceof AttributeDef) || !this.writeShape(bg, false)) continue;
            res = true;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeInsert(PhxGraphicInsert insert) {
        boolean res;
        Primitive prim = this.s.findPrimInLibsById(insert.SourceID, insert.LibID);
        if (prim == null || prim.BG == null) {
            return false;
        }
        GraphicBlock block = (GraphicBlock)prim.BG;
        if (insert.getInternalPrimGraphicBlock() != null) {
            block = insert.getInternalPrimGraphicBlock();
        }
        if (block == null || block.Objects == null || block.Objects.isEmpty()) {
            return false;
        }
        this.insertMode = true;
        try {
            res = this.writeBlock(block);
            int attCount = insert.Attributes != null ? insert.Attributes.size() : 0;
            for (int i = 0; i < attCount; ++i) {
                Attribute att = (Attribute)insert.Attributes.get(i);
                if (att == null || att.invisible()) continue;
                if (att.Inscribe) {
                    if (att.getEngine() == null) {
                        att.setEngine(this.engine);
                    }
                    double oldSideX = att.SideX;
                    att.setInscribeExt(block, true, false, false);
                    if (oldSideX < att.SideX) {
                        double scaleX = insert.TransProps == null ? 1.0 : insert.TransProps.ScaleX;
                        double scaleY = insert.TransProps == null ? 1.0 : insert.TransProps.ScaleY;
                        double attCenterX = att.SideX * 0.5;
                        double attCenterY = att.SideY * 0.5;
                        if (att.TransProps != null) {
                            att.TransProps.CenterX = attCenterX;
                            att.TransProps.CenterY = attCenterY;
                        }
                        att.OrgX = -attCenterX / scaleX;
                        att.OrgY = -attCenterY / scaleY;
                    }
                }
                if (!this.writeShape(att, false)) continue;
                res = true;
            }
        }
        finally {
            this.insertMode = false;
        }
        return res;
    }

    public void setStateHost(ServerSideHost host) {
        this.stateHost = host;
    }

    private void putStateCaption(String caption) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateCaption(caption);
    }

    private void putStateText(String value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateText(value);
    }

    private void putStateInstruction(String value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateInstruction(value);
    }

    private void putStateLog(String value) {
        if (this.stateHost == null) {
            return;
        }
        try {
            this.stateHost.putRequestStateLog(value);
        }
        catch (Exception ex) {
            Core.logger.error("", ex);
        }
    }

    private void putStateProgressMin(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressMin(value);
    }

    private void putStateProgressMax(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressMax(value);
    }

    private void putStateProgressPosition(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressPosition(value);
    }

    public static class RealPoint {
        private double x = 0.0;
        private double y = 0.0;

        public RealPoint(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public void assign(RealPoint source) {
            this.x = source.x;
            this.y = source.y;
        }
    }
}

