/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.schemes.AddObjectCommand;
import inform.agent.schemes.DeleteObjectCommand;
import inform.agent.schemes.EndTransactionCommand;
import inform.agent.schemes.ModifyObjectCommand;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.StartTransactionCommand;
import inform.agent.schemes.UnknownModificationCommandException;

public abstract class ModificationCommand {
    private SchemeObject subjectDescriptor;
    private SchemeObject resolvedObject;
    private int revision;

    public static ModificationCommand createCommand(int commandTag) throws UnknownModificationCommandException {
        ModificationCommand command = null;
        switch (commandTag) {
            case 2: {
                command = new AddObjectCommand();
                break;
            }
            case 3: {
                command = new ModifyObjectCommand();
                break;
            }
            case 4: {
                command = new DeleteObjectCommand();
                break;
            }
            case 6: {
                command = new StartTransactionCommand();
                break;
            }
            case 7: {
                command = new EndTransactionCommand();
                break;
            }
            default: {
                throw new UnknownModificationCommandException(commandTag);
            }
        }
        return command;
    }

    public abstract void run(Scheme var1, Request var2) throws InformException;

    public SchemeObject getSubjectDescriptor() {
        return this.subjectDescriptor;
    }

    public void setSubjectDescriptor(SchemeObject subjectDescriptor) {
        this.subjectDescriptor = subjectDescriptor;
    }

    public void setSessionSchemeRevision(int revision) {
        this.revision = revision;
    }

    public int getSessionSchemeRevision() {
        return this.revision;
    }

    public void log(String comment) {
        if (this.subjectDescriptor == null) {
            Core.logger.debug("{} {}", comment, this.getClass().getName());
        } else {
            Core.logger.debug(comment + " {}, {}", this.getClass().getName(), this.getSubjectDescriptor());
        }
    }

    public void log() {
        this.log("");
    }

    abstract boolean isModificationAllowed(Scheme var1);

    public SchemeObject getLockedObject() {
        return this.resolvedObject;
    }

    public void lockObject(Scheme scheme, long handle) throws InterruptedException {
        SchemeObject so;
        if (this.resolvedObject == null && (so = scheme.getObjectSilent(this.subjectDescriptor.getType(), this.subjectDescriptor.getID())) != null) {
            so.lock(handle);
            this.resolvedObject = so;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockObject(Scheme scheme, long handle) {
        if (this.resolvedObject != null) {
            SchemeObject schemeObject = this.resolvedObject;
            synchronized (schemeObject) {
                this.resolvedObject.unlock(handle);
                if (this.resolvedObject.getLockOwner() != handle) {
                    this.resolvedObject = null;
                }
            }
        }
    }
}

