/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.DateTime;
import inform.adt.collections.IntegerList;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.schemes.Attribute;
import inform.agent.schemes.AttributeDef;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.Ellipse;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PhxImage;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.Polygon;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.Region;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemePageLayout;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.Spline;
import inform.agent.schemes.Table;
import inform.agent.schemes.TableCell;
import inform.agent.schemes.TextProps;
import inform.agent.schemes.TransformProps;
import inform.agent.schemes.converters.odg.Odg;
import inform.agent.schemes.converters.odg.OdgParser;
import inform.agent.schemes.converters.odg.content.FigureType;
import inform.agent.schemes.converters.odg.content.OdgConnector;
import inform.agent.schemes.converters.odg.content.OdgEllipse;
import inform.agent.schemes.converters.odg.content.OdgEnhancedGeometry;
import inform.agent.schemes.converters.odg.content.OdgFigure;
import inform.agent.schemes.converters.odg.content.OdgFrame;
import inform.agent.schemes.converters.odg.content.OdgGluePoint;
import inform.agent.schemes.converters.odg.content.OdgGraphicGroup;
import inform.agent.schemes.converters.odg.content.OdgGraphicObject;
import inform.agent.schemes.converters.odg.content.OdgImage;
import inform.agent.schemes.converters.odg.content.OdgLine;
import inform.agent.schemes.converters.odg.content.OdgOfficeStyles;
import inform.agent.schemes.converters.odg.content.OdgPage;
import inform.agent.schemes.converters.odg.content.OdgProperties;
import inform.agent.schemes.converters.odg.content.OdgStyleStyle;
import inform.agent.schemes.converters.odg.content.OdgTable;
import inform.agent.schemes.converters.odg.content.OdgText;
import inform.agent.schemes.converters.odg.content.OdgTextBox;
import inform.agent.schemes.converters.odg.content.OdgUtils;
import inform.agent.schemes.converters.odg.styles.OdgAutomaticStyles;
import inform.agent.schemes.converters.odg.styles.OdgMasterStyles;
import inform.agent.schemes.converters.odg.styles.OdgStylePageLayoutProperties;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.DoubleStream;
import javax.imageio.ImageIO;

public class OdgReader {
    private ServerSideHost stateHost;
    private double userId;
    private double modifiedTime;
    private int order;
    private Scheme scheme;
    private SchemeEngine engine;
    private Odg odg;
    private double scaleX = 0.01;
    private double scaleY = 0.01;
    private boolean isFlatOdg;
    private static final double GLUE_TOLERANCE = 0.05;
    private static final double RECT_TOLERANCE = 0.1;
    private static final String DEF_ATT_CAPTION = "\u0410\u0442\u0440\u0438\u0431\u0443\u0442";
    private static final String COSMETIC_LAYER_NAME = "\u041a\u043e\u0441\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u043b\u043e\u0439";
    private static final String DEFAULT_FONT_NAME = "Liberation Sans";
    private static final double OPTIMAL_COLUMN_WIDTH = 28.2;
    private static final double OPTIMAL_ROW_HEIGHT = 9.6;
    private LinkedHashMap<PhxLayer, Boolean> hasGraphicsByLayer;
    private LinkedHashMap<String, PhxLayer> layerByName;
    private LinkedHashMap<Double, BaseGraphic> shapeHash;
    private LinkedHashMap<Double, IntegerList> connectionList;
    private LinkedHashMap<Integer, Double> connectionId;
    private LinkedHashMap<BaseGraphic, OdgGraphicObject> graphicObjectLinkedHashMap;

    public void setStateHost(ServerSideHost host) {
        this.stateHost = host;
    }

    public void setUserId(double userId) {
        this.userId = userId;
        this.modifiedTime = DateTime.currentDateTime();
    }

    public byte[] importOdg(byte[] content, boolean isFlatXml) throws Exception {
        this.isFlatOdg = isFlatXml;
        this.odg = this.parseOdg(content);
        if (this.odg == null) {
            return null;
        }
        this.scheme = new Scheme();
        this.engine = new SchemeEngine(this.scheme);
        this.engine.InitTmpProps();
        this.scheme.primInsFlags = 0;
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
        Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0441\u0445\u0435\u043c\u044b");
        this.connectionList = new LinkedHashMap();
        this.shapeHash = new LinkedHashMap();
        this.connectionId = new LinkedHashMap();
        this.graphicObjectLinkedHashMap = new LinkedHashMap();
        OdgMasterStyles masterStyles = this.odg.getStyles().getOfficeMasterStyles();
        if (masterStyles == null) {
            OdgPage page = this.odg.getContent().drawPage.get(0);
            this.readPage(page, null);
        } else {
            this.layerByName = new LinkedHashMap();
            this.hasGraphicsByLayer = new LinkedHashMap();
            this.initBasicTags();
            ArrayList<OdgMasterStyles.LayerSet.Layer> layout = masterStyles.getLayersMap();
            int numberPages = this.odg.numberPages();
            for (int i = 0; i < numberPages; ++i) {
                PhxLayer phxLayer;
                double layerId;
                OdgPage page = this.odg.getContent().drawPage.get(i);
                double pageId = i == 0 ? 1.0 : Core.generateId();
                SchemeObject pageObject = new SchemeObject(pageId, 116);
                pageObject.setOrder(i);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                TaggedWriter writer = new TaggedWriter(os);
                writer.putString(1, page.getDrawName());
                OdgAutomaticStyles oas = this.odg.getStyles().getOfficeAutomaticStyles();
                OdgStylePageLayoutProperties properties = oas.getPageProperties();
                SchemePageLayout schemePageLayout = this.convertPageLayout(properties);
                ByteArrayOutputStream os2 = new ByteArrayOutputStream();
                TaggedWriter writer2 = new TaggedWriter(os2);
                schemePageLayout.store(writer2);
                writer2.flush();
                if (os2.size() > 0) {
                    writer.putRaw(2, os2);
                }
                writer.flush();
                if (os.size() > 0) {
                    pageObject.setParams(os.toByteArray());
                }
                this.scheme.placeLast(pageObject);
                int order = 1;
                if (i == 0) {
                    layerId = Core.generateId();
                    phxLayer = new PhxLayer();
                    phxLayer.ID = layerId;
                    phxLayer.Cosmetic = true;
                    phxLayer.setCaption(COSMETIC_LAYER_NAME);
                    if (pageId > 1.0) {
                        phxLayer.PageId = pageId;
                    }
                    SchemeObject layerObject = new SchemeObject(layerId, 204);
                    layerObject.setOrder(order++);
                    layerObject.setParams(phxLayer.asBinary());
                    this.scheme.placeLast(layerObject);
                }
                for (OdgMasterStyles.LayerSet.Layer layer : layout) {
                    layerId = Core.generateId();
                    phxLayer = new PhxLayer();
                    phxLayer.ID = layerId;
                    phxLayer.Description = layer.svgDesc;
                    phxLayer.Selectable = !layer.drawProtected;
                    phxLayer.Visible = !layer.drawDisplay.equals("none");
                    phxLayer.setCaption(layer.drawName);
                    if (pageId > 1.0) {
                        phxLayer.PageId = pageId;
                    }
                    this.layerByName.put(layer.drawName, phxLayer);
                    this.hasGraphicsByLayer.put(phxLayer, false);
                }
                this.readPage(page, properties);
                Core.logger.info("\u0421\u0442\u0430\u0442\u0443\u0441: \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f " + (i + 1) + " \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b (" + this.shapeHash.size() + " \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432)");
                Collection<Boolean> layerCollection = this.hasGraphicsByLayer.values();
                if (this.isEmptyPage(layerCollection.toArray()) && numberPages > 1) {
                    PhxLayer phxLayer2 = this.layerByName.get("layout");
                    assert (phxLayer2 != null);
                    SchemeObject phxLayerObject = new SchemeObject(phxLayer2.ID, 204);
                    phxLayerObject.setOrder(order);
                    phxLayerObject.setParams(phxLayer2.asBinary());
                    this.scheme.placeLast(phxLayerObject);
                } else {
                    Map.Entry<String, PhxLayer> map;
                    PhxLayer layer;
                    Iterator<Map.Entry<String, PhxLayer>> iterator = this.layerByName.entrySet().iterator();
                    while (iterator.hasNext() && (layer = (map = iterator.next()).getValue()) != null) {
                        Boolean hasGraphics = this.hasGraphicsByLayer.get(layer);
                        assert (hasGraphics != null);
                        if (!hasGraphics.booleanValue() && numberPages != 1) continue;
                        SchemeObject phxLayerObject = new SchemeObject(layer.ID, 204);
                        phxLayerObject.setOrder(order++);
                        phxLayerObject.setParams(layer.asBinary());
                        this.scheme.placeLast(phxLayerObject);
                    }
                }
                this.layerByName.clear();
                this.hasGraphicsByLayer.clear();
                this.shapeHash.clear();
                this.connectionId.clear();
                this.connectionList.clear();
                this.graphicObjectLinkedHashMap.clear();
            }
        }
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e");
        Core.logger.info("\u0418\u043c\u043f\u043e\u0440\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.scheme.saveAll(out, null, true, false);
        return out.toByteArray();
    }

    private boolean isEmptyPage(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return true;
        }
        Object firstElement = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (firstElement.equals(arr[i])) continue;
            return false;
        }
        return true;
    }

    private void readPage(OdgPage page, OdgStylePageLayoutProperties properties) throws IOException {
        OdgGraphicGroup shape = page.getShape();
        int n = shape.childShape.size();
        for (int m = 0; m < n; ++m) {
            OdgGraphicObject object = shape.childShape.get(m);
            GraphicBlock block = new GraphicBlock();
            block.setEngine(this.engine);
            block.ID = Core.generateId();
            block.Objects = new ArrayList();
            if (object instanceof OdgGraphicGroup) {
                this.convertFigure((OdgGraphicGroup)object, block, properties);
                block.calcOrgAndAjust(Integer.MAX_VALUE, true);
                if (block.Objects.size() == 0) continue;
                BaseGraphic graphic = block.Objects.get(0);
                block.LayerID = graphic.LayerID;
                this.shapeHash.put(block.ID, block);
                continue;
            }
            this.convertFigure(object, block, properties);
            int cnt = block.Objects.size();
            for (int j = 0; j < cnt; ++j) {
                BaseGraphic graphic = block.Objects.get(j);
                this.shapeHash.put(graphic.ID, graphic);
            }
        }
        for (Map.Entry<Double, IntegerList> entry : this.connectionList.entrySet()) {
            int[] arr = entry.getValue().toArray();
            for (int j = 0; j < arr.length; ++j) {
                int k = arr[j];
                BaseGraphic graphic1 = this.shapeHash.get(entry.getKey());
                BaseGraphic graphic2 = this.shapeHash.get(this.connectionId.get(k));
                if (graphic1 instanceof Polyline && graphic2 instanceof Polyline) {
                    Polyline polyline1 = (Polyline)graphic1;
                    Polyline polyline2 = (Polyline)graphic2;
                    if (polyline1.ConnectorView != 0 && polyline2.ConnectorView != 0) continue;
                    this.connectFigure(graphic1, graphic2, j);
                    continue;
                }
                this.connectFigure(graphic1, graphic2, j);
            }
        }
        for (Map.Entry<Double, Object> entry : this.shapeHash.entrySet()) {
            BaseGraphic graphic = (BaseGraphic)entry.getValue();
            SchemeObject schemeObject = this.init(graphic.shapeType(), graphic);
            this.scheme.placeLast(schemeObject);
        }
    }

    private void connectFigure(BaseGraphic from, BaseGraphic to, int order) {
        if (from == null || to == null) {
            return;
        }
        BaseGraphic node = null;
        BaseGraphic polyline = null;
        double[] pt = new double[2];
        double[] pt1 = new double[2];
        double[] pt2 = new double[2];
        if (this.shapeIsArc(from) && from instanceof Polyline) {
            polyline = from;
        } else if (this.shapeIsNode(from)) {
            node = from;
        }
        if (this.shapeIsArc(to) && to instanceof Polyline) {
            polyline = to;
        } else if (this.shapeIsNode(to)) {
            node = to;
        }
        if (node != null && polyline != null) {
            double rectSize2;
            int verticesCount;
            int num;
            OdgConnector connector = (OdgConnector)this.graphicObjectLinkedHashMap.get(polyline);
            OdgFigure figure = (OdgFigure)this.graphicObjectLinkedHashMap.get(node);
            assert (connector != null);
            int n = num = order == 0 ? connector.getDrawStartGluePoints() : connector.getDrawEndGluePoints();
            if (num >= 0 && num <= 3) {
                this.setGluePointsDefault(node, num, figure);
            }
            List<BaseGraphic.GluePoint> polylinePointList = polyline.GluePoints;
            List<BaseGraphic.GluePoint> nodePointList = node.GluePoints;
            if (polylinePointList != null && nodePointList != null && num >= 0) {
                int fromCount = polylinePointList.size();
                int toCount = nodePointList.size();
                for (int i = 0; i < fromCount; ++i) {
                    for (int j = 0; j < toCount; ++j) {
                        this.glueShapes(polyline, node);
                    }
                }
                return;
            }
            pt[0] = 0.0;
            pt[1] = 0.0;
            pt = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(node), pt);
            int n2 = verticesCount = polylinePointList == null ? 0 : polylinePointList.size();
            assert (verticesCount > 1);
            BaseGraphic.GluePoint linePoint1 = polylinePointList.get(0);
            pt1[0] = linePoint1.ptX;
            pt1[1] = linePoint1.ptY;
            pt1 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(polyline), pt1);
            BaseGraphic.GluePoint linePoint2 = polylinePointList.get(verticesCount - 1);
            pt2[0] = linePoint2.ptX;
            pt2[1] = linePoint2.ptY;
            pt2 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(polyline), pt2);
            BaseGraphic.RealRect rect = node.getMinMaxRect();
            double rectSize = Math.abs(rect.Right - rect.Left);
            if (rectSize < (rectSize2 = Math.abs(rect.Bottom - rect.Top))) {
                rectSize = rectSize2;
            }
            rect.Left -= rectSize * 0.1;
            rect.Right += rectSize * 0.1;
            rect.Top -= rectSize * 0.1;
            rect.Bottom += rectSize * 0.1;
            if (SchemeEngine.IsPointInRect(rect.Left, rect.Top, rect.Right, rect.Bottom, pt1[0], pt1[1]) || SchemeEngine.IsPointInRect(rect.Left, rect.Top, rect.Right, rect.Bottom, pt2[0], pt2[1])) {
                if (SchemeUtils.distance(pt[0], pt[1], pt1[0], pt1[1]) < SchemeUtils.distance(pt[0], pt[1], pt2[0], pt2[1])) {
                    pt2 = pt1;
                    linePoint2 = linePoint1;
                }
                try {
                    AffineTransform tm = SchemeEngine.GenTransform(node);
                    tm.invert();
                    pt2 = SchemeEngine.MulPointsTM(tm, pt2);
                }
                catch (NoninvertibleTransformException ex) {
                    ex.printStackTrace();
                }
                if (polyline instanceof Spline) {
                    node.addGluePoint(pt2[0], pt2[1]);
                    this.glueShapes(from, to);
                } else {
                    node.addDynamicGluePoint();
                    double linkId = node.DynamicGluePoint.joinId != 0.0 ? node.DynamicGluePoint.joinId : Core.generateId();
                    node.DynamicGluePoint.flags = (byte)4;
                    node.DynamicGluePoint.joinId = linkId;
                    linePoint2.flags = (byte)4;
                    linePoint2.joinId = linkId;
                }
            }
        } else if (this.shapeIsArc(from) && this.shapeIsArc(to)) {
            int cntConnector = from.getVerticesCount();
            int cntShape = to.getVerticesCount();
            if (cntConnector < 2 || cntShape < 2) {
                return;
            }
            double[] conn1 = new double[2];
            double[] conn2 = new double[2];
            double[] point = null;
            conn1[0] = from.getVertexX(0);
            conn1[1] = from.getVertexY(0);
            conn1 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(from), conn1);
            conn2[0] = from.getVertexX(cntConnector - 1);
            conn2[1] = from.getVertexY(cntConnector - 1);
            conn2 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(from), conn2);
            pt1[0] = to.getVertexX(0);
            pt1[1] = to.getVertexY(0);
            pt1 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(to), pt1);
            for (int idx = 1; idx < cntShape && point == null; ++idx) {
                pt2[0] = to.getVertexX(idx);
                pt2[1] = to.getVertexY(idx);
                pt2 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(to), pt2);
                if (SchemeUtils.isPointOnLine(pt1[0], pt1[1], pt2[0], pt2[1], conn1[0], conn1[1])) {
                    point = conn1;
                    continue;
                }
                if (SchemeUtils.isPointOnLine(pt1[0], pt1[1], pt2[0], pt2[1], conn2[0], conn2[1])) {
                    point = conn2;
                    continue;
                }
                pt1[0] = pt2[0];
                pt1[1] = pt2[1];
            }
            if (point != null) {
                try {
                    AffineTransform tm = SchemeEngine.GenTransform(to);
                    tm.invert();
                    point = SchemeEngine.MulPointsTM(tm, point);
                }
                catch (NoninvertibleTransformException ex) {
                    ex.printStackTrace();
                }
                to.addGluePoint((double)point[0], point[1]);
                this.glueShapes(from, to);
            }
        }
    }

    private boolean shapeIsNode(BaseGraphic shape) {
        if (shape == null) {
            return false;
        }
        return shape instanceof GraphicBlock ? !this.shapeIsArc(shape) : shape instanceof Rectangle || shape instanceof Polygon || shape instanceof Region;
    }

    private boolean shapeIsArc(BaseGraphic shape) {
        if (shape == null) {
            return false;
        }
        if (shape instanceof GraphicBlock) {
            GraphicBlock block = (GraphicBlock)shape;
            int linesCount = 0;
            int childrenCount = block.Objects == null ? 0 : block.Objects.size();
            for (int i = 0; i < childrenCount; ++i) {
                boolean isLine;
                BaseGraphic child = block.Objects.get(i);
                boolean bl = isLine = child instanceof Polyline && child.getVerticesCount() == 2 && !(child instanceof Spline) && !(child instanceof Polygon) && !(child instanceof Region);
                if (isLine) {
                    ++linesCount;
                }
                if ((isLine || child instanceof AttributeDef) && linesCount <= 1) continue;
                return false;
            }
            return true;
        }
        return shape instanceof Polyline && !(shape instanceof Polygon) && !(shape instanceof Region);
    }

    private void glueShapes(BaseGraphic from, BaseGraphic to) {
        if (from == null || from.GluePoints == null || from.GluePoints.isEmpty()) {
            return;
        }
        if (to == null || to.GluePoints == null || to.GluePoints.isEmpty()) {
            return;
        }
        double[] p1 = new double[2];
        double[] p2 = new double[2];
        for (int i = 0; i < from.GluePoints.size(); ++i) {
            BaseGraphic.GluePoint gp1 = from.GluePoints.get(i);
            if (gp1 == null) continue;
            p1[0] = gp1.ptX;
            p1[1] = gp1.ptY;
            p1 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(from), p1);
            for (int j = 0; j < to.GluePoints.size(); ++j) {
                BaseGraphic.GluePoint gp2 = to.GluePoints.get(j);
                if (gp2 == null) continue;
                p2[0] = gp2.ptX;
                p2[1] = gp2.ptY;
                p2 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(to), p2);
                double distance = SchemeUtils.distance(p1[0], p1[1], p2[0], p2[1]);
                if (!(distance < 0.05)) continue;
                double linkId = gp1.joinId != 0.0 ? gp1.joinId : (gp2.joinId != 0.0 ? gp2.joinId : Core.generateId());
                gp1.flags = (byte)4;
                gp1.joinId = linkId;
                gp2.flags = (byte)4;
                gp2.joinId = linkId;
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertFigure(OdgGraphicObject obj, GraphicBlock block, OdgStylePageLayoutProperties properties) {
        OdgFrame frame;
        BaseGraphic graphic = null;
        double shiftMarginTop = 0.0;
        if (properties != null) {
            shiftMarginTop = properties.getFoMarginTop() * 2.0;
        }
        if (obj.hasGeometry()) {
            String geometryType = obj.getGeometry().getType();
            OdgFigure figure = (OdgFigure)obj;
            this.setScale(figure);
            graphic = geometryType.equals("ellipse") ? this.buildRectangle(figure, FigureType.ELLIPSE) : (geometryType.equals("rectangle") ? this.buildRectangle(figure, FigureType.RECTANGLE) : this.readShape(figure));
        } else if (obj instanceof OdgConnector) {
            OdgConnector connector = (OdgConnector)obj;
            graphic = this.readSvgShape(connector);
            this.setGluePointsFigure(connector, graphic);
            IntegerList glueList = new IntegerList(2);
            glueList.add(connector.getDrawStartShape());
            glueList.add(connector.getDrawEndShape());
            this.connectionList.put(graphic.ID, glueList);
        } else if (obj instanceof OdgLine) {
            OdgLine line = (OdgLine)obj;
            graphic = this.buildPolyline(line, FigureType.POLYLINE);
            this.setGluePointsFigure(line, graphic);
        } else if (obj instanceof OdgEllipse) {
            OdgEllipse ellipse = (OdgEllipse)obj;
            String value = ellipse.getDrawKind();
            int slices = 90;
            double sliceAngle = Math.PI * 2 / (double)slices;
            double sidesX = ellipse.getSvgWidth();
            double sidesY = ellipse.getSvgHeight();
            double Axe = Math.max(sidesX, sidesY) / 2.0;
            double angle1 = Math.toRadians(ellipse.getDrawStartAngle());
            double angle2 = Math.toRadians(ellipse.getDrawEndAngle());
            BaseGraphic.RealPoints result = this.getCompressedFigure(sidesX, sidesY, slices, sliceAngle, Axe);
            List<BaseGraphic.RealPoint> realPoints = this.getCircumference(angle1, angle2, result);
            switch (value) {
                case "arc": {
                    graphic = this.buildPolyline(realPoints, ellipse, FigureType.POLYLINE);
                    break;
                }
                case "cut": {
                    this.scaleX = 1.0;
                    this.scaleY = 1.0;
                    graphic = this.buildPolyline(realPoints, ellipse, FigureType.POLYGON);
                    break;
                }
                case "circle": 
                case "ellipse": {
                    graphic = this.buildRectangle(ellipse, FigureType.ELLIPSE);
                    break;
                }
            }
            assert (graphic != null);
            if (graphic.TransProps == null || SchemeUtils.isEqual(graphic.TransProps.Angle, 0.0)) {
                graphic.OrgX = ellipse.getSvgX() + ellipse.getSvgWidth() / 2.0;
                graphic.OrgY = ellipse.getSvgY() + ellipse.getSvgHeight() / 2.0;
            } else {
                BaseGraphic.RealPoint p = SchemeUtils.rotatePoint(ellipse.getSvgWidth() / 2.0, ellipse.getSvgHeight() / 2.0, graphic.TransProps.Angle);
                graphic.OrgX = ellipse.getSvgX() + p.X;
                graphic.OrgY = ellipse.getSvgY() + p.Y;
            }
        } else if (obj instanceof OdgFrame) {
            OdgFrame frame2 = (OdgFrame)obj;
            if (frame2.isTable()) {
                graphic = this.buildTable(frame2);
            } else if (frame2.isPicture()) {
                graphic = this.buildRectangle(frame2, FigureType.IMAGE);
            } else {
                if (!frame2.isTextBox()) return;
                graphic = this.buildRectangle(frame2, FigureType.PARAGRAPH);
            }
        } else {
            OdgFigure figure = (OdgFigure)obj;
            if (figure.isPolyline()) {
                graphic = this.buildPolyline(figure.getPoints(), figure, FigureType.POLYLINE);
            } else if (figure.isPolygon()) {
                graphic = this.buildPolyline(figure.getPoints(), figure, FigureType.POLYGON);
            } else if (figure.isPath()) {
                graphic = this.readSvgShape(obj);
            }
            if (graphic != null) {
                boolean mirrorHorizontal = false;
                boolean mirrorVertical = false;
                OdgEnhancedGeometry geometry = figure.getGeometry();
                if (geometry != null) {
                    mirrorHorizontal = geometry.isMirrorHorizontal();
                    mirrorVertical = geometry.isMirrorVertical();
                }
                graphic.calcOrgAndAjust(Integer.MAX_VALUE, true);
                this.calcPosition(graphic, figure, true, mirrorHorizontal != mirrorVertical);
            }
            if (figure.isRect()) {
                graphic = this.buildRectangle(figure, FigureType.RECTANGLE);
            }
        }
        if (graphic == null) {
            return;
        }
        ArrayList<BaseGraphic> doublesFigure = new ArrayList<BaseGraphic>();
        boolean isPictureWithText = false;
        if (obj instanceof OdgFrame && (frame = (OdgFrame)obj).isPicture() && frame.getImage().hasText()) {
            isPictureWithText = true;
        }
        if (obj.hasText() && !(obj instanceof OdgLine) || isPictureWithText) {
            GraphicBlock gb = new GraphicBlock();
            gb.SourceID = Core.generateId();
            gb.GluePoints = new ArrayList();
            gb.Objects = new ArrayList();
            gb.ID = Core.generateId();
            gb.LayerID = graphic.LayerID;
            gb.setEngine(this.engine);
            gb.TransProps = new TransformProps();
            if (graphic.StringProps != null) {
                gb.setCaption(graphic.StringProps.Caption);
            }
            if (graphic.TransProps != null) {
                gb.TransProps.Angle = graphic.TransProps.Angle;
                graphic.TransProps.Angle = 0.0;
            }
            gb.Objects.add(graphic);
            gb.calcOrgAndAjust(Integer.MAX_VALUE, true);
            AttributeDef attribute = new AttributeDef();
            this.assignText(attribute, obj, graphic);
            double height = gb.MaxPtY - gb.MinPtY;
            double width = gb.MaxPtX - gb.MinPtX;
            if (obj instanceof OdgFigure) {
                OdgFigure figure = (OdgFigure)obj;
                double dy = (figure.getSvgHeight() - height) / 2.0;
                double dx = (figure.getSvgWidth() - width) / 2.0;
                if (dy < 0.0) {
                    attribute.OrgY += dy;
                }
                if (dx < 0.0) {
                    attribute.OrgX += dx;
                }
            }
            gb.Objects.add(attribute);
            graphic = gb;
        } else if (obj.hasText()) {
            Paragraph paragraph = new Paragraph();
            this.assignText(paragraph, obj, graphic);
            paragraph.ShowBackground = false;
            paragraph.OrgX = graphic.OrgX;
            paragraph.OrgY = graphic.OrgY;
            OdgLine line = (OdgLine)obj;
            if (!(obj instanceof OdgConnector)) {
                paragraph.TransProps = new TransformProps();
                paragraph.TransProps.Angle = line.getRotateAngle();
                double x = Math.abs(line.getSvgX2() - line.getSvgX1());
                double y = Math.abs(line.getSvgY2() - line.getSvgY1());
                paragraph.SideX = Math.sqrt(x * x + y * y);
                paragraph.ShowBackground = false;
            } else {
                paragraph.SideX = Math.abs(line.getSvgX2() - line.getSvgX1());
                paragraph.SideY = Math.abs(line.getSvgY2() - line.getSvgY1());
            }
            doublesFigure.add(paragraph);
        }
        doublesFigure.add(graphic);
        for (BaseGraphic bg : doublesFigure) {
            if (obj instanceof OdgFigure) {
                if (bg instanceof GraphicBlock) {
                    double newHeight = ((GraphicBlock)bg).MaxPtY - ((GraphicBlock)bg).MinPtY;
                    double newWidth = ((GraphicBlock)bg).MaxPtX - ((GraphicBlock)bg).MinPtX;
                    ((OdgFigure)obj).setSvgHeight(newHeight);
                    ((OdgFigure)obj).setSvgWidth(newWidth);
                }
                if (obj.hasDrawId() && block != null) {
                    this.connectionId.put(obj.getDrawId(), block.ID);
                }
                this.setGluePointsFigure(obj, bg);
            }
            if (obj.hasDrawId()) {
                this.connectionId.put(obj.getDrawId(), bg.ID);
            }
            bg.OrgY -= shiftMarginTop;
            if (block == null) {
                this.shapeHash.put(bg.ID, bg);
            } else {
                block.Objects.add(bg);
            }
            this.graphicObjectLinkedHashMap.put(bg, obj);
        }
        doublesFigure.clear();
        this.scaleX = 0.01;
        this.scaleY = 0.01;
    }

    private void convertFigure(OdgGraphicGroup shape, GraphicBlock block, OdgStylePageLayoutProperties properties) {
        if (block == null) {
            return;
        }
        if (shape.hasDrawId()) {
            this.connectionId.put(shape.getDrawId(), block.ID);
        }
        int cnt = shape.childShape.size();
        for (int i = 0; i < cnt; ++i) {
            OdgGraphicObject obj = shape.childShape.get(i);
            if (obj instanceof OdgGraphicGroup) {
                OdgGraphicGroup group = (OdgGraphicGroup)obj;
                if (group.childShape != null && !group.childShape.isEmpty()) {
                    GraphicBlock gb = new GraphicBlock();
                    gb.setEngine(this.engine);
                    gb.ID = Core.generateId();
                    gb.Objects = new ArrayList();
                    this.convertFigure(group, gb, properties);
                    gb.LayerID = gb.Objects.get((int)0).LayerID;
                    gb.calcOrgAndAjust(Integer.MAX_VALUE, true);
                    block.Objects.add(gb);
                }
                block.StringProps = new TextProps();
                block.StringProps.Caption = shape.getDrawName();
                continue;
            }
            this.convertFigure(obj, block, properties);
        }
    }

    private SchemePageLayout convertPageLayout(OdgStylePageLayoutProperties page) {
        SchemePageLayout layout = new SchemePageLayout();
        double pageWidth = page.getFoPageWidth();
        double pageHeight = page.getFoPageHeight();
        if (page.getFoPageWidth() > 0.0 && page.getFoPageHeight() > 0.0) {
            layout.setActive(true);
            boolean portrait = page.getPrintOrientation().equals("portrait");
            layout.setPortrait(portrait);
            int w = (int)Math.round(pageWidth);
            int h = (int)Math.round(pageHeight);
            int v1 = portrait ? w : h;
            int v2 = portrait ? h : w;
            int format = 0;
            if (v1 == 105 && v2 == 148) {
                format = 7;
            } else if (v1 == 148 && v2 == 210) {
                format = 6;
            } else if (v1 == 210 && v2 == 297) {
                format = 5;
            } else if (v1 == 297 && v2 == 420) {
                format = 4;
            } else if (v1 == 420 && v2 == 594) {
                format = 3;
            } else if (v1 == 594 && v2 == 841) {
                format = 2;
            } else if (v1 == 841 && v2 == 1189) {
                format = 1;
            }
            layout.setFormat(format);
            if (format == 0) {
                layout.setWidth(w);
                layout.setHeight(h);
            }
        }
        layout.setLeftField((int)page.getFoMarginLeft());
        layout.setRightField((int)page.getFoMarginRight());
        layout.setTopField((int)page.getFoMarginTop());
        layout.setBottomField((int)page.getFoMarginBottom());
        return layout;
    }

    private String getExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    private PhxImage convertBitmap(OdgImage image, PhxImage phxImage) {
        String fileExtension;
        String fileName = image.getFileName();
        String string = fileExtension = this.getExtension(fileName).isEmpty() ? image.getType() : this.getExtension(fileName);
        if (fileExtension == null) {
            return null;
        }
        byte[] bytes = fileName.isEmpty() ? image.binaryData() : this.odg.getPictures().get(fileName);
        try {
            BufferedImage bmp;
            boolean bl = phxImage.StoreImage = "bmp".equalsIgnoreCase(fileExtension) || "jpeg".equalsIgnoreCase(fileExtension) || "jpg".equalsIgnoreCase(fileExtension) || "png".equalsIgnoreCase(fileExtension);
            if (phxImage.StoreImage) {
                phxImage.Content = bytes;
            }
            if ((bmp = ImageIO.read(new ByteArrayInputStream(bytes))) == null) {
                return null;
            }
            bmp = SchemeUtils.transformImageToABGR(bmp);
            phxImage.Bmp = SchemeUtils.getImagePixels24(bmp);
            phxImage.BmpHeight = bmp.getHeight();
            phxImage.BmpWidth = bmp.getWidth();
            if (phxImage.Bmp != null) {
                phxImage.ImageSize = phxImage.Bmp.length;
            }
            if (phxImage.Content == null) {
                ByteArrayOutputStream content = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bmp, "png", content);
                content.flush();
                phxImage.Content = content.toByteArray();
                phxImage.StoreImage = phxImage.Content.length > 0;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        phxImage.initClipPoints();
        return phxImage;
    }

    private Odg parseOdg(byte[] content) throws Exception {
        if (content == null || content.length == 0) {
            return null;
        }
        this.putStateCaption();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0430\u043d\u0430\u043b\u0438\u0437 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0441\u0445\u0435\u043c\u044b");
        Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0430\u043d\u0430\u043b\u0438\u0437 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 Draw");
        Odg odg = new Odg();
        OdgParser parser = new OdgParser(content, this.isFlatOdg);
        odg.setMeta(parser.parseMeta());
        odg.setSettings(parser.parseSettings());
        odg.setStyles(parser.parseStyles());
        odg.setContent(parser.parseContent());
        odg.setPictures(parser.getPictures());
        this.odg = odg;
        return odg;
    }

    private void initBasicTags() throws IOException {
        this.scheme.placeLast(this.scheme.createPropObject(-6));
        this.scheme.placeLast(this.scheme.createPropObject(-30));
        this.scheme.placeLast(this.scheme.createPropObject(-34));
        this.scheme.placeLast(this.scheme.createPropObject(-7));
        this.scheme.placeLast(this.scheme.createPropObject(-26));
        this.scheme.placeLast(this.scheme.createPropObject(-4));
        this.scheme.placeLast(this.scheme.createPropObject(-22));
        this.scheme.placeLast(this.scheme.createPropObject(-5));
        this.scheme.placeLast(this.scheme.createPropObject(-18));
        this.scheme.placeLast(this.scheme.createPropObject(-3));
        this.scheme.placeLast(this.scheme.createPropObject(-15));
        this.scheme.placeLast(this.scheme.createPropObject(-31));
        this.scheme.placeLast(this.scheme.createPropObject(-32));
        this.scheme.placeLast(this.scheme.createPropObject(-13));
        this.scheme.placeLast(this.scheme.createPropObject(-27));
        this.scheme.placeLast(this.scheme.createPropObject(-2));
        this.scheme.placeLast(this.scheme.createPropObject(-11));
        this.scheme.placeLast(this.scheme.createPropObject(-1));
        this.scheme.placeLast(this.scheme.createPropObject(-23));
        this.scheme.placeLast(this.scheme.createPropObject(-9));
        this.scheme.placeLast(this.scheme.createPropObject(-33));
        this.scheme.placeLast(this.scheme.createPropObject(-19));
        this.scheme.placeLast(this.scheme.createPropObject(-28));
        this.scheme.placeLast(this.scheme.createPropObject(-24));
        this.scheme.placeLast(this.scheme.createPropObject(-20));
        this.scheme.placeLast(this.scheme.createPropObject(-16));
        this.scheme.placeLast(this.scheme.createPropObject(-29));
        this.scheme.placeLast(this.scheme.createPropObject(-14));
        this.scheme.placeLast(this.scheme.createPropObject(-25));
        this.scheme.placeLast(this.scheme.createPropObject(-12));
        this.scheme.placeLast(this.scheme.createPropObject(-21));
        this.scheme.placeLast(this.scheme.createPropObject(-10));
        this.scheme.placeLast(this.scheme.createPropObject(-8));
    }

    private SchemeObject init(int type, BaseGraphic shape) throws IOException {
        SchemeObject object = new SchemeObject(shape.ID, type);
        object.setParams(shape.asBinary());
        object.setLastModUser(this.userId);
        object.setOrder(this.order++);
        object.setLastModTime(this.modifiedTime);
        object.setRevision(1);
        return object;
    }

    private void putStateCaption() throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateCaption("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0438\u043c\u043f\u043e\u0440\u0442 \u0441\u0445\u0435\u043c\u044b");
    }

    private void putStateText(String value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateText(value);
    }

    /*
     * Could not resolve type clashes
     */
    private BaseGraphic readShape(OdgFigure figure) {
        boolean transform;
        assert (figure != null);
        GraphicBlock block = new GraphicBlock();
        block.SourceID = Core.generateId();
        block.GluePoints = new ArrayList();
        block.Objects = new ArrayList();
        block.ID = Core.generateId();
        block.setCaption(figure.getDrawName());
        block.setEngine(this.engine);
        OdgEnhancedGeometry geometry = figure.getGeometry();
        List<OdgEnhancedGeometry.OdgCommand> listOdgCommand = geometry == null ? null : geometry.getDrawListOdgCommand();
        ArrayList<BaseGraphic.RealPoint> points = new ArrayList<BaseGraphic.RealPoint>();
        ArrayList<ArrayList<BaseGraphic.RealPoint>> pointsLists = new ArrayList<ArrayList<BaseGraphic.RealPoint>>();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        ArrayList<Region> regions = new ArrayList<Region>();
        String priorityCommand = null;
        boolean isTrajectoriesShaded = true;
        boolean isRepeatingEnd = false;
        boolean isRepeating = false;
        boolean isDisplaced = false;
        boolean hasL = false;
        double centerX = 0.0;
        double centerY = 0.0;
        double multiplePredominanceZ = 0.0;
        if (listOdgCommand != null) {
            int cnti = listOdgCommand.size();
            block47: for (int i = 0; i < cnti; ++i) {
                OdgEnhancedGeometry.OdgCommand command = listOdgCommand.get(i);
                assert (command != null);
                switch (command.nameCommand) {
                    case "M": {
                        points.add(command.pointTo.asRealPoint());
                        continue block47;
                    }
                    case "L": {
                        OdgEnhancedGeometry.Point p;
                        hasL = true;
                        if (priorityCommand == null) {
                            priorityCommand = "L";
                        }
                        BaseGraphic.RealPoint lineToPoint = new BaseGraphic.RealPoint();
                        if (isDisplaced) {
                            lineToPoint.X = command.pointTo.getX() - centerX;
                            lineToPoint.Y = command.pointTo.getY() - centerY;
                            points.add(lineToPoint);
                        } else if (!priorityCommand.equals("Q")) {
                            points.add(command.pointTo.asRealPoint());
                        } else {
                            for (int j = 0; j < 3; ++j) {
                                points.add(command.pointTo.asRealPoint());
                            }
                        }
                        String nameCommand = listOdgCommand.get((int)(i + 1)).nameCommand;
                        if (nameCommand.equals("Z") || nameCommand.equals("M") || nameCommand.equals("S") || nameCommand.equals("N") || nameCommand.equals("F")) {
                            switch (priorityCommand) {
                                case "Q": {
                                    points.add(command.pointTo.asRealPoint());
                                    Region region = (Region)this.buildPolyline(points, figure, FigureType.REGION, false);
                                    regions.add(region);
                                    break;
                                }
                                case "C": {
                                    points.remove(lineToPoint);
                                    Region region = (Region)this.buildPolyline(points, figure, FigureType.REGION, false);
                                    regions.add(region);
                                    break;
                                }
                                case "L": {
                                    if (points.size() == 2 || nameCommand.equals("F")) {
                                        Polyline polyline = (Polyline)this.buildPolyline(points, figure, FigureType.POLYLINE, false);
                                        block.Objects.add(polyline);
                                        break;
                                    }
                                    if (nameCommand.equals("M")) {
                                        ArrayList<BaseGraphic.RealPoint> list = new ArrayList<BaseGraphic.RealPoint>(points);
                                        pointsLists.add(list);
                                        break;
                                    }
                                    Polygon polygon = (Polygon)this.buildPolyline(points, figure, FigureType.POLYGON, false);
                                    polygons.add(polygon);
                                    break;
                                }
                                case "F": {
                                    for (int j = 0; j < points.size() - 1; ++j) {
                                        ArrayList<BaseGraphic.RealPoint> list = new ArrayList<BaseGraphic.RealPoint>();
                                        list.add((BaseGraphic.RealPoint)points.get(j));
                                        list.add((BaseGraphic.RealPoint)points.get(j + 1));
                                        Polyline polyline = (Polyline)this.buildPolyline(list, figure, FigureType.POLYLINE, false);
                                        block.Objects.add(polyline);
                                        list.clear();
                                    }
                                    break;
                                }
                            }
                            if (nameCommand.equals("Z")) {
                                multiplePredominanceZ += 1.0;
                            }
                            if (nameCommand.equals("S")) {
                                isTrajectoriesShaded = false;
                            }
                            if (nameCommand.equals("Z") && (priorityCommand.equals("W") || priorityCommand.equals("B"))) {
                                Polygon polygon = (Polygon)this.buildPolyline(points, figure, FigureType.POLYGON, false);
                                polygons.add(polygon);
                            }
                            points.clear();
                        }
                        if (nameCommand.equals("Q") && !priorityCommand.equals("Q")) {
                            ArrayList<BaseGraphic.RealPoint> real = new ArrayList<BaseGraphic.RealPoint>();
                            for (BaseGraphic.RealPoint realPoint : points) {
                                for (int j = 0; j < 3; ++j) {
                                    real.add(realPoint);
                                }
                            }
                            points = real;
                        }
                        if (!nameCommand.equals("C") || priorityCommand.equals("C")) continue block47;
                        points.clear();
                        LinkedList<OdgEnhancedGeometry.Point> pointQueue = new LinkedList<OdgEnhancedGeometry.Point>();
                        for (int counter = i; counter >= 0 && (listOdgCommand.get((int)counter).nameCommand.equals("L") || listOdgCommand.get((int)counter).nameCommand.equals("M")); --counter) {
                            pointQueue.add(listOdgCommand.get((int)counter).pointTo);
                        }
                        while ((p = (OdgEnhancedGeometry.Point)pointQueue.pollLast()) != null) {
                            points.add(p.asRealPoint());
                        }
                        ArrayList<BaseGraphic.RealPoint> list = new ArrayList<BaseGraphic.RealPoint>();
                        list.add((BaseGraphic.RealPoint)points.get(0));
                        for (int k = 1; k < points.size(); ++k) {
                            list.add((BaseGraphic.RealPoint)points.get(k));
                            list.add((BaseGraphic.RealPoint)points.get(k));
                            list.add((BaseGraphic.RealPoint)points.get(k));
                        }
                        points.clear();
                        points.addAll(list);
                        isRepeatingEnd = true;
                        continue block47;
                    }
                    case "C": {
                        priorityCommand = "C";
                        OdgEnhancedGeometry.Point point = command.pointTo;
                        BaseGraphic.RealPoint realPoint = point.asRealPoint();
                        points.add(realPoint);
                        String nameCommandEnd = listOdgCommand.get((int)(i + 1)).nameCommand;
                        if (nameCommandEnd.equals("Z")) {
                            if (isRepeatingEnd) {
                                int size = points.size();
                                points.add((BaseGraphic.RealPoint)points.get(size - 1));
                                points.add((BaseGraphic.RealPoint)points.get(0));
                                isRepeatingEnd = false;
                            } else if (hasL) {
                                points.add((BaseGraphic.RealPoint)points.get(0));
                                points.add((BaseGraphic.RealPoint)points.get(0));
                            } else {
                                points.remove(realPoint);
                            }
                            Region region = (Region)this.buildPolyline(points, figure, FigureType.REGION, false);
                            regions.add(region);
                            points.clear();
                        }
                        if (nameCommandEnd.equals("L")) {
                            points.add(realPoint);
                            points.add(realPoint);
                        }
                        if (!nameCommandEnd.equals("F") && !listOdgCommand.get((int)(i + 1)).nameCommand.equals("N")) continue block47;
                        ArrayList<BaseGraphic.RealPoint> list = new ArrayList<BaseGraphic.RealPoint>(points);
                        Spline spline = (Spline)this.buildPolyline(list, figure, FigureType.SPLINE, false);
                        block.Objects.add(spline);
                        points.clear();
                        continue block47;
                    }
                    case "Q": {
                        priorityCommand = "Q";
                        int x1 = command.angleEllipse.get(0);
                        int y1 = command.angleEllipse.get(1);
                        int x = command.angleEllipse.get(2);
                        int y = command.angleEllipse.get(3);
                        String nameCommandStart = listOdgCommand.get((int)(i - 1)).nameCommand;
                        if (nameCommandStart.equals("L")) {
                            BaseGraphic.RealPoint point = (BaseGraphic.RealPoint)points.get(points.size() - 1);
                            points.remove(point);
                        }
                        points.add(new BaseGraphic.RealPoint(x1, y1));
                        for (int j = 0; j < 3; ++j) {
                            points.add(new BaseGraphic.RealPoint(x, y));
                        }
                        String nameCommandEnd = listOdgCommand.get((int)(i + 1)).nameCommand;
                        if (nameCommandEnd.equals("Q")) {
                            BaseGraphic.RealPoint point = (BaseGraphic.RealPoint)points.get(points.size() - 1);
                            points.remove(point);
                            continue block47;
                        }
                        if (!nameCommandEnd.equals("Z")) continue block47;
                        Region region = (Region)this.buildPolyline(points, figure, FigureType.REGION, false);
                        regions.add(region);
                        points.clear();
                        continue block47;
                    }
                    case "U": 
                    case "T": {
                        isDisplaced = true;
                        priorityCommand = "U";
                        IntegerList list = command.angleEllipse;
                        int slices = 90;
                        double sliceAngle = Math.toRadians(Math.min(list.get(5), 360)) / (double)slices;
                        double sidesX = Math.abs(list.get(2) / 2);
                        double sidesY = Math.abs(list.get(3) / 2);
                        double Axe = Math.max(sidesX, sidesY);
                        for (int z = 0; z < slices; ++z) {
                            double x = Axe * Math.cos(sliceAngle * (double)z);
                            double y = Axe * Math.sin(sliceAngle * (double)z);
                            points.add(new BaseGraphic.RealPoint(x * 2.0, y * 2.0));
                        }
                        Polygon polygon = (Polygon)this.buildPolyline(points, figure, FigureType.POLYGON, false);
                        polygon.OrgX = (double)list.get(0) * this.scaleX;
                        polygon.OrgY = (double)list.get(1) * this.scaleY;
                        polygons.add(polygon);
                        String nameCommandEnd = listOdgCommand.get((int)(i + 1)).nameCommand;
                        if (!nameCommandEnd.equals("Z") && !nameCommandEnd.equals("M") && !nameCommandEnd.equals("S") && !nameCommandEnd.equals("N")) continue block47;
                        points.clear();
                        continue block47;
                    }
                    case "B": 
                    case "W": 
                    case "A": 
                    case "V": {
                        int v;
                        int z;
                        int cnt;
                        boolean flag;
                        isDisplaced = true;
                        List<OdgEnhancedGeometry.Point> list = command.arcEllipse;
                        double x1 = list.get(0).getX();
                        double y1 = list.get(0).getY();
                        double x2 = list.get(1).getX();
                        double y2 = list.get(1).getY();
                        double x3 = list.get(2).getX();
                        double y3 = list.get(2).getY();
                        double x4 = list.get(3).getX();
                        double y4 = list.get(3).getY();
                        centerX = (x1 + x2) / 2.0;
                        centerY = (y1 + y2) / 2.0;
                        double startX = x3 - centerX;
                        double startY = y3 - centerY;
                        double endX = x4 - centerX;
                        double endY = y4 - centerY;
                        double angle1 = OdgReader.calcAngle(startX, startY);
                        double angle2 = OdgReader.calcAngle(endX, endY);
                        double MAX_ANGLE = Math.PI * 2;
                        angle1 = angle1 < 0.0 ? angle1 + Math.PI * 2 : angle1;
                        angle2 = angle2 < 0.0 ? angle2 + Math.PI * 2 : angle2;
                        angle1 = angle1 >= Math.PI * 2 ? angle1 - Math.PI * 2 : angle1;
                        angle2 = angle2 >= Math.PI * 2 ? angle2 - Math.PI * 2 : angle2;
                        int slices = 90;
                        double sliceAngle = Math.PI * 2 / (double)slices;
                        double sidesX = Math.abs(x2 - x1) / 2.0;
                        double sidesY = Math.abs(y2 - y1) / 2.0;
                        double Axe = Math.max(sidesX, sidesY);
                        BaseGraphic.RealPoints result = this.getCompressedFigure(sidesX, sidesY, slices, sliceAngle, Axe);
                        if (command.nameCommand.equals("B") || command.nameCommand.equals("A")) {
                            double t;
                            BaseGraphic.RealPoint p;
                            priorityCommand = "B";
                            if (command.nameCommand.equals("A")) {
                                points.remove(0);
                            }
                            flag = angle1 < angle2;
                            Collections.reverse(result);
                            cnt = result.size();
                            for (z = 0; z < cnt; ++z) {
                                p = (BaseGraphic.RealPoint)result.get(z);
                                double d = t = z == 0 ? Math.PI * 2 : OdgReader.calcAngle(p.X, p.Y);
                                if (t > angle1) continue;
                                if (!flag && t < angle2) break;
                                points.add(new BaseGraphic.RealPoint(p.X, p.Y));
                            }
                            if (flag) {
                                cnt = result.size();
                                for (v = 0; v < cnt; ++v) {
                                    p = (BaseGraphic.RealPoint)result.get(v);
                                    double d = t = v == 0 ? Math.PI * 2 : OdgReader.calcAngle(p.X, p.Y);
                                    if (!(t < angle2)) {
                                        BaseGraphic.RealPoint rp = new BaseGraphic.RealPoint();
                                        rp.X = p.X;
                                        rp.Y = p.Y;
                                        points.add(rp);
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else {
                            double t;
                            priorityCommand = "W";
                            flag = angle1 > angle2;
                            points.add(new BaseGraphic.RealPoint(startX, startY));
                            cnt = result.size();
                            int last = cnt - 1;
                            for (z = 0; z < cnt; ++z) {
                                BaseGraphic.RealPoint p = (BaseGraphic.RealPoint)result.get(z);
                                double d = t = z == last ? Math.PI * 2 : OdgReader.calcAngle(p.X, p.Y);
                                if (t < angle1) continue;
                                if (!flag && t > angle2) break;
                                points.add(new BaseGraphic.RealPoint(p.X, p.Y));
                            }
                            if (flag) {
                                cnt = result.size();
                                last = cnt - 1;
                                for (v = 0; v < cnt; ++v) {
                                    BaseGraphic.RealPoint p = (BaseGraphic.RealPoint)result.get(v);
                                    double d = t = v == last ? Math.PI * 2 : OdgReader.calcAngle(p.X, p.Y);
                                    if (t > angle2) break;
                                    points.add(new BaseGraphic.RealPoint(p.X, p.Y));
                                }
                            }
                            points.add(new BaseGraphic.RealPoint(endX, endY));
                        }
                        String nameCommandEnd = listOdgCommand.get((int)(i + 1)).nameCommand;
                        if (nameCommandEnd.equals("Z")) {
                            Polygon polygon = (Polygon)this.buildPolyline(points, figure, FigureType.POLYGON, false);
                            polygons.add(polygon);
                            points.clear();
                        }
                        if (!nameCommandEnd.equals("N")) continue block47;
                        Polyline polyline = (Polyline)this.buildPolyline(points, figure, FigureType.POLYLINE, false);
                        polyline.calcOrgAndAjust(Integer.MAX_VALUE, true);
                        block.Objects.add(polyline);
                        points.clear();
                        continue block47;
                    }
                    case "X": {
                        double pointY;
                        double pointX;
                        int lastPoint = points.size();
                        BaseGraphic.RealPoint lastRealPoint = (BaseGraphic.RealPoint)points.get(lastPoint - 1);
                        double x1 = lastRealPoint.X;
                        double y1 = lastRealPoint.Y;
                        double x2 = command.pointTo.getX();
                        double y2 = command.pointTo.getY();
                        centerX = isRepeating ? x2 : x1;
                        centerY = isRepeating ? y1 : y2;
                        boolean bl = isRepeating = !isRepeating;
                        if (!listOdgCommand.get((int)(i + 1)).nameCommand.equals("X")) {
                            isRepeating = false;
                        }
                        double radiusX = Math.abs(x2 - x1);
                        double radiusY = Math.abs(y2 - y1);
                        int startAngle = (int)Math.toDegrees(Math.atan2(y1 - centerY, x1 - centerX));
                        int endAngle = (int)Math.toDegrees(Math.atan2(y2 - centerY, x2 - centerX));
                        if (endAngle < 0) {
                            endAngle += 360;
                        } else if (startAngle + 90 != endAngle) {
                            endAngle = startAngle - 90;
                        }
                        int DOTS = 25;
                        double angleStep = (double)(endAngle - startAngle) / 25.0;
                        for (int j = 1; j <= 25; ++j) {
                            double angle = Math.toRadians((double)startAngle + (double)j * angleStep);
                            pointX = centerX + radiusX * Math.cos(angle);
                            pointY = centerY + radiusY * Math.sin(angle);
                            points.add(new BaseGraphic.RealPoint(pointX, pointY));
                        }
                        points.add(new BaseGraphic.RealPoint(x2, y2));
                        String nameCommandEnd = listOdgCommand.get((int)(i + 1)).nameCommand;
                        if (nameCommandEnd.equals("Z") || nameCommandEnd.equals("F")) {
                            if (priorityCommand == null) {
                                priorityCommand = "L";
                            }
                            Polygon generalPolygon = (Polygon)this.buildPolyline(points, figure, FigureType.POLYGON, false);
                            polygons.add(generalPolygon);
                            points.clear();
                        }
                        if (!nameCommandEnd.equals("N")) continue block47;
                        if (priorityCommand == null) {
                            priorityCommand = "L";
                        }
                        Polyline polyline = (Polyline)this.buildPolyline(points, figure, FigureType.POLYLINE, false);
                        polyline.calcOrgAndAjust(Integer.MAX_VALUE, true);
                        block.Objects.add(polyline);
                        points.clear();
                        continue block47;
                    }
                    case "Y": {
                        double pointY;
                        double pointX;
                        int lastPoint = points.size();
                        BaseGraphic.RealPoint lastRealPoint = (BaseGraphic.RealPoint)points.get(lastPoint - 1);
                        double x1 = lastRealPoint.X;
                        double y1 = lastRealPoint.Y;
                        double x2 = command.pointTo.getX();
                        double y2 = command.pointTo.getY();
                        centerX = isRepeating ? x1 : x2;
                        centerY = isRepeating ? y2 : y1;
                        boolean bl = isRepeating = !isRepeating;
                        if (!listOdgCommand.get((int)(i + 1)).nameCommand.equals("Y")) {
                            isRepeating = false;
                        }
                        double radiusX = Math.abs(x2 - x1);
                        double radiusY = Math.abs(y2 - y1);
                        int startAngle = (int)Math.toDegrees(Math.atan2(y1 - centerY, x1 - centerX));
                        int endAngle = (int)Math.toDegrees(Math.atan2(y2 - centerY, x2 - centerX));
                        if (endAngle < 0) {
                            endAngle += 360;
                        }
                        if (startAngle == 0 && endAngle == 270) {
                            endAngle = -90;
                        }
                        int DOTS = 25;
                        double angleStep = (double)(endAngle - startAngle) / 25.0;
                        for (int j = 0; j <= 25; ++j) {
                            double angle = Math.toRadians((double)startAngle + (double)j * angleStep);
                            pointX = centerX + radiusX * Math.cos(angle);
                            pointY = centerY + radiusY * Math.sin(angle);
                            points.add(new BaseGraphic.RealPoint(pointX, pointY));
                        }
                        String nameCommandEnd = listOdgCommand.get((int)(i + 1)).nameCommand;
                        if (nameCommandEnd.equals("Z") || nameCommandEnd.equals("F")) {
                            if (priorityCommand == null) {
                                priorityCommand = "L";
                            }
                            Polygon polygon = (Polygon)this.buildPolyline(points, figure, FigureType.POLYGON, false);
                            polygons.add(polygon);
                            points.clear();
                        }
                        if (!nameCommandEnd.equals("N")) continue block47;
                        if (priorityCommand == null) {
                            priorityCommand = "L";
                        }
                        Polyline polyline = (Polyline)this.buildPolyline(points, figure, FigureType.POLYLINE, false);
                        polyline.calcOrgAndAjust(Integer.MAX_VALUE, true);
                        block.Objects.add(polyline);
                        points.clear();
                        continue block47;
                    }
                    case "G": {
                        if (priorityCommand == null) {
                            priorityCommand = "L";
                        }
                        int sizePoints = points.size();
                        BaseGraphic.RealPoint lastPoint = (BaseGraphic.RealPoint)points.get(sizePoints - 1);
                        double x1 = lastPoint.X;
                        double y1 = lastPoint.Y;
                        double radiusX = command.angleEllipse.get(0);
                        double radiusY = command.angleEllipse.get(1);
                        int startAngle = command.angleEllipse.get(2);
                        int swingAngle = command.angleEllipse.get(3);
                        int endAngle = startAngle + swingAngle;
                        double dx = radiusX * Math.cos(Math.toRadians(startAngle));
                        double dy = radiusY * Math.sin(Math.toRadians(startAngle));
                        centerX = x1 - dx;
                        centerY = y1 - dy;
                        if (this.comparison(2.0 * radiusX / 100.0, figure.getSvgWidth())) {
                            centerX = radiusX;
                        }
                        if (this.comparison(2.0 * radiusY / 100.0, figure.getSvgHeight())) {
                            centerY = radiusY;
                        }
                        int DOTS = 25;
                        double angleStep = (double)(endAngle - startAngle) / (double)DOTS;
                        for (int j = 1; j <= DOTS; ++j) {
                            double angle = Math.toRadians((double)startAngle + (double)j * angleStep);
                            double pointX = centerX + radiusX * Math.cos(angle);
                            double pointY = centerY + radiusY * Math.sin(angle);
                            points.add(new BaseGraphic.RealPoint(pointX, pointY));
                        }
                        String nameCommandEnd = listOdgCommand.get((int)(i + 1)).nameCommand;
                        if (nameCommandEnd.equals("G") && priorityCommand != null && priorityCommand.equals("Q")) {
                            BaseGraphic.RealPoint point = (BaseGraphic.RealPoint)points.get(points.size() - 1);
                            points.add(point);
                            continue block47;
                        }
                        if (nameCommandEnd.equals("Z") && priorityCommand != null && !priorityCommand.equals("Q")) {
                            Polygon polygon = (Polygon)this.buildPolyline(points, figure, FigureType.POLYGON, false);
                            polygons.add(polygon);
                            points.clear();
                            continue block47;
                        }
                        if (nameCommandEnd.equals("Z") && priorityCommand != null && priorityCommand.equals("Q")) {
                            Region region = (Region)this.buildPolyline(points, figure, FigureType.REGION, false);
                            regions.add(region);
                            points.clear();
                            continue block47;
                        }
                        if (nameCommandEnd.equals("N") || nameCommandEnd.equals("F") || nameCommandEnd.equals("M")) {
                            if (priorityCommand == null) {
                                priorityCommand = "L";
                            }
                            Polyline polyline = (Polyline)this.buildPolyline(points, figure, FigureType.POLYLINE, false);
                            polyline.calcOrgAndAjust(Integer.MAX_VALUE, true);
                            block.Objects.add(polyline);
                            points.clear();
                            continue block47;
                        }
                        if (!nameCommandEnd.equals("Q")) continue block47;
                        for (int j = 0; j < 3; ++j) {
                            points.add((BaseGraphic.RealPoint)points.get(points.size() - 1));
                        }
                        continue block47;
                    }
                    case "N": {
                        assert (priorityCommand != null);
                        if (priorityCommand.equals("U") || priorityCommand.equals("B") || priorityCommand.equals("W") || priorityCommand.equals("DRAWOOO")) {
                            if (polygons.size() > 1) {
                                Polygon generalPolygon = (Polygon)this.summarizePolyline(polygons, figure, FigureType.POLYGON, false);
                                block.Objects.add(generalPolygon);
                            } else {
                                block.Objects.addAll(polygons);
                            }
                            polygons.clear();
                        }
                        if (priorityCommand.equals("F")) {
                            if (pointsLists.size() != 0) {
                                for (List pointArrayList : pointsLists) {
                                    Polyline polyline = (Polyline)this.buildPolyline(pointArrayList, figure, FigureType.POLYLINE, false);
                                    block.Objects.add(polyline);
                                }
                            } else if (regions.size() != 0) {
                                block.Objects.addAll(regions);
                                regions.clear();
                            }
                            pointsLists.clear();
                        }
                        if (priorityCommand.equals("L")) {
                            if (pointsLists.size() != 0) {
                                for (List pointArrayList : pointsLists) {
                                    Polygon polygon = (Polygon)this.buildPolyline(pointArrayList, figure, FigureType.POLYGON, false);
                                    block.Objects.add(polygon);
                                }
                                if (polygons.size() != 0) {
                                    block.Objects.addAll(polygons);
                                }
                                pointsLists.clear();
                            } else if (polygons.size() > 1 && multiplePredominanceZ > 1.0 && isTrajectoriesShaded) {
                                Polygon generalPolygon = (Polygon)this.summarizePolyline(polygons, figure, FigureType.POLYGON, false);
                                block.Objects.add(generalPolygon);
                            } else {
                                block.Objects.addAll(polygons);
                            }
                            polygons.clear();
                        }
                        if (priorityCommand.equals("C") || priorityCommand.equals("W") || priorityCommand.equals("B") || priorityCommand.equals("Q")) {
                            if (regions.size() > 1) {
                                Region generalRegion = (Region)this.summarizePolyline(regions, figure, FigureType.REGION, false);
                                block.Objects.add(generalRegion);
                            } else {
                                block.Objects.addAll(regions);
                            }
                            regions.clear();
                        }
                        priorityCommand = null;
                        continue block47;
                    }
                    case "F": {
                        priorityCommand = command.nameCommand;
                        continue block47;
                    }
                    case "J": 
                    case "I": 
                    case "K": 
                    case "H": {
                        if (priorityCommand != null) continue block47;
                        priorityCommand = "DRAWOOO";
                    }
                }
            }
        }
        block.TransProps = new TransformProps();
        boolean mirrorHorizontal = false;
        boolean mirrorVertical = false;
        if (geometry != null) {
            mirrorHorizontal = geometry.isMirrorHorizontal();
            mirrorVertical = geometry.isMirrorVertical();
            block.TransProps.ScaleX = this.getMirror(mirrorHorizontal);
            block.TransProps.ScaleY = this.getMirror(mirrorVertical);
        }
        block.TransProps.Angle = this.rotateShapes(figure);
        block.TransProps.SkewX = figure.getSkewX();
        block.TransProps.SkewY = figure.getSkewY();
        boolean bl = transform = !SchemeUtils.isEqual(block.TransProps.Angle, 0.0) || !SchemeUtils.isEqual(block.TransProps.SkewX, 0.0) || !SchemeUtils.isEqual(block.TransProps.SkewY, 0.0);
        if (block.Objects.size() > 1) {
            block.LayerID = block.Objects.get((int)0).LayerID;
            block.calcOrgAndAjust(Integer.MAX_VALUE, true);
            this.calcPosition(block, figure, true, mirrorVertical != mirrorHorizontal);
            polygons.clear();
            return block;
        }
        BaseGraphic graphic = block.Objects.get(0);
        if (transform || mirrorHorizontal || mirrorVertical) {
            if (graphic.TransProps == null) {
                graphic.TransProps = new TransformProps();
            }
            graphic.TransProps.Angle = block.TransProps.Angle;
            graphic.TransProps.SkewX = block.TransProps.SkewX;
            graphic.TransProps.SkewY = block.TransProps.SkewY;
            graphic.TransProps.ScaleX = block.TransProps.ScaleX;
            graphic.TransProps.ScaleY = block.TransProps.ScaleY;
        }
        if (!isDisplaced) {
            graphic.calcOrgAndAjust(Integer.MAX_VALUE, true);
        }
        this.calcPosition(graphic, figure, !isDisplaced, mirrorVertical != mirrorHorizontal);
        return graphic;
    }

    private BaseGraphic readSvgShape(OdgGraphicObject svgObj) {
        boolean transform;
        List<OdgEnhancedGeometry.OdgCommand> listOdgCommand = svgObj.getListOdgCommand();
        if (listOdgCommand == null) {
            return null;
        }
        ArrayList<BaseGraphic.RealPoint> points = new ArrayList<BaseGraphic.RealPoint>();
        ArrayList<Region> regions = new ArrayList<Region>();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        GraphicBlock block = new GraphicBlock();
        block.SourceID = Core.generateId();
        block.GluePoints = new ArrayList();
        block.Objects = new ArrayList();
        block.ID = Core.generateId();
        block.setEngine(this.engine);
        String priorityCommand = "L";
        OdgFigure figure = null;
        boolean isPainted = false;
        boolean isConnector = svgObj instanceof OdgConnector;
        if (!isConnector) {
            figure = (OdgFigure)svgObj;
            this.setScale(figure);
        }
        int cnt = listOdgCommand.size();
        block31: for (int i = 0; i < cnt; ++i) {
            OdgEnhancedGeometry.OdgCommand command = listOdgCommand.get(i);
            switch (command.nameCommand) {
                case "M": {
                    Spline spline;
                    Polyline polyline;
                    if (i != 0 && !listOdgCommand.get((int)(i - 1)).nameCommand.equals("Z")) {
                        switch (priorityCommand) {
                            case "L": {
                                polyline = (Polyline)this.buildPolyline(points, (OdgFigure)svgObj, FigureType.POLYLINE, false);
                                block.Objects.add(polyline);
                                break;
                            }
                            case "C": {
                                spline = (Spline)this.buildPolyline(points, (OdgFigure)svgObj, FigureType.SPLINE, false);
                                block.Objects.add(spline);
                                break;
                            }
                        }
                        points.clear();
                    }
                    points.add(command.pointTo.asRealPoint());
                    continue block31;
                }
                case "L": 
                case "H": 
                case "V": {
                    Spline spline;
                    Polyline polyline;
                    for (int j = 0; j < 3; ++j) {
                        points.add(command.pointTo.asRealPoint());
                        if (isConnector) break;
                    }
                    if (isConnector || i + 1 != listOdgCommand.size()) continue block31;
                    switch (priorityCommand) {
                        case "L": {
                            polyline = (Polyline)this.buildPolyline(points, (OdgFigure)svgObj, FigureType.POLYLINE, false);
                            block.Objects.add(polyline);
                            continue block31;
                        }
                        case "C": {
                            spline = (Spline)this.buildPolyline(points, (OdgFigure)svgObj, FigureType.SPLINE, false);
                            block.Objects.add(spline);
                            continue block31;
                        }
                    }
                    continue block31;
                }
                case "C": 
                case "S": {
                    priorityCommand = "C";
                    points.add(command.pointTo.asRealPoint());
                    continue block31;
                }
                case "Z": {
                    isPainted = true;
                    assert (svgObj instanceof OdgFigure);
                    if ("C".equals(priorityCommand)) {
                        points.add((BaseGraphic.RealPoint)points.get(points.size() - 1));
                        points.add((BaseGraphic.RealPoint)points.get(0));
                        Region region = (Region)this.buildPolyline(points, (OdgFigure)svgObj, FigureType.REGION, false);
                        regions.add(region);
                    } else {
                        Polygon polygon = (Polygon)this.buildPolyline(points, (OdgFigure)svgObj, FigureType.POLYGON, false);
                        polygons.add(polygon);
                    }
                    points.clear();
                }
            }
        }
        if (isConnector) {
            OdgConnector connector = (OdgConnector)svgObj;
            if (priorityCommand.equals("L")) {
                return this.buildPolyline(points, connector, FigureType.POLYLINE);
            }
            return this.buildPolyline(points, connector, FigureType.SPLINE);
        }
        OdgFigure figureObj = (OdgFigure)svgObj;
        if (!isPainted && priorityCommand.equals("C")) {
            Spline spline = (Spline)this.buildPolyline(points, figureObj, FigureType.SPLINE, false);
            block.Objects.add(spline);
        }
        if (regions.size() > 0) {
            Region generalRegion = (Region)this.summarizePolyline(regions, figure, FigureType.REGION, false);
            block.Objects.add(generalRegion);
        }
        if (polygons.size() > 0) {
            Polygon generalPolygon = (Polygon)this.summarizePolyline(polygons, figure, FigureType.POLYGON, false);
            block.Objects.add(generalPolygon);
        }
        block.TransProps = new TransformProps();
        boolean mirrorHorizontal = false;
        boolean mirrorVertical = false;
        OdgEnhancedGeometry geometry = figure.getGeometry();
        if (geometry != null) {
            mirrorHorizontal = geometry.isMirrorHorizontal();
            mirrorVertical = geometry.isMirrorVertical();
            block.TransProps.ScaleX = this.getMirror(mirrorHorizontal);
            block.TransProps.ScaleY = this.getMirror(mirrorVertical);
        }
        block.TransProps.Angle = this.rotateShapes(figure);
        block.TransProps.SkewX = figure.getSkewX();
        block.TransProps.SkewY = figure.getSkewY();
        boolean bl = transform = !SchemeUtils.isEqual(block.TransProps.Angle, 0.0) || !SchemeUtils.isEqual(block.TransProps.SkewX, 0.0) || !SchemeUtils.isEqual(block.TransProps.SkewY, 0.0);
        if (block.Objects.size() > 1) {
            block.LayerID = block.Objects.get((int)0).LayerID;
            return block;
        }
        BaseGraphic graphic = block.Objects.get(0);
        if (transform || mirrorHorizontal || mirrorVertical) {
            if (graphic.TransProps == null) {
                graphic.TransProps = new TransformProps();
            }
            graphic.TransProps.Angle = block.TransProps.Angle;
            graphic.TransProps.SkewX = block.TransProps.SkewX;
            graphic.TransProps.SkewY = block.TransProps.SkewY;
            graphic.TransProps.ScaleX = block.TransProps.ScaleX;
            graphic.TransProps.ScaleY = block.TransProps.ScaleY;
        }
        return graphic;
    }

    private BaseGraphic buildTable(OdgFrame figure) {
        OdgTable nativeTable = figure.getTable();
        Table table = new Table();
        table.SideX = figure.getSvgWidth();
        table.SideY = figure.getSvgHeight();
        table.ID = Core.generateId();
        table.TransProps = new TransformProps();
        table.Objects = new ArrayList();
        this.setLayerId(table, figure);
        HashMap<String, OdgStyleStyle> styles = nativeTable.getTemplateStyleList();
        List<OdgTable.OdgTableRow> rows = nativeTable.getRowList();
        List<OdgTable.OdgTableColumn> columns = nativeTable.getColumnList();
        for (OdgTable.OdgTableColumn column : columns) {
            OdgStyleStyle columnStyle = column.style;
            OdgProperties properties = columnStyle.getStyleProperty();
            String columnWidth = properties.getStyles("style:column-width");
            String optimalColumnWidth = properties.getStyles("style:use-optimal-column-width");
            double width = OdgUtils.asBoolean(optimalColumnWidth) ? 28.2 : OdgUtils.asMillimeters(OdgUtils.asDouble(columnWidth));
            table.widths.add(width);
        }
        int cnti = rows.size();
        for (int i = 0; i < cnti; ++i) {
            String foBorder;
            OdgTable.OdgTableRow row = rows.get(i);
            OdgStyleStyle rowStyle = row.style;
            OdgStyleStyle rowDefaultStyle = row.defaultStyle;
            OdgProperties styleProperty = rowStyle.getStyleProperty();
            OdgProperties defaultStyleProperty = null;
            if (rowDefaultStyle != null && (foBorder = (defaultStyleProperty = rowDefaultStyle.getStyleProperty()).getStyles("fo:border")) != null) {
                String[] attr = foBorder.split(" ");
                table.lWidth = OdgUtils.asDouble(attr[0]);
                table.PenPattern = OdgUtils.asInteger(attr[1]);
                table.pColor = OdgUtils.asColor(attr[2]);
            }
            String rowHeight = styleProperty.getStyles("style:row-height");
            String optimalRowHeight = styleProperty.getStyles("style:use-optimal-row-height");
            double height = OdgUtils.asBoolean(optimalRowHeight) ? 9.6 : OdgUtils.asMillimeters(OdgUtils.asDouble(rowHeight));
            table.row = new ArrayList();
            int cntj = row.tableCells.size();
            for (int j = 0; j < cntj; ++j) {
                Color color;
                String defaultDrawFill;
                TableCell tableCell = new TableCell();
                tableCell.SideX = table.widths.get(j);
                tableCell.SideY = height;
                tableCell.ID = Core.generateId();
                tableCell.VertAlign = 0;
                tableCell.Align = 0;
                tableCell.Lines = new Paragraph.Lines();
                tableCell.pColor = table.pColor;
                tableCell.PenPattern = table.PenPattern;
                tableCell.lWidth = table.lWidth;
                if (!nativeTable.isDefaultTemplate() && styles != null) {
                    this.paintDesign(i, j, styles, nativeTable, tableCell);
                }
                Color colorTemplate = tableCell.bColor;
                if (defaultStyleProperty != null && !Objects.equals(defaultDrawFill = defaultStyleProperty.getStyles("draw:fill"), "none") && (color = OdgUtils.asColor(defaultStyleProperty.getStyles("draw:fill-color"))) != null) {
                    tableCell.bColor = color;
                }
                OdgTable.OdgTableCell cell = row.tableCells.get(j);
                tableCell.colSpan = cell.tableNumberColumnsSpanned;
                tableCell.rowSpan = cell.tableNumberRowsSpanned;
                OdgStyleStyle cellStyle = cell.style;
                if (cellStyle != null) {
                    String foBorder2;
                    OdgProperties cellProp;
                    tableCell.bColor = colorTemplate;
                    if (cellStyle.hasGraphic()) {
                        cellProp = cellStyle.getStyleProperty();
                        tableCell.VertAlign = OdgUtils.asInteger(cellProp.getStyles("draw:textarea-vertical-align"));
                        String drawFill = cellProp.getStyles("draw:fill");
                        Color color2 = tableCell.bColor = Objects.equals(drawFill, "none") ? null : OdgUtils.asColor(cellProp.getStyles("draw:fill-color"));
                    }
                    if (cellStyle.hasParagraph() && (foBorder2 = (cellProp = cellStyle.getStyleProperty()).getStyles("fo:border")) != null) {
                        String[] attr = foBorder2.split(" ");
                        table.lWidth = OdgUtils.asDouble(attr[0]);
                        table.PenPattern = OdgUtils.asInteger(attr[1]);
                        table.pColor = OdgUtils.asColor(attr[2]);
                    }
                }
                OdgText text = cell.text;
                List<OdgText.OdgPartText> partsText = text.getPartTexts();
                RectTextLine rtl = new RectTextLine();
                String curLine = "";
                for (OdgText.OdgPartText partText : partsText) {
                    OdgStyleStyle textPStyle;
                    RectTextLine.PartTextLine ptl = RectTextLine.PartTextLine.getDefaultPart();
                    ptl.fontName = DEFAULT_FONT_NAME;
                    OdgStyleStyle partTextStyle = partText.textSpanStyle;
                    if (partTextStyle != null) {
                        OdgProperties partProperties = partTextStyle.getStyleProperty();
                        ptl.fontName = partProperties.getStyles("style:font-name");
                        ptl.fontColor = OdgUtils.asColor(partProperties.getStyles("fo:color"));
                        ptl.fontBgColor = OdgUtils.asColor(partProperties.getStyles("fo:background-color"));
                        ptl.fontStyle = OdgUtils.asByte(partProperties.getStyles("fo:font-style"));
                        ptl.fontHeight = OdgUtils.asDouble(partProperties.getStyles("fo:font-size"));
                        ptl.ssScript = OdgUtils.asByte(partProperties.getStyles("style:text-position"));
                    }
                    if ((textPStyle = partText.textPStyle) != null && textPStyle.hasParagraph()) {
                        OdgProperties styleProperties = textPStyle.getStyleProperty();
                        rtl.paragraphLine = new RectTextLine.ParagraphLine();
                        rtl.paragraphLine.leftIndent = OdgUtils.asDouble(styleProperties.getStyles("fo:margin-left"));
                        rtl.paragraphLine.rightIndent = OdgUtils.asDouble(styleProperties.getStyles("fo:margin-right"));
                        rtl.paragraphLine.firstIndent = OdgUtils.asDouble(styleProperties.getStyles("fo:text-indent"));
                        rtl.paragraphLine.spaceBefore = OdgUtils.asDouble(styleProperties.getStyles("fo:margin-top"));
                        rtl.paragraphLine.spaceAfter = OdgUtils.asDouble(styleProperties.getStyles("fo:margin-bottom"));
                        rtl.paragraphLine.lineSpacing = OdgUtils.asDouble(styleProperties.getStyles("fo:line-height"));
                        rtl.paragraphLine.align = OdgUtils.asByte(styleProperties.getStyles("fo:text-align"));
                    }
                    ptl.text = partText.text;
                    curLine = curLine.concat(partText.text);
                    rtl.Parts.add(ptl);
                    if (partsText.size() == 1) {
                        rtl.FontName = ptl.fontName;
                        rtl.FontColor = ptl.fontColor;
                        rtl.FontStyle = ptl.fontStyle;
                    }
                    if (!partText.newLine) continue;
                    rtl.Text = curLine;
                    tableCell.Lines.add(rtl);
                    rtl = new RectTextLine();
                    curLine = "";
                }
                table.row.add(tableCell);
                if (cell.isCoveredCell) continue;
                table.Objects.add(tableCell);
            }
            table.heights.add(height);
            table.rows.add(table.row);
        }
        table.row = null;
        this.checkPosition(table, figure);
        return table;
    }

    private void paintDesign(int i, int j, HashMap<String, OdgStyleStyle> styleMap, OdgTable table, TableCell tableCell) {
        OdgTable.TableStyle tableStyle = table.getTableStyle();
        OdgStyleStyle style = styleMap.get("table:body");
        if (i % 2 != 0 && tableStyle.useBandingRows) {
            style = styleMap.get("table:odd-rows");
        }
        if (j % 2 != 0 && tableStyle.useBandingColumns) {
            style = styleMap.get("table:odd-columns");
        }
        if (i + 1 == table.getRowSize() && tableStyle.useLastRow) {
            style = styleMap.get("table:last-row");
        }
        if (j + 1 == table.getColumnSize() && tableStyle.useLastColumn) {
            style = styleMap.get("table:last-column");
        }
        if (i == 0 && tableStyle.useFirstRow) {
            style = styleMap.get("table:first-row");
        }
        if (j == 0 && tableStyle.useFirstColumn) {
            style = styleMap.get("table:first-column");
        }
        OdgProperties properties = style.getStyleProperty();
        tableCell.bColor = OdgUtils.asColor(properties.getStyles("draw:fill-color"));
    }

    private BaseGraphic buildRectangle(OdgFigure figure, FigureType figureType) {
        Rectangle rectangle = this.detectionRectangleByType(figureType);
        assert (rectangle != null);
        rectangle.SideX = figure.getSvgWidth();
        rectangle.SideY = figure.getSvgHeight();
        OdgProperties properties = figure.getStyle().getStyleProperty();
        rectangle.bColor = OdgUtils.asColor(properties.getStyles("draw:fill-color"));
        rectangle.pColor = OdgUtils.asColor(properties.getStyles("svg:stroke-color"));
        rectangle.lWidth = OdgUtils.asDouble(properties.getStyles("svg:stroke-width"));
        rectangle.LineCap = OdgUtils.asInteger(properties.getStyles("svg:stroke-linecap"));
        (rectangle.StringProps = new TextProps()).Caption = figure.hasGeometry() ? figure.getDrawName() : "";
        rectangle.Transparent = properties.getStyles("draw:fill").equals("none") ? 255 : OdgUtils.asInteger(properties.getStyles("draw:opacity"));
        rectangle.TransparentBorder = OdgUtils.asInteger(properties.getStyles("svg:stroke-opacity"));
        rectangle.PenPattern = OdgUtils.asInteger(properties.getStyles("draw:stroke"));
        rectangle.TransProps = new TransformProps();
        rectangle.TransProps.Angle = figure.getRotateAngle();
        this.checkPosition(rectangle, figure);
        rectangle.TransProps.SkewX = figure.getSkewX();
        rectangle.TransProps.SkewY = figure.getSkewY();
        rectangle.ID = Core.generateId();
        this.setLayerId(rectangle, figure);
        boolean mirrorHorizontal = false;
        boolean mirrorVertical = false;
        if (figure.getGeometry() != null) {
            OdgEnhancedGeometry geometry = figure.getGeometry();
            mirrorHorizontal = geometry.isMirrorHorizontal();
            mirrorVertical = geometry.isMirrorVertical();
            rectangle.TransProps.ScaleX = this.getMirror(mirrorHorizontal);
            rectangle.TransProps.ScaleY = this.getMirror(mirrorVertical);
        }
        if (properties.getStyles("draw:fill-gradient-name") != null) {
            String gradientName = properties.getStyles("draw:fill-gradient-name");
            OdgOfficeStyles.OdgGradient gradient = OdgOfficeStyles.getGradient(gradientName);
            rectangle.bColor = gradient.drawEndColor;
            rectangle.BkColor = gradient.drawStartColor;
            rectangle.BrushPattern = this.getGradientDirectionNum(gradient.drawStyle, gradient.drawAngle);
        }
        if (rectangle instanceof Paragraph) {
            this.assignText((Paragraph)rectangle, figure, null);
        }
        if (rectangle instanceof PhxImage) {
            OdgImage image = ((OdgFrame)figure).getImage();
            PhxImage phxImage = this.convertBitmap(image, (PhxImage)rectangle);
            if (phxImage == null) {
                return null;
            }
            OdgStyleStyle style = figure.getStyle();
            if (style != null && style.hasGraphic()) {
                OdgProperties graphicsProperties = style.getStyleProperty();
                phxImage.Transparent = OdgUtils.asInteger(graphicsProperties.getStyles("draw:image-opacity"));
                String foClip = graphicsProperties.getStyles("fo:clip");
                if (foClip != null) {
                    this.parseCrop(phxImage, foClip);
                }
            }
        }
        if (mirrorVertical != mirrorHorizontal && !SchemeUtils.isEqual(rectangle.TransProps.Angle, 0.0)) {
            rectangle.TransProps.Angle = 360.0 - rectangle.TransProps.Angle;
        }
        return rectangle;
    }

    public void parseCrop(PhxImage image, String foClip) {
        Pattern pattern = Pattern.compile("\\d+\\.?\\d*");
        Matcher matcher = pattern.matcher(foClip);
        int NUMBERS_COUNT = 4;
        double[] cropValues = new double[4];
        int index = 0;
        while (matcher.find()) {
            assert (index < 4);
            cropValues[index++] = OdgUtils.asMillimeters(OdgUtils.asDouble(matcher.group()));
        }
        double PX_TO_MM = Toolkit.getDefaultToolkit().getScreenResolution();
        double width = (double)image.BmpWidth / PX_TO_MM * 25.4;
        double height = (double)image.BmpHeight / PX_TO_MM * 25.4;
        image.TopCropPercentage = cropValues[0] / height;
        image.RightCropPercentage = cropValues[1] / width;
        image.BottomCropPercentage = cropValues[2] / height;
        image.LeftCropPercentage = cropValues[3] / width;
    }

    private void checkPosition(BaseGraphic bg, OdgFigure figure) {
        if (SchemeUtils.isEqual(bg.TransProps.Angle, 0.0)) {
            bg.OrgX = figure.getSvgX() + figure.getSvgWidth() / 2.0;
            bg.OrgY = figure.getSvgY() + figure.getSvgHeight() / 2.0;
        } else {
            BaseGraphic.RealPoint p = SchemeUtils.rotatePoint(figure.getSvgWidth() / 2.0, figure.getSvgHeight() / 2.0, bg.TransProps.Angle);
            bg.OrgX = figure.getSvgX() + p.X;
            bg.OrgY = figure.getSvgY() + p.Y;
        }
    }

    private BaseGraphic buildPolyline(OdgLine line, FigureType figureType) {
        Polyline polyline = null;
        switch (figureType) {
            case POLYLINE: {
                polyline = new Polyline();
                break;
            }
            case SPLINE: {
                polyline = new Spline();
                break;
            }
        }
        assert (polyline != null);
        polyline.Points = new double[]{line.getSvgX1(), line.getSvgY1(), line.getSvgX2(), line.getSvgY2()};
        OdgProperties properties = line.getStyle().getStyleProperty();
        polyline.bColor = OdgUtils.asColor(properties.getStyles("draw:fill-color"));
        polyline.pColor = OdgUtils.asColor(properties.getStyles("svg:stroke-color"));
        polyline.lWidth = OdgUtils.asDouble(properties.getStyles("svg:stroke-width"));
        polyline.LineCap = OdgUtils.asInteger(properties.getStyles("svg:stroke-linecap"));
        polyline.Transparent = properties.getStyles("draw:fill").equals("none") ? 255 : OdgUtils.asInteger(properties.getStyles("draw:opacity"));
        polyline.TransparentBorder = OdgUtils.asInteger(properties.getStyles("svg:stroke-opacity"));
        polyline.PenPattern = OdgUtils.asInteger(properties.getStyles("draw:stroke"));
        polyline.StartVisArrowType = OdgUtils.asInteger(properties.getStyles("draw:marker-start"));
        polyline.StartVisArrowSize = OdgUtils.asDouble(properties.getStyles("draw:marker-start-width"));
        polyline.EndVisArrowType = OdgUtils.asInteger(properties.getStyles("draw:marker-end"));
        polyline.EndVisArrowSize = OdgUtils.asDouble(properties.getStyles("draw:marker-end-width"));
        polyline.ID = Core.generateId();
        this.setLayerId(polyline, line);
        polyline.calcOrgAndAjust(Integer.MAX_VALUE, true);
        if (properties.getStyles("draw:fill-gradient-name") != null) {
            String gradientName = properties.getStyles("draw:fill-gradient-name");
            OdgOfficeStyles.OdgGradient gradient = OdgOfficeStyles.getGradient(gradientName);
            polyline.bColor = gradient.drawEndColor;
            polyline.BkColor = gradient.drawStartColor;
            polyline.BrushPattern = this.getGradientDirectionNum(gradient.drawStyle, gradient.drawAngle);
        }
        return polyline;
    }

    private BaseGraphic buildPolyline(List<BaseGraphic.RealPoint> realPoints, OdgFigure figure, FigureType figureType) {
        return this.buildPolyline(realPoints, figure, figureType, true);
    }

    private BaseGraphic buildPolyline(List<BaseGraphic.RealPoint> realPoints, OdgFigure figure, FigureType figureType, boolean transform) {
        int amount = realPoints.size();
        Polyline polyline = this.detectionPolylineByType(figureType);
        assert (polyline != null);
        polyline.Points = new double[amount * 2];
        if (polyline instanceof Polygon) {
            ((Polygon)polyline).Counts = new int[]{amount};
        } else if (polyline instanceof Region) {
            ((Region)polyline).Counts = new int[]{amount + 1};
            polyline.Points = new double[amount * 2 + 2];
            polyline.Points[amount * 2] = realPoints.get((int)0).X * this.scaleX;
            polyline.Points[amount * 2 + 1] = realPoints.get((int)0).Y * this.scaleY;
        }
        for (int i = 0; i < amount; ++i) {
            if (figure instanceof OdgEllipse) {
                polyline.Points[i * 2] = realPoints.get((int)i).X;
                polyline.Points[i * 2 + 1] = realPoints.get((int)i).Y;
                continue;
            }
            polyline.Points[i * 2] = realPoints.get((int)i).X * this.scaleX;
            polyline.Points[i * 2 + 1] = realPoints.get((int)i).Y * this.scaleY;
        }
        if (transform) {
            polyline.TransProps = new TransformProps();
            if (figure.getGeometry() != null) {
                OdgEnhancedGeometry geometry = figure.getGeometry();
                polyline.TransProps.ScaleX = this.getMirror(geometry.isMirrorHorizontal());
                polyline.TransProps.ScaleY = this.getMirror(geometry.isMirrorVertical());
            }
            polyline.TransProps.Angle = this.rotateShapes(figure);
            polyline.TransProps.SkewX = figure.getSkewX();
            polyline.TransProps.SkewY = figure.getSkewY();
        }
        polyline.LineCap = 1;
        (polyline.StringProps = new TextProps()).Caption = figure.hasGeometry() ? figure.getDrawName() : "";
        OdgProperties properties = figure.getStyle().getStyleProperty();
        polyline.bColor = OdgUtils.asColor(properties.getStyles("draw:fill-color"));
        polyline.pColor = OdgUtils.asColor(properties.getStyles("svg:stroke-color"));
        polyline.lWidth = OdgUtils.asDouble(properties.getStyles("svg:stroke-width"));
        polyline.LineCap = OdgUtils.asInteger(properties.getStyles("svg:stroke-linecap"));
        polyline.Transparent = properties.getStyles("draw:fill").equals("none") ? 255 : OdgUtils.asInteger(properties.getStyles("draw:opacity"));
        polyline.TransparentBorder = OdgUtils.asInteger(properties.getStyles("svg:stroke-opacity"));
        polyline.PenPattern = OdgUtils.asInteger(properties.getStyles("draw:stroke"));
        polyline.StartVisArrowType = OdgUtils.asInteger(properties.getStyles("draw:marker-start"));
        polyline.StartVisArrowSize = OdgUtils.asDouble(properties.getStyles("draw:marker-start-width"));
        polyline.EndVisArrowType = OdgUtils.asInteger(properties.getStyles("draw:marker-end"));
        polyline.EndVisArrowSize = OdgUtils.asDouble(properties.getStyles("draw:marker-end-width"));
        polyline.ID = Core.generateId();
        this.setLayerId(polyline, figure);
        if (properties.getStyles("draw:fill-gradient-name") != null) {
            String gradientName = properties.getStyles("draw:fill-gradient-name");
            OdgOfficeStyles.OdgGradient gradient = OdgOfficeStyles.getGradient(gradientName);
            polyline.bColor = gradient.drawEndColor;
            polyline.BkColor = gradient.drawStartColor;
            polyline.BrushPattern = this.getGradientDirectionNum(gradient.drawStyle, gradient.drawAngle);
        }
        return polyline;
    }

    private BaseGraphic buildPolyline(List<BaseGraphic.RealPoint> points, OdgConnector connector, FigureType figureType) {
        BaseGraphic graphic = this.buildPolyline(connector, figureType);
        Polyline polyline = (Polyline)graphic;
        polyline.Points = new double[points.size() * 2];
        if (FigureType.POLYLINE.equals((Object)figureType)) {
            polyline.ConnectorView = polyline.Points.length == 4 ? 1 : 2;
        }
        for (int i = 0; i < points.size(); ++i) {
            polyline.Points[i * 2] = points.get((int)i).X * this.scaleX;
            polyline.Points[i * 2 + 1] = points.get((int)i).Y * this.scaleY;
        }
        polyline.calcOrgAndAjust(Integer.MAX_VALUE, true);
        return polyline;
    }

    private BaseGraphic summarizePolyline(List<? extends Polyline> polylines, OdgFigure figure, FigureType figureType, boolean transform) {
        Polyline polyline = this.detectionPolylineByType(figureType);
        assert (polyline != null);
        int[] counts = new int[polylines.size()];
        double[] generalMassive = new double[]{};
        for (int j = 0; j < polylines.size(); ++j) {
            counts[j] = polyline instanceof Region ? ((Region)polylines.get((int)j)).Counts[0] : ((Polygon)polylines.get((int)j)).Counts[0];
            generalMassive = DoubleStream.concat(Arrays.stream(generalMassive), Arrays.stream(polylines.get((int)j).Points)).toArray();
        }
        if (polyline instanceof Region) {
            ((Region)polyline).Counts = counts;
        } else {
            ((Polygon)polyline).Counts = counts;
        }
        polyline.Points = (double[])generalMassive.clone();
        if (transform) {
            polyline.TransProps = new TransformProps();
            if (figure.getGeometry() != null) {
                OdgEnhancedGeometry geometry = figure.getGeometry();
                polyline.TransProps.ScaleX = this.getMirror(geometry.isMirrorHorizontal());
                polyline.TransProps.ScaleY = this.getMirror(geometry.isMirrorVertical());
            }
            polyline.TransProps.Angle = this.rotateShapes(figure);
            polyline.TransProps.SkewX = figure.getSkewX();
            polyline.TransProps.SkewY = figure.getSkewY();
        }
        (polyline.StringProps = new TextProps()).Caption = figure.hasGeometry() ? figure.getDrawName() : "";
        OdgProperties properties = figure.getStyle().getStyleProperty();
        polyline.bColor = OdgUtils.asColor(properties.getStyles("draw:fill-color"));
        polyline.pColor = OdgUtils.asColor(properties.getStyles("svg:stroke-color"));
        polyline.lWidth = OdgUtils.asDouble(properties.getStyles("svg:stroke-width"));
        polyline.LineCap = OdgUtils.asInteger(properties.getStyles("svg:stroke-linecap"));
        polyline.Transparent = properties.getStyles("draw:fill").equals("none") ? 255 : OdgUtils.asInteger(properties.getStyles("draw:opacity"));
        polyline.TransparentBorder = OdgUtils.asInteger(properties.getStyles("svg:stroke-opacity"));
        polyline.PenPattern = OdgUtils.asInteger(properties.getStyles("draw:stroke"));
        polyline.ID = Core.generateId();
        this.setLayerId(polyline, figure);
        if (properties.getStyles("draw:fill-gradient-name") != null) {
            String gradientName = properties.getStyles("draw:fill-gradient-name");
            OdgOfficeStyles.OdgGradient gradient = OdgOfficeStyles.getGradient(gradientName);
            polyline.bColor = gradient.drawEndColor;
            polyline.BkColor = gradient.drawStartColor;
            polyline.BrushPattern = this.getGradientDirectionNum(gradient.drawStyle, gradient.drawAngle);
        }
        return polyline;
    }

    private void setLayerId(BaseGraphic bg, OdgGraphicObject obj) {
        if (this.layerByName == null) {
            bg.LayerID = 0.0;
        } else {
            PhxLayer layer = this.layerByName.get(obj.getDrawLayer());
            if (layer != null) {
                bg.LayerID = layer.ID;
                this.hasGraphicsByLayer.put(layer, true);
            } else {
                bg.LayerID = 0.0;
            }
        }
    }

    private Polyline detectionPolylineByType(FigureType type) {
        switch (type) {
            case POLYGON: {
                return new Polygon();
            }
            case POLYLINE: {
                return new Polyline();
            }
            case SPLINE: {
                return new Spline();
            }
            case REGION: {
                return new Region();
            }
        }
        return null;
    }

    private Rectangle detectionRectangleByType(FigureType type) {
        switch (type) {
            case PARAGRAPH: {
                return new Paragraph();
            }
            case ELLIPSE: {
                return new Ellipse();
            }
            case RECTANGLE: {
                return new Rectangle();
            }
            case IMAGE: {
                return new PhxImage();
            }
        }
        return null;
    }

    private static double calcAngle(double dx, double dy) {
        if (dx == 0.0) {
            return 1.5707963267948966 + (dy > 0.0 ? 0.0 : Math.PI);
        }
        double result = Math.atan(dy / dx);
        if (dx < 0.0) {
            result += Math.PI;
        } else if (dy < 0.0 && result < 0.0) {
            result = Math.PI * 2 + result;
        }
        return result;
    }

    private int getMirror(boolean mirror) {
        return mirror ? -1 : 1;
    }

    private double rotateShapes(OdgFigure figure) {
        double rotateAngle = figure.getRotateAngle();
        return SchemeUtils.isEqual(rotateAngle, 0.0) ? 0.0 : rotateAngle;
    }

    private BaseGraphic.RealPoints getCompressedFigure(double sidesX, double sidesY, double slices, double sliceAngle, double Axe) {
        BaseGraphic.RealPoints result = new BaseGraphic.RealPoints();
        if (sidesX > BaseGraphic.FloatTolerance && sidesY > BaseGraphic.FloatTolerance) {
            double lDx;
            double lDy;
            if (sidesX > sidesY) {
                lDy = sidesY / sidesX;
                lDx = 1.0;
            } else {
                lDx = sidesX / sidesY;
                lDy = 1.0;
            }
            int j = 0;
            while ((double)j < slices) {
                double x = Axe * Math.cos(sliceAngle * (double)j);
                double y = Axe * Math.sin(sliceAngle * (double)j);
                result.add(new BaseGraphic.RealPoint(x * lDx, y * lDy));
                ++j;
            }
        } else {
            int j = 0;
            while ((double)j < slices) {
                double x = 0.0;
                double y = 0.0;
                if (sidesY > BaseGraphic.FloatTolerance) {
                    x = 0.0;
                    y = (double)j == slices - 1.0 ? sidesY : -sidesY + (double)(j * 2) * sidesY / slices;
                } else if (sidesX > BaseGraphic.FloatTolerance) {
                    x = (double)j == slices - 1.0 ? sidesX : -sidesX + (double)(j * 2) * sidesX / slices;
                    y = 0.0;
                }
                result.add(new BaseGraphic.RealPoint(x, y));
                ++j;
            }
        }
        return result;
    }

    private List<BaseGraphic.RealPoint> getCircumference(double angle1, double angle2, BaseGraphic.RealPoints result) {
        double t;
        ArrayList<BaseGraphic.RealPoint> realPoints = new ArrayList<BaseGraphic.RealPoint>();
        if (angle1 < angle2) {
            Collections.reverse(result);
            for (BaseGraphic.RealPoint p : result) {
                t = Math.PI * 2 - OdgReader.calcAngle(p.X, p.Y);
                if (t < angle1) continue;
                if (t > angle2) break;
                realPoints.add(new BaseGraphic.RealPoint(p.X, p.Y));
            }
        }
        if (angle1 > angle2) {
            for (BaseGraphic.RealPoint p : result) {
                t = Math.PI * 2 - OdgReader.calcAngle(p.X, p.Y);
                if (!(t > angle1)) break;
                realPoints.add(new BaseGraphic.RealPoint(p.X, p.Y));
            }
            Collections.reverse(realPoints);
            Collections.reverse(result);
            for (BaseGraphic.RealPoint p : result) {
                t = Math.PI * 2 - OdgReader.calcAngle(p.X, p.Y);
                if (t > angle2) break;
                realPoints.add(new BaseGraphic.RealPoint(p.X, p.Y));
            }
        }
        return realPoints;
    }

    private int getGradientDirectionNum(String style, double angle) {
        if (style.equals("radial")) {
            return 10019;
        }
        boolean isAxial = style.equals("axial");
        if (angle >= 0.0 && angle < 45.0 || angle == 360.0) {
            return isAxial ? 10014 : 10004;
        }
        if (angle >= 45.0 && angle < 90.0) {
            return isAxial ? 10018 : 10007;
        }
        if (angle >= 90.0 && angle < 135.0) {
            return isAxial ? 10012 : 10002;
        }
        if (angle >= 135.0 && angle < 180.0) {
            return isAxial ? 10016 : 10005;
        }
        if (angle >= 180.0 && angle < 225.0) {
            return isAxial ? 10014 : 10003;
        }
        if (angle >= 225.0 && angle < 270.0) {
            return isAxial ? 10018 : 10006;
        }
        if (angle >= 270.0 && angle < 315.0) {
            return isAxial ? 10012 : 10001;
        }
        if (angle >= 315.0 && angle < 360.0) {
            return isAxial ? 10016 : 10008;
        }
        return 0;
    }

    private void calcPosition(BaseGraphic graphic, OdgFigure figure, boolean calcCenter, boolean mirrorAngle) {
        double w2 = figure.getSvgWidth() / 2.0;
        double h2 = figure.getSvgHeight() / 2.0;
        if (calcCenter) {
            double cX = graphic.OrgX - w2;
            double cY = graphic.OrgY - h2;
            if (!SchemeUtils.isEqual(cX, 0.0) || !SchemeUtils.isEqual(cY, 0.0)) {
                if (graphic.TransProps == null) {
                    graphic.TransProps = new TransformProps();
                }
                graphic.TransProps.CenterX = cX;
                graphic.TransProps.CenterY = cY;
            }
        }
        double angle = this.rotateShapes(figure);
        double skewX = figure.getSkewX();
        double skewY = figure.getSkewY();
        boolean hasAngle = !SchemeUtils.isEqual(angle, 0.0);
        boolean hasSkewX = !SchemeUtils.isEqual(skewX, 0.0);
        boolean hasSkewY = !SchemeUtils.isEqual(skewY, 0.0);
        graphic.OrgX = figure.getSvgX();
        graphic.OrgY = figure.getSvgY();
        if (graphic.TransProps == null && (hasAngle || hasSkewX || hasSkewY)) {
            graphic.TransProps = new TransformProps();
        }
        double dW = 0.0;
        double dH = 0.0;
        if (hasSkewX || hasSkewY) {
            graphic.TransProps.SkewX = figure.getSkewX();
            graphic.TransProps.SkewY = figure.getSkewY();
            dW = SchemeUtils.shiftSkew(figure.getSvgHeight() / 2.0, graphic.TransProps.SkewX);
            dH = SchemeUtils.shiftSkew(figure.getSvgWidth() / 2.0, graphic.TransProps.SkewY);
        }
        if (!hasAngle) {
            graphic.OrgX += w2 + dW;
            graphic.OrgY += h2 + dH;
        } else {
            graphic.TransProps.Angle = angle;
            BaseGraphic.RealPoint p = SchemeUtils.rotatePoint(w2 + dW, h2 + dH, angle);
            graphic.OrgX += p.X;
            graphic.OrgY += p.Y;
        }
        if (mirrorAngle && hasAngle) {
            graphic.TransProps.Angle = 360.0 - graphic.TransProps.Angle;
        }
    }

    private void setGluePointsDefault(BaseGraphic bg, int num, OdgGraphicObject object) {
        double halfHeight;
        double halfWidth;
        double x = 0.0;
        double y = 0.0;
        if (bg instanceof Rectangle) {
            Rectangle rect = (Rectangle)bg;
            halfWidth = rect.SideX / 2.0;
            halfHeight = rect.SideY / 2.0;
        } else {
            OdgFigure figure;
            OdgFigure odgFigure = figure = object == null ? null : (OdgFigure)object;
            if (figure != null && figure.isProprietaryFigure()) {
                halfWidth = figure.getSvgWidth() / 2.0;
                halfHeight = figure.getSvgHeight() / 2.0;
            } else {
                BaseGraphic.RealRect rect = bg.getMinMaxRect();
                halfWidth = (rect.Right - rect.Left) / 2.0;
                halfHeight = (rect.Bottom - rect.Top) / 2.0;
            }
        }
        switch (num) {
            case 0: {
                x = 0.0;
                y = -halfHeight;
                break;
            }
            case 1: {
                x = halfWidth;
                y = 0.0;
                break;
            }
            case 2: {
                x = 0.0;
                y = halfHeight;
                break;
            }
            case 3: {
                x = -halfWidth;
                y = 0.0;
            }
        }
        bg.addGluePoint(x, y);
    }

    private void setGluePointsFigure(OdgGraphicObject object, BaseGraphic bg) {
        block13: {
            block14: {
                block12: {
                    OdgFrame frame;
                    bg.GluePoints = new ArrayList<BaseGraphic.GluePoint>();
                    if (!(object instanceof OdgFigure)) break block12;
                    double cntShape = bg.getVerticesCount();
                    OdgFigure figure = (OdgFigure)object;
                    if (figure instanceof OdgFrame && (frame = (OdgFrame)figure).isTable()) {
                        return;
                    }
                    BaseGraphic.RealRect rect = bg.getMinMaxRect();
                    double width = Math.abs(rect.Right - rect.Left);
                    double height = Math.abs(rect.Bottom - rect.Top);
                    if (this.isPolylineOrSpline(bg)) {
                        List<OdgGluePoint> customPointList = object.getCustomGluePoint();
                        block0: for (OdgGluePoint odgpoint : customPointList) {
                            double pointX = odgpoint.getX() * width / 100.0;
                            double pointY = odgpoint.getY() * height / 100.0;
                            int idx = 0;
                            while ((double)idx < cntShape) {
                                double x = bg.getVertexX(idx);
                                double y = bg.getVertexY(idx);
                                if (SchemeUtils.isEqual(x, pointX, 0.05) && SchemeUtils.isEqual(y, pointY, 0.05)) {
                                    bg.addGluePoint(x, y);
                                    continue block0;
                                }
                                ++idx;
                            }
                        }
                    } else {
                        OdgEnhancedGeometry geometry;
                        AffineTransform emptyTm = new AffineTransform();
                        if (bg.TransProps != null) {
                            double angle = -SchemeEngine.NormAngle(bg.TransProps.Angle) * Math.PI / 180.0;
                            angle = this.transformRadian(angle);
                            emptyTm.rotate(angle);
                        }
                        List<Object> specialPointList = (geometry = figure.getGeometry()) == null ? new ArrayList() : geometry.getSpectialPointList();
                        for (Object point : specialPointList) {
                            double x = ((OdgEnhancedGeometry.Point)point).getX() * this.scaleX - figure.getSvgWidth() / 2.0;
                            double y = ((OdgEnhancedGeometry.Point)point).getY() * this.scaleY - figure.getSvgHeight() / 2.0;
                            if (bg.TransProps != null) {
                                x -= bg.TransProps.CenterX;
                                y -= bg.TransProps.CenterY;
                            }
                            bg.addGluePoint(x, y);
                        }
                        List<OdgGluePoint> customPointList = object.getCustomGluePoint();
                        for (OdgGluePoint odgpoint : customPointList) {
                            double pointX = odgpoint.getX() * width / 100.0;
                            double pointY = odgpoint.getY() * height / 100.0;
                            double[] pts = SchemeEngine.MulPointsTM(emptyTm, new double[]{pointX, pointY});
                            bg.addGluePoint(pts[0], pts[1]);
                        }
                    }
                    break block13;
                }
                if (!(object instanceof OdgConnector)) break block14;
                Polyline polyline = (Polyline)bg;
                int value = polyline.Points.length;
                polyline.addGluePointToVertex(polyline.Points[0], polyline.Points[1], 0);
                polyline.addGluePointToVertex(polyline.Points[value - 2], polyline.Points[value - 1], value);
                break block13;
            }
            if (!(object instanceof OdgLine)) break block13;
            Polyline polyline = (Polyline)bg;
            double x1 = polyline.Points[0];
            List<OdgGluePoint> customPointList = object.getCustomGluePoint();
            double y1 = polyline.Points[1];
            double x2 = polyline.Points[2];
            double y2 = polyline.Points[3];
            double width = Math.abs(x2 - x1);
            double height = Math.abs(y2 - y1);
            for (OdgGluePoint point : customPointList) {
                double pointX = point.getX() * width / 100.0;
                double pointY = point.getY() * height / 100.0;
                if (SchemeUtils.isEqual(x1, pointX, 0.05) && SchemeUtils.isEqual(y1, pointY, 0.05)) {
                    bg.addGluePoint(x1, y1);
                    continue;
                }
                if (!SchemeUtils.isEqual(x2, pointX, 0.05) || !SchemeUtils.isEqual(y2, pointY, 0.05)) continue;
                bg.addGluePoint(x2, y2);
            }
        }
    }

    private double transformRadian(double rad) {
        if (rad > Math.PI) {
            rad -= Math.PI * 2;
        }
        if (rad < -Math.PI) {
            rad += Math.PI * 2;
        }
        return rad;
    }

    private boolean isPolylineOrSpline(BaseGraphic graphic) {
        return (graphic instanceof Polyline || graphic instanceof Spline) && !(graphic instanceof Polygon) && !(graphic instanceof Region);
    }

    private void setScale(OdgFigure figure) {
        this.scaleX = figure.getSvgWidth() / (double)figure.getSvgViewBox()[2] == Double.POSITIVE_INFINITY ? 0.01 : figure.getSvgWidth() / (double)figure.getSvgViewBox()[2];
        this.scaleY = figure.getSvgHeight() / (double)figure.getSvgViewBox()[3] == Double.POSITIVE_INFINITY ? 0.01 : figure.getSvgHeight() / (double)figure.getSvgViewBox()[3];
    }

    private boolean comparison(double x, double y) {
        return Math.floor(x) == Math.floor(y);
    }

    private void assignText(Paragraph paragraph, OdgGraphicObject graphicObj, BaseGraphic graphic) {
        OdgStyleStyle textStyle;
        OdgStyleStyle style;
        PhxLayer layer;
        String drawLayer;
        OdgText odgText;
        if (graphic == null) {
            OdgTextBox box = ((OdgFrame)graphicObj).getTextBox();
            odgText = box.getText();
        } else if (graphicObj instanceof OdgFrame) {
            OdgImage image = ((OdgFrame)graphicObj).getImage();
            odgText = image.getText();
        } else {
            odgText = graphicObj.getText();
        }
        paragraph.AutoSize = false;
        paragraph.Lines = new Paragraph.Lines();
        paragraph.lfHeight = 6.3486;
        paragraph.ShowBackground = true;
        paragraph.Lines.FontName = DEFAULT_FONT_NAME;
        paragraph.ID = Core.generateId();
        paragraph.LayerID = 0.0;
        if (this.layerByName != null && (drawLayer = graphicObj.getDrawLayer()) != null && (layer = this.layerByName.get(drawLayer)) != null) {
            paragraph.LayerID = layer.ID;
            this.hasGraphicsByLayer.put(layer, true);
        }
        if ((style = graphicObj.getStyle()) != null && style.hasGraphic()) {
            OdgProperties styleProperties = style.getStyleProperty();
            paragraph.TopMargin = OdgUtils.asDouble(styleProperties.getStyles("fo:padding-top"));
            paragraph.RightMargin = OdgUtils.asDouble(styleProperties.getStyles("fo:padding-right"));
            paragraph.LeftMargin = OdgUtils.asDouble(styleProperties.getStyles("fo:padding-left"));
            paragraph.BottomMargin = OdgUtils.asDouble(styleProperties.getStyles("fo:padding-bottom"));
            paragraph.VertAlign = OdgUtils.asInteger(styleProperties.getStyles("draw:textarea-vertical-align"));
        }
        if ((textStyle = graphicObj.getTextStyle()) != null && textStyle.hasParagraph()) {
            OdgProperties styleProperties = textStyle.getStyleProperty();
            paragraph.Align = OdgUtils.asByte(styleProperties.getStyles("fo:text-align"));
        }
        RectTextLine rtl = new RectTextLine();
        String curLine = "";
        List<OdgText.OdgPartText> partsText = odgText.getPartTexts();
        for (OdgText.OdgPartText partText : partsText) {
            OdgProperties styleProperties;
            OdgStyleStyle partTextStyle = partText.textSpanStyle == null ? graphicObj.getStyle() : partText.textSpanStyle;
            OdgProperties properties = partTextStyle.getStyleProperty();
            RectTextLine.PartTextLine ptl = new RectTextLine.PartTextLine();
            ptl.fontName = properties.getStyles("style:font-name");
            ptl.fontColor = OdgUtils.asColor(properties.getStyles("fo:color"));
            ptl.fontBgColor = OdgUtils.asColor(properties.getStyles("fo:background-color"));
            ptl.fontStyle = OdgUtils.asByte(properties.getStyles("fo:font-style"));
            ptl.fontHeight = OdgUtils.asDouble(properties.getStyles("fo:font-size"));
            ptl.ssScript = OdgUtils.asByte(properties.getStyles("style:text-position"));
            OdgStyleStyle textPStyle = partText.textPStyle;
            if (textPStyle != null && textPStyle.hasParagraph()) {
                styleProperties = textPStyle.getStyleProperty();
                paragraph.TabStopPosition = OdgUtils.asDouble(styleProperties.getStyles("style:tab-stop"));
                rtl.paragraphLine = new RectTextLine.ParagraphLine();
                rtl.paragraphLine.leftIndent = OdgUtils.asDouble(styleProperties.getStyles("fo:margin-left"));
                rtl.paragraphLine.rightIndent = OdgUtils.asDouble(styleProperties.getStyles("fo:margin-right"));
                rtl.paragraphLine.firstIndent = OdgUtils.asDouble(styleProperties.getStyles("fo:text-indent"));
                rtl.paragraphLine.spaceBefore = OdgUtils.asDouble(styleProperties.getStyles("fo:margin-top"));
                rtl.paragraphLine.spaceAfter = OdgUtils.asDouble(styleProperties.getStyles("fo:margin-bottom"));
                rtl.paragraphLine.lineSpacing = OdgUtils.asDouble(styleProperties.getStyles("fo:line-height"));
                rtl.paragraphLine.align = OdgUtils.asByte(styleProperties.getStyles("fo:text-align"));
            }
            if (paragraph instanceof Attribute && style != null && style.hasGraphic()) {
                styleProperties = style.getStyleProperty();
                byte value = OdgUtils.asByte(styleProperties.getStyles("draw:textarea-horizontal-align"));
                if (rtl.paragraphLine != null && value != -1) {
                    rtl.paragraphLine.align = value;
                }
            }
            ptl.text = partText.text;
            curLine = curLine.concat(partText.text);
            if (partsText.size() != 1) {
                rtl.Parts.add(ptl);
            } else {
                paragraph.fontBgColor = ptl.fontBgColor;
                paragraph.lfHeight = ptl.fontHeight;
                rtl.FontName = ptl.fontName;
                rtl.FontColor = ptl.fontColor;
                rtl.FontStyle = ptl.fontStyle;
            }
            if (!partText.newLine) continue;
            rtl.Text = curLine;
            paragraph.Lines.add(rtl);
            rtl = new RectTextLine();
            curLine = "";
        }
        if (paragraph instanceof AttributeDef && graphic != null && style != null) {
            AttributeDef attr = (AttributeDef)paragraph;
            attr.setCaption("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 1");
            attr.ID = Core.generateId();
            attr.LayerID = graphic.LayerID;
            attr.AutoSize = false;
            attr.ShowBackground = false;
            attr.TransProps = new TransformProps();
            OdgFigure figure = (OdgFigure)graphicObj;
            OdgEnhancedGeometry geometry = figure.getGeometry();
            if (geometry != null) {
                if (!geometry.hasTextArea()) {
                    attr.SideX = figure.getSvgWidth();
                    attr.SideY = figure.getSvgHeight();
                } else {
                    int[] arr = geometry.getDrawTextAreas();
                    int wt = arr[2] - arr[0];
                    int ht = arr[3] - arr[1];
                    attr.SideX = (double)wt * this.scaleX;
                    attr.SideY = (double)ht * this.scaleY;
                    if (!geometry.isSvgZoneEmpty()) {
                        attr.OrgX = -0.5 * figure.getSvgWidth() + (double)arr[0] * this.scaleX + 0.5 * (double)wt * this.scaleX;
                        attr.OrgY = -0.5 * figure.getSvgHeight() + (double)arr[1] * this.scaleY + 0.5 * (double)ht * this.scaleY;
                    }
                }
            } else {
                attr.SideX = figure.getSvgWidth();
                attr.SideY = figure.getSvgHeight();
            }
        }
    }
}

