/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.SchemeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PrimParam {
    private String name = "";
    private String caption = "";
    private String value = "";
    private ValueType type;
    private final List<String> dict = new ArrayList<String>();
    private boolean showInContextMenu = true;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(ValueType type) {
        this.type = type;
    }

    public List<String> getDict() {
        return this.dict;
    }

    public void addToDict(String entry) {
        this.dict.add(entry);
    }

    public boolean isShowInContextMenu() {
        return this.showInContextMenu;
    }

    public void setShowInContextMenu(boolean showInContextMenu) {
        this.showInContextMenu = showInContextMenu;
    }

    public String getVisioValueType() {
        String visioTypeOfValue = "";
        switch (this.type) {
            case String: {
                visioTypeOfValue = "STR";
                break;
            }
            case Boolean: {
                visioTypeOfValue = "BOOL";
                break;
            }
            case DateTime: {
                visioTypeOfValue = "DATE";
            }
        }
        return visioTypeOfValue;
    }

    public String getVisioParamType() {
        String paramType = "";
        switch (this.type) {
            case String: {
                paramType = this.dict.isEmpty() ? "0" : "1";
                break;
            }
            case Boolean: {
                paramType = "3";
                break;
            }
            case Double: 
            case Integer: {
                paramType = "2";
                break;
            }
            case DateTime: {
                paramType = "5";
            }
        }
        return paramType;
    }

    public ValueType getType() {
        return this.type;
    }

    public void store(TaggedWriter out) throws IOException {
        if (!SchemeUtils.isEmpty(this.name)) {
            out.putString(1, this.name);
        }
        if (!SchemeUtils.isEmpty(this.caption)) {
            out.putString(2, this.caption);
        }
        out.putBool(11, this.showInContextMenu);
        if (this.value == null) {
            out.putEmpty(3);
        } else {
            switch (this.type) {
                case Boolean: {
                    out.putBool(4, "1".equals(this.value));
                    break;
                }
                case Integer: {
                    int numInteger = 0;
                    try {
                        numInteger = Integer.parseInt(this.value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    out.putInt32(5, numInteger);
                    break;
                }
                case Double: {
                    double numDouble = 0.0;
                    try {
                        numDouble = Double.parseDouble(this.value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    out.putDouble(6, numDouble);
                    break;
                }
                case String: {
                    out.putString(8, this.value);
                    break;
                }
                default: {
                    out.putEmpty(3);
                }
            }
        }
        if (!this.dict.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TaggedWriter dictWriter = new TaggedWriter(stream);
            for (String entry : this.dict) {
                dictWriter.putString(8, entry);
            }
            dictWriter.flush();
            out.putRaw(10, stream);
        }
    }

    public void parse(TaggedReader reader) throws IOException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.name = reader.getString();
                    break;
                }
                case 2: {
                    this.caption = reader.getString();
                    break;
                }
                case 11: {
                    this.showInContextMenu = reader.getBoolean();
                    break;
                }
                case 4: {
                    this.value = reader.getBoolean() ? "1" : "0";
                    this.type = ValueType.Boolean;
                    break;
                }
                case 5: {
                    this.value = String.valueOf(reader.getInt());
                    this.type = ValueType.Integer;
                    break;
                }
                case 6: {
                    this.value = String.valueOf(reader.getDouble());
                    this.type = ValueType.Double;
                    break;
                }
                case 3: 
                case 8: {
                    this.value = reader.getString();
                    this.type = ValueType.String;
                    break;
                }
                case 10: {
                    TaggedReader dictReader = reader.getStreamReader();
                    while (dictReader.getNextTag() != 0) {
                        switch (dictReader.getCurrentTag()) {
                            case 8: {
                                this.dict.add(dictReader.getString());
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    public static enum ValueType {
        Boolean,
        Integer,
        Double,
        DateTime,
        String,
        Binary,
        Undefined;

    }
}

