/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.PrimParam;
import inform.agent.schemes.SchemeParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class Primitive
implements DoubleHash.Entry {
    private double ID = 0.0;
    private double LibID = 0.0;
    public String Name = null;
    public String Caption = null;
    public String Description = null;
    public double ClassificationID = 0.0;
    public String ImportID;
    public boolean Imported = false;
    public BaseGraphic BG;
    public List<PrimParam> PrimParams = new ArrayList<PrimParam>();

    @Override
    public double key() {
        return this.ID;
    }

    public void setID(double value) {
        this.ID = value;
    }

    public double getLibID() {
        return this.LibID;
    }

    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException, InformException {
        int tmpInt = 0;
        byte[] tmpBytes = null;
        byte[] tmpBytes1 = null;
        TaggedReader StreamReader = null;
        block28: while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 21: {
                    this.Name = reader.getString();
                    break;
                }
                case 9: {
                    this.Caption = reader.getUnicode();
                    break;
                }
                case 20: {
                    this.Description = reader.getUnicode();
                    break;
                }
                case 4: {
                    tmpBytes1 = reader.getRaw();
                    ByteArrayInputStream in = new ByteArrayInputStream(tmpBytes1);
                    try {
                        GZIPInputStream zin = SchemeParser.isGZip(tmpBytes1) ? new GZIPInputStream(in) : null;
                        try {
                            StreamReader = new TaggedReader(zin == null ? in : zin);
                            while (StreamReader.getNextTag() != 0) {
                                switch (StreamReader.getCurrentTag()) {
                                    case 2: {
                                        tmpBytes = StreamReader.getRaw();
                                        tmpInt = LittleEndian.getInt(tmpBytes, 0);
                                        this.BG = Parser2.createObject(tmpInt);
                                        if (this.BG == null) break;
                                        this.BG.parse(Parser2, StreamReader);
                                    }
                                }
                            }
                            continue block28;
                        }
                        finally {
                            if (zin == null) continue block28;
                            zin.close();
                            continue block28;
                        }
                    }
                    finally {
                        ((InputStream)in).close();
                        continue block28;
                    }
                }
                case 5: {
                    this.LibID = reader.getDouble();
                    break;
                }
                case 6: {
                    this.ID = reader.getDouble();
                    break;
                }
                case 7: {
                    this.ClassificationID = reader.getDouble();
                    break;
                }
                case 35: {
                    this.ImportID = reader.getUnicode();
                    break;
                }
                case 37: {
                    this.Imported = reader.getBoolean();
                    break;
                }
                case 40: {
                    StreamReader = reader.getStreamReader();
                    while (StreamReader.getNextTag() != 0) {
                        switch (StreamReader.getCurrentTag()) {
                            case 1: {
                                TaggedReader paramReader = StreamReader.getStreamReader();
                                PrimParam param = new PrimParam();
                                param.parse(paramReader);
                                this.PrimParams.add(param);
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    protected synchronized void store(TaggedWriter writer) throws IOException {
        if (writer == null) {
            return;
        }
        if (this.Name != null) {
            writer.putAnsi(21, this.Name);
        }
        if (this.Caption != null) {
            writer.putUnicode(9, this.Caption);
        }
        if (this.Description != null) {
            writer.putUnicode(20, this.Description);
        }
        if (this.BG != null) {
            ByteArrayOutputStream bgStream = new ByteArrayOutputStream();
            TaggedWriter bgWriter = new TaggedWriter(bgStream);
            this.BG.writeBG(bgWriter, false, false);
            if (bgStream.size() > 0) {
                writer.putRaw(4, bgStream);
            }
        }
        if (this.LibID != 0.0) {
            writer.putDouble(5, this.LibID);
        }
        writer.putDouble(6, this.key());
        writer.putDouble(7, this.ClassificationID);
        if (this.ImportID != null) {
            writer.putUnicode(35, this.ImportID);
        }
        if (this.Imported) {
            writer.putBool(37, this.Imported);
        }
        if (!this.PrimParams.isEmpty()) {
            ByteArrayOutputStream paramStream = new ByteArrayOutputStream();
            TaggedWriter paramWriter = new TaggedWriter(paramStream);
            for (PrimParam param : this.PrimParams) {
                ByteArrayOutputStream paramDetailsStream = new ByteArrayOutputStream();
                TaggedWriter paramDetailsWriter = new TaggedWriter(paramDetailsStream);
                param.store(paramDetailsWriter);
                paramDetailsWriter.flush();
                paramWriter.putRaw(1, paramDetailsStream);
            }
            paramStream.flush();
            writer.putRaw(40, paramStream);
        }
        writer.flush();
    }

    public synchronized byte[] asBinary() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(os);
        this.store(writer);
        return os.toByteArray();
    }
}

