/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.VsdxReader;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RectTextLine
extends Rectangle {
    public String Text = null;
    public String FontName = "Times New Roman";
    public int FontSize = 10;
    public Color FontColor = null;
    public byte FontStyle = 0;
    public byte FontCharSet = 0;
    public int CursorPos = 0;
    public int LCursorPos = 0;
    public List<PartTextLine> Parts = new ArrayList<PartTextLine>();
    public ParagraphLine paragraphLine;
    public Paragraph parentParagraph = null;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        RectTextLine shape = (RectTextLine)Dest;
        shape.Text = this.Text;
        shape.FontName = this.FontName;
        shape.FontSize = this.FontSize;
        shape.FontColor = this.FontColor;
        shape.FontStyle = this.FontStyle;
        shape.FontCharSet = this.FontCharSet;
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        this.parse_(Parser2, reader, this.parentParagraph);
    }

    protected void parse_(SchemeParser Parser2, TaggedReader reader, Paragraph paragraph) throws IOException, TaggedReaderException {
        String buff;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 3: {
                    TaggedReader StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 53: {
                    this.Text = reader.getUnicode();
                    break;
                }
                case 56: {
                    this.FontName = reader.getString();
                    break;
                }
                case 57: {
                    this.FontSize = reader.getInt();
                    break;
                }
                case 58: {
                    this.FontColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 59: {
                    this.FontStyle = reader.getByte();
                    break;
                }
                case 60: {
                    this.FontCharSet = reader.getByte();
                    break;
                }
                case 119: {
                    reader.skip();
                    TaggedReader StreamReader = reader.getStreamReader(202);
                    while (StreamReader.next()) {
                        this.readExtraTaggedLines(StreamReader, StreamReader.getCurrentTag(), paragraph);
                    }
                    break;
                }
            }
        }
        if (!this.Parts.isEmpty() && !Strings.isVoid(buff = this.getPartsLineText())) {
            this.Text = buff;
        }
    }

    protected String getPartsLineText() {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < this.Parts.size(); ++i) {
            PartTextLine part = this.Parts.get(i);
            if (part == null || Strings.isVoid(part.text)) continue;
            buff.append(part.text);
        }
        return buff.toString();
    }

    public void readExtraTaggedLines(TaggedReader reader, int tag, Paragraph paragraph) throws IOException {
        boolean asParagraph;
        ParagraphLine pLine = new ParagraphLine();
        if (paragraph != null) {
            pLine.align = paragraph.Align;
            pLine.lineSpacing = paragraph.LineSpacing;
        }
        switch (tag) {
            case 16: {
                PartTextLine currentLine = null;
                TaggedReader subReader = reader.getStreamReader();
                block20: while (subReader.next()) {
                    switch (subReader.getCurrentTag()) {
                        case 56: {
                            currentLine = new PartTextLine();
                            this.Parts.add(currentLine);
                            currentLine.fontName = subReader.getString();
                            continue block20;
                        }
                        case 53: {
                            assert (currentLine != null);
                            currentLine.text = subReader.getString();
                            continue block20;
                        }
                        case 57: {
                            assert (currentLine != null);
                            currentLine.fontHeight = subReader.getDouble();
                            continue block20;
                        }
                        case 58: {
                            assert (currentLine != null);
                            currentLine.fontColor = SchemeParser.parseColor(subReader.getInt());
                            continue block20;
                        }
                        case 51: {
                            assert (currentLine != null);
                            currentLine.fontBgColor = SchemeParser.parseColor(subReader.getInt());
                            if (paragraph == null || paragraph.fontBgColor != null && (currentLine.fontBgColor == null || paragraph.fontBgColor.equals(currentLine.fontBgColor))) continue block20;
                            if (paragraph.isFontBgColorSetted) {
                                paragraph.fontBgColor = null;
                                continue block20;
                            }
                            if (currentLine.fontBgColor != null) {
                                paragraph.fontBgColor = new Color(currentLine.fontBgColor.getRGB());
                            }
                            paragraph.isFontBgColorSetted = true;
                            continue block20;
                        }
                        case 59: {
                            assert (currentLine != null);
                            currentLine.fontStyle = subReader.getByte();
                            continue block20;
                        }
                        case 61: {
                            assert (currentLine != null);
                            double[] data = LittleEndian.toDoubleArray(subReader.getRaw());
                            assert (data.length == 2);
                            if (currentLine.sides == null) {
                                currentLine.sides = new BaseGraphic.RealPoint();
                            }
                            currentLine.sides.X = data[0];
                            currentLine.sides.Y = data[1];
                            continue block20;
                        }
                        case 52: {
                            assert (currentLine != null);
                            currentLine.ssScript = subReader.getByte();
                            continue block20;
                        }
                        case 47: {
                            pLine.firstIndent = subReader.getDouble();
                            continue block20;
                        }
                        case 45: {
                            pLine.leftIndent = subReader.getDouble();
                            continue block20;
                        }
                        case 46: {
                            pLine.rightIndent = subReader.getDouble();
                            continue block20;
                        }
                        case 48: {
                            pLine.spaceBefore = subReader.getDouble();
                            continue block20;
                        }
                        case 49: {
                            pLine.spaceAfter = subReader.getDouble();
                            continue block20;
                        }
                        case 50: {
                            pLine.align = subReader.getByte();
                            continue block20;
                        }
                        case 44: {
                            pLine.lineSpacing = subReader.getDouble();
                            continue block20;
                        }
                    }
                }
                break;
            }
        }
        boolean bl = asParagraph = SchemeUtils.isEqual(pLine.firstIndent, 0.0) && SchemeUtils.isEqual(pLine.leftIndent, 0.0) && SchemeUtils.isEqual(pLine.rightIndent, 0.0) && SchemeUtils.isEqual(pLine.spaceAfter, 0.0) && SchemeUtils.isEqual(pLine.spaceBefore, 0.0) && pLine.align == paragraph.Align && SchemeUtils.isEqual(pLine.lineSpacing, paragraph.LineSpacing);
        if (!asParagraph) {
            this.paragraphLine = pLine;
        }
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        this.writeTaggedData_(writer, clipboard, simult, null);
    }

    public synchronized void writeTaggedData_(TaggedWriter writer, boolean clipboard, boolean simult, Paragraph paragraph) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (os.size() > 0) {
            writer.putRaw(3, os);
        }
        if (this.Text != null && !this.Text.isEmpty()) {
            writer.putUnicode(53, this.Text);
        }
        if (this.CursorPos != 0) {
            writer.putInt32(54, this.CursorPos);
        }
        if (this.LCursorPos != 0) {
            writer.putInt32(55, this.LCursorPos);
        }
        if (!"Times New Roman".equals(this.FontName)) {
            writer.putAnsi(56, this.FontName);
        }
        if (this.FontSize != 10) {
            writer.putInt32(57, this.FontSize);
        }
        if (this.FontColor != null) {
            SchemeUtils.writeColor(writer, 58, this.FontColor);
        }
        if (this.FontStyle != 0) {
            writer.putInt08(59, this.FontStyle);
        }
        if (this.FontCharSet != 204) {
            writer.putInt08(60, this.FontCharSet);
        }
        ByteArrayOutputStream extraOs = new ByteArrayOutputStream();
        TaggedWriter extraWriter = new TaggedWriter(extraOs);
        this.writeExtraTaggedLine(extraWriter, paragraph);
        extraWriter.flush();
        if (extraOs.size() > 0) {
            writer.putEmpty(119);
            writer.putRaw(202, extraOs);
        }
    }

    public synchronized void writeExtraTaggedLine(TaggedWriter writer, Paragraph paragraph) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(os);
        for (PartTextLine p : this.Parts) {
            String fontName;
            if (p.text == null || p.text.isEmpty()) continue;
            String string = fontName = p.fontName != null && !p.fontName.isEmpty() ? p.fontName : this.FontName;
            if (fontName == null || fontName.isEmpty()) {
                fontName = Paragraph.DEFAULT_FONTNAME;
            }
            w.putString(56, fontName);
            w.putString(53, p.text);
            if (p.sides != null) {
                SchemeUtils.writeDoubles(w, 61, p.sides.X, p.sides.Y);
            }
            w.putDouble(57, p.fontHeight);
            if (p.fontColor != null) {
                SchemeUtils.writeColor(w, 58, p.fontColor);
            }
            if (p.fontBgColor != null) {
                SchemeUtils.writeColor(w, 51, p.fontBgColor);
            }
            w.putInt08(59, p.fontStyle);
            if (p.ssScript == 0) continue;
            w.putInt08(52, p.ssScript);
        }
        if (this.paragraphLine != null) {
            if (!SchemeUtils.isEqual(this.paragraphLine.firstIndent, 0.0)) {
                w.putDouble(47, this.paragraphLine.firstIndent);
            }
            if (!SchemeUtils.isEqual(this.paragraphLine.leftIndent, 0.0)) {
                w.putDouble(45, this.paragraphLine.leftIndent);
            }
            if (!SchemeUtils.isEqual(this.paragraphLine.rightIndent, 0.0)) {
                w.putDouble(46, this.paragraphLine.rightIndent);
            }
            if (!SchemeUtils.isEqual(this.paragraphLine.spaceBefore, 0.0)) {
                w.putDouble(48, this.paragraphLine.spaceBefore);
            }
            if (!SchemeUtils.isEqual(this.paragraphLine.spaceAfter, 0.0)) {
                w.putDouble(49, this.paragraphLine.spaceAfter);
            }
            if (this.paragraphLine.align != paragraph.Align) {
                w.putInt08(50, this.paragraphLine.align);
            }
            if (!SchemeUtils.isEqual(this.paragraphLine.lineSpacing, paragraph.LineSpacing)) {
                w.putDouble(44, this.paragraphLine.lineSpacing);
            }
        }
        w.flush();
        if (os.size() > 0) {
            writer.putRaw(16, os);
        }
    }

    @Override
    public int shapeType() {
        return 222;
    }

    @Override
    public int shapeVersion() {
        return version;
    }

    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        if (this.Text != null && !this.Text.isEmpty()) {
            double[] Pts = new double[]{this.OrgX - 0.5 * this.SideX, this.OrgY};
            if (Engine2.UseGTM) {
                Pts = Engine2.MulPoints(Pts);
            }
            g2d.drawString(this.Text, (float)Pts[0], (float)Pts[1]);
        }
    }

    public void freshSides(double fontHeight, double fontScale) {
        boolean isEmpty;
        boolean bl = isEmpty = this.Text == null || this.Text.isEmpty();
        if (isEmpty && Math.abs(fontHeight) <= FloatTolerance) {
            return;
        }
        if (isEmpty) {
            this.SideY = 1.3 * fontHeight;
            this.SideX = 0.5 * this.SideY;
        } else {
            BaseGraphic.RealPoint pt = VsdxReader.calcTextSize(this.getFont((float)fontHeight, fontScale), this.Text);
            this.SideX = pt.X;
            this.SideY = pt.Y;
        }
    }

    private Font getFont(float fontHeight, double WidthScale) {
        return this.Engine == null ? null : this.Engine.getActualFont(this.FontName, this.FontStyle, this.FontColor, fontHeight, WidthScale);
    }

    public boolean samePL(RectTextLine rtl) {
        if (rtl == null) {
            return false;
        }
        ParagraphLine p1 = rtl.paragraphLine;
        ParagraphLine p2 = this.paragraphLine;
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        return p1.equals(p2);
    }

    public static class PartTextLine
    implements Cloneable {
        public String text;
        public BaseGraphic.RealPoint sides;
        public String fontName;
        public byte fontStyle = 0;
        public Color fontColor = null;
        public Color fontBgColor = null;
        public double fontHeight = 0.0;
        public byte ssScript = 0;

        public static PartTextLine getDefaultPart() {
            PartTextLine ptl = new PartTextLine();
            ptl.fontName = "Times New Roman";
            ptl.fontHeight = 6.3486;
            ptl.fontColor = Color.BLACK;
            ptl.sides = new BaseGraphic.RealPoint();
            ptl.text = " ";
            return ptl;
        }

        public static PartTextLine getParentCopy(RectTextLine rtl) {
            PartTextLine ptl = new PartTextLine();
            ptl.text = rtl.Text;
            ptl.sides = new BaseGraphic.RealPoint();
            ptl.sides.X = rtl.SideX;
            ptl.sides.Y = rtl.SideY;
            ptl.fontName = rtl.FontName;
            ptl.fontColor = rtl.FontColor;
            ptl.fontStyle = rtl.FontStyle;
            Paragraph p = rtl.parentParagraph;
            if (p != null) {
                ptl.fontHeight = p.lfHeight;
            }
            return ptl;
        }

        public PartTextLine clone() {
            try {
                return (PartTextLine)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        boolean sameFont(PartTextLine part) {
            if (part == null) {
                return false;
            }
            if (!SchemeUtils.isEqual(this.sides, part.sides)) {
                return false;
            }
            if (!SchemeUtils.isEqual(this.fontName, part.fontName)) {
                return false;
            }
            if (!SchemeUtils.isEqual(this.fontColor, part.fontColor)) {
                return false;
            }
            if (!SchemeUtils.isEqual(this.fontBgColor, part.fontBgColor)) {
                return false;
            }
            if (!SchemeUtils.isEqual(this.fontHeight, part.fontHeight)) {
                return false;
            }
            return this.fontStyle == part.fontStyle && this.ssScript == part.ssScript;
        }
    }

    public static class ParagraphLine {
        public byte align;
        public double firstIndent;
        public double leftIndent;
        public double rightIndent;
        public double spaceBefore;
        public double spaceAfter;
        public double lineSpacing = 1.0;
    }
}

