/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.Spline;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.io.IOException;

public class Region
extends Spline {
    public int[] Counts = null;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        Region shape = (Region)Dest;
        int count = this.Counts.length;
        shape.Counts = new int[count];
        for (int i = 0; i < count; ++i) {
            shape.Counts[i] = this.Counts[i];
        }
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        TaggedReader StreamReader = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 3: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 81: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    while (StreamReader.getNextTag() != 0) {
                        switch (StreamReader.getCurrentTag()) {
                            case 83: {
                                this.Counts = LittleEndian.toIntArray(StreamReader.getRaw());
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        double[] Pts = null;
        Pts = Engine2.UseGTM ? Engine2.MulPoints(this.Points) : this.Points;
        int pcount = Pts.length / 2;
        int idx = 0;
        int SectCount = 1;
        if (this.Counts != null) {
            SectCount = this.Counts.length;
        }
        int SegmCount = (pcount - SectCount) / 3;
        int SectIdx = 0;
        int Count = 0;
        Path2D.Double shape = new Path2D.Double();
        shape.setWindingRule(0);
        for (int i = 0; i < SegmCount; ++i) {
            if (i == 0 || i == Count) {
                if (SectCount > 1) {
                    Count = Count + (this.Counts[SectIdx] + 2) / 3 - 1;
                }
                ((Path2D)shape).moveTo(Pts[idx], Pts[idx + 1]);
                idx += 2;
                ++SectIdx;
            }
            ((Path2D)shape).curveTo(Pts[idx], Pts[idx + 1], Pts[idx + 2], Pts[idx + 3], Pts[idx + 4], Pts[idx + 5]);
            idx += 6;
            if (i != SegmCount - 1 && i != Count - 1) continue;
            shape.closePath();
        }
        if (Engine2.isNeedFill(this.BrushPattern)) {
            Engine2.setActualBColor(g2d, this.bColor);
            g2d.fill(shape);
        }
        if (Engine2.isNeedPen(this.PenPattern) && (!Engine2.isNeedFill(this.BrushPattern) || Engine2.getActualPColor(this.pColor) != Engine2.getActualBColor(this.bColor))) {
            Engine2.setActualPColor(g2d, this.pColor);
            Engine2.setActualPenStyle(g2d, this.PenPattern, this.lWidth);
            g2d.draw(shape);
        }
    }

    @Override
    protected int polyCountsCount() {
        return this.Counts != null ? this.Counts.length : 1;
    }

    @Override
    protected int getSectionIndex(int segmIdx) {
        int polyCount = this.polyCountsCount();
        if (polyCount <= 1) {
            return 0;
        }
        int res = 0;
        int sum = 0;
        for (int i = 0; i < polyCount; ++i) {
            int segmCount = (this.Counts[i] + 2) / 3 - 1;
            if (segmIdx >= (sum += segmCount)) continue;
            res = i;
            break;
        }
        return res;
    }

    private int getSegmentIndex(int sectIdx) {
        int polyCount = this.polyCountsCount();
        if (polyCount <= 1 || sectIdx <= 0 || sectIdx >= polyCount) {
            return 0;
        }
        int sum = 0;
        for (int i = 0; i < sectIdx; ++i) {
            int segmCount = (this.Counts[i] + 2) / 3 - 1;
            sum += segmCount;
        }
        return sum;
    }

    public double[] calcPoints(int sectIdx) {
        int count;
        int polyCount = this.polyCountsCount();
        if (sectIdx < 0 || sectIdx >= polyCount) {
            return null;
        }
        this.calcCoefSpline();
        if (this.cx == null) {
            return null;
        }
        int n = count = polyCount > 1 ? this.Counts[sectIdx] : this.Points.length / 2;
        if (count == 0) {
            return null;
        }
        int ns = (count - 1) / 3;
        if (ns == 0) {
            return null;
        }
        int startSegm = this.getSegmentIndex(sectIdx);
        if (startSegm < 0) {
            return null;
        }
        int sCount = this.cx.length / 4;
        if (startSegm + ns > sCount) {
            return null;
        }
        double dt = 1.0 / (double)(this.pointsPerSegment - 1);
        int nv = (this.pointsPerSegment - 1) * ns + 1;
        double[] pts = new double[2 * nv];
        int k = 0;
        double[] pt = new double[2];
        for (int i = 0; i < ns; ++i) {
            int idx;
            for (int j = 0; j < this.pointsPerSegment - 1; ++j) {
                this.getSplinePoint(startSegm + i, dt * (double)j, pt);
                idx = 2 * k;
                pts[idx] = pt[0];
                pts[idx + 1] = pt[1];
                ++k;
            }
            if (i != ns - 1) continue;
            this.getSplinePoint(startSegm + i, 1.0, pt);
            idx = 2 * k;
            pts[idx] = pt[0];
            pts[idx + 1] = pt[1];
        }
        return pts;
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (os.size() > 0) {
            writer.putRaw(3, os);
        }
        this.writeTaggedCounts(writer);
    }

    synchronized void writeTaggedCounts(TaggedWriter writer) throws IOException {
        if (writer == null || this.Counts == null || this.Counts.length == 0) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(os);
        if (this.Counts.length != 1) {
            w.putInt32(82, this.Counts.length);
        }
        w.putRaw(83, LittleEndian.intArrayToBinary(this.Counts, this.Counts.length));
        w.flush();
        writer.putRaw(81, os);
    }

    @Override
    public int shapeType() {
        return 213;
    }

    @Override
    public int shapeVersion() {
        return version;
    }

    @Override
    public boolean isVertexGluable(int index) {
        return this.checkIsNode(index);
    }

    public boolean checkIsNode(int index) {
        int leftNode = this.getLeftNodeIndex(index);
        return index == leftNode || index == leftNode + 3;
    }

    public int getLeftNodeIndex(int index) {
        int sum = 0;
        int cnt = this.Counts == null ? 0 : this.Counts.length;
        for (int i = 0; i < cnt && index >= sum + this.Counts[i]; ++i) {
            sum += this.Counts[i];
        }
        return sum + 3 * ((index - sum - 1) / 3);
    }
}

