/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemeObjectsTypes;
import inform.agent.schemes.SchemeUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;

public class SchemeEngine {
    public Scheme s = null;
    private int ImageWidth = 256;
    private int ImageHeight = 256;
    private int BufferedImageType = 2;
    private String ImageFormat = "PNG";
    private int TailX = 0;
    private int TailY = 0;
    private int TailZ = 0;
    private String LayersConfig = "";
    private double CellLeft = 0.0;
    private double CellTop = 0.0;
    private double CellRight = 0.0;
    private double CellBottom = 0.0;
    private double CellWidth = 0.0;
    private double CellHeight = 0.0;
    private double ViewPointScaleX = 0.0;
    private double ViewPointScaleY = 0.0;
    private double ViewPointX = 0.0;
    private double ViewPointY = 0.0;
    public AffineTransform GTM = new AffineTransform();
    public AffineTransform VTM = new AffineTransform();
    public boolean UseGTM = true;
    public boolean UseJavaShapes = false;
    public PhxLayer tmpLayer = null;
    public boolean tmpInsertPaint = false;
    public boolean tmpPrimPolylinePaint = false;
    public boolean tmpDimPaint = false;
    double tmpAngle = 0.0;
    int tmpPenPattern = 0;
    double tmpLWidth = 0.0;
    Font tmpFont = null;
    String tmpFontName = "Times New Roman";
    byte tmpFontStyle = 0;
    Color tmpFontColor = Color.BLACK;
    double tmpFontHeight = 10.0;
    double tmpFontWidthScale = 1.0;
    double tmpFontAngle = 0.0;
    private static final Comparator<SchemeObject> CMP = new Comparator<SchemeObject>(){

        @Override
        public int compare(SchemeObject o1, SchemeObject o2) {
            return o1.getOrder() - o2.getOrder();
        }
    };

    public SchemeEngine(Scheme sch) {
        this.s = sch;
    }

    public byte[] Raster(ConnectionManager dbMgr, String layersConfig, int x, int y, int z, int CallCount) throws IOException, TaggedReaderException, InformException, IllegalAccessException, InstantiationException, SQLException {
        byte[] res = null;
        int p2z = (int)Math.pow(2.0, z);
        if (z >= 0 && x >= 0 && x < p2z && y >= 0 && y < p2z) {
            this.TailX = x;
            this.TailY = y;
            this.TailZ = z;
            if (Ini.TraceScheme) {
                Core.logger.info("SCHEME: raster(s:{},l:{},x:{},y:{},z:{},call:{})", NumberConverter.doubleToString(this.s.getSchemeId()), layersConfig, this.TailX, this.TailY, this.TailZ, CallCount);
            }
            this.LayersConfig = layersConfig;
            this.s.parse(dbMgr, false);
            this.s.sortObjects();
            long t1 = System.currentTimeMillis();
            this.s.calcSchemeBounds();
            if (this.s.getSchemeWidth() / (double)this.ImageWidth > this.s.getSchemeHeight() / (double)this.ImageHeight) {
                this.CellWidth = this.s.getSchemeWidth() / (double)p2z;
                this.CellHeight = this.CellWidth * (double)this.ImageHeight / (double)this.ImageWidth;
            } else {
                this.CellHeight = this.s.getSchemeHeight() / (double)p2z;
                this.CellWidth = this.CellHeight * (double)this.ImageWidth / (double)this.ImageHeight;
            }
            if (this.CellWidth > 0.0 || this.CellHeight > 0.0) {
                this.CellLeft = this.s.getSchemeLeft() + (double)this.TailX * this.CellWidth;
                this.CellTop = this.s.getSchemeTop() + (double)this.TailY * this.CellHeight;
                this.CellRight = this.CellLeft + this.CellWidth;
                this.CellBottom = this.CellTop + this.CellHeight;
                this.ViewPointScaleY = this.ViewPointScaleX = this.CellWidth == 0.0 ? 1.0 : (double)this.ImageWidth / this.CellWidth;
                this.ViewPointX = -this.CellLeft;
                this.ViewPointY = -this.CellTop;
                this.GenVTM();
                BufferedImage bi = new BufferedImage(this.ImageWidth, this.ImageHeight, this.BufferedImageType);
                Graphics2D g2d = bi.createGraphics();
                this.paint(g2d, CallCount);
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bi, this.ImageFormat, stream);
                if (stream != null) {
                    res = stream.toByteArray();
                }
                long t2 = System.currentTimeMillis();
                Core.logger.info("\u0420\u0438\u0441\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0439\u043b\u0430 (s:{},l:{},x:{},y:{},z:{},call:{}): {}ms", NumberConverter.doubleToString(this.s.getSchemeId()), layersConfig, this.TailX, this.TailY, this.TailZ, CallCount, t2 - t1);
            }
        } else {
            throw new InformException("\u0417\u0430\u043f\u0440\u043e\u0441 \u0442\u0430\u0439\u043b\u0430 \u0441 \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u043c\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 (s:" + NumberConverter.doubleToString(this.s.getSchemeId()) + ",x:" + x + ",y:" + y + ",z:" + z + ")");
        }
        return res;
    }

    public byte[] RasterDbg(double SchemeID, int x, int y, int z, int CallCount) throws IOException, TaggedReaderException, InformException, IllegalAccessException, InstantiationException {
        byte[] res = null;
        int p2z = (int)Math.pow(2.0, z);
        if (z >= 0 && x >= 0 && x < p2z && y >= 0 && y < p2z) {
            this.TailX = x;
            this.TailY = y;
            this.TailZ = z;
            if (Ini.TraceScheme) {
                Core.logger.info("SCHEME: raster(s:{},x:{},y:{},z:{},call:{})", NumberConverter.doubleToString(SchemeID), this.TailX, this.TailY, this.TailZ, CallCount);
            }
            long t1 = System.currentTimeMillis();
            BufferedImage bi = new BufferedImage(this.ImageWidth, this.ImageHeight, this.BufferedImageType);
            Graphics2D g2d = bi.createGraphics();
            g2d.setColor(Color.WHITE);
            g2d.fillRect(1, 1, this.ImageWidth - 2, this.ImageHeight - 2);
            g2d.setColor(Color.BLUE);
            g2d.drawRect(1, 1, this.ImageWidth - 2, this.ImageHeight - 2);
            String CallCountStr = "x:" + this.TailX + ", y:" + this.TailY + ", z:" + this.TailZ + ", call:" + CallCount;
            g2d.drawString(CallCountStr, 10, 20);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, this.ImageFormat, stream);
            if (stream != null) {
                res = stream.toByteArray();
            }
            long t2 = System.currentTimeMillis();
            Core.logger.info("\u0420\u0438\u0441\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0439\u043b\u0430 (s:{},x:{},y:{},z:{},call:{}): {}ms", NumberConverter.doubleToString(SchemeID), this.TailX, this.TailY, this.TailZ, CallCount, t2 - t1);
        }
        return res;
    }

    private void GenVTM() {
        this.VTM.setToIdentity();
        this.VTM.scale(this.ViewPointScaleX, this.ViewPointScaleY);
        this.VTM.translate(this.ViewPointX, this.ViewPointY);
    }

    public static AffineTransform GenTransform(BaseGraphic BG) {
        AffineTransform Transform = new AffineTransform();
        if (BG.OrgX != 0.0 || BG.OrgY != 0.0) {
            Transform.translate(BG.OrgX, BG.OrgY);
        }
        if (BG.TransProps != null) {
            double gradToRad = Math.PI / 180;
            if (BG.TransProps.Angle != 0.0) {
                Transform.rotate(BG.TransProps.Angle * gradToRad);
            }
            if (BG.TransProps.ScaleX != 1.0 || BG.TransProps.ScaleY != 1.0) {
                Transform.scale(BG.TransProps.ScaleX, BG.TransProps.ScaleY);
            }
            if (BG.TransProps.SkewX != 0.0 || BG.TransProps.SkewY != 0.0) {
                Transform.shear(Math.tan(BG.TransProps.SkewX * gradToRad), Math.tan(BG.TransProps.SkewY * gradToRad));
            }
            if (BG.TransProps.CenterX != 0.0 || BG.TransProps.CenterY != 0.0) {
                Transform.translate(BG.TransProps.CenterX, BG.TransProps.CenterY);
            }
        }
        return Transform;
    }

    public static void Transform(Graphics2D g2d, BaseGraphic BG) {
        if (BG.OrgX != 0.0 || BG.OrgY != 0.0) {
            g2d.translate(BG.OrgX, BG.OrgY);
        }
        if (BG.TransProps != null) {
            double gradToRad = Math.PI / 180;
            if (BG.TransProps.Angle != 0.0) {
                g2d.rotate(BG.TransProps.Angle * gradToRad);
            }
            if (BG.TransProps.ScaleX != 1.0 || BG.TransProps.ScaleY != 1.0) {
                g2d.scale(BG.TransProps.ScaleX, BG.TransProps.ScaleY);
            }
            if (BG.TransProps.SkewX != 0.0 || BG.TransProps.SkewY != 0.0) {
                g2d.shear(Math.tan(BG.TransProps.SkewX * gradToRad), Math.tan(BG.TransProps.SkewY * gradToRad));
            }
            if (BG.TransProps.CenterX != 0.0 || BG.TransProps.CenterY != 0.0) {
                g2d.translate(BG.TransProps.CenterX, BG.TransProps.CenterY);
            }
        }
    }

    public static boolean IsPointInRect(double Left, double Top2, double Right, double Bottom, double X, double Y) {
        return X >= Left && X <= Right && Y >= Top2 && Y <= Bottom;
    }

    private static boolean IsIntersectRect(double Left1, double Top1, double Right1, double Bottom1, double Left2, double Top2, double Right2, double Bottom2) {
        double SideX1 = 0.5 * (Right1 - Left1);
        double SideX2 = 0.5 * (Right2 - Left2);
        double SideY1 = 0.5 * (Bottom1 - Top1);
        double SideY2 = 0.5 * (Bottom2 - Top2);
        double DistX = Math.abs(Left1 + SideX1 - (Left2 + SideX2));
        double DistY = Math.abs(Top1 + SideY1 - (Top2 + SideY2));
        return DistX < SideX1 + SideX2 && DistY < SideY1 + SideY2;
    }

    private boolean ShapeInCell(BaseGraphic BG) {
        double lw = 2.0;
        return SchemeEngine.IsPointInRect(this.CellLeft - lw, this.CellTop - lw, this.CellRight + lw, this.CellBottom + lw, BG.OrgX, BG.OrgY) || SchemeEngine.IsIntersectRect(this.CellLeft - lw, this.CellTop - lw, this.CellRight + lw, this.CellBottom + lw, BG.Left - this.ViewPointScaleX, BG.Top - this.ViewPointScaleY, BG.Right, BG.Bottom);
    }

    public static double[] SidesToEllipse(double SideX, double SideY, int Slices) {
        int idx = 0;
        if (Slices <= 0) {
            Slices = 10;
        }
        double SliceAngle = Math.PI * 2 / (double)Slices;
        SideX /= 2.0;
        SideY /= 2.0;
        double[] Pts = new double[2 * Slices];
        if (SideX > 0.0 && SideY > 0.0) {
            double Axe = SideX;
            double lDy = SideY / SideX;
            double lDx = 1.0;
            if (SideX < SideY) {
                Axe = SideY;
                lDx = SideX / SideY;
                lDy = 1.0;
            }
            double ang = 0.0;
            for (int i = 0; i < Slices; ++i) {
                idx = 2 * i;
                ang = SliceAngle * (double)i;
                Pts[idx] = Axe * Math.cos(ang);
                Pts[idx + 1] = Axe * Math.sin(ang);
                Pts[idx] = Pts[idx] * lDx;
                Pts[idx + 1] = Pts[idx + 1] * lDy;
            }
        } else {
            for (int i = 0; i < Slices; ++i) {
                idx = 2 * i;
                if (SideY > 0.0) {
                    Pts[idx] = 0.0;
                    if (i == Slices - 1) {
                        Pts[idx + 1] = SideY;
                        continue;
                    }
                    Pts[idx + 1] = -SideY + 2.0 * SideY / (double)Slices * (double)i;
                    continue;
                }
                if (SideX > 0.0) {
                    Pts[idx] = i == Slices - 1 ? SideX : -SideX + 2.0 * SideX / (double)Slices * (double)i;
                    Pts[idx + 1] = 0.0;
                    continue;
                }
                Pts[idx] = 0.0;
                Pts[idx + 1] = 0.0;
            }
        }
        return Pts;
    }

    public static double[] SidesToPie(double SideX, double SideY, int Slices, byte PieType, double StartAngle, double EndAngle) {
        if (Slices <= 0) {
            Slices = 10;
        }
        if (StartAngle < EndAngle) {
            StartAngle += Math.PI * 2;
        }
        double SliceAngle = 0.0;
        SliceAngle = PieType == 1 ? (StartAngle - EndAngle) / (double)(Slices - 2) : (StartAngle - EndAngle) / (double)(Slices - 1);
        double[] Pts = new double[2 * Slices];
        double Axe = SideX /= 2.0;
        double lDy = SchemeEngine.divide(SideY /= 2.0, SideX);
        double lDx = 1.0;
        if (SideX < SideY) {
            Axe = SideY;
            lDx = SchemeEngine.divide(SideX, SideY);
            lDy = 1.0;
        }
        double ang = 0.0;
        for (int i = 0; i < Slices; ++i) {
            int idx = 2 * i;
            ang = StartAngle - SliceAngle * (double)i;
            Pts[idx] = Axe * Math.cos(ang);
            Pts[idx + 1] = -Axe * Math.sin(ang);
            Pts[idx] = Pts[idx] * lDx;
            Pts[idx + 1] = Pts[idx + 1] * lDy;
        }
        if (PieType == 1) {
            Pts[2 * Slices - 2] = 0.0;
            Pts[2 * Slices - 1] = 0.0;
        }
        return Pts;
    }

    private static double divide(double v1, double v2) {
        double v = v1 / v2;
        if (Double.isNaN(v)) {
            return 0.0;
        }
        return v;
    }

    public static boolean checkEllipseOnLine(double x1, double y1, double x2, double y2, double x3, double y3) {
        return SchemeEngine.ptOnLine(x2, y2, x3, y3, x1, y1) && SchemeEngine.ptOnLine(x1, y1, x3, y3, x2, y2) && SchemeEngine.ptOnLine(x1, y1, x2, y2, x3, y3);
    }

    public static boolean ptOnLine(double x1, double y1, double x2, double y2, double x, double y) {
        double a = y2 - y1;
        double b = x1 - x2;
        double c = x2 * y1 - x1 * y2;
        if (Math.abs(a) < 1.0E-12 && Math.abs(b) < 1.0E-12) {
            return false;
        }
        return Math.abs((a * x + b * y + c) / Math.sqrt(a * a + b * b)) < 1.0E-6;
    }

    public static boolean checkRect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        return Math.abs(x1 - x4) < 1.0E-12 && Math.abs(x2 - x3) < 1.0E-12 && Math.abs(y1 - y2) < 1.0E-12 && Math.abs(y3 - y4) < 1.0E-12 && Math.abs(x1 - x2) > 1.0E-12 && Math.abs(y1 - y4) > 1.0E-12;
    }

    public double[] MulPoints(double[] Points) {
        int count = Points.length / 2;
        double[] Pts = new double[2 * count];
        this.GTM.transform(Points, 0, Pts, 0, count);
        this.VTM.transform(Pts, 0, Pts, 0, count);
        return Pts;
    }

    public static double[] MulPointsTM(AffineTransform TM, double[] Points) {
        int count = Points.length / 2;
        double[] Pts = new double[2 * count];
        TM.transform(Points, 0, Pts, 0, count);
        return Pts;
    }

    public static double NormAngle(double value) {
        if (value < 0.0) {
            value += 360.0;
        }
        if (Math.abs(value) > 360.0) {
            value -= (double)(360 * (int)(value / 360.0));
        }
        if (value < 0.0) {
            value += 360.0;
        }
        return value;
    }

    public static double aTan(double x, double y) {
        double modX = Math.abs(x);
        if (modX > 0.0) {
            double a = Math.atan(y / modX);
            return x >= 0.0 ? a : Math.PI - a;
        }
        return y >= 0.0 ? 1.5707963267948966 : -1.5707963267948966;
    }

    public void setActualPColor(Graphics2D g2d, Color c) {
        if (c != null) {
            g2d.setColor(c);
        } else if (this.tmpLayer != null && this.tmpLayer.pColor != null) {
            g2d.setColor(this.tmpLayer.pColor);
        } else {
            g2d.setColor(Color.BLACK);
        }
    }

    public Color getActualPColor(Color c) {
        if (c != null) {
            return c;
        }
        if (this.tmpLayer != null && this.tmpLayer.pColor != null) {
            return this.tmpLayer.pColor;
        }
        return Color.BLACK;
    }

    public void setActualBColor(Graphics2D g2d, Color c) {
        if (c != null) {
            g2d.setColor(c);
        } else if (this.tmpLayer != null && this.tmpLayer.bColor != null) {
            g2d.setColor(this.tmpLayer.bColor);
        } else {
            g2d.setColor(Color.WHITE);
        }
    }

    public Color getActualBColor(Color c) {
        if (c != null) {
            return c;
        }
        if (this.tmpLayer != null && this.tmpLayer.bColor != null) {
            return this.tmpLayer.bColor;
        }
        return Color.WHITE;
    }

    public Color getActualBkColor(Color c) {
        if (c != null) {
            return c;
        }
        if (this.tmpLayer != null && this.tmpLayer.BkColor != null) {
            return this.tmpLayer.BkColor;
        }
        return Color.WHITE;
    }

    public void setActualFontColor(Graphics2D g2d, Color c) {
        if (c != null) {
            g2d.setColor(c);
        } else if (this.tmpLayer != null && this.tmpLayer.FontColor != null) {
            g2d.setColor(this.tmpLayer.FontColor);
        } else {
            g2d.setColor(Color.BLACK);
        }
    }

    public Color getActualFontColor(Color c) {
        if (c != null) {
            return c;
        }
        if (this.tmpLayer != null && this.tmpLayer.FontColor != null) {
            return this.tmpLayer.FontColor;
        }
        return Color.BLACK;
    }

    public boolean isNeedFill(int b) {
        if (b != -1 || this.tmpLayer == null) {
            return b != 1;
        }
        return this.tmpLayer.BrushPattern != 1;
    }

    public boolean isNeedPen(int p) {
        if (p != -1 || this.tmpLayer == null) {
            return p != 5;
        }
        return this.tmpLayer.PenPattern != 5;
    }

    public double getActualPrimID(int PenPattern, double PrimID) {
        if (PenPattern == -1 && this.tmpLayer != null) {
            return this.tmpLayer.PrimID;
        }
        return PrimID;
    }

    public double getActualLWidth(double lWidth) {
        double w = lWidth;
        if (lWidth == -1.0 && this.tmpLayer != null) {
            w = this.tmpLayer.lWidth;
        }
        return w > 0.0 ? w : 0.0;
    }

    public int getActualPenPattern(int penPattern) {
        int pp = penPattern;
        if (pp == -1 && this.tmpLayer != null) {
            pp = this.tmpLayer.PenPattern;
        }
        if (pp < 0 || pp > 5) {
            pp = 0;
        }
        return pp;
    }

    public int getActualBrushPattern(int brushPattern) {
        int bp = brushPattern;
        if (bp == -1 && this.tmpLayer != null) {
            bp = this.tmpLayer.BrushPattern;
        }
        return bp;
    }

    public void setActualPenStyle(Graphics2D g2d, int PenPattern, double lWidth) {
        if (PenPattern == -1 && this.tmpLayer != null) {
            PenPattern = this.tmpLayer.PenPattern;
        }
        if (PenPattern < 0 || PenPattern > 4) {
            PenPattern = 0;
        }
        if (lWidth == -1.0 && this.tmpLayer != null) {
            lWidth = (float)this.tmpLayer.lWidth;
        }
        if (lWidth < 0.0) {
            lWidth = 0.0;
        }
        if (PenPattern != this.tmpPenPattern || lWidth != this.tmpLWidth) {
            int w = 0;
            w = this.UseGTM ? (int)Math.ceil(Math.abs(lWidth * this.VTM.getScaleX())) : (int)Math.ceil(lWidth);
            float[] arr = null;
            switch (PenPattern) {
                case 1: {
                    if (w <= 1) {
                        arr = new float[]{18.0f, 6.0f};
                        break;
                    }
                    arr = new float[]{3 * w, w};
                    break;
                }
                case 2: {
                    if (w <= 1) {
                        arr = new float[]{3.0f, 3.0f};
                        break;
                    }
                    arr = new float[]{w, w};
                    break;
                }
                case 3: {
                    if (w <= 1) {
                        arr = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
                        break;
                    }
                    arr = new float[]{3 * w, w, w, w};
                    break;
                }
                case 4: {
                    arr = w <= 1 ? new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f} : new float[]{3 * w, w, w, w, w, w};
                }
            }
            g2d.setStroke(new BasicStroke(w, 0, 2, 0.0f, arr, 0.0f));
            this.tmpPenPattern = PenPattern;
            this.tmpLWidth = lWidth;
        }
    }

    public Font getActualFont(String FontName2, byte FontStyle2, Color c, double lfHeight, double WidthScale) {
        Color FontColor = this.getActualFontColor(c);
        int Height = 0;
        Height = this.UseGTM ? (int)Math.abs(lfHeight * this.VTM.getScaleX()) : (int)Math.abs(lfHeight);
        if (this.tmpFont == null || !this.tmpFontName.equalsIgnoreCase(FontName2) || this.tmpFontStyle != FontStyle2 || this.tmpFontColor != FontColor || this.tmpFontHeight != (double)Height || !SchemeUtils.isEqual(this.tmpFontWidthScale, WidthScale) || this.tmpFontAngle != this.tmpAngle) {
            HashMap<TextAttribute, Object> hm = new HashMap<TextAttribute, Object>();
            hm.put(TextAttribute.FAMILY, FontName2);
            if ((FontStyle2 & 1) != 0) {
                hm.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if ((FontStyle2 & 2) != 0) {
                hm.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if ((FontStyle2 & 4) != 0) {
                hm.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if ((FontStyle2 & 8) != 0) {
                hm.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            hm.put(TextAttribute.FOREGROUND, FontColor);
            hm.put(TextAttribute.SIZE, Height);
            if (WidthScale != 1.0 || this.tmpAngle != 0.0) {
                AffineTransform at = new AffineTransform();
                if (this.tmpAngle != 0.0) {
                    at.rotate(this.tmpAngle * Math.PI / 180.0);
                }
                if (WidthScale != 1.0 && WidthScale != 0.0) {
                    at.scale(WidthScale, 1.0);
                }
                hm.put(TextAttribute.TRANSFORM, at);
            }
            this.tmpFontName = FontName2;
            this.tmpFontStyle = FontStyle2;
            this.tmpFontColor = FontColor;
            this.tmpFontHeight = Height;
            this.tmpFontWidthScale = WidthScale;
            this.tmpFontAngle = this.tmpAngle;
            this.tmpFont = new Font(hm);
        }
        return this.tmpFont;
    }

    public void InitTmpProps() {
        this.tmpLayer = null;
        this.tmpAngle = 0.0;
        this.tmpPenPattern = 0;
        this.tmpLWidth = 0.0;
        this.tmpFont = null;
        this.tmpFontName = "Arial";
        this.tmpFontStyle = 0;
        this.tmpFontColor = Color.BLACK;
        this.tmpFontHeight = 0.0;
        this.tmpFontWidthScale = 1.0;
        this.tmpFontAngle = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTmpLayer(double layerID) {
        if (this.tmpLayer == null || this.tmpLayer.ID != layerID) {
            this.tmpLayer = null;
            if (layerID != 0.0) {
                SchemeObject LayerObject = this.s.schemeObjects.get(layerID);
                if (LayerObject != null) {
                    SchemeObject schemeObject = LayerObject;
                    synchronized (schemeObject) {
                        this.tmpLayer = (PhxLayer)LayerObject.BG;
                    }
                } else {
                    Core.logger.info("SchemeEngine.setTmpLayer: not found layer by ID {}. Raster(s:{},l:{},x:{},y:{},z:{})", layerID, this.s.getSchemeId(), this.LayersConfig, this.TailX, this.TailY, this.TailZ);
                }
            }
        }
    }

    public String getLayersConfig() {
        return this.LayersConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paint(Graphics2D g2d, int CallCount) throws IllegalAccessException, InstantiationException {
        if (g2d != null) {
            SchemeObject schemeObject;
            this.InitTmpProps();
            g2d.setColor(this.s.BkColor);
            g2d.fillRect(0, 0, this.ImageWidth, this.ImageHeight);
            if (!this.UseGTM) {
                g2d.transform(this.VTM);
            }
            List<SchemeObject> SShapes = this.s.SortShapes;
            if (!this.s.KeepSort) {
                SShapes = new ArrayList<SchemeObject>();
                Iterator it = this.s.schemeObjects.iterator();
                while (it.hasNext()) {
                    SchemeObject i;
                    schemeObject = i = (SchemeObject)it.next();
                    synchronized (schemeObject) {
                        if (!i.isDeleted() && SchemeObjectsTypes.ObjTypeIsShape(i.getType()) && i.BG != null && this.ShapeInCell(i.BG)) {
                            SShapes.add(i);
                        }
                    }
                }
                Collections.sort(SShapes, CMP);
            }
            SchemeObject i = null;
            for (int j = 0; j < SShapes.size(); ++j) {
                i = SShapes.get(j);
                if (i == null) {
                    Core.logger.info("SchemeEngine.Paint: not found object by index {}. Raster(s:{},l:{},x:{},y:{},z:{},call:{})", j, this.s.getSchemeId(), this.LayersConfig, this.TailX, this.TailY, this.TailZ, CallCount);
                    continue;
                }
                schemeObject = i;
                synchronized (schemeObject) {
                    if (i.BG == null) {
                        Core.logger.info("SchemeEngine.Paint: object {} not parsed. Rraster(s:{},l:{},x:{},y:{},z:{},call:{})", i.getID(), this.s.getSchemeId(), this.LayersConfig, this.TailX, this.TailY, this.TailZ, CallCount);
                    }
                    if (i.BG != null && (!this.s.KeepSort || this.ShapeInCell(i.BG))) {
                        this.setTmpLayer(i.BG.LayerID);
                        i.BG.paint(g2d, this);
                    }
                    continue;
                }
            }
        }
    }
}

