/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.MtdEngine;
import inform.agent.schemes.DxfWriter;
import inform.agent.schemes.MifWriter;
import inform.agent.schemes.OdgWriter;
import inform.agent.schemes.PdfWriter;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemesManager;
import inform.agent.schemes.SvgWriter;
import inform.agent.schemes.VsdxWriter;
import inform.agent.srv.ProxyConverterService;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;

public class SchemeExportRequest
extends Request {
    public SchemeExportRequest(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        byte[] Content2;
        TaggedReader reqReader = this.createRequestContentReader();
        ConnectionManager dbMgr = new ConnectionManager(null, "rq:SchemeExportRequest");
        try {
            this.putRequestStateText("\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u0445\u0435\u043c\u044b");
            Content2 = this.exportScheme(dbMgr, reqReader);
        }
        finally {
            dbMgr.release();
        }
        this.putRequestStateText("\u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430");
        if (Content2 != null) {
            this.sendResult(Content2);
        } else {
            this.sendResult();
        }
    }

    private byte[] exportScheme(ConnectionManager dbMgr, TaggedReader reqReader) throws InformException, IOException, TaggedReaderException, Exception {
        Scheme scheme = null;
        byte[] content = null;
        if (!reqReader.next()) {
            return null;
        }
        if (reqReader.getCurrentTag() == 103) {
            if (!reqReader.next()) {
                return null;
            }
            content = reqReader.getRaw();
            if (content == null || content.length == 0) {
                return null;
            }
            SchemeKeepSettings keepSettings = null;
            if (reqReader.getNextTag() == 49) {
                keepSettings = new SchemeKeepSettings(reqReader.getSubStreamReader());
                if (!reqReader.next()) {
                    return null;
                }
            }
            scheme = SchemesManager.getScheme(this.getNodeID(), content, dbMgr.getSSHost(), keepSettings);
        } else {
            if (reqReader.getCurrentTag() == 1) {
                byte[] locationData = new byte[20];
                reqReader.get(1, locationData, locationData.length);
                double tableID = LittleEndian.getDouble(locationData, 0);
                double recordID = LittleEndian.getDouble(locationData, 8);
                int fieldID = LittleEndian.getInt(locationData, 16);
                SchemeKeepSettings keepSettings = null;
                int dateFieldID = 0;
                if (reqReader.getNextTag() == 49) {
                    keepSettings = new SchemeKeepSettings(reqReader.getSubStreamReader());
                    dateFieldID = keepSettings.getSchemeDate();
                    if (!reqReader.next()) {
                        return null;
                    }
                }
                scheme = SchemesManager.getScheme(null, dbMgr, tableID, recordID, fieldID, dateFieldID, false, true, keepSettings);
            } else if (this.getNodeID() > 0.0 && !Ini.libraryMode) {
                scheme = SchemesManager.getScheme(MtdEngine.getValidNode(this.getNodeID()).getRealNode(), false, dbMgr.getSSHost(), null);
            }
            if (scheme == null || scheme.getRevision().get() <= 0 || !scheme.schemeOrdered()) {
                return null;
            }
        }
        if (reqReader.getCurrentTag() != 102) {
            return null;
        }
        int ext = reqReader.getInt();
        if (reqReader.getNextTag() == 106) {
            scheme.exportPageId = reqReader.getDouble();
        }
        this.putRequestStateText("\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        switch (ext) {
            case 0: {
                scheme.saveAll(out, null, true, false);
                break;
            }
            case 1: {
                DxfWriter dxfWriter = new DxfWriter(scheme);
                dxfWriter.saveToStream(dbMgr, out);
                break;
            }
            case 2: {
                SvgWriter svgWriter = new SvgWriter(scheme);
                svgWriter.saveToStream(dbMgr, out);
                break;
            }
            case 3: {
                PdfWriter pdfWriter = new PdfWriter(scheme);
                pdfWriter.saveToStream(dbMgr, out);
                break;
            }
            case 4: {
                MifWriter mifWriter = new MifWriter(scheme);
                mifWriter.saveToStream(dbMgr, out);
                break;
            }
            case 5: {
                VsdxWriter vsdxWriter = new VsdxWriter(scheme);
                vsdxWriter.saveToStream(dbMgr, out);
                break;
            }
            case 7: {
                VsdxWriter vsdxConverter = new VsdxWriter(scheme);
                vsdxConverter.saveToStream(dbMgr, out);
                return ProxyConverterService.convertVSDXtoVSD(this, out.toByteArray());
            }
            case 8: {
                SvgWriter svgzWriter = new SvgWriter(scheme);
                svgzWriter.saveToStream(dbMgr, new GZIPOutputStream(out));
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                OdgWriter odfWriter = new OdgWriter(scheme);
                odfWriter.saveToStream(dbMgr, out, ext == 15);
                break;
            }
            default: {
                throw new InformException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442(" + ext + ") \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0441\u0445\u0435\u043c\u044b");
            }
        }
        return out.toByteArray();
    }
}

