/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import java.io.IOException;
import java.util.ArrayList;

public class SchemeKeepSettings {
    private double schemeTable = 0.0;
    private int schemeBlob = 0;
    private int schemeName;
    private int schemeDist = 0;
    private int schemeDate = 0;
    private double table = 0.0;
    private int geometry = 0;
    private int geometryLrs = 0;
    private int shapeData = 0;
    private int shapeID = 0;
    private int shapeType = 0;
    private int lastModificationDate = 0;
    private int lastModificationAuthor = 0;
    private int shapeOrder = 0;
    private int schemeID = 0;
    private int layerID = 0;
    private int revision = 0;
    private int parentID = 0;
    private int precendingID = 0;
    private int caption = 0;
    private double primLibTable = 0.0;
    private int primLibID = 0;
    private int primLibName;
    private int primLibBlob = 0;
    private double primTable = 0.0;
    private int primID = 0;
    private int primName;
    private int primLib = 0;
    private int primBlob = 0;
    private int primParent = 0;
    private int primFolder = 0;
    private int primOrder = 0;
    private double marksTable = 0.0;
    private int markData = 0;
    private int markID = 0;
    private int markType = 0;
    private int markLastModificationDate = 0;
    private int markLastModificationAuthor = 0;
    private int markSchemeID = 0;
    private int markCaption = 0;
    TableDescriptor tableDesc = null;
    FieldDescriptor primaryKeyFieldDesc = null;
    FieldDescriptor geometryFieldDesc = null;
    FieldDescriptor geometryLrsFieldDesc = null;
    FieldDescriptor lastModificationAuthorFieldDesc = null;
    FieldDescriptor lastModificationDateFieldDesc = null;
    FieldDescriptor layerIDFieldDesc = null;
    FieldDescriptor schemeIDFieldDesc = null;
    FieldDescriptor shapeDataFieldDesc = null;
    FieldDescriptor shapeIDFieldDesc = null;
    FieldDescriptor shapeOrderFieldDesc = null;
    FieldDescriptor shapeTypeFieldDesc = null;
    FieldDescriptor revisionFieldDesc = null;
    FieldDescriptor parentIDFieldDesc = null;
    FieldDescriptor precendingIDFieldDesc = null;
    FieldDescriptor captionFieldDesc = null;
    public static final String WRONG_KEEP_SETTINGS_ERROR = "\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c\u044b";
    public static final String WRONG_KEEP_FIELDS = "\u0421\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442 \u043d\u0435\u0441\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043f\u043e\u043b\u044f \u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c\u044b";

    public SchemeKeepSettings(TaggedReader reader) throws IOException, TaggedReaderException, InformException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 65: {
                    this.schemeTable = reader.getDouble();
                    break;
                }
                case 16: {
                    this.schemeTable = reader.getNodeID();
                    break;
                }
                case 17: 
                case 66: {
                    this.schemeBlob = reader.getInt();
                    break;
                }
                case 18: 
                case 67: {
                    this.schemeName = reader.getInt();
                    break;
                }
                case 19: 
                case 68: {
                    this.schemeDist = reader.getInt();
                    break;
                }
                case 31: 
                case 80: {
                    this.schemeDate = reader.getInt();
                    break;
                }
                case 50: {
                    this.table = reader.getDouble();
                    break;
                }
                case 1: {
                    this.table = reader.getNodeID();
                    break;
                }
                case 2: 
                case 51: {
                    this.geometry = reader.getInt();
                    break;
                }
                case 3: 
                case 52: {
                    this.shapeData = reader.getInt();
                    break;
                }
                case 4: 
                case 53: {
                    this.shapeID = reader.getInt();
                    break;
                }
                case 5: 
                case 54: {
                    this.shapeType = reader.getInt();
                    break;
                }
                case 6: 
                case 55: {
                    this.lastModificationDate = reader.getInt();
                    break;
                }
                case 7: 
                case 56: {
                    this.lastModificationAuthor = reader.getInt();
                    break;
                }
                case 8: 
                case 57: {
                    this.shapeOrder = reader.getInt();
                    break;
                }
                case 9: 
                case 58: {
                    this.schemeID = reader.getInt();
                    break;
                }
                case 10: 
                case 59: {
                    this.layerID = reader.getInt();
                    break;
                }
                case 11: 
                case 60: {
                    this.revision = reader.getInt();
                    break;
                }
                case 12: 
                case 61: {
                    this.parentID = reader.getInt();
                    break;
                }
                case 13: 
                case 62: {
                    this.precendingID = reader.getInt();
                    break;
                }
                case 14: 
                case 63: {
                    this.caption = reader.getInt();
                    break;
                }
                case 15: 
                case 64: {
                    this.geometryLrs = reader.getInt();
                    break;
                }
                case 69: {
                    this.primLibTable = reader.getDouble();
                    break;
                }
                case 20: {
                    this.primLibTable = reader.getNodeID();
                    break;
                }
                case 21: 
                case 70: {
                    this.primLibID = reader.getInt();
                    break;
                }
                case 22: 
                case 71: {
                    this.primLibName = reader.getInt();
                    break;
                }
                case 23: 
                case 72: {
                    this.primLibBlob = reader.getInt();
                    break;
                }
                case 73: {
                    this.primTable = reader.getDouble();
                    break;
                }
                case 24: {
                    this.primTable = reader.getNodeID();
                    break;
                }
                case 25: 
                case 74: {
                    this.primID = reader.getInt();
                    break;
                }
                case 26: 
                case 75: {
                    this.primName = reader.getInt();
                    break;
                }
                case 27: 
                case 76: {
                    this.primLib = reader.getInt();
                    break;
                }
                case 28: 
                case 77: {
                    this.primBlob = reader.getInt();
                    break;
                }
                case 29: 
                case 78: {
                    this.primParent = reader.getInt();
                    break;
                }
                case 30: 
                case 79: {
                    this.primFolder = reader.getInt();
                    break;
                }
                case 32: 
                case 81: {
                    this.primOrder = reader.getInt();
                    break;
                }
                case 82: {
                    this.marksTable = reader.getDouble();
                    break;
                }
                case 33: {
                    this.marksTable = reader.getNodeID();
                    break;
                }
                case 34: 
                case 83: {
                    this.markData = reader.getInt();
                    break;
                }
                case 35: 
                case 84: {
                    this.markID = reader.getInt();
                    break;
                }
                case 36: 
                case 85: {
                    this.markType = reader.getInt();
                    break;
                }
                case 37: 
                case 86: {
                    this.markLastModificationDate = reader.getInt();
                    break;
                }
                case 38: 
                case 87: {
                    this.markLastModificationAuthor = reader.getInt();
                    break;
                }
                case 39: 
                case 88: {
                    this.markSchemeID = reader.getInt();
                    break;
                }
                case 40: 
                case 89: {
                    this.markCaption = reader.getInt();
                }
            }
        }
        if (this.checkKeepSettingsFields()) {
            this.tableDesc = TableDescriptor.getIfExists(this.table);
            if (this.tableDesc == null || this.tableDesc.getRecordIdField() == null) {
                throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u043b\u0435\u043d\u043e\u0433\u043e \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c\u044b");
            }
            ArrayList<FieldDescriptor> primaryFields = this.tableDesc.getPrimaryKeyFields();
            if (primaryFields.size() < 1) {
                throw new InformException("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u043b\u0435\u043d\u043e\u0433\u043e \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c\u044b \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447");
            }
            this.primaryKeyFieldDesc = primaryFields.get(0);
            if (this.geometry != 0) {
                this.geometryFieldDesc = this.tableDesc.getFieldDescriptor(this.geometry);
            }
            if (this.geometryLrs != 0) {
                this.geometryLrsFieldDesc = this.tableDesc.getFieldDescriptor(this.geometryLrs);
            }
        } else {
            throw new InformException(WRONG_KEEP_FIELDS);
        }
        this.lastModificationAuthorFieldDesc = this.tableDesc.getFieldDescriptor(this.lastModificationAuthor);
        this.lastModificationDateFieldDesc = this.tableDesc.getFieldDescriptor(this.lastModificationDate);
        this.layerIDFieldDesc = this.tableDesc.getFieldDescriptor(this.layerID);
        this.schemeIDFieldDesc = this.tableDesc.getFieldDescriptor(this.schemeID);
        this.shapeDataFieldDesc = this.tableDesc.getFieldDescriptor(this.shapeData);
        this.shapeIDFieldDesc = this.tableDesc.getFieldDescriptor(this.shapeID);
        this.shapeOrderFieldDesc = this.tableDesc.getFieldDescriptor(this.shapeOrder);
        this.shapeTypeFieldDesc = this.tableDesc.getFieldDescriptor(this.shapeType);
        this.revisionFieldDesc = this.tableDesc.getFieldDescriptor(this.revision);
        this.parentIDFieldDesc = this.tableDesc.getFieldDescriptor(this.parentID);
        this.precendingIDFieldDesc = this.tableDesc.getFieldDescriptor(this.precendingID);
        this.captionFieldDesc = this.tableDesc.getFieldDescriptor(this.caption);
    }

    private boolean checkKeepSettingsFields() {
        return this.table != 0.0 && this.shapeData != 0 && this.shapeID != 0 && this.shapeType != 0 && this.lastModificationDate != 0 && this.lastModificationAuthor != 0 && this.shapeOrder != 0 && this.schemeID != 0 && this.layerID != 0 && this.revision != 0;
    }

    public void store(TaggedWriter writer) throws IOException {
        if (this.schemeTable != 0.0) {
            writer.putDouble(65, this.schemeTable);
        }
        if (this.schemeBlob != 0) {
            writer.putInt32(66, this.schemeBlob);
        }
        if (this.schemeName != 0) {
            writer.putInt32(67, this.schemeName);
        }
        if (this.schemeDist != 0) {
            writer.putInt32(68, this.schemeDist);
        }
        if (this.schemeDate != 0) {
            writer.putInt32(80, this.schemeDate);
        }
        writer.putDouble(50, this.table);
        if (this.geometry != 0) {
            writer.putInt32(51, this.geometry);
        }
        writer.putInt32(52, this.shapeData);
        writer.putInt32(53, this.shapeID);
        writer.putInt32(54, this.shapeType);
        writer.putInt32(55, this.lastModificationDate);
        writer.putInt32(56, this.lastModificationAuthor);
        writer.putInt32(57, this.shapeOrder);
        writer.putInt32(58, this.schemeID);
        writer.putInt32(59, this.layerID);
        writer.putInt32(60, this.revision);
        writer.putInt32(61, this.parentID);
        writer.putInt32(62, this.precendingID);
        writer.putInt32(63, this.caption);
        if (this.geometryLrs != 0) {
            writer.putInt32(64, this.geometryLrs);
        }
        if (this.primLibTable != 0.0) {
            writer.putDouble(69, this.primLibTable);
        }
        if (this.primLibID != 0) {
            writer.putInt32(70, this.primLibID);
        }
        if (this.primLibName != 0) {
            writer.putInt32(71, this.primLibName);
        }
        if (this.primLibBlob != 0) {
            writer.putInt32(72, this.primLibBlob);
        }
        if (this.primTable != 0.0) {
            writer.putDouble(73, this.primTable);
        }
        if (this.primID != 0) {
            writer.putInt32(74, this.primID);
        }
        if (this.primName != 0) {
            writer.putInt32(75, this.primName);
        }
        if (this.primLib != 0) {
            writer.putInt32(76, this.primLib);
        }
        if (this.primBlob != 0) {
            writer.putInt32(77, this.primBlob);
        }
        if (this.primParent != 0) {
            writer.putInt32(78, this.primParent);
        }
        if (this.primFolder != 0) {
            writer.putInt32(79, this.primFolder);
        }
        if (this.primOrder != 0) {
            writer.putInt32(81, this.primOrder);
        }
        if (this.marksTable != 0.0) {
            writer.putDouble(82, this.marksTable);
        }
        if (this.markData != 0) {
            writer.putInt32(83, this.markData);
        }
        if (this.markID != 0) {
            writer.putInt32(84, this.markID);
        }
        if (this.markType != 0) {
            writer.putInt32(85, this.markType);
        }
        if (this.markLastModificationDate != 0) {
            writer.putInt32(86, this.markLastModificationDate);
        }
        if (this.markLastModificationAuthor != 0) {
            writer.putInt32(87, this.markLastModificationAuthor);
        }
        if (this.markSchemeID != 0) {
            writer.putInt32(88, this.markSchemeID);
        }
        if (this.markCaption != 0) {
            writer.putInt32(89, this.markCaption);
        }
    }

    public double getSchemeTable() {
        return this.schemeTable;
    }

    public void setSchemeTable(double Value2) {
        this.schemeTable = Value2;
    }

    public int getSchemeBlob() {
        return this.schemeBlob;
    }

    public void setSchemeBlob(int Value2) {
        this.schemeBlob = Value2;
    }

    public int getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(int Value2) {
        this.schemeName = Value2;
    }

    public int getSchemeDist() {
        return this.schemeDist;
    }

    public void setSchemeDist(int Value2) {
        this.schemeDist = Value2;
    }

    public int getSchemeDate() {
        return this.schemeDate;
    }

    public void setSchemeDate(int Value2) {
        this.schemeDate = Value2;
    }

    public int getGeometry() {
        return this.geometry;
    }

    public int getLastModificationAuthor() {
        return this.lastModificationAuthor;
    }

    public int getLastModificationDate() {
        return this.lastModificationDate;
    }

    public int getLayerID() {
        return this.layerID;
    }

    public int getSchemeID() {
        return this.schemeID;
    }

    public int getShapeData() {
        return this.shapeData;
    }

    public int getShapeID() {
        return this.shapeID;
    }

    public int getShapeOrder() {
        return this.shapeOrder;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public double getTable() {
        return this.table;
    }

    public int getParentID() {
        return this.parentID;
    }

    public int getPrecendingID() {
        return this.precendingID;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getCaption() {
        return this.caption;
    }

    public void setCaption(int NewCaption) {
        this.caption = NewCaption;
        if (this.captionFieldDesc == null) {
            this.captionFieldDesc = this.tableDesc.getFieldDescriptor(this.caption);
        }
    }

    public double getPrimLibTable() {
        return this.primLibTable;
    }

    public void setPrimLibTable(double Value2) {
        this.primLibTable = Value2;
    }

    public int getPrimLibID() {
        return this.primLibID;
    }

    public void setPrimLibID(int Value2) {
        this.primLibID = Value2;
    }

    public int getPrimLibName() {
        return this.primLibName;
    }

    public void setPrimLibName(int Value2) {
        this.primLibName = Value2;
    }

    public int getPrimLibBlob() {
        return this.primLibBlob;
    }

    public void setPrimLibBlob(int Value2) {
        this.primLibBlob = Value2;
    }

    public double getPrimTable() {
        return this.primTable;
    }

    public void setPrimTable(double Value2) {
        this.primTable = Value2;
    }

    public int getPrimID() {
        return this.primID;
    }

    public void setPrimID(int Value2) {
        this.primID = Value2;
    }

    public int getPrimName() {
        return this.primName;
    }

    public void setPrimName(int Value2) {
        this.primName = Value2;
    }

    public int getPrimLib() {
        return this.primLib;
    }

    public void setPrimLib(int Value2) {
        this.primLib = Value2;
    }

    public int getPrimBlob() {
        return this.primBlob;
    }

    public void setPrimBlob(int Value2) {
        this.primBlob = Value2;
    }

    public int getPrimParent() {
        return this.primParent;
    }

    public void setPrimParent(int Value2) {
        this.primParent = Value2;
    }

    public int getPrimFolder() {
        return this.primFolder;
    }

    public void setPrimFolder(int Value2) {
        this.primFolder = Value2;
    }

    public int getPrimOrder() {
        return this.primOrder;
    }

    public void setPrimOrder(int Value2) {
        this.primOrder = Value2;
    }

    public double getMarksTable() {
        return this.marksTable;
    }

    public void setMarksTable(double Value2) {
        this.marksTable = Value2;
    }

    public int getMarkData() {
        return this.markData;
    }

    public void setMarkData(int Value2) {
        this.markData = Value2;
    }

    public int getMarkID() {
        return this.markID;
    }

    public void setMarkID(int Value2) {
        this.markID = Value2;
    }

    public int getMarkType() {
        return this.markType;
    }

    public void setMarkType(int Value2) {
        this.markType = Value2;
    }

    public int getMarkLastModificationDate() {
        return this.markLastModificationDate;
    }

    public void setMarkLastModificationDate(int Value2) {
        this.markLastModificationDate = Value2;
    }

    public int getMarkLastModificationAuthor() {
        return this.markLastModificationAuthor;
    }

    public void setMarkLastModificationAuthor(int Value2) {
        this.markLastModificationAuthor = Value2;
    }

    public int getMarkSchemeID() {
        return this.markSchemeID;
    }

    public void setMarkSchemeID(int Value2) {
        this.markSchemeID = Value2;
    }

    public int getMarkCaption() {
        return this.markCaption;
    }

    public void setMarkCaption(int Value2) {
        this.markCaption = Value2;
    }

    public FieldDescriptor getGeometryFieldDesc() {
        return this.geometryFieldDesc;
    }

    public FieldDescriptor getGeometryLrsFieldDesc() {
        return this.geometryLrsFieldDesc;
    }

    public FieldDescriptor getLastModificationAuthorFieldDesc() {
        return this.lastModificationAuthorFieldDesc;
    }

    public FieldDescriptor getLastModificationDateFieldDesc() {
        return this.lastModificationDateFieldDesc;
    }

    public FieldDescriptor getLayerIDFieldDesc() {
        return this.layerIDFieldDesc;
    }

    public FieldDescriptor getParentIDFieldDesc() {
        return this.parentIDFieldDesc;
    }

    public FieldDescriptor getPrecendingIDFieldDesc() {
        return this.precendingIDFieldDesc;
    }

    public FieldDescriptor getPrimaryKeyFieldDesc() {
        return this.primaryKeyFieldDesc;
    }

    public FieldDescriptor getRevisionFieldDesc() {
        return this.revisionFieldDesc;
    }

    public FieldDescriptor getSchemeIDFieldDesc() {
        return this.schemeIDFieldDesc;
    }

    public FieldDescriptor getShapeDataFieldDesc() {
        return this.shapeDataFieldDesc;
    }

    public FieldDescriptor getShapeIDFieldDesc() {
        return this.shapeIDFieldDesc;
    }

    public FieldDescriptor getShapeOrderFieldDesc() {
        return this.shapeOrderFieldDesc;
    }

    public FieldDescriptor getShapeTypeFieldDesc() {
        return this.shapeTypeFieldDesc;
    }

    public FieldDescriptor getCaptionFieldDesc() {
        return this.captionFieldDesc;
    }

    public TableDescriptor getTableDesc() {
        return this.tableDesc;
    }
}

