/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.NumberConverter;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.oracle.Geometry;
import inform.agent.db.types.Geometry;
import inform.agent.db.types.SqlDataType;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.NoSuchObjectException;
import inform.agent.schemes.SaveSchemeObjectCommand;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeKeepSettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import oracle.spatial.geometry.JGeometry;

public class SchemeObject
implements DoubleHash.Entry {
    private double recordID;
    private double id;
    private int type;
    private byte[] params;
    private int revision;
    private boolean deleted;
    private boolean added;
    private double parentID;
    private double followingID;
    private double precedingID;
    private long lockOwner;
    private double lastModUser;
    private double lastModTime;
    private double layerID;
    private Geometry geometry;
    private Geometry geometryLrs;
    private String caption;
    private boolean modified = false;
    private int order;
    private SaveSchemeObjectCommand saveCommand = SaveSchemeObjectCommand.ADD;
    private static final int SOC_POSITION = 1;
    private static final int SOC_PARAMS = 2;
    private static final int SOC_ACL = 4;
    private static final int SOC_DELETE = 8;
    private static final int SOC_PARENT = 16;
    private static final int SOC_LAYER = 32;
    private static final int SOC_ORDER = 64;
    private long flags;
    private long ownerHandle;
    private int lockCount;
    public BaseGraphic BG;
    public boolean BGChanged = false;

    public SchemeObject(double id, int type) {
        this.id = id;
        this.type = type;
    }

    protected SchemeObject() {
    }

    public String toString() {
        return "SchemeObject{type:" + this.type + " id:" + NumberConverter.doubleToString(this.id) + "}";
    }

    public synchronized void lock(long handle) throws InterruptedException {
        while (this.ownerHandle != handle && this.ownerHandle != 0L) {
            this.wait();
        }
        if (this.ownerHandle == 0L) {
            this.ownerHandle = handle;
        }
        ++this.lockCount;
    }

    public synchronized void unlock(long handle) {
        if (this.ownerHandle == handle && --this.lockCount == 0) {
            this.ownerHandle = 0L;
            this.notify();
        }
    }

    public synchronized long getLockOwner() {
        return this.lockOwner;
    }

    public byte[] getParams() {
        return this.params;
    }

    public void setParams(byte[] params) {
        if (!Arrays.equals(params, this.params)) {
            this.params = params;
            this.modified = true;
        }
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        if (revision != this.revision) {
            this.revision = revision;
            this.modified = true;
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isPositionChanged() {
        return (this.flags & 1L) != 0L;
    }

    public boolean isContentChanged() {
        return (this.flags & 2L) != 0L;
    }

    public boolean isAclChanged() {
        return (this.flags & 4L) != 0L;
    }

    public boolean isParentChanged() {
        return (this.flags & 0x10L) != 0L;
    }

    public boolean isLayerChanged() {
        return (this.flags & 0x20L) != 0L;
    }

    public boolean isOrderChanged() {
        return (this.flags & 0x40L) != 0L;
    }

    public void setDeleted(boolean deleted) {
        if (deleted != this.deleted) {
            this.deleted = deleted;
            this.modified = true;
        }
    }

    public void setAdded(boolean added) {
        if (added != this.added) {
            this.added = added;
        }
    }

    public double getParentID() {
        return this.parentID;
    }

    public void setParentID(double parentID) {
        if (parentID != this.parentID) {
            this.parentID = parentID;
            this.modified = true;
        }
    }

    public double getLayerID() {
        return this.layerID;
    }

    public void setLayerID(double layerID) {
        if (layerID != this.layerID) {
            this.layerID = layerID;
            this.modified = true;
        }
    }

    public double getFollowingID() {
        return this.followingID;
    }

    public void setFollowingID(double followingID) {
        if (this.followingID != followingID) {
            this.followingID = followingID;
            this.modified = true;
        }
    }

    public double getPrecedingID() {
        return this.precedingID;
    }

    public void setPrecedingID(double precedingID) {
        if (this.precedingID != precedingID) {
            this.precedingID = precedingID;
            this.modified = true;
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        if (this.order != order) {
            this.order = order;
            this.modified = true;
        }
    }

    public static SchemeObject readObject(TaggedReader reader, Scheme scheme) throws IOException, TaggedReaderException, NoSuchObjectException {
        if (reader.getCurrentTag() != 20) {
            reader.skipNextTag();
            reader.get(20);
        }
        SchemeObject o = new SchemeObject();
        o.fillParamsFromReader(reader, scheme);
        o.flags = 0L;
        return o;
    }

    public static SchemeObject readObjectFromTable(ResultSet row, Scheme scheme) throws IOException, NoSuchObjectException, SQLException {
        SchemeObject o = new SchemeObject();
        int nextIdx = 1;
        o.recordID = row.getDouble(nextIdx++);
        o.params = row.getBlobBytes(nextIdx++);
        o.id = row.getDouble(nextIdx++);
        o.type = row.getInt(nextIdx++);
        o.lastModTime = row.getDateTime(nextIdx++);
        o.lastModUser = row.getDouble(nextIdx++);
        o.order = row.getInt(nextIdx++);
        o.layerID = row.getDouble(nextIdx++);
        o.revision = row.getInt(nextIdx++);
        if (scheme.getKeepSettings() != null) {
            if (scheme.getKeepSettings().getGeometryFieldDesc() != null) {
                o.geometry = row.getGeometry(nextIdx++);
            }
            if (scheme.getKeepSettings().getGeometryLrsFieldDesc() != null) {
                o.geometryLrs = row.getGeometry(nextIdx++);
            }
        }
        o.flags = 0L;
        return o;
    }

    public static SchemeObject readDescriptor(TaggedReader reader, Scheme scheme) throws IOException, TaggedReaderException, NoSuchObjectException {
        if (reader.getCurrentTag() != 20) {
            reader.takeNextTag();
            reader.get(20);
        }
        SchemeObject o = new SchemeObject();
        o.fillParamsFromReader(reader, scheme);
        return o;
    }

    private void fillParamsFromReader(TaggedReader reader, Scheme scheme) throws IOException, TaggedReaderException, NoSuchObjectException {
        int tag;
        double[] coords = null;
        int[] elements = null;
        do {
            tag = reader.getNextTag();
            switch (tag) {
                case 22: {
                    this.id = reader.getDouble();
                    break;
                }
                case 23: {
                    this.type = reader.getInt();
                    break;
                }
                case 24: {
                    this.params = reader.getSubStreamData();
                    this.flags |= 2L;
                    break;
                }
                case 25: {
                    this.revision = reader.getInt();
                    break;
                }
                case 26: {
                    break;
                }
                case 29: {
                    this.followingID = reader.getDouble();
                    this.flags |= 1L;
                    break;
                }
                case 30: {
                    this.precedingID = reader.getDouble();
                    this.flags |= 1L;
                    break;
                }
                case 36: {
                    this.order = reader.getInt();
                    this.flags |= 0x40L;
                    break;
                }
                case 31: {
                    this.parentID = reader.getDouble();
                    this.flags |= 0x10L;
                    break;
                }
                case 32: {
                    this.lastModUser = reader.getDouble();
                    break;
                }
                case 33: {
                    this.lastModTime = reader.getDouble();
                    break;
                }
                case 34: {
                    this.layerID = reader.getDouble();
                    this.flags |= 0x20L;
                    break;
                }
                case 35: {
                    coords = LittleEndian.toDoubleArray(reader.getSubStreamData());
                    break;
                }
                case 37: {
                    elements = LittleEndian.toIntArray(reader.getSubStreamData());
                    break;
                }
                case 38: {
                    this.caption = reader.getString();
                }
            }
        } while (tag != 21 && tag != 0);
        this.geometry = null;
        this.geometryLrs = null;
        if (coords != null) {
            if (scheme.getKeepSettings() != null && scheme.getKeepSettings().getGeometryFieldDesc() != null) {
                this.geometry = new Geometry.Old(this.createGeometryByCoords(coords, elements));
            }
            if (scheme.getKeepSettings() != null && scheme.getKeepSettings().getGeometryLrsFieldDesc() != null && this.type == 210 && this.params != null) {
                InputStream in = new ByteArrayInputStream(this.params);
                if (SchemeObject.isGZip(this.params)) {
                    in = new GZIPInputStream(in);
                }
                TaggedReader r = new TaggedReader(in);
                while (r.next()) {
                    if (r.getCurrentTag() != 120) continue;
                    double[] pikets = LittleEndian.toDoubleArray(r.getRaw());
                    double[] ords = SchemeObject.buildGeometry(pikets, coords);
                    JGeometry g = JGeometry.createLRSLinearLineString((double[])ords, (int)2, (int)0);
                    if (g == null) {
                        SchemeObject.checkPikets(pikets, this.id);
                        throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f " + JGeometry.class.getName() + " (\u043e\u0431\u044a\u0435\u043a\u0442:" + (long)this.id + ")");
                    }
                    this.geometryLrs = new Geometry.Old(g);
                }
            }
        }
    }

    private static boolean isGZip(byte[] data) {
        return data.length > 1 && data[0] == 31 && data[1] == -117;
    }

    private static void checkPikets(double[] pikets, double objId) {
        int l = pikets.length;
        if (l < 2) {
            return;
        }
        double last = pikets[1];
        double lastSign = last - pikets[0];
        for (int i = 2; i < l; ++i) {
            double p = pikets[i];
            double s = p - last;
            if (s * lastSign < 0.0) {
                throw new InformException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u0438\u043a\u0435\u0442\u043e\u0432 \u043d\u0435 \u043c\u043e\u043d\u043e\u0442\u043e\u043d\u043d\u044b (\u043e\u0431\u044a\u0435\u043a\u0442:" + (long)objId + ", \u0432\u0435\u0440\u0448\u0438\u043d\u0430:" + (i - 1) + ")");
            }
            last = p;
            lastSign = s;
        }
    }

    private static void interpolate(double[] ll, double[] pk, int c0, int c1, int a, int b, double[] out) {
        double la = ll[a];
        double pa = pk[a];
        double k = (pk[b] - pa) / (ll[b] - la);
        for (int i = c0; i < c1; ++i) {
            out[i * 3 + 2] = (ll[i] - la) * k + pa;
        }
    }

    private static double[] buildGeometry(double[] pikets, double[] coords) {
        if (coords == null) {
            return null;
        }
        if (coords.length % 2 != 0) {
            throw new IllegalArgumentException("Only 2D coordinates supported");
        }
        int pcount = coords.length / 2;
        int[] idxs = new int[pcount];
        int vcnt = 0;
        for (int i = 0; i < pcount && i < pikets.length; ++i) {
            if (Double.isNaN(pikets[i])) continue;
            idxs[vcnt++] = i;
        }
        if (vcnt == 0) {
            throw new IllegalArgumentException("No LRS values");
        }
        double[] result = new double[pcount * 3];
        if (vcnt == 1) {
            double v = pikets[idxs[0]];
            for (int i = 0; i < pcount; ++i) {
                result[i * 3 + 0] = coords[i * 2 + 0];
                result[i * 3 + 1] = coords[i * 2 + 1];
                result[i * 3 + 2] = v;
            }
        } else {
            int i;
            result[0] = coords[0];
            result[1] = coords[1];
            double[] ll = new double[pcount];
            for (i = 1; i < pcount; ++i) {
                double dx = coords[i * 2 + 0] - coords[(i - 1) * 2 + 0];
                double dy = coords[i * 2 + 1] - coords[(i - 1) * 2 + 1];
                ll[i] = ll[i - 1] + Math.sqrt(dx * dx + dy * dy);
                result[i * 3 + 0] = coords[i * 2 + 0];
                result[i * 3 + 1] = coords[i * 2 + 1];
            }
            if (vcnt == 2) {
                SchemeObject.interpolate(ll, pikets, 0, pcount, idxs[0], idxs[1], result);
            } else {
                if (idxs[0] != 0) {
                    SchemeObject.interpolate(ll, pikets, 0, idxs[0], idxs[0], idxs[1], result);
                }
                result[idxs[0] * 3 + 2] = pikets[idxs[0]];
                for (i = 1; i < vcnt; ++i) {
                    result[idxs[i] * 3 + 2] = pikets[idxs[i]];
                    SchemeObject.interpolate(ll, pikets, idxs[i - 1] + 1, idxs[i], idxs[i - 1], idxs[i], result);
                }
                if (idxs[vcnt - 1] != pcount - 1) {
                    SchemeObject.interpolate(ll, pikets, idxs[vcnt - 1] + 1, pcount, idxs[vcnt - 2], idxs[vcnt - 1], result);
                }
            }
        }
        return result;
    }

    public void saveObject(TaggedWriter writer) throws IOException {
        writer.putEmpty(20);
        writer.putDouble(22, this.id);
        writer.putInt32(23, this.type);
        writer.putInt32(25, this.revision);
        writer.putDouble(32, this.lastModUser);
        writer.putDouble(33, this.lastModTime);
        if (this.params != null) {
            writer.putEmpty(24);
            writer.putRaw(202, this.params);
        }
        if (this.parentID != 0.0) {
            writer.putDouble(31, this.parentID);
        }
        writer.putInt32(36, this.order);
        writer.putEmpty(21);
    }

    public void addObjectToTable(DatabaseConnection conn, SchemeKeepSettings keepSettings, PreparedStatement stmt, double schemeId) throws SQLException, InformException {
        this.recordID = Core.generateId();
        int nextIdx = 1;
        stmt.setDouble(nextIdx++, this.recordID);
        stmt.setDouble(nextIdx++, this.lastModUser);
        stmt.setDateTime(nextIdx++, this.lastModTime);
        stmt.setDouble(nextIdx++, this.layerID);
        stmt.setDouble(nextIdx++, schemeId);
        if (this.params == null) {
            stmt.setNull(nextIdx++, SqlDataType.BLOB);
        } else {
            stmt.setBlob(nextIdx++, this.params);
        }
        stmt.setDouble(nextIdx++, this.id);
        stmt.setInt(nextIdx++, this.order);
        stmt.setInt(nextIdx++, this.type);
        stmt.setInt(nextIdx++, this.revision);
        if (this.caption != null) {
            stmt.setString(nextIdx++, this.caption);
        } else {
            stmt.setNull(nextIdx++, SqlDataType.STRING);
        }
        if (keepSettings.getGeometryFieldDesc() != null) {
            if (this.geometry == null) {
                stmt.setNull(nextIdx++, SqlDataType.GEOMETRY);
            } else {
                stmt.setGeometry(nextIdx++, this.geometry);
            }
        }
        if (keepSettings.getGeometryLrsFieldDesc() != null) {
            if (this.geometryLrs == null) {
                stmt.setNull(nextIdx++, SqlDataType.GEOMETRY);
            } else {
                stmt.setGeometry(nextIdx++, this.geometryLrs);
            }
        }
        stmt.addBatch();
    }

    public void updateObjectAtTable(DatabaseConnection conn, SchemeKeepSettings keepSettings, PreparedStatement stmt, double schemeId) throws SQLException {
        int nextIdx = 1;
        stmt.setDouble(nextIdx++, this.lastModUser);
        stmt.setDateTime(nextIdx++, this.lastModTime);
        stmt.setDouble(nextIdx++, this.layerID);
        if (this.params == null) {
            stmt.setNull(nextIdx++, SqlDataType.BLOB);
        } else {
            stmt.setBlob(nextIdx++, this.params);
        }
        stmt.setInt(nextIdx++, this.order);
        stmt.setInt(nextIdx++, this.type);
        stmt.setInt(nextIdx++, this.revision);
        if (this.caption != null) {
            stmt.setString(nextIdx++, this.caption);
        } else {
            stmt.setNull(nextIdx++, SqlDataType.STRING);
        }
        if (keepSettings.getGeometryFieldDesc() != null) {
            if (this.geometry == null) {
                stmt.setNull(nextIdx++, SqlDataType.GEOMETRY);
            } else {
                stmt.setGeometry(nextIdx++, this.geometry);
            }
        }
        if (keepSettings.getGeometryLrsFieldDesc() != null) {
            if (this.geometryLrs == null) {
                stmt.setNull(nextIdx++, SqlDataType.GEOMETRY);
            } else {
                stmt.setGeometry(nextIdx++, this.geometryLrs);
            }
        }
        stmt.setDouble(nextIdx++, schemeId);
        stmt.setDouble(nextIdx++, this.id);
        stmt.addBatch();
    }

    public void saveDescriptor(TaggedWriter writer) throws IOException {
        writer.putEmpty(20);
        writer.putDouble(22, this.id);
        writer.putInt32(23, this.type);
        writer.putInt32(25, this.revision);
        writer.putDouble(32, this.lastModUser);
        writer.putDouble(33, this.lastModTime);
        if (this.params != null) {
            writer.putEmpty(24);
            writer.putRaw(202, this.params);
        }
        if (this.parentID != 0.0) {
            writer.putDouble(31, this.parentID);
        }
        if (this.deleted) {
            writer.putEmpty(27);
        }
        if (this.order == 0) {
            writer.putDouble(30, this.precedingID);
        }
        writer.putInt32(36, this.order);
        writer.putEmpty(21);
    }

    public double getRecordID() {
        return this.recordID;
    }

    public double getID() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int t) {
        if (this.type != t) {
            this.type = t;
            this.modified = true;
        }
    }

    @Override
    public double key() {
        return this.getID();
    }

    public double getLastModUser() {
        return this.lastModUser;
    }

    public void setLastModUser(double lastModUser) {
        if (this.lastModUser != lastModUser) {
            this.lastModUser = lastModUser;
            this.modified = true;
        }
    }

    public double getLastModTime() {
        return this.lastModTime;
    }

    public void setLastModTime(double lastModTime) {
        if (this.lastModTime != lastModTime) {
            this.lastModTime = lastModTime;
            this.modified = true;
        }
    }

    public SaveSchemeObjectCommand getSaveCommand() {
        return this.saveCommand;
    }

    public void setSaveCommand(SaveSchemeObjectCommand saveCommand) {
        this.saveCommand = saveCommand;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public Geometry getGeometryLrs() {
        return this.geometryLrs;
    }

    public void setGeometryLrs(Geometry geometry) {
        this.geometryLrs = geometry;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    private JGeometry createGeometryByCoords(double[] coords, int[] elements) {
        switch (this.type) {
            case 210: 
            case 212: {
                return JGeometry.createLinearLineString((double[])coords, (int)2, (int)0);
            }
            case 216: {
                int Count = coords.length;
                if (Count > 1 && coords[0] == coords[Count - 2] && coords[1] == coords[Count - 1]) {
                    return JGeometry.createLinearPolygon((double[])coords, (int)2, (int)0);
                }
                return JGeometry.createLinearLineString((double[])coords, (int)2, (int)0);
            }
            case 202: 
            case 206: 
            case 207: {
                int[] elems = null;
                int count = 0;
                if (elements != null) {
                    count = elements.length / 2;
                }
                if (count > 0) {
                    elems = new int[3 * count];
                    for (int i = 0; i < count; ++i) {
                        elems[3 * i] = 2 * elements[2 * i + 1] + 1;
                        elems[3 * i + 1] = elements[2 * i] == 210 || elements[2 * i] == 212 || elements[2 * i] == 216 ? 2 : 3;
                        elems[3 * i + 2] = 1;
                    }
                    if (count == 1) {
                        if (elems[1] == 3) {
                            return JGeometry.createLinearPolygon((double[])coords, (int)2, (int)0);
                        }
                        return JGeometry.createLinearLineString((double[])coords, (int)2, (int)0);
                    }
                    return new JGeometry(4, 0, elems, coords);
                }
                return JGeometry.createLinearPolygon((double[])coords, (int)2, (int)0);
            }
        }
        return JGeometry.createLinearPolygon((double[])coords, (int)2, (int)0);
    }
}

