/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.collections.DoubleHash;
import inform.agent.schemes.SchemePageLayout;
import inform.agent.schemes.SchemePageNotes;
import java.awt.Color;

public class SchemePage
implements DoubleHash.Entry {
    public static final int sp1to1000 = 0;
    public static final int sp1to500 = 1;
    public static final int sp1to200 = 2;
    public static final int sp1to100 = 3;
    public static final int sp1to50 = 4;
    public static final int sp1to25 = 5;
    public static final int sp1to20 = 6;
    public static final int sp1to10 = 7;
    public static final int sp1to5 = 8;
    public static final int sp1to2_5 = 9;
    public static final int sp1to2 = 10;
    public static final int sp1to1 = 11;
    public static final int sp10to1 = 12;
    public static final int sp20to1 = 13;
    public static final int sp50to1 = 14;
    public double SchemePageLeft = 0.0;
    public double SchemePageTop = 0.0;
    public double SchemePageRight = 0.0;
    public double SchemePageBottom = 0.0;
    public double SchemePageWidth = 0.0;
    public double SchemePageHeight = 0.0;
    public double basePageX;
    public double basePageY;
    public int i1x;
    public int i1y;
    public int i2x;
    public int i2y;
    private final double id;
    private String caption;
    private int order;
    public Color BkColor = Color.WHITE;
    public SchemePageLayout pageLayout = null;
    public SchemePageNotes pageNotes = null;
    public double backPageId = -1.0;
    public boolean isBackPage = false;
    public static double DEF_PAGE_ID = 1.0;
    private static final double DEFAULT_LINE_JUMP_SIZE = 2.0;
    public static int LINE_JUMP_TYPE_NONE = 0;
    public static int LINE_JUMP_TYPE_ARC = 1;
    public static int LINE_JUMP_TYPE_SQUARE = 2;
    public static int LINE_JUMP_TYPE_2SIDES = 3;
    public static int LINE_JUMP_TYPE_3SIDES = 4;
    public static int LINE_JUMP_TYPE_4SIDES = 5;
    public static int LINE_JUMP_TYPE_5SIDES = 6;
    public static int LINE_JUMP_TYPE_6SIDES = 7;
    public static int LINE_JUMP_TYPE_7SIDES = 8;
    public boolean LineJumpEnable = false;
    public double LineJumpSize = 2.0;
    public int LineJumpType = LINE_JUMP_TYPE_ARC;

    public SchemePage(double id, int order) {
        this.id = id;
        this.order = order;
    }

    public double getId() {
        return this.id;
    }

    public double getNormalizeId() {
        if (this.id == DEF_PAGE_ID) {
            return 0.0;
        }
        return this.id;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int value) {
        this.order = value;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String value) {
        this.caption = value;
    }

    public void calcPageDimensions(SchemePageLayout xPageLayoutSettings) {
        double distP;
        this.pageLayout = xPageLayoutSettings;
        double stepX = this.pageLayout.getPagePrintWidth();
        double stepY = this.pageLayout.getPagePrintHeight();
        double XY_TOLERANCE = 1.0E-8;
        if (stepX <= 0.0 || stepY <= 0.0) {
            return;
        }
        this.getBasePageXY();
        double dist = this.SchemePageLeft - this.basePageX;
        this.i1x = (int)(Math.abs(dist) / stepX + 0.5);
        if (dist < 0.0) {
            this.i1x *= -1;
        }
        if (Math.abs(dist - (distP = stepX * (double)this.i1x)) >= 1.0E-8 && distP > dist) {
            --this.i1x;
        }
        dist = this.SchemePageTop - this.basePageY;
        this.i1y = (int)(Math.abs(dist) / stepY + 0.5);
        if (dist < 0.0) {
            this.i1y *= -1;
        }
        if (Math.abs(dist - (distP = stepY * (double)this.i1y)) >= 1.0E-8 && distP > dist) {
            --this.i1y;
        }
        dist = this.SchemePageRight - this.basePageX;
        this.i2x = (int)(Math.abs(dist) / stepX + 0.5);
        if (dist < 0.0) {
            this.i2x *= -1;
        }
        if (Math.abs(dist - (distP = stepX * (double)this.i2x)) >= 1.0E-8) {
            if (distP > dist) {
                --this.i2x;
            }
        } else {
            --this.i2x;
            if (this.i2x < this.i1x) {
                this.i2x = this.i1x;
            }
        }
        dist = this.SchemePageBottom - this.basePageY;
        this.i2y = (int)(Math.abs(dist) / stepY + 0.5);
        if (dist < 0.0) {
            this.i2y *= -1;
        }
        if (Math.abs(dist - (distP = stepY * (double)this.i2y)) >= 1.0E-8) {
            if (distP > dist) {
                --this.i2y;
            }
        } else {
            --this.i2y;
            if (this.i2y < this.i1y) {
                this.i2y = this.i1y;
            }
        }
        ++this.i2x;
        ++this.i2y;
    }

    private void getBasePageXY() {
        if (this.usePageLayoutSettings() && !this.pageLayout.getFitOnPages()) {
            this.basePageX = this.pageLayout.getLeftField();
            this.basePageY = -this.pageLayout.getTopField();
        } else {
            this.basePageX = this.SchemePageLeft;
            this.basePageY = this.SchemePageTop;
        }
    }

    public boolean usePageLayoutSettings() {
        return this.pageLayout != null && this.pageLayout.getActive();
    }

    public int getPageHeight() {
        if (this.pageLayout == null) {
            return 0;
        }
        int y = this.i2y - this.i1y;
        int height = this.pageLayout.getHeight();
        int tbField = this.pageLayout.getBottomField() + this.pageLayout.getTopField();
        return height * y - tbField * (y - 1);
    }

    public int getPageWidth() {
        if (this.pageLayout == null) {
            return 0;
        }
        int x = this.i2x - this.i1x;
        int width = this.pageLayout.getWidth();
        int lrField = this.pageLayout.getLeftField() + this.pageLayout.getRightField();
        return width * x - lrField * (x - 1);
    }

    @Override
    public double key() {
        return this.id;
    }
}

