/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.MtdEngine;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemesManager;
import java.io.IOException;

public class SchemeSizeRequest
extends Request {
    public SchemeSizeRequest(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader reqReader = this.createRequestContentReader();
        byte[] Content2 = this.getSchemeSize(reqReader);
        if (Content2 != null) {
            this.sendResult(Content2);
        } else {
            this.sendResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getSchemeSize(TaggedReader reqReader) throws InformException, IOException, TaggedReaderException, Exception {
        byte[] Content2 = null;
        long schemeSize = 0L;
        double schemeDate = 0.0;
        if (this.getNodeID() > 0.0) {
            if (!Ini.libraryMode) {
                schemeSize = MtdEngine.getValidNode(this.getNodeID()).getRealNode().getContentSize();
            }
        } else {
            SchemeKeepSettings NewKeepSettings;
            byte[] locationData = new byte[20];
            reqReader.get(1, locationData, locationData.length);
            double tableID = LittleEndian.getDouble(locationData, 0);
            double recordID = LittleEndian.getDouble(locationData, 8);
            int fieldID = LittleEndian.getInt(locationData, 16);
            int dateFieldID = 0;
            reqReader.takeNextTag();
            if (reqReader.getCurrentTag() == 49 && (NewKeepSettings = new SchemeKeepSettings(reqReader.getSubStreamReader())) != null) {
                dateFieldID = NewKeepSettings.getSchemeDate();
            }
            ConnectionManager dbMgr = new ConnectionManager(null, "rq:SchemeSizeRequest");
            try {
                SchemesManager.SchemeSizeDate SizeDate = SchemesManager.getBlobSchemeSize(null, dbMgr, tableID, recordID, fieldID, dateFieldID);
                schemeSize = SizeDate.schemeSize;
                schemeDate = SizeDate.schemeDate;
            }
            finally {
                dbMgr.release();
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(out);
        writer.putInt32(15, (int)schemeSize);
        writer.putDouble(17, schemeDate);
        writer.flush();
        Content2 = out.toByteArray();
        return Content2;
    }
}

