/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.SchemeEngine;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;

public class Spline
extends Polyline {
    protected double[] cx = null;
    protected double[] cy = null;
    protected int pointsPerSegment = 30;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        if (Engine2.isNeedPen(this.PenPattern)) {
            Engine2.setActualPColor(g2d, this.pColor);
            Engine2.setActualPenStyle(g2d, this.PenPattern, this.lWidth);
            double[] Pts = null;
            Pts = Engine2.UseGTM ? Engine2.MulPoints(this.Points) : this.Points;
            int pcount = Pts.length / 2;
            int SegmCount = (pcount - 1) / 3;
            Path2D.Double shape = new Path2D.Double();
            ((Path2D)shape).moveTo(Pts[0], Pts[1]);
            int idx = 0;
            for (int i = 0; i < SegmCount; ++i) {
                idx = 2 * (3 * i + 1);
                ((Path2D)shape).curveTo(Pts[idx], Pts[idx + 1], Pts[idx + 2], Pts[idx + 3], Pts[idx + 4], Pts[idx + 5]);
            }
            g2d.draw(shape);
        }
    }

    protected int polyCountsCount() {
        return 1;
    }

    protected int getSectionIndex(int segmIdx) {
        return 0;
    }

    protected void calcCoefSpline() {
        if (this.cx != null && this.cy != null) {
            return;
        }
        int count = this.Points.length / 2;
        int ns = (count - this.polyCountsCount()) / 3;
        this.cx = new double[4 * ns];
        this.cy = new double[4 * ns];
        for (int i = 0; i < ns; ++i) {
            int i0 = 2 * (3 * (i + 1) + this.getSectionIndex(i));
            int i1 = i0 - 2;
            int i2 = i0 - 4;
            int i3 = i0 - 6;
            int k = 4 * i;
            this.cx[k] = this.Points[i0] - 3.0 * this.Points[i1] + 3.0 * this.Points[i2] - this.Points[i3];
            this.cy[k] = this.Points[i0 + 1] - 3.0 * this.Points[i1 + 1] + 3.0 * this.Points[i2 + 1] - this.Points[i3 + 1];
            this.cx[k + 1] = 3.0 * (this.Points[i1] + this.Points[i3] - 2.0 * this.Points[i2]);
            this.cy[k + 1] = 3.0 * (this.Points[i1 + 1] + this.Points[i3 + 1] - 2.0 * this.Points[i2 + 1]);
            this.cx[k + 2] = 3.0 * (this.Points[i2] - this.Points[i3]);
            this.cy[k + 2] = 3.0 * (this.Points[i2 + 1] - this.Points[i3 + 1]);
            this.cx[k + 3] = this.Points[i3];
            this.cy[k + 3] = this.Points[i3 + 1];
        }
    }

    protected void getSplinePoint(int s, double t, double[] pt) {
        int i = 4 * s;
        double t2 = t * t;
        double t3 = t2 * t;
        pt[0] = this.cx[i] * t3 + this.cx[i + 1] * t2 + this.cx[i + 2] * t + this.cx[i + 3];
        pt[1] = this.cy[i] * t3 + this.cy[i + 1] * t2 + this.cy[i + 2] * t + this.cy[i + 3];
    }

    public double[] calcPoints() {
        this.calcCoefSpline();
        if (this.cx == null) {
            return null;
        }
        int count = this.Points.length / 2;
        if (count == 0) {
            return null;
        }
        int ns = (count - this.polyCountsCount()) / 3;
        if (ns == 0) {
            return null;
        }
        double dt = 1.0 / (double)(this.pointsPerSegment - 1);
        int nv = (this.pointsPerSegment - 1) * ns + 1;
        double[] pts = new double[2 * nv];
        int k = 0;
        double[] pt = new double[2];
        for (int i = 0; i < ns; ++i) {
            int idx;
            for (int j = 0; j < this.pointsPerSegment - 1; ++j) {
                this.getSplinePoint(i, dt * (double)j, pt);
                idx = 2 * k;
                pts[idx] = pt[0];
                pts[idx + 1] = pt[1];
                ++k;
            }
            if (i != ns - 1) continue;
            this.getSplinePoint(i, 1.0, pt);
            idx = 2 * k;
            pts[idx] = pt[0];
            pts[idx + 1] = pt[1];
        }
        return pts;
    }

    @Override
    public int shapeType() {
        return 212;
    }

    @Override
    public int shapeVersion() {
        return version;
    }
}

