/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.Core;
import inform.agent.schemes.converters.odg.content.OdgConnector;
import inform.agent.schemes.converters.odg.content.OdgEllipse;
import inform.agent.schemes.converters.odg.content.OdgFigure;
import inform.agent.schemes.converters.odg.content.OdgFrame;
import inform.agent.schemes.converters.odg.content.OdgGraphicGroup;
import inform.agent.schemes.converters.odg.content.OdgLine;
import inform.agent.schemes.converters.odg.content.OdgMeasure;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgDeepContentPageParser {
    private final OdgGraphicGroup parentShape = new OdgGraphicGroup();

    public void setPage(Element element) {
        this.convertShape(element, this.parentShape);
    }

    public void convertShape(Element element, OdgGraphicGroup parentShape) {
        NodeList nodeList = element.getChildNodes();
        block21: for (int j = 0; j < nodeList.getLength(); ++j) {
            Node node = nodeList.item(j);
            if (node.getNodeType() != 1) continue;
            Element obj = (Element)node;
            String tagName = obj.getTagName();
            if (tagName.equals("draw:g")) {
                OdgGraphicGroup shape = new OdgGraphicGroup(obj);
                parentShape.childShape.add(shape);
                this.convertShape(obj, shape);
                continue;
            }
            switch (tagName) {
                case "draw:rect": 
                case "draw:path": 
                case "draw:polyline": 
                case "draw:polygon": 
                case "draw:custom-shape": {
                    parentShape.add(new OdgFigure(obj));
                    continue block21;
                }
                case "draw:line": {
                    parentShape.add(new OdgLine(obj));
                    continue block21;
                }
                case "draw:ellipse": 
                case "draw:circle": {
                    parentShape.add(new OdgEllipse(obj));
                    continue block21;
                }
                case "draw:frame": {
                    parentShape.add(new OdgFrame(obj));
                    continue block21;
                }
                case "draw:connector": {
                    parentShape.add(new OdgConnector(obj));
                    continue block21;
                }
                case "draw:measure": {
                    parentShape.add(new OdgMeasure(obj));
                    continue block21;
                }
                default: {
                    Core.logger.warn("\u0424\u0438\u0433\u0443\u0440\u0430: " + tagName + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
                }
            }
        }
    }

    public OdgGraphicGroup getParserShape() {
        return this.parentShape;
    }
}

