/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.converters.odg.content.OdgEnhancedGeometry;
import inform.agent.schemes.converters.odg.content.OdgGraphicObject;
import inform.agent.schemes.converters.odg.content.OdgUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgFigure
extends OdgGraphicObject {
    protected OdgEnhancedGeometry geometry;
    protected String tagName;
    protected double svgX;
    protected double svgY;
    protected double svgHeight;
    protected double svgWidth;
    protected double skewX;
    protected double skewY;
    protected List<BaseGraphic.RealPoint> points;
    protected boolean isProprietaryFigure;

    OdgFigure() {
    }

    OdgFigure(Element element) {
        super(element);
        this.tagName = element.getTagName();
        if (element.hasAttribute("svg:x")) {
            String nodeX = element.getAttribute("svg:x");
            this.svgX = OdgUtils.parseSizeValue(nodeX);
        }
        if (element.hasAttribute("svg:y")) {
            String nodeY = element.getAttribute("svg:y");
            this.svgY = OdgUtils.parseSizeValue(nodeY);
        }
        if (element.hasAttribute("svg:height")) {
            String nodeHeight = element.getAttribute("svg:height");
            this.svgHeight = OdgUtils.parseSizeValue(nodeHeight);
        }
        if (element.hasAttribute("svg:width")) {
            String nodeWidth = element.getAttribute("svg:width");
            this.svgWidth = OdgUtils.parseSizeValue(nodeWidth);
        }
        if (element.hasAttribute("draw:transform")) {
            int indexSkewY;
            int indexSkewX;
            int indexTranslate;
            String attribute = element.getAttribute("draw:transform");
            int indexRotate = attribute.indexOf("rotate");
            if (indexRotate != -1) {
                int startIndex = attribute.indexOf("rotate") + 8;
                int endIndex = attribute.indexOf(")", startIndex);
                String rotateValue = attribute.substring(startIndex, endIndex);
                double radian = Double.parseDouble(rotateValue);
                this.rotateAngle = SchemeUtils.convertAngle(radian);
            }
            if ((indexTranslate = attribute.indexOf("translate")) != -1) {
                int i = indexTranslate + 10;
                while (attribute.indexOf(")", i) != -1) {
                    ++i;
                }
                String value = attribute.substring(indexTranslate + 10, i);
                String[] values = value.split(" ");
                this.svgX = Double.parseDouble(values[0].substring(1, values[0].indexOf("cm")));
                this.svgY = Double.parseDouble(values[1].substring(0, values[1].indexOf("cm")));
            }
            if ((indexSkewX = attribute.indexOf("skewX")) != -1) {
                int startIndex = attribute.indexOf("skewX") + 7;
                int endIndex = attribute.indexOf(")", startIndex);
                String skewXValue = attribute.substring(startIndex, endIndex);
                double radian = Double.parseDouble(skewXValue);
                this.skewX = SchemeUtils.convertAngle(radian);
            }
            if ((indexSkewY = attribute.indexOf("skewY")) != -1) {
                int startIndex = attribute.indexOf("skewY") + 7;
                int endIndex = attribute.indexOf(")", startIndex);
                String skewYValue = attribute.substring(startIndex, endIndex);
                this.skewY = Double.parseDouble(skewYValue);
                double radian = Double.parseDouble(skewYValue);
                this.skewY = SchemeUtils.convertAngle(radian);
            }
        }
        if (element.hasAttribute("draw:points")) {
            String[] coordinates = element.getAttribute("draw:points").split(" ");
            ArrayList<BaseGraphic.RealPoint> points = new ArrayList<BaseGraphic.RealPoint>();
            for (String coordinate : coordinates) {
                String[] values = coordinate.split(",");
                double x = Integer.parseInt(values[0]);
                double y = Integer.parseInt(values[1]);
                BaseGraphic.RealPoint realPoint = new BaseGraphic.RealPoint(x, y);
                points.add(realPoint);
            }
            this.points = points;
        }
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getTagName().equals("draw:enhanced-geometry")) continue;
                this.isProprietaryFigure = true;
                this.geometry = new OdgEnhancedGeometry(el, this);
            }
        }
    }

    public boolean isPath() {
        return this.tagName.equals("draw:path");
    }

    public boolean isPolygon() {
        return this.tagName.equals("draw:polygon");
    }

    public boolean isPolyline() {
        return this.tagName.equals("draw:polyline");
    }

    public boolean isRect() {
        return this.tagName.equals("draw:rect");
    }

    public List<BaseGraphic.RealPoint> getPoints() {
        return this.points;
    }

    public double getSvgX() {
        return this.svgX * 10.0;
    }

    public double getSvgY() {
        return this.svgY * 10.0;
    }

    public double getSvgHeight() {
        return this.svgHeight * 10.0;
    }

    public double getSvgWidth() {
        return this.svgWidth * 10.0;
    }

    public double getSkewX() {
        return this.skewX;
    }

    public double getSkewY() {
        return this.skewY;
    }

    @Override
    public String getDrawName() {
        return this.drawName;
    }

    @Override
    public OdgEnhancedGeometry getGeometry() {
        return this.geometry;
    }

    @Override
    public boolean hasGeometry() {
        return this.geometry != null;
    }

    public void setSvgHeight(double svgHeight) {
        this.svgHeight = svgHeight / 10.0;
    }

    public void setSvgWidth(double svgWidth) {
        this.svgWidth = svgWidth / 10.0;
    }

    public boolean isProprietaryFigure() {
        return this.isProprietaryFigure;
    }
}

