/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.converters.odg.content.OdgAutomaticStyles;
import inform.agent.schemes.converters.odg.content.OdgEnhancedGeometry;
import inform.agent.schemes.converters.odg.content.OdgGluePoint;
import inform.agent.schemes.converters.odg.content.OdgStyleStyle;
import inform.agent.schemes.converters.odg.content.OdgText;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class OdgGraphicObject {
    OdgStyleStyle styleName;
    OdgStyleStyle textStyleName;
    String drawLayer;
    String drawName;
    OdgText text;
    List<OdgEnhancedGeometry.OdgCommand> listOdgCommand;
    List<OdgGluePoint> listCustomGluePoint;
    int[] svgViewBox = new int[]{0, 0, 21600, 21600};
    int drawId = -1;
    double rotateAngle;

    OdgGraphicObject() {
    }

    OdgGraphicObject(Element element) {
        OdgAutomaticStyles automaticStyles;
        this.listCustomGluePoint = new ArrayList<OdgGluePoint>();
        if (element.hasAttribute("draw:name")) {
            this.drawName = element.getAttribute("draw:name");
        }
        if (element.hasAttribute("draw:style-name")) {
            automaticStyles = new OdgAutomaticStyles(element.getAttribute("draw:style-name"));
            this.styleName = automaticStyles.getStyleByName(element.getAttribute("draw:style-name"));
        }
        if (element.hasAttribute("draw:text-style-name")) {
            automaticStyles = new OdgAutomaticStyles(element.getAttribute("draw:text-style-name"));
            this.textStyleName = automaticStyles.getStyleByName(element.getAttribute("draw:text-style-name"));
        }
        if (element.hasAttribute("draw:layer")) {
            this.drawLayer = element.getAttribute("draw:layer");
        }
        if (element.hasAttribute("svg:d")) {
            String path = element.getAttribute("svg:d");
            Pattern commandPattern = Pattern.compile("[a-zA-Z]|-?\\d+");
            Matcher commandMatcher = commandPattern.matcher(path);
            StringBuilder builder = new StringBuilder();
            while (commandMatcher.find()) {
                String command = commandMatcher.group();
                builder.append(command).append(" ");
            }
            String[] arr = builder.toString().trim().split(" ");
            OdgEnhancedGeometry geometry = new OdgEnhancedGeometry();
            this.listOdgCommand = geometry.svgParsing(arr);
        }
        if (element.hasAttribute("svg:viewBox")) {
            String svgViewBox = element.getAttribute("svg:viewBox");
            String[] splitValues = svgViewBox.split(" ");
            this.svgViewBox[0] = Integer.parseInt(splitValues[0]);
            this.svgViewBox[1] = Integer.parseInt(splitValues[1]);
            this.svgViewBox[2] = Integer.parseInt(splitValues[2]);
            this.svgViewBox[3] = Integer.parseInt(splitValues[3]);
        }
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                String tagName = el.getTagName();
                if (tagName.equals("text:p") && el.getTextContent().length() != 0) {
                    this.text = new OdgText(element);
                    continue;
                }
                if (tagName.equals("text:list")) {
                    if (this.text == null) {
                        this.text = new OdgText(el.getChildNodes());
                        continue;
                    }
                    OdgText newText = new OdgText(el.getChildNodes());
                    this.text.clone(newText);
                    continue;
                }
                if (!tagName.equals("draw:glue-point")) continue;
                this.listCustomGluePoint.add(new OdgGluePoint(el));
            }
        }
        if (element.hasAttribute("draw:id")) {
            String id = element.getAttribute("draw:id");
            this.drawId = Integer.parseInt(id.substring(2));
        }
    }

    public abstract OdgEnhancedGeometry getGeometry();

    public abstract boolean hasGeometry();

    public OdgStyleStyle getStyle() {
        return this.styleName;
    }

    public OdgStyleStyle getTextStyle() {
        return this.textStyleName;
    }

    public List<OdgEnhancedGeometry.OdgCommand> getListOdgCommand() {
        return this.listOdgCommand;
    }

    public List<OdgGluePoint> getCustomGluePoint() {
        return this.listCustomGluePoint;
    }

    public int[] getSvgViewBox() {
        return this.svgViewBox;
    }

    public int getDrawId() {
        return this.drawId;
    }

    public boolean hasDrawId() {
        return this.drawId != -1;
    }

    public boolean hasText() {
        return this.text != null;
    }

    public double getRotateAngle() {
        return this.rotateAngle;
    }

    public OdgText getText() {
        return this.text;
    }

    public String getDrawLayer() {
        return this.drawLayer;
    }

    public String getDrawName() {
        return this.drawName;
    }
}

