/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.converters.odg.OdgParser;
import inform.agent.schemes.converters.odg.content.OdgStyleStyle;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgOfficeStyles {
    private static HashMap<String, OdgGradient> gradientHashMap;
    private static HashMap<String, OdgStyleStyle> styleHashMap;
    private static HashMap<String, HashMap<String, OdgStyleStyle>> tableHashMap;

    public OdgOfficeStyles(Element element) {
        OdgOfficeStyles.writeStyles(element);
    }

    private static void writeStyles(Element element) {
        gradientHashMap = new HashMap();
        styleHashMap = new HashMap();
        tableHashMap = new HashMap();
        List<Element> listPage = OdgParser.getChildElements(element);
        for (Element page : listPage) {
            String tagName;
            switch (tagName = page.getTagName()) {
                case "draw:gradient": {
                    OdgGradient gradient = new OdgGradient();
                    gradient.drawStartColor = Color.decode(page.getAttribute("draw:start-color"));
                    gradient.drawEndColor = Color.decode(page.getAttribute("draw:end-color"));
                    gradient.drawStyle = page.getAttribute("draw:style");
                    String drawAngle = page.getAttribute("draw:angle");
                    gradient.drawAngle = drawAngle.contains("deg") ? Double.parseDouble(drawAngle.substring(0, drawAngle.indexOf("deg"))) : 0.0;
                    String gradientName = page.getAttribute("draw:name");
                    gradientHashMap.put(gradientName, gradient);
                    break;
                }
                case "style:style": {
                    styleHashMap.put(page.getAttribute("style:name"), new OdgStyleStyle(page));
                    break;
                }
                case "table:table-template": {
                    String style = page.getAttribute("table:name");
                    HashMap<String, OdgStyleStyle> templateMap = new HashMap<String, OdgStyleStyle>();
                    NodeList nodeList = page.getChildNodes();
                    int cnt = nodeList.getLength();
                    for (int i = 0; i < cnt; ++i) {
                        Node node = nodeList.item(i);
                        if (node.getNodeType() != 1) continue;
                        Element el = (Element)node;
                        String styleName = el.getAttribute("table:style-name");
                        templateMap.put(el.getTagName(), OdgOfficeStyles.getStyle(styleName));
                    }
                    tableHashMap.put(style, templateMap);
                }
            }
        }
    }

    public static HashMap<String, OdgStyleStyle> getTableStyles(String tableStyle) {
        return tableHashMap.get(tableStyle);
    }

    public static OdgStyleStyle getStyle(String styleName) {
        return styleHashMap.get(styleName);
    }

    public static OdgGradient getGradient(String name) {
        return gradientHashMap.get(name);
    }

    public static class OdgGradient {
        public Color drawStartColor;
        public Color drawEndColor;
        public double drawAngle;
        public String drawStyle;
    }
}

