/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.converters.odg.content.OdgParentStyle;
import inform.agent.schemes.converters.odg.content.OdgProperties;
import inform.agent.schemes.converters.odg.content.OdgUtils;
import inform.agent.schemes.converters.odg.styles.OdgOfficeFontFaceDecls;
import java.util.Set;
import org.w3c.dom.Element;

public class OdgStyleTextProperties
extends OdgProperties {
    public OdgStyleTextProperties(RectTextLine.PartTextLine part, double scale) {
        byte foFontStyle;
        this.styles.put("fo:font-size", "18pt");
        this.styles.put("style:font-name", "Liberation Sans");
        this.styles.put("fo:color", "#000000");
        if (part.fontColor != null) {
            String foColor = String.format("#%06x", part.fontColor.getRGB() & 0xFFFFFF);
            this.styles.put("fo:color", foColor);
        }
        if (part.fontBgColor != null) {
            String foBgColor = String.format("#%06x", part.fontBgColor.getRGB() & 0xFFFFFF);
            this.styles.put("fo:background-color", foBgColor);
        }
        if (part.fontName != null) {
            String fontName = part.fontName;
            this.styles.put("style:font-name", fontName);
        }
        if (part.fontHeight != 0.0) {
            double fontSize = part.fontHeight * scale;
            String foFontSize = String.valueOf(fontSize / 0.3527);
            String fontSizePt = foFontSize.concat("pt");
            this.styles.put("fo:font-size", fontSizePt);
        }
        if (((foFontStyle = part.fontStyle) & 1) != 0) {
            this.styles.put("fo:font-weight", "bold");
        }
        if ((foFontStyle & 2) != 0) {
            this.styles.put("fo:font-style", "italic");
        }
        if ((foFontStyle & 4) != 0) {
            this.styles.put("style:text-underline-style", "solid");
        }
        if ((foFontStyle & 8) != 0) {
            this.styles.put("style:text-line-through-style", "solid");
        }
        switch (part.ssScript) {
            case 1: {
                this.styles.put("style:text-position", "sub 58%");
                break;
            }
            case 2: {
                this.styles.put("style:text-position", "super 58%");
                break;
            }
        }
    }

    public OdgStyleTextProperties(Paragraph paragraph, PhxLayer layer, double scale) {
        String foColor;
        this.styles.put("fo:font-size", "18pt");
        this.styles.put("style:font-name", "Liberation Sans");
        this.styles.put("fo:color", "#000000");
        if (paragraph.lfHeight != 0.0) {
            double fontSize = paragraph.lfHeight * scale;
            String foFontSize = String.valueOf(fontSize / 0.3527);
            String fontSizePt = foFontSize.concat("pt");
            this.styles.put("fo:font-size", fontSizePt);
        }
        if (paragraph.TransparentText != 0) {
            this.styles.put("loext:opacity", OdgUtils.asStringWithPercent(paragraph.TransparentText));
        }
        RectTextLine line = (RectTextLine)paragraph.Lines.get(0);
        if (!line.FontName.equals("Liberation Sans")) {
            String fontName = line.FontName;
            this.styles.put("style:font-name", fontName);
        }
        if (line.FontColor != null) {
            foColor = String.format("#%06x", line.FontColor.getRGB() & 0xFFFFFF);
            this.styles.put("fo:color", foColor);
        } else if (layer.FontColor != null) {
            foColor = String.format("#%06x", layer.FontColor.getRGB() & 0xFFFFFF);
            this.styles.put("fo:color", foColor);
        }
        byte foFontStyle = line.FontStyle;
        if ((foFontStyle & 1) != 0) {
            this.styles.put("fo:font-weight", "bold");
        }
        if ((foFontStyle & 2) != 0) {
            this.styles.put("fo:font-style", "italic");
        }
        if ((foFontStyle & 4) != 0) {
            this.styles.put("style:text-underline-style", "solid");
        }
        if ((foFontStyle & 8) != 0) {
            this.styles.put("style:text-line-through-style", "solid");
        }
    }

    public OdgStyleTextProperties(Element element, OdgParentStyle parentStyle) {
        Set<String> parentAttrs = null;
        if (parentStyle != null && parentStyle.style != null) {
            OdgProperties properties = parentStyle.style.getStyleProperty();
            parentAttrs = properties.styles.keySet();
        }
        if (parentAttrs == null || !parentAttrs.contains("fo:font-size")) {
            this.styles.put("fo:font-size", "6.3486");
        }
        if (parentAttrs == null || !parentAttrs.contains("style:font-name")) {
            this.styles.put("style:font-name", "Liberation Sans");
        }
        if (parentAttrs == null || !parentAttrs.contains("style:text-position")) {
            this.styles.put("style:text-position", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("fo:color")) {
            this.styles.put("fo:color", "#000000");
        }
        if (element.hasAttribute("fo:font-size")) {
            String value = element.getAttribute("fo:font-size");
            double foFontSize = OdgUtils.parseParagraphValue(value) * 0.3527;
            this.styles.put("fo:font-size", String.valueOf(foFontSize));
        }
        if (element.hasAttribute("style:font-name")) {
            String styleFontName = element.getAttribute("style:font-name");
            this.styles.put("style:font-name", OdgOfficeFontFaceDecls.getFontFamily(styleFontName));
        }
        if (element.hasAttribute("style:text-position")) {
            String styleScript = element.getAttribute("style:text-position");
            if (styleScript.contains("sub")) {
                this.styles.put("style:text-position", "1");
            } else if (styleScript.contains("super")) {
                this.styles.put("style:text-position", "2");
            } else {
                this.styles.put("style:text-position", "0");
            }
        }
        if (element.hasAttribute("fo:background-color")) {
            String styleBgColor = element.getAttribute("fo:background-color");
            this.styles.put("fo:background-color", styleBgColor);
        }
        if (element.hasAttribute("fo:color")) {
            String foColor = element.getAttribute("fo:color");
            this.styles.put("fo:color", foColor);
        }
        int fontStyle = 0;
        if (element.hasAttribute("fo:font-weight") && element.getAttribute("fo:font-weight").equals("bold")) {
            fontStyle = (byte)(fontStyle + 1);
        }
        if (element.hasAttribute("fo:font-style") && element.getAttribute("fo:font-style").equals("italic")) {
            fontStyle = (byte)(fontStyle + 2);
        }
        if (element.hasAttribute("style:text-underline-style") && !element.getAttribute("style:text-underline-style").equals("none")) {
            fontStyle = (byte)(fontStyle + 4);
        }
        if (element.hasAttribute("style:text-line-through-style") && !element.getAttribute("style:text-line-through-style").equals("none")) {
            fontStyle = (byte)(fontStyle + 8);
        }
        this.styles.put("fo:font-style", String.valueOf(fontStyle));
    }
}

