/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.converters.odg.content.OdgAutomaticStyles;
import inform.agent.schemes.converters.odg.content.OdgFrame;
import inform.agent.schemes.converters.odg.content.OdgOfficeStyles;
import inform.agent.schemes.converters.odg.content.OdgProperties;
import inform.agent.schemes.converters.odg.content.OdgStyleStyle;
import inform.agent.schemes.converters.odg.content.OdgText;
import inform.agent.schemes.converters.odg.content.OdgUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgTable
extends OdgFrame {
    private boolean isDefaultTemplate;
    private TableStyle tableStyle;
    private final List<OdgTableColumn> columnList = new ArrayList<OdgTableColumn>();
    private final List<OdgTableRow> rowList = new ArrayList<OdgTableRow>();
    private final HashMap<String, OdgStyleStyle> styleList;

    public void checkTableStyles(Element element) {
        String value;
        this.tableStyle = new TableStyle();
        if (element.hasAttribute("table:use-first-row-styles")) {
            value = element.getAttribute("table:use-first-row-styles");
            this.tableStyle.useFirstRow = OdgUtils.asBoolean(value);
        }
        if (element.hasAttribute("table:use-last-row-styles")) {
            value = element.getAttribute("table:use-last-row-styles");
            this.tableStyle.useLastRow = OdgUtils.asBoolean(value);
        }
        if (element.hasAttribute("table:use-first-column-styles")) {
            value = element.getAttribute("table:use-first-column-styles");
            this.tableStyle.useFirstColumn = OdgUtils.asBoolean(value);
        }
        if (element.hasAttribute("table:use-last-column-styles")) {
            value = element.getAttribute("table:use-last-column-styles");
            this.tableStyle.useLastColumn = OdgUtils.asBoolean(value);
        }
        if (element.hasAttribute("table:use-banding-rows-styles")) {
            value = element.getAttribute("table:use-banding-rows-styles");
            this.tableStyle.useBandingRows = OdgUtils.asBoolean(value);
        }
        if (element.hasAttribute("table:use-banding-columns-styles")) {
            value = element.getAttribute("table:use-banding-columns-styles");
            this.tableStyle.useBandingColumns = OdgUtils.asBoolean(value);
        }
    }

    public OdgTable(Element element) {
        String templateName = element.getAttribute("table:template-name");
        if (templateName.equals("default")) {
            this.isDefaultTemplate = true;
        }
        this.styleList = OdgOfficeStyles.getTableStyles(templateName);
        this.checkTableStyles(element);
        NodeList nodeList = element.getChildNodes();
        block8: for (int i = 0; i < nodeList.getLength(); ++i) {
            String name;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            switch (name = node.getNodeName()) {
                case "table:table-column": {
                    this.columnList.add(new OdgTableColumn((Element)node));
                    continue block8;
                }
                case "table:table-row": {
                    this.rowList.add(new OdgTableRow((Element)node));
                    continue block8;
                }
            }
        }
    }

    public OdgStyleStyle getTableStyle(Element el) {
        String styleName = el.getAttribute("table:style-name");
        OdgAutomaticStyles style = new OdgAutomaticStyles(styleName);
        return style.getStyleByName(styleName);
    }

    public OdgStyleStyle getDefaultTableStyle(Element el) {
        String styleName = el.getAttribute("table:default-cell-style-name");
        OdgStyleStyle style = OdgOfficeStyles.getStyle(styleName);
        if (style == null) {
            OdgAutomaticStyles automaticStyle = new OdgAutomaticStyles(styleName);
            style = automaticStyle.getStyleByName(styleName);
        }
        return style;
    }

    public HashMap<String, OdgStyleStyle> getTemplateStyleList() {
        return this.styleList;
    }

    public TableStyle getTableStyle() {
        return this.tableStyle;
    }

    public List<OdgTableColumn> getColumnList() {
        return this.columnList;
    }

    public List<OdgTableRow> getRowList() {
        return this.rowList;
    }

    public int getColumnSize() {
        return this.columnList.size();
    }

    public int getRowSize() {
        return this.rowList.size();
    }

    public boolean isDefaultTemplate() {
        return this.isDefaultTemplate;
    }

    public static class OdgStyleTableRowProperties
    extends OdgProperties {
        public OdgStyleTableRowProperties(double height, double scale) {
            this.styles.put("style:use-optimal-row-height", "false");
            this.styles.put("style:row-height", OdgUtils.asStringWithCentimeter(height * scale));
        }

        public OdgStyleTableRowProperties(Element element) {
            String value;
            if (element.hasAttribute("style:row-height")) {
                value = element.getAttribute("style:row-height");
                double rowHeight = OdgUtils.parseSizeValue(value);
                this.styles.put("style:row-height", String.valueOf(rowHeight));
            }
            if (element.hasAttribute("style:use-optimal-row-height")) {
                value = element.getAttribute("style:use-optimal-row-height");
                this.styles.put("style:use-optimal-row-height", value);
            }
        }
    }

    public static class OdgStyleTableColumnProperties
    extends OdgProperties {
        public OdgStyleTableColumnProperties(double width, double scale) {
            this.styles.put("style:use-optimal-column-width", "false");
            this.styles.put("style:column-width", OdgUtils.asStringWithCentimeter(width * scale));
        }

        public OdgStyleTableColumnProperties(Element element) {
            String value;
            if (element.hasAttribute("style:column-width")) {
                value = element.getAttribute("style:column-width");
                double columnWidth = OdgUtils.parseSizeValue(value);
                this.styles.put("style:column-width", String.valueOf(columnWidth));
            }
            if (element.hasAttribute("style:use-optimal-column-width")) {
                value = element.getAttribute("style:use-optimal-column-width");
                this.styles.put("style:use-optimal-column-width", value);
            }
        }
    }

    public class OdgTableCell {
        public int tableNumberRowsSpanned = 1;
        public int tableNumberColumnsSpanned = 1;
        public OdgText text;
        public OdgStyleStyle style;
        public boolean isCoveredCell;

        public OdgTableCell(Element item) {
            this(item, false);
        }

        public OdgTableCell(Element item, boolean isCoveredCell) {
            String value;
            this.isCoveredCell = isCoveredCell;
            this.text = new OdgText(item);
            if (item.hasAttribute("table:style-name")) {
                OdgStyleStyle style = OdgTable.this.getTableStyle(item);
                if (style != null) {
                    this.style = style;
                } else {
                    String styleName = item.getAttribute("table:style-name");
                    this.style = OdgOfficeStyles.getStyle(styleName);
                }
            }
            if (item.hasAttribute("table:number-rows-spanned")) {
                value = item.getAttribute("table:number-rows-spanned");
                this.tableNumberRowsSpanned = Integer.parseInt(value);
            }
            if (item.hasAttribute("table:number-columns-spanned")) {
                value = item.getAttribute("table:number-columns-spanned");
                this.tableNumberColumnsSpanned = Integer.parseInt(value);
            }
        }
    }

    public class OdgTableColumn {
        public OdgStyleStyle style;

        public OdgTableColumn(Element item) {
            this.style = OdgTable.this.getTableStyle(item);
        }
    }

    public class OdgTableRow {
        public List<OdgTableCell> tableCells = new ArrayList<OdgTableCell>();
        public OdgStyleStyle style;
        public OdgStyleStyle defaultStyle;

        public OdgTableRow(Element item) {
            if (item.hasAttribute("table:style-name")) {
                this.style = OdgTable.this.getTableStyle(item);
            }
            if (item.hasAttribute("table:default-cell-style-name")) {
                this.defaultStyle = OdgTable.this.getDefaultTableStyle(item);
            }
            NodeList nodeList = item.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                String name = node.getNodeName();
                if (name.equals("table:table-cell")) {
                    this.tableCells.add(new OdgTableCell((Element)node));
                }
                if (!name.equals("table:covered-table-cell")) continue;
                this.tableCells.add(new OdgTableCell((Element)node, true));
            }
        }
    }

    public static class TableStyle {
        public boolean useFirstRow;
        public boolean useLastRow;
        public boolean useFirstColumn;
        public boolean useLastColumn;
        public boolean useBandingRows;
        public boolean useBandingColumns;
    }
}

