/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.converters.odg.content.OdgAutomaticStyles;
import inform.agent.schemes.converters.odg.content.OdgStyleStyle;
import inform.agent.schemes.converters.odg.content.OdgTextListStyle;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgText {
    private List<OdgPartText> partTexts = new ArrayList<OdgPartText>();

    public OdgText(NodeList list) {
        String textStyleName = ((Element)((Object)list)).getAttribute("text:style-name");
        OdgAutomaticStyles aStyle = new OdgAutomaticStyles(textStyleName);
        OdgTextListStyle listStyle = aStyle.getTextStyleByName(textStyleName);
        List<OdgTextListStyle.OdgStyleListLevelBullet> listLevelBullet = listStyle.getListLevelBullets();
        listLevelBullet.clear();
        int cnt = list.getLength();
        for (int i = 0; i < cnt; ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)list.item(i);
            this.parseText(element);
        }
    }

    public OdgText(Element element) {
        this.parseText(element);
    }

    private void parseText(Element element) {
        NodeList nodeList = element.getChildNodes();
        int cnt = nodeList.getLength();
        for (int i = 0; i < cnt; ++i) {
            NodeList childNodes;
            int childLength;
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (node.getNodeType() != 1 || !nodeName.equals("text:p")) continue;
            Element el = (Element)((Object)node.getChildNodes());
            OdgStyleStyle textPStyle = null;
            if (el.hasAttribute("text:style-name")) {
                String textPStyleName = el.getAttribute("text:style-name");
                OdgAutomaticStyles style = new OdgAutomaticStyles(textPStyleName);
                textPStyle = style.getStyleByName(textPStyleName);
            }
            if ((childLength = (childNodes = el.getChildNodes()).getLength()) == 0) {
                OdgPartText opt = new OdgPartText();
                opt.text = "";
                opt.newLine = true;
                this.partTexts.add(opt);
            }
            for (int j = 0; j < childLength; ++j) {
                OdgPartText opt = new OdgPartText();
                opt.textPStyle = textPStyle;
                Node span = childNodes.item(j);
                String nodeValue = span.getNodeValue();
                if (nodeValue != null) {
                    opt.text = this.correctText(nodeValue);
                } else {
                    Element e = (Element)span;
                    String name = span.getNodeName();
                    opt.text = name.equals("text:s") ? " " : (name.equals("text:tab") ? "\t" : this.correctText(e.getTextContent()));
                    String textSpanStyleName = e.getAttribute("text:style-name");
                    OdgAutomaticStyles style = new OdgAutomaticStyles(textSpanStyleName);
                    opt.textSpanStyle = style.getStyleByName(textSpanStyleName);
                }
                if (j + 1 == childLength) {
                    opt.newLine = true;
                }
                this.partTexts.add(opt);
            }
        }
    }

    public void clone(OdgText odgText) {
        this.partTexts = odgText.partTexts;
    }

    private String correctText(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder correctedText = new StringBuilder();
        for (char symbol : text.toCharArray()) {
            if (symbol == '\u2028') {
                correctedText.append('\n');
                continue;
            }
            correctedText.append(symbol);
        }
        return correctedText.toString();
    }

    public List<OdgPartText> getPartTexts() {
        return this.partTexts;
    }

    public static class OdgPartText {
        public String text;
        public OdgStyleStyle textSpanStyle;
        public OdgStyleStyle textPStyle;
        public boolean newLine;
    }
}

