/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.converters.odg.content.OdgUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgTextListStyle {
    private final List<OdgStyleListLevelBullet> listLevelBullets = new ArrayList<OdgStyleListLevelBullet>();
    private String styleName;

    public OdgTextListStyle(Element element) {
        NodeList nodeList = element.getChildNodes();
        if (element.hasAttribute("style:name")) {
            this.styleName = element.getAttribute("style:name");
        }
        int cnt = nodeList.getLength();
        for (int i = 0; i < cnt; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            this.listLevelBullets.add(new OdgStyleListLevelBullet(el));
        }
    }

    public List<OdgStyleListLevelBullet> getListLevelBullets() {
        return this.listLevelBullets;
    }

    public String getStyleName() {
        return this.styleName;
    }

    static class OdgStyleListLevelBullet {
        private String textBulletChar;
        private int textLevel;

        public OdgStyleListLevelBullet(Element el) {
            if (el.hasAttribute("text:level")) {
                String level = el.getAttribute("text:level");
                this.textLevel = OdgUtils.asInteger(level);
            }
            if (el.hasAttribute("text:bullet-char")) {
                this.textBulletChar = el.getAttribute("text:bullet-char");
            }
        }

        public String getTextBulletChar() {
            return this.textBulletChar;
        }

        public int getTextLevel() {
            return this.textLevel;
        }
    }
}

