/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content.evaluator;

import inform.agent.schemes.converters.odg.content.OdgEnhancedGeometry;
import inform.agent.schemes.converters.odg.content.evaluator.OdgFunctionResolver;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSyntaxTreeNode {
    public abstract double evaluate();

    public static class AstConstNode
    extends AbstractSyntaxTreeNode {
        private final String node;
        private final OdgEnhancedGeometry geometry;

        public AstConstNode(String node, OdgEnhancedGeometry geometry) {
            this.node = node;
            this.geometry = geometry;
        }

        @Override
        public double evaluate() {
            int[] viewBox = this.geometry.figure.getSvgViewBox();
            switch (this.node) {
                case "left": {
                    return viewBox[0];
                }
                case "top": {
                    return viewBox[1];
                }
                case "right": {
                    return viewBox[2];
                }
                case "bottom": {
                    return viewBox[3];
                }
                case "xstretch": {
                    return this.geometry.getDrawPathStretchpointX();
                }
                case "ystretch": {
                    return this.geometry.getDrawPathStretchpointY();
                }
                case "pi": {
                    return Math.PI;
                }
                case "hasfill": 
                case "hasstroke": {
                    return 1.0;
                }
                case "width": {
                    return viewBox[2] - viewBox[0];
                }
                case "height": {
                    return viewBox[3] - viewBox[1];
                }
                case "logwidth": {
                    return this.geometry.getFigure().getSvgWidth() * 100.0;
                }
                case "logheight": {
                    return this.geometry.getFigure().getSvgHeight() * 100.0;
                }
            }
            return 0.0;
        }
    }

    public static class AstNumberNode
    extends AbstractSyntaxTreeNode {
        private final double number;

        public AstNumberNode(double number) {
            this.number = number;
        }

        @Override
        public double evaluate() {
            return this.number;
        }
    }

    public static class AstFunctionCallNode
    extends AbstractSyntaxTreeNode {
        private final String functionName;
        private final List<AbstractSyntaxTreeNode> arguments;

        public AstFunctionCallNode(String functionName, List<AbstractSyntaxTreeNode> arguments) {
            this.functionName = functionName;
            this.arguments = arguments;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public List<AbstractSyntaxTreeNode> getArguments() {
            return this.arguments;
        }

        @Override
        public double evaluate() {
            ArrayList<Double> arguments = new ArrayList<Double>();
            for (AbstractSyntaxTreeNode node : this.arguments) {
                arguments.add(node.evaluate());
            }
            return OdgFunctionResolver.resolveFunction(this.functionName, arguments);
        }
    }

    public static class AstElementaryOperationNode
    extends AbstractSyntaxTreeNode {
        private final char operation;
        private final AbstractSyntaxTreeNode left;
        private final AbstractSyntaxTreeNode right;

        public AstElementaryOperationNode(char operation, AbstractSyntaxTreeNode left, AbstractSyntaxTreeNode right) {
            this.operation = operation;
            this.left = left;
            this.right = right;
        }

        @Override
        public double evaluate() {
            double left = this.left == null ? 0.0 : this.left.evaluate();
            double right = this.right == null ? 0.0 : this.right.evaluate();
            switch (this.operation) {
                case '+': {
                    return left + right;
                }
                case '-': {
                    return left - right;
                }
                case '*': {
                    return left * right;
                }
                case '/': {
                    if (right != 0.0) {
                        return left / right;
                    }
                    return 0.0;
                }
            }
            return 0.0;
        }
    }
}

