/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content.evaluator;

import java.util.List;
import java.util.NoSuchElementException;

public class OdgFunctionResolver {
    public static double resolveFunction(String functionName, List<Double> arguments) {
        switch (functionName) {
            case "min": {
                return OdgFunctionResolver.min(arguments);
            }
            case "max": {
                return OdgFunctionResolver.max(arguments);
            }
            case "sin": {
                return Math.sin(arguments.get(0));
            }
            case "cos": {
                return Math.cos(arguments.get(0));
            }
            case "sqrt": {
                return Math.sqrt(arguments.get(0));
            }
            case "abs": {
                return Math.abs(arguments.get(0));
            }
            case "tan": {
                return Math.tan(arguments.get(0));
            }
            case "atan": {
                return Math.atan(arguments.get(0));
            }
            case "atan2": {
                return Math.atan2(arguments.get(0), arguments.get(1));
            }
            case "if": {
                return arguments.get(0) > 0.0 ? arguments.get(1) : arguments.get(2);
            }
        }
        throw new UnsupportedOperationException("\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0442\u0441\u044f: " + functionName + ", " + arguments.size() + " \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
    }

    private static double max(List<Double> args) {
        return args.stream().mapToDouble(value -> value).max().orElseThrow(NoSuchElementException::new);
    }

    private static double min(List<Double> args) {
        return args.stream().mapToDouble(value -> value).min().orElseThrow(NoSuchElementException::new);
    }
}

